/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.composer.service.fs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.SystemUtils;
import org.ballerinalang.composer.service.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileSystem
implements FileSystem {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileSystem.class);
    private static final String FOLDER_TYPE = "folder";
    private static final String FILE_TYPE = "file";
    private static final String NODE_ID = "id";
    private static final String NODE_TYPE = "type";
    private static final String NODE_LABEL = "label";
    private static final String NODE_CHILDREN = "children";
    private static final String NODE_ERROR = "error";
    private static final String FILE_CONTENT = "fileContent";
    private static final String FILE_NAME = "fileName";
    private static final String FILE_PATH = "filePath";
    private static final String PARENT = "parent";
    private static final String FILE_FULL_PATH = "fileFullPath";
    private static final String EXTENSION = "extension";
    private static final String EXISTS = "exists";

    @Override
    public JsonArray listRoots(List<String> extensionList) throws IOException {
        Iterable<Path> rootDirs = FileSystems.getDefault().getRootDirectories();
        ArrayList<Path> rootDirsList = new ArrayList<Path>();
        rootDirs.forEach(rootDirsList::add);
        return this.getJsonArrayForDirs(rootDirsList, extensionList);
    }

    @Override
    public JsonArray getJsonForRoots(List<Path> rootPaths, List<String> extensionList) throws IOException {
        return this.getJsonArrayForDirs(rootPaths, extensionList);
    }

    @Override
    public JsonObject exists(String path) throws IOException {
        Path ioPath = Paths.get(path, new String[0]);
        JsonObject result = new JsonObject();
        boolean exists = Files.exists(ioPath, new LinkOption[0]);
        result.addProperty(FILE_TYPE, path);
        result.addProperty(EXISTS, Boolean.valueOf(exists));
        if (exists) {
            if (Files.isDirectory(ioPath, new LinkOption[0])) {
                result.addProperty(NODE_TYPE, FOLDER_TYPE);
            } else if (Files.isRegularFile(ioPath, new LinkOption[0])) {
                result.addProperty(NODE_TYPE, FILE_TYPE);
            }
        }
        return result;
    }

    @Override
    public void move(String src, String dest) throws IOException {
        Files.createDirectories(Paths.get(dest, new String[0]).getParent(), new FileAttribute[0]);
        Files.move(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), new CopyOption[0]);
    }

    @Override
    public void copy(String src, String dest) throws IOException {
        Files.copy(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), new CopyOption[0]);
    }

    @Override
    public JsonObject read(String path) throws IOException {
        byte[] fileContent = Files.readAllBytes(Paths.get(path, new String[0]));
        JsonObject fileObject = new JsonObject();
        fileObject.addProperty(FILE_FULL_PATH, path);
        fileObject.addProperty(FILE_NAME, FilenameUtils.getBaseName((String)path));
        fileObject.addProperty(FILE_PATH, FilenameUtils.getFullPath((String)path));
        fileObject.addProperty(EXTENSION, FilenameUtils.getExtension((String)path));
        fileObject.addProperty(FILE_CONTENT, new String(fileContent, Charset.defaultCharset()));
        return fileObject;
    }

    @Override
    public void create(String path, String type, String content) throws IOException {
        Path ioPath = Paths.get(path, new String[0]);
        if (FOLDER_TYPE.equals(type)) {
            Files.createDirectories(ioPath, new FileAttribute[0]);
        } else {
            Files.write(ioPath, content.getBytes(Charset.defaultCharset()), new OpenOption[0]);
        }
    }

    @Override
    public void write(String path, String content) throws IOException {
        Path ioPath = Paths.get(path, new String[0]);
        Files.write(ioPath, content.getBytes(Charset.defaultCharset()), new OpenOption[0]);
    }

    @Override
    public void delete(String path) throws IOException {
        Path ioPath = Paths.get(path, new String[0]);
        if (ioPath.toFile().isDirectory()) {
            Files.walk(ioPath, FileVisitOption.FOLLOW_LINKS).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        } else {
            Files.delete(ioPath);
        }
    }

    @Override
    public JsonArray listFilesInPath(String path, List<String> extensions) throws IOException {
        Path ioPath = Paths.get(path, new String[0]);
        JsonArray dirs = new JsonArray();
        Iterator iterator = Files.list(ioPath).sorted().iterator();
        while (iterator.hasNext()) {
            Path next = (Path)iterator.next();
            if (!Files.isDirectory(next, new LinkOption[0]) && !Files.isRegularFile(next, new LinkOption[0]) || Files.isHidden(next) || this.isWindowsSystemFile(next)) continue;
            JsonObject jsnObj = this.getJsonObjForFile(next, extensions);
            if (Files.isRegularFile(next, new LinkOption[0])) {
                Path fileName = next.getFileName();
                SuffixFileFilter fileFilter = new SuffixFileFilter(extensions, IOCase.INSENSITIVE);
                if (null == fileName || !fileFilter.accept(next.toFile())) continue;
                jsnObj.addProperty(FILE_FULL_PATH, next.toString());
                jsnObj.addProperty(FILE_NAME, FilenameUtils.getBaseName((String)next.toString()));
                jsnObj.addProperty(FILE_PATH, FilenameUtils.getFullPath((String)next.toString()));
                jsnObj.addProperty(EXTENSION, FilenameUtils.getExtension((String)next.toString()));
                dirs.add((JsonElement)jsnObj);
                continue;
            }
            dirs.add((JsonElement)jsnObj);
        }
        return dirs;
    }

    @Override
    public String getUserHome() {
        return System.getProperty("user.home");
    }

    private JsonArray getJsonArrayForDirs(List<Path> rootDirs, List<String> extensionList) {
        JsonArray rootArray = new JsonArray();
        for (Path root : rootDirs) {
            JsonObject rootObj = this.getJsonObjForFile(root, extensionList);
            if (!Files.isDirectory(root, new LinkOption[0])) continue;
            rootArray.add((JsonElement)rootObj);
        }
        return rootArray;
    }

    private JsonObject getJsonObjForFile(Path root, List<String> extensions) {
        JsonObject rootObj = new JsonObject();
        Path fileName = root.getFileName();
        if (fileName != null) {
            rootObj.addProperty(NODE_LABEL, fileName.toString());
        } else {
            rootObj.addProperty(NODE_LABEL, root.toString());
        }
        rootObj.addProperty(NODE_ID, root.toAbsolutePath().toString());
        Path parent = root.getParent();
        if (parent != null) {
            rootObj.addProperty(PARENT, parent.toAbsolutePath().toString());
        }
        if (Files.isDirectory(root, new LinkOption[0])) {
            rootObj.addProperty(NODE_TYPE, FOLDER_TYPE);
            try {
                File rootFile = root.toFile();
                boolean hasChildren = Boolean.FALSE;
                if (rootFile != null) {
                    File[] subDirs = rootFile.listFiles(File::isDirectory);
                    if (subDirs != null && subDirs.length > 0) {
                        hasChildren = Boolean.TRUE;
                    } else {
                        String[] list;
                        String[] stringArray = list = extensions != null && !extensions.isEmpty() ? rootFile.list((FilenameFilter)new SuffixFileFilter(extensions, IOCase.INSENSITIVE)) : rootFile.list();
                        if (list != null && list.length > 0) {
                            hasChildren = true;
                        }
                    }
                }
                rootObj.addProperty(NODE_CHILDREN, Boolean.valueOf(hasChildren));
            }
            catch (Exception e) {
                logger.debug("Error while fetching children of " + root.toString(), (Throwable)e);
                rootObj.addProperty(NODE_ERROR, e.toString());
            }
        } else if (Files.isRegularFile(root, new LinkOption[0])) {
            rootObj.addProperty(NODE_TYPE, FILE_TYPE);
            rootObj.addProperty(NODE_CHILDREN, Boolean.FALSE);
        }
        return rootObj;
    }

    private boolean isWindowsSystemFile(Path filePath) throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            DosFileAttributes dosAttribs = Files.readAttributes(filePath, DosFileAttributes.class, new LinkOption[0]);
            return dosAttribs.isSystem();
        }
        return false;
    }
}

