/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.ballerinalang.docgen.docs.BallerinaDocDataHolder;
import org.ballerinalang.docgen.docs.utils.BallerinaDocUtils;
import org.ballerinalang.docgen.model.ActionDoc;
import org.ballerinalang.docgen.model.AnnotationDoc;
import org.ballerinalang.docgen.model.ConnectorDoc;
import org.ballerinalang.docgen.model.Documentable;
import org.ballerinalang.docgen.model.EnumDoc;
import org.ballerinalang.docgen.model.Field;
import org.ballerinalang.docgen.model.FunctionDoc;
import org.ballerinalang.docgen.model.GlobalVariableDoc;
import org.ballerinalang.docgen.model.Link;
import org.ballerinalang.docgen.model.PackageName;
import org.ballerinalang.docgen.model.Page;
import org.ballerinalang.docgen.model.PrimitiveTypeDoc;
import org.ballerinalang.docgen.model.StaticCaption;
import org.ballerinalang.docgen.model.StructDoc;
import org.ballerinalang.docgen.model.Variable;
import org.ballerinalang.model.elements.DocTag;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.AnnotatableNode;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.DocumentableNode;
import org.ballerinalang.model.tree.DocumentationNode;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.DocumentationAttributeNode;
import org.ballerinalang.model.tree.types.TypeNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructType;
import org.wso2.ballerinalang.compiler.tree.BLangAction;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangObject;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecord;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangDocumentationAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;

public class Generator {
    private static final String ANONYMOUS_STRUCT = "$anonStruct$";

    public static Page generatePage(BLangPackage balPackage, List<Link> packages, String description, List<Link> primitives) {
        ArrayList<Documentable> documentables = new ArrayList<Documentable>();
        String currentPackageName = BallerinaDocDataHolder.getInstance().getOrgName() + balPackage.packageID.getName().getValue();
        if (balPackage.getRecords().size() > 0) {
            for (BLangRecord record : balPackage.getRecords()) {
                if (!record.getFlags().contains(Flag.PUBLIC)) continue;
                documentables.add(Generator.createDocForNode(record));
            }
        }
        if (balPackage.getFunctions().size() > 0) {
            for (Object function : balPackage.getFunctions()) {
                if (!function.getFlags().contains(Flag.PUBLIC) || function.getFlags().contains(Flag.ATTACHED)) continue;
                if (function.getReceiver() != null) {
                    if (documentables.size() <= 0) continue;
                    for (Documentable parentDocumentable : documentables) {
                        TypeNode langType = function.getReceiver().getTypeNode();
                        String typeName = langType instanceof BLangUserDefinedType ? ((BLangUserDefinedType)langType).typeName.value : langType.toString();
                        if (!typeName.equals(parentDocumentable.name)) continue;
                        parentDocumentable.children.add(Generator.createDocForNode((BLangFunction)function));
                    }
                    continue;
                }
                documentables.add(Generator.createDocForNode((BLangFunction)function));
            }
        }
        List visitedObjects = balPackage.getObjects().stream().filter(bLangObject -> {
            if (!bLangObject.getDocumentationAttachments().isEmpty() && !bLangObject.getDocumentationAttachments().isEmpty()) {
                DocumentationNode bLangDocumentation = (DocumentationNode)bLangObject.getDocumentationAttachments().get(0);
                for (DocumentationAttributeNode attribute : bLangDocumentation.getAttributes()) {
                    if (!(attribute instanceof BLangDocumentationAttribute)) continue;
                    BLangDocumentationAttribute docAttribute = (BLangDocumentationAttribute)attribute;
                    if (docAttribute.docTag != DocTag.ENDPOINT) continue;
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        List<ConnectorDoc> connectors = visitedObjects.stream().map(obj -> {
            Optional<BLangObject> objectDefOptional;
            BLangType returnTypeNode;
            BLangIdentifier epName = obj.getName();
            Optional<BLangFunction> getClientOptional = obj.getFunctions().stream().filter(bLangFunction -> bLangFunction.getName().getValue().equals("getClient")).findFirst();
            if (getClientOptional.isPresent() && (returnTypeNode = getClientOptional.get().returnTypeNode) instanceof BLangUserDefinedType && (objectDefOptional = balPackage.getObjects().stream().filter(objDef -> objDef.getName().getValue().equals(((BLangUserDefinedType)returnTypeNode).getTypeName().getValue())).findFirst()).isPresent()) {
                BLangObject objectDefinition = objectDefOptional.get();
                objectDefinition.setName((IdentifierNode)epName);
                String objDesc = Generator.description((BLangNode)obj);
                return Generator.createDocForNode(objectDefinition, obj.functions, objDesc, true);
            }
            return null;
        }).collect(Collectors.toList());
        connectors.forEach(connectorDoc -> visitedObjects.add(connectorDoc.getObject()));
        documentables.addAll(connectors);
        balPackage.getObjects().removeAll(visitedObjects);
        for (BLangObject connector : balPackage.getObjects()) {
            if (!connector.getFlags().contains(Flag.PUBLIC)) continue;
            documentables.add(Generator.createDocForNode(connector, false));
        }
        for (BLangTypeDefinition enumNode : balPackage.getTypeDefinitions()) {
            if (!enumNode.getFlags().contains(Flag.PUBLIC)) continue;
            documentables.add(Generator.createDocForNode(enumNode));
        }
        for (BLangAnnotation annotation : balPackage.getAnnotations()) {
            if (!annotation.getFlags().contains(Flag.PUBLIC)) continue;
            documentables.add(Generator.createDocForNode(annotation));
        }
        for (BLangVariable var : balPackage.getGlobalVariables()) {
            if (!var.getFlags().contains(Flag.PUBLIC)) continue;
            documentables.add(Generator.createDocForNode(var));
        }
        ArrayList<Link> links = new ArrayList<Link>();
        PackageName packageNameHeading = null;
        for (Link pkgLink : packages) {
            if (pkgLink.caption.value.equals(currentPackageName)) {
                packageNameHeading = (PackageName)pkgLink.caption;
                links.add(new Link(pkgLink.caption, pkgLink.href, true));
                continue;
            }
            links.add(new Link(pkgLink.caption, pkgLink.href, false));
        }
        return new Page(description, packageNameHeading, documentables, links, primitives);
    }

    public static Page generatePageForPrimitives(BLangPackage balPackage, List<Link> packages, List<Link> primitives) {
        ArrayList<Documentable> primitiveTypes = new ArrayList<Documentable>();
        Properties descriptions = BallerinaDocUtils.loadPrimitivesDescriptions();
        for (Link primitiveType : primitives) {
            String type;
            String desc = descriptions.getProperty(type = primitiveType.caption.value);
            primitiveTypes.add(new PrimitiveTypeDoc(type, desc != null && !desc.isEmpty() ? BallerinaDocUtils.mdToHtml(desc) : desc, new ArrayList<Documentable>()));
        }
        if (balPackage.getFunctions().size() > 0) {
            for (BLangFunction function : balPackage.getFunctions()) {
                PrimitiveTypeDoc primitiveTypeDoc;
                TypeNode langType;
                if (!function.getFlags().contains(Flag.PUBLIC) || function.getReceiver() == null || (langType = function.getReceiver().getTypeNode()) instanceof BLangUserDefinedType) continue;
                Optional<PrimitiveTypeDoc> existingPrimitiveType = primitiveTypes.stream().filter(doc -> doc instanceof PrimitiveTypeDoc && ((PrimitiveTypeDoc)doc).name.equals(langType.toString())).map(doc -> (PrimitiveTypeDoc)doc).findFirst();
                if (existingPrimitiveType.isPresent()) {
                    primitiveTypeDoc = existingPrimitiveType.get();
                } else {
                    String desc = descriptions.getProperty(langType.toString());
                    primitiveTypeDoc = new PrimitiveTypeDoc(langType.toString(), desc != null && !desc.isEmpty() ? BallerinaDocUtils.mdToHtml(desc) : desc, new ArrayList<Documentable>());
                    primitiveTypes.add(primitiveTypeDoc);
                }
                primitiveTypeDoc.children.add(Generator.createDocForNode(function));
            }
        }
        ArrayList<Link> links = new ArrayList<Link>();
        for (Link pkgLink : packages) {
            if ("Primitive Types".equals(pkgLink.caption.value)) {
                links.add(new Link(pkgLink.caption, pkgLink.href, true));
                continue;
            }
            links.add(new Link(pkgLink.caption, pkgLink.href, false));
        }
        StaticCaption primitivesPageHeading = new StaticCaption("Primitive Types");
        return new Page(null, primitivesPageHeading, primitiveTypes, links, primitives);
    }

    public static EnumDoc createDocForNode(BLangTypeDefinition enumNode) {
        String enumName = enumNode.getName().getValue();
        ArrayList<Variable> enumerators = new ArrayList<Variable>();
        if (enumNode.getValueSet().size() > 0) {
            for (BLangExpression bLangExpression : enumNode.getValueSet()) {
            }
        }
        return new EnumDoc(enumName, Generator.description((BLangNode)enumNode), new ArrayList<Documentable>(), enumerators);
    }

    public static AnnotationDoc createDocForNode(BLangAnnotation annotationNode) {
        String annotationName = annotationNode.getName().getValue();
        String dataType = "-";
        String href = "";
        if (annotationNode.typeNode != null) {
            dataType = Generator.getTypeName(annotationNode.typeNode);
            href = Generator.extractLink(annotationNode.typeNode);
        }
        String attachments = annotationNode.attachmentPoints.stream().map(attachmentPoint -> attachmentPoint.attachmentPoint.getValue()).collect(Collectors.joining(", "));
        return new AnnotationDoc(annotationName, Generator.description((BLangNode)annotationNode), dataType, href, attachments);
    }

    private static String extractLink(BLangType typeNode) {
        if (typeNode instanceof BLangUserDefinedType) {
            BLangUserDefinedType type = (BLangUserDefinedType)typeNode;
            String pkg = type.pkgAlias.getValue();
            BTypeSymbol tsymbol = type.type.tsymbol;
            if (tsymbol instanceof BStructSymbol) {
                pkg = ((BStructSymbol)tsymbol).pkgID.getName().getValue();
            }
            return pkg + ".html#" + type.typeName.getValue();
        }
        if (typeNode instanceof BLangValueType) {
            if (((BLangValueType)typeNode).type != null && ((BLangValueType)typeNode).type.tsymbol != null) {
                return "primitive-types.html#" + typeNode.type.tsymbol.getName().value;
            }
        } else {
            return "";
        }
        return "";
    }

    public static GlobalVariableDoc createDocForNode(BLangVariable bLangVariable) {
        String globalVarName = bLangVariable.getName().getValue();
        String dataType = Generator.getTypeName(bLangVariable.getTypeNode());
        String desc = Generator.description((BLangNode)bLangVariable);
        return new GlobalVariableDoc(globalVarName, desc, new ArrayList<Documentable>(), dataType);
    }

    public static FunctionDoc createDocForNode(BLangFunction functionNode) {
        String functionName = functionNode.getName().value;
        ArrayList<Variable> parameters = new ArrayList<Variable>();
        ArrayList<Variable> returnParams = new ArrayList<Variable>();
        if (functionNode.getParameters().size() > 0) {
            for (BLangVariable param : functionNode.getParameters()) {
                String dataType = Generator.type(param);
                String desc = Generator.paramAnnotation((BLangNode)functionNode, param);
                String href = Generator.extractLink(param.getTypeNode());
                Variable variable = new Variable(param.getName().value, dataType, desc, href);
                parameters.add(variable);
            }
        }
        if (functionNode.getReturnTypeNode() != null) {
            BLangVariable returnParam = new BLangVariable();
            returnParam.typeNode = functionNode.getReturnTypeNode();
            String dataType = Generator.type(returnParam);
            if (!dataType.equals("null")) {
                String desc = Generator.returnParamAnnotation((BLangNode)functionNode);
                String href = Generator.extractLink(returnParam.getTypeNode());
                Variable variable = new Variable("", dataType, desc, href);
                returnParams.add(variable);
            }
        }
        return new FunctionDoc(functionName, Generator.description((BLangNode)functionNode), new ArrayList<Documentable>(), parameters, returnParams);
    }

    public static ActionDoc createDocForNode(BLangAction actionNode) {
        String actionName = actionNode.getName().value;
        ArrayList<Variable> parameters = new ArrayList<Variable>();
        ArrayList<Variable> returnParams = new ArrayList<Variable>();
        if (actionNode.getParameters().size() > 0) {
            for (BLangVariable param : actionNode.getParameters()) {
                String dataType = Generator.type(param);
                String desc = Generator.paramAnnotation((BLangNode)actionNode, param);
                String href = Generator.extractLink(param.getTypeNode());
                Variable variable = new Variable(param.getName().value, dataType, desc, href);
                parameters.add(variable);
            }
        }
        return new ActionDoc(actionName, Generator.description((BLangNode)actionNode), new ArrayList<Documentable>(), parameters, returnParams);
    }

    public static StructDoc createDocForNode(BLangRecord structNode) {
        String structName = structNode.getName().getValue();
        if (structName.contains(ANONYMOUS_STRUCT)) {
            structName = "Anonymous Struct";
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        if (structNode.getFields().size() > 0) {
            Generator.getFields((BLangNode)structNode, structNode.fields, fields);
        }
        return new StructDoc(structName, Generator.description((BLangNode)structNode), new ArrayList<Documentable>(), fields);
    }

    private static void getFields(BLangNode node, List<BLangVariable> allFields, List<Field> fields) {
        for (BLangVariable param : allFields) {
            if (!param.getFlags().contains(Flag.PUBLIC)) continue;
            String dataType = Generator.type(param);
            String desc = Generator.fieldAnnotation(node, (BLangNode)param);
            String defaultValue = "";
            if (null != param.getInitialExpression()) {
                defaultValue = param.getInitialExpression().toString();
            }
            String href = Generator.extractLink(param.getTypeNode());
            Field variable = new Field(param.getName().value, dataType, desc, defaultValue, href);
            fields.add(variable);
        }
    }

    public static ConnectorDoc createDocForNode(BLangObject connectorNode, List<BLangFunction> utilitiyFunctions, String description, boolean isConnector) {
        String connectorName = connectorNode.getName().value;
        ArrayList<Field> parameters = new ArrayList<Field>();
        ArrayList<Documentable> actions = new ArrayList<Documentable>();
        ArrayList<Documentable> functions = new ArrayList<Documentable>();
        if (connectorNode.fields.size() > 0) {
            Generator.getFields((BLangNode)connectorNode, connectorNode.fields, parameters);
        }
        if (connectorNode.getFunctions().size() > 0) {
            for (BLangFunction action : connectorNode.getFunctions()) {
                if (!action.flagSet.contains(Flag.PUBLIC)) continue;
                actions.add(Generator.createDocForNode(action));
            }
        }
        for (BLangFunction func : utilitiyFunctions) {
            if (!func.flagSet.contains(Flag.PUBLIC)) continue;
            functions.add(Generator.createDocForNode(func));
        }
        ConnectorDoc connectorDoc = new ConnectorDoc(connectorName, description == null ? Generator.description((BLangNode)connectorNode) : description, actions, parameters, functions, isConnector);
        connectorDoc.setObject(connectorNode);
        return connectorDoc;
    }

    public static ConnectorDoc createDocForNode(BLangObject connectorNode, boolean isConnector) {
        return Generator.createDocForNode(connectorNode, new ArrayList<BLangFunction>(), null, isConnector);
    }

    private static String type(BLangVariable bLangVariable) {
        if (bLangVariable.typeNode.getKind() == NodeKind.USER_DEFINED_TYPE && ((BLangUserDefinedType)bLangVariable.typeNode).typeName.value.contains(ANONYMOUS_STRUCT)) {
            return Generator.getAnonStructString((BStructType)bLangVariable.type);
        }
        return Generator.getTypeName(bLangVariable.typeNode);
    }

    private static String getTypeName(BLangType bLangType) {
        return bLangType instanceof BLangUserDefinedType ? ((BLangUserDefinedType)bLangType).typeName.value : bLangType.toString();
    }

    private static List<? extends AnnotationAttachmentNode> getAnnotationAttachments(BLangNode node) {
        return ((AnnotatableNode)node).getAnnotationAttachments();
    }

    private static String paramAnnotation(BLangNode node, BLangVariable param) {
        block3: {
            String subName;
            block2: {
                String string = subName = param.getName() == null ? param.type.tsymbol.name.value : param.getName().getValue();
                if (!(node instanceof DocumentableNode) || ((DocumentableNode)node).getDocumentationAttachments().isEmpty()) break block2;
                if (((DocumentableNode)node).getDocumentationAttachments().isEmpty()) break block3;
                DocumentationNode bLangDocumentation = (DocumentationNode)((DocumentableNode)node).getDocumentationAttachments().get(0);
                for (DocumentationAttributeNode attribute : bLangDocumentation.getAttributes()) {
                    if (!(attribute instanceof BLangDocumentationAttribute)) continue;
                    BLangDocumentationAttribute docAttribute = (BLangDocumentationAttribute)attribute;
                    if (docAttribute.docTag != DocTag.PARAM || !docAttribute.getDocumentationField().toString().equals(subName)) continue;
                    return BallerinaDocUtils.mdToHtml(attribute.getDocumentationText());
                }
                break block3;
            }
            for (AnnotationAttachmentNode annotationAttachmentNode : Generator.getAnnotationAttachments(node)) {
                BLangRecordLiteral bLangRecordLiteral = (BLangRecordLiteral)annotationAttachmentNode.getExpression();
                if (bLangRecordLiteral == null || bLangRecordLiteral.getKeyValuePairs().size() != 1) continue;
                BLangExpression bLangLiteral = ((BLangRecordLiteral.BLangRecordKeyValue)bLangRecordLiteral.getKeyValuePairs().get(0)).getValue();
                String attribVal = bLangLiteral.toString();
                if (!annotationAttachmentNode.getAnnotationName().getValue().equals("Param") || !attribVal.startsWith(subName + ":")) continue;
                return attribVal.split(subName + ":")[1].trim();
            }
        }
        return "";
    }

    public static String returnParamAnnotation(BLangNode node) {
        block3: {
            block2: {
                if (!(node instanceof DocumentableNode) || ((DocumentableNode)node).getDocumentationAttachments().isEmpty()) break block2;
                if (((DocumentableNode)node).getDocumentationAttachments().isEmpty()) break block3;
                DocumentationNode bLangDocumentation = (DocumentationNode)((DocumentableNode)node).getDocumentationAttachments().get(0);
                for (DocumentationAttributeNode attribute : bLangDocumentation.getAttributes()) {
                    if (!(attribute instanceof BLangDocumentationAttribute)) continue;
                    BLangDocumentationAttribute docAttribute = (BLangDocumentationAttribute)attribute;
                    if (docAttribute.docTag != DocTag.RETURN) continue;
                    return BallerinaDocUtils.mdToHtml(attribute.getDocumentationText());
                }
                break block3;
            }
            for (AnnotationAttachmentNode annotationAttachmentNode : Generator.getAnnotationAttachments(node)) {
                BLangRecordLiteral bLangRecordLiteral = (BLangRecordLiteral)annotationAttachmentNode.getExpression();
                if (bLangRecordLiteral == null || bLangRecordLiteral.getKeyValuePairs().size() != 1 || !annotationAttachmentNode.getAnnotationName().getValue().equals("Return")) continue;
                BLangExpression bLangLiteral = ((BLangRecordLiteral.BLangRecordKeyValue)bLangRecordLiteral.getKeyValuePairs().get(0)).getValue();
                return bLangLiteral.toString();
            }
        }
        return "";
    }

    private static String fieldAnnotation(BLangNode node, BLangNode param) {
        block4: {
            String subName;
            block3: {
                subName = "";
                if (param instanceof BLangVariable) {
                    BLangVariable paramVariable = (BLangVariable)param;
                    String string = subName = paramVariable.getName() == null ? paramVariable.type.tsymbol.name.value : paramVariable.getName().getValue();
                }
                if (!(node instanceof DocumentableNode) || ((DocumentableNode)node).getDocumentationAttachments().isEmpty()) break block3;
                if (((DocumentableNode)node).getDocumentationAttachments().isEmpty()) break block4;
                DocumentationNode bLangDocumentation = (DocumentationNode)((DocumentableNode)node).getDocumentationAttachments().get(0);
                for (DocumentationAttributeNode attribute : bLangDocumentation.getAttributes()) {
                    if (!(attribute instanceof BLangDocumentationAttribute)) continue;
                    BLangDocumentationAttribute docAttribute = (BLangDocumentationAttribute)attribute;
                    if (docAttribute.docTag != DocTag.FIELD || !docAttribute.getDocumentationField().toString().equals(subName)) continue;
                    return BallerinaDocUtils.mdToHtml(attribute.getDocumentationText());
                }
                break block4;
            }
            for (AnnotationAttachmentNode annotationAttachmentNode : Generator.getAnnotationAttachments(node)) {
                BLangRecordLiteral bLangRecordLiteral = (BLangRecordLiteral)annotationAttachmentNode.getExpression();
                if (bLangRecordLiteral.getKeyValuePairs().size() != 1) continue;
                BLangExpression bLangLiteral = ((BLangRecordLiteral.BLangRecordKeyValue)bLangRecordLiteral.getKeyValuePairs().get(0)).getValue();
                String attribVal = bLangLiteral.toString();
                if (!annotationAttachmentNode.getAnnotationName().getValue().equals("Field") || !attribVal.startsWith(subName + ":")) continue;
                return attribVal.split(subName + ":")[1].trim();
            }
        }
        return "";
    }

    private static String description(BLangNode node) {
        if (node instanceof DocumentableNode && !((DocumentableNode)node).getDocumentationAttachments().isEmpty()) {
            if (!((DocumentableNode)node).getDocumentationAttachments().isEmpty()) {
                DocumentationNode bLangDocumentation = (DocumentationNode)((DocumentableNode)node).getDocumentationAttachments().get(0);
                return BallerinaDocUtils.mdToHtml(bLangDocumentation.getDocumentationText());
            }
        } else {
            if (Generator.getAnnotationAttachments(node).size() == 0) {
                return null;
            }
            for (AnnotationAttachmentNode annotationAttachmentNode : Generator.getAnnotationAttachments(node)) {
                BLangRecordLiteral bLangRecordLiteral = (BLangRecordLiteral)annotationAttachmentNode.getExpression();
                if (bLangRecordLiteral == null || bLangRecordLiteral.getKeyValuePairs() == null || bLangRecordLiteral.getKeyValuePairs().size() != 1 || !annotationAttachmentNode.getAnnotationName().getValue().equals("Description")) continue;
                BLangExpression bLangLiteral = ((BLangRecordLiteral.BLangRecordKeyValue)bLangRecordLiteral.getKeyValuePairs().get(0)).getValue();
                return bLangLiteral.toString();
            }
        }
        return "";
    }

    private static String getAnonStructString(BStructType type) {
        StringBuilder builder = new StringBuilder();
        builder.append("struct {");
        int nFields = type.fields.size();
        for (int i = 0; i < nFields; ++i) {
            BStructType.BStructField field = (BStructType.BStructField)type.fields.get(i);
            builder.append(field.type.toString()).append(" ").append(field.name.value);
            if (i == nFields - 1) {
                return builder.append("}").toString();
            }
            builder.append(", ");
        }
        return builder.append("}").toString();
    }
}

