/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.docs;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.StringJoiner;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.docgen.Generator;
import org.ballerinalang.docgen.Writer;
import org.ballerinalang.docgen.docs.BallerinaDocDataHolder;
import org.ballerinalang.docgen.docs.utils.BallerinaDocUtils;
import org.ballerinalang.docgen.model.Caption;
import org.ballerinalang.docgen.model.Link;
import org.ballerinalang.docgen.model.PackageDoc;
import org.ballerinalang.docgen.model.PackageName;
import org.ballerinalang.docgen.model.Page;
import org.ballerinalang.model.elements.PackageID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.FileSystemProjectDirectory;
import org.wso2.ballerinalang.compiler.PackageLoader;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.semantics.analyzer.CodeAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemanticAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaDocGenerator {
    private static final Logger log = LoggerFactory.getLogger(BallerinaDocGenerator.class);
    private static final PrintStream out = System.out;
    private static final String BSOURCE_FILE_EXT = ".bal";
    private static final String PACKAGE_CONTENT_FILE = "Package.md";
    private static final Path BAL_BUILTIN = Paths.get("ballerina", "builtin");
    private static final String HTML = ".html";

    public static void generateApiDocs(String sourceRoot, String output, String packageFilter, boolean isNative, String ... sources) {
        out.println("docerina: API documentation generation for sources - " + Arrays.toString(sources));
        List<Link> primitives = BallerinaDocGenerator.primitives();
        for (String source : sources) {
            source = source.trim();
            try {
                Map<String, PackageDoc> docsMap = BallerinaDocGenerator.generatePackageDocsFromBallerina(sourceRoot, source, packageFilter, isNative);
                if (docsMap.size() == 0) {
                    out.println("docerina: no package definitions found!");
                    return;
                }
                if (BallerinaDocUtils.isDebugEnabled()) {
                    out.println("Generating HTML API documentation...");
                }
                String userDir = System.getProperty("user.dir");
                if (output == null) {
                    output = System.getProperty("html.output.path", userDir + File.separator + "api-docs" + File.separator + "html");
                }
                Files.createDirectories(Paths.get(output, new String[0]), new FileAttribute[0]);
                ArrayList<PackageDoc> packageList = new ArrayList<PackageDoc>(docsMap.values());
                packageList.sort(Comparator.comparing(pkg -> pkg.bLangPackage.packageID.toString()));
                ArrayList<String> packageNames = new ArrayList<String>(docsMap.keySet());
                Collections.sort(packageNames);
                List<Link> packageNameList = PackageName.convertList(packageNames);
                String packageTemplateName = System.getProperty("package.template.name", "page");
                String packageToCTemplateName = System.getProperty("package.toc.template.name", "toc");
                for (PackageDoc packageDoc : packageList) {
                    BLangPackage bLangPackage = packageDoc.bLangPackage;
                    String pkgDescription = packageDoc.description;
                    bLangPackage.getFunctions().sort(Comparator.comparing(f -> (f.getReceiver() == null ? "" : f.getReceiver().getName()) + f.getName().getValue()));
                    bLangPackage.getObjects().sort(Comparator.comparing(c -> c.getName().getValue()));
                    bLangPackage.getAnnotations().sort(Comparator.comparing(a -> a.getName().getValue()));
                    bLangPackage.getTypeDefinitions().sort(Comparator.comparing(a -> a.getName().getValue()));
                    bLangPackage.getRecords().sort(Comparator.comparing(a -> a.getName().getValue()));
                    bLangPackage.getGlobalVariables().sort(Comparator.comparing(a -> a.getName().getValue()));
                    String packagePath = BallerinaDocGenerator.refinePackagePath(bLangPackage);
                    Page page = Generator.generatePage(bLangPackage, packageNameList, pkgDescription, primitives);
                    String filePath = output + File.separator + packagePath + HTML;
                    Writer.writeHtmlDocument(page, packageTemplateName, filePath);
                    if (ConfigRegistry.getInstance().getAsBoolean("generateToc")) {
                        String tocFilePath = output + File.separator + packagePath + "-toc" + HTML;
                        Writer.writeHtmlDocument(page, packageToCTemplateName, tocFilePath);
                    }
                    if (!"builtin".equals(packagePath)) continue;
                    Page primitivesPage = Generator.generatePageForPrimitives(bLangPackage, packageNameList, primitives);
                    String primitivesFilePath = output + File.separator + "primitive-types" + HTML;
                    Writer.writeHtmlDocument(primitivesPage, packageTemplateName, primitivesFilePath);
                }
                String indexTemplateName = System.getProperty("package.template.name", "index");
                String indexFilePath = output + File.separator + "index" + HTML;
                Writer.writeHtmlDocument(packageNameList, indexTemplateName, indexFilePath);
                String pkgListTemplateName = System.getProperty("package.list.template.name", "package-list");
                String pkgListFilePath = output + File.separator + "package-list" + HTML;
                Writer.writeHtmlDocument(packageNameList, pkgListTemplateName, pkgListFilePath);
                if (BallerinaDocUtils.isDebugEnabled()) {
                    out.println("Copying HTML theme...");
                }
                BallerinaDocUtils.copyResources("docerina-theme", output);
            }
            catch (IOException e) {
                out.println(String.format("docerina: API documentation generation failed for %s: %s", source, e.getMessage()));
                log.error(String.format("API documentation generation failed for %s", source), (Throwable)e);
            }
        }
        try {
            String zipPath = System.getProperty("output.zip.path");
            if (zipPath != null) {
                BallerinaDocUtils.packageToZipFile(output, zipPath);
            }
        }
        catch (IOException e) {
            out.println(String.format("docerina: API documentation zip packaging failed for %s: %s", output, e.getMessage()));
            log.error(String.format("API documentation zip packaging failed for %s", output), (Throwable)e);
        }
    }

    protected static Map<String, PackageDoc> generatePackageDocsFromBallerina(String sourceRoot, String packagePath) throws IOException {
        return BallerinaDocGenerator.generatePackageDocsFromBallerina(sourceRoot, packagePath, null);
    }

    protected static Map<String, PackageDoc> generatePackageDocsFromBallerina(String sourceRoot, String packagePath, String packageFilter) throws IOException {
        return BallerinaDocGenerator.generatePackageDocsFromBallerina(sourceRoot, packagePath, packageFilter, false);
    }

    protected static Map<String, PackageDoc> generatePackageDocsFromBallerina(String sourceRoot, String packagePath, String packageFilter, boolean isNative) throws IOException {
        return BallerinaDocGenerator.generatePackageDocsFromBallerina(sourceRoot, Paths.get(packagePath, new String[0]), packageFilter, isNative);
    }

    protected static Map<String, PackageDoc> generatePackageDocsFromBallerina(String sourceRoot, Path packagePath, String packageFilter, boolean isNative) throws IOException {
        Path absolutePkgPath = Paths.get(sourceRoot, new String[0]).resolve(packagePath);
        Optional<Path> o = Files.find(absolutePkgPath, 1, (path, attr) -> {
            Path fileName = path.getFileName();
            if (fileName != null) {
                return fileName.toString().equals(PACKAGE_CONTENT_FILE);
            }
            return false;
        }, new FileVisitOption[0]).findFirst();
        Path packageMd = o.isPresent() ? o.get() : null;
        BallerinaDocDataHolder dataHolder = BallerinaDocDataHolder.getInstance();
        if (!isNative) {
            System.setProperty("skipNatives", "true");
        }
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRoot);
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.TYPE_CHECK.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
        context.put(SourceDirectory.class, (Object)new FileSystemProjectDirectory(Paths.get(sourceRoot, new String[0])));
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        BLangPackage bLangPackage = absolutePkgPath.endsWith(BAL_BUILTIN.toString()) ? BallerinaDocGenerator.loadBuiltInPackage(context) : compiler.compile(BallerinaDocGenerator.getPackageNameFromPath(packagePath));
        if (bLangPackage == null) {
            out.println(String.format("docerina: invalid Ballerina package: %s", packagePath));
        } else {
            String packageName = BallerinaDocGenerator.packageNameToString(bLangPackage.packageID);
            if (BallerinaDocGenerator.isFilteredPackage(packageName, packageFilter)) {
                if (BallerinaDocUtils.isDebugEnabled()) {
                    out.println("Package " + packageName + " excluded");
                }
            } else {
                dataHolder.getPackageMap().put(packageName, new PackageDoc(packageMd == null ? null : packageMd.toAbsolutePath(), bLangPackage));
            }
        }
        return dataHolder.getPackageMap();
    }

    private static String packageNameToString(PackageID pkgId) {
        return pkgId.toString().split(":")[0];
    }

    private static boolean isFilteredPackage(String packageName, String packageFilter) {
        if (packageFilter != null && packageFilter.trim().length() > 0) {
            return Arrays.asList(packageFilter.split(",")).stream().filter(e -> packageName.startsWith(e.replace(".*", ""))).findAny().isPresent();
        }
        return false;
    }

    private static String getPackageNameFromPath(Path path) {
        StringJoiner sj = new StringJoiner(".");
        Iterator<Path> pathItr = path.iterator();
        while (pathItr.hasNext()) {
            sj.add(pathItr.next().toString());
        }
        return sj.toString();
    }

    private static BLangPackage loadBuiltInPackage(CompilerContext context) {
        SymbolTable symbolTable = SymbolTable.getInstance((CompilerContext)context);
        BLangPackage builtInPkg = BallerinaDocGenerator.getBuiltInPackage(context);
        symbolTable.builtInPackageSymbol = builtInPkg.symbol;
        return builtInPkg;
    }

    private static BLangPackage getBuiltInPackage(CompilerContext context) {
        PackageLoader pkgLoader = PackageLoader.getInstance((CompilerContext)context);
        SemanticAnalyzer semAnalyzer = SemanticAnalyzer.getInstance((CompilerContext)context);
        CodeAnalyzer codeAnalyzer = CodeAnalyzer.getInstance((CompilerContext)context);
        return codeAnalyzer.analyze(semAnalyzer.analyze(pkgLoader.loadAndDefinePackage(Names.BUILTIN_ORG.getValue(), Names.BUILTIN_PACKAGE.getValue())));
    }

    private static List<Link> primitives() {
        Properties primitives = BallerinaDocUtils.loadPrimitivesDescriptions();
        ArrayList<Link> primitiveLinks = new ArrayList<Link>();
        for (Object primitive : primitives.keySet()) {
            String type = (String)primitive;
            primitiveLinks.add(new Link(new Caption(type), "primitive-types".concat(".html#" + type), true));
        }
        return primitiveLinks;
    }

    private static String refinePackagePath(BLangPackage bLangPackage) {
        if (bLangPackage == null) {
            return "";
        }
        if (bLangPackage.getPosition().getSource().getPackageName().equals(".")) {
            return bLangPackage.getPosition().getSource().getCompilationUnitName();
        }
        return bLangPackage.packageID.getName().getValue();
    }

    static class BallerinaSubPackageVisitor
    extends SimpleFileVisitor<Path> {
        private List<Path> subPackages;
        private Map<String, Path> packageMdsMap;

        public BallerinaSubPackageVisitor(List<Path> aList, Map<String, Path> map) {
            this.subPackages = aList;
            this.packageMdsMap = map;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path filePath;
            Path parent;
            if (file.toString().endsWith(BallerinaDocGenerator.BSOURCE_FILE_EXT)) {
                Path relativePath = file.getParent();
                if (!this.subPackages.contains(relativePath)) {
                    this.subPackages.add(relativePath);
                }
            } else if (file.toString().endsWith(BallerinaDocGenerator.PACKAGE_CONTENT_FILE) && (parent = file.getParent()) != null && (filePath = parent.getFileName()) != null) {
                this.packageMdsMap.putIfAbsent(filePath.toString(), file);
            }
            return FileVisitResult.CONTINUE;
        }

        public List<Path> getSubPackages() {
            return this.subPackages;
        }
    }
}

