/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.error;

import java.util.Collections;
import org.ballerinalang.jvm.api.BErrorCreator;
import org.ballerinalang.jvm.api.BStringUtils;
import org.ballerinalang.jvm.api.BValueCreator;
import org.ballerinalang.jvm.api.values.BMap;
import org.ballerinalang.jvm.api.values.BString;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.BLangConstants;
import org.ballerinalang.jvm.values.AbstractObjectValue;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.FutureValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.error", version="1.0.0", functionName="stackTrace", args={@Argument(name="value", type=TypeKind.ERROR)}, returnType={@ReturnType(type=TypeKind.OBJECT)})
public class StackTrace {
    public static ObjectValue stackTrace(Strand strand, ErrorValue value) {
        BObjectType callStackObjType = new BObjectType("CallStack", new BPackage("ballerina", "lang.error", null), 0);
        callStackObjType.setAttachedFunctions(new AttachedFunction[0]);
        callStackObjType.setFields(Collections.singletonMap("callStack", new BField((BType)new BArrayType(BTypes.typeAny), null, 0)));
        CallStack callStack = new CallStack(callStackObjType);
        callStack.callStack = StackTrace.getCallStackArray(value.getStackTrace());
        callStack.callStack.freezeDirect();
        return callStack;
    }

    private static ArrayValue getCallStackArray(StackTraceElement[] stackTrace) {
        BType recordType = BValueCreator.createRecordValue((BPackage)BLangConstants.BALLERINA_LANG_ERROR_PKG_ID, (String)"CallStackElement").getType();
        Object[] array = new Object[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            array[i] = StackTrace.getStackFrame(stackTrace[i]);
        }
        return new ArrayValueImpl(array, new BArrayType(recordType));
    }

    static BMap<BString, Object> getStackFrame(StackTraceElement stackTraceElement) {
        Object[] values = new Object[]{stackTraceElement.getMethodName(), stackTraceElement.getClassName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber()};
        return BValueCreator.createRecordValue((BMap)BValueCreator.createRecordValue((BPackage)BLangConstants.BALLERINA_LANG_ERROR_PKG_ID, (String)"CallStackElement"), (Object[])values);
    }

    public static class CallStack
    extends AbstractObjectValue {
        ArrayValue callStack;

        public CallStack(BObjectType type) {
            super(type);
        }

        public Object call(Strand strand, String funcName, Object ... args) {
            throw BErrorCreator.createError((BString)BStringUtils.fromString((String)("No such field or method: " + funcName)));
        }

        public FutureValue start(Strand strand, String funcName, Object ... args) {
            throw BErrorCreator.createError((BString)BStringUtils.fromString((String)("No such field or method: " + funcName)));
        }

        public Object get(BString fieldName) {
            if (fieldName.getValue().equals("callStack")) {
                return this.callStack;
            }
            throw BErrorCreator.createError((BString)BStringUtils.fromString((String)"No such field or method: callStack"));
        }

        public void set(BString fieldName, Object value) {
            throw BErrorCreator.createError((BString)BStringUtils.fromString((String)"No such field or method: callStack"));
        }
    }
}

