/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.java;

import io.ballerina.runtime.api.ErrorCreator;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.StringUtils;
import io.ballerina.runtime.api.ValueCreator;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.util.exceptions.BallerinaErrorReasons;

public class JavaUtils {
    private static final String booleanTypeName = "boolean";
    private static final String byteTypeName = "byte";
    private static final String shortTypeName = "short";
    private static final String charTypeName = "char";
    private static final String intTypeName = "int";
    private static final String longTypeName = "long";
    private static final String floatTypeName = "float";
    private static final String doubleTypeName = "double";
    private static final Module JAVA_PACKAGE_ID = new Module("ballerina", "java", "0.9.0");

    public static Object getClass(BString namebStr) {
        String name = namebStr.getValue();
        Class<?> clazz = JavaUtils.getPrimitiveTypeClass(name);
        if (clazz != null) {
            return ValueCreator.createHandleValue(clazz);
        }
        try {
            clazz = Class.forName(name);
            return ValueCreator.createHandleValue(clazz);
        }
        catch (ClassNotFoundException e) {
            return ErrorCreator.createDistinctError((String)BallerinaErrorReasons.JAVA_CLASS_NOT_FOUND_ERROR, (Module)JAVA_PACKAGE_ID, (BString)StringUtils.fromString((String)name));
        }
    }

    private static Class<?> getPrimitiveTypeClass(String name) {
        switch (name) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
        }
        return null;
    }
}

