/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.java;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypedescType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BHandle;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;

public class Cast {
    private static final String moduleName = "{ballerina/java}";
    private static final String annotationName = "@java:Binding";
    private static final String annotationType = "ballerina/java:0.9.0:Binding";
    private static final String classAttribute = "class";
    private static final String jObjField = "jObj";

    public static Object cast(BObject value, BTypedesc castType) {
        ObjectType objType = value.getType();
        String valueObjName = objType.getName();
        BHandle handleObj = (BHandle)value.get(StringUtils.fromString((String)jObjField));
        Object jObj = handleObj.getValue();
        if (jObj == null) {
            return ErrorCreator.createError((BString)StringUtils.fromString((String)("{ballerina/java} Empty handle reference found for `jObj` field in `" + valueObjName + "`")));
        }
        try {
            BString castObjClass;
            String castObjTypeName;
            ObjectType castObjType;
            BString objClass;
            try {
                BMap objAnnotation = (BMap)objType.getAnnotation(StringUtils.fromString((String)annotationType));
                objClass = objAnnotation.getStringValue(StringUtils.fromString((String)classAttribute));
            }
            catch (Exception e) {
                return ErrorCreator.createError((BString)StringUtils.fromString((String)("{ballerina/java} Error while retrieving details of the `@java:Binding` annotation from `" + valueObjName + "` object: " + e)));
            }
            Type describingBType = castType.getDescribingType();
            try {
                TypedescType describingType = (TypedescType)describingBType;
                castObjType = (ObjectType)describingType.getConstraint();
                castObjTypeName = castObjType.getName();
                Field objField = (Field)castObjType.getFields().get(jObjField);
                if (objField == null) {
                    return ErrorCreator.createError((BString)StringUtils.fromString((String)"{ballerina/java} Handle reference field `jObj` not found in the typedesc object"));
                }
            }
            catch (Exception e) {
                return ErrorCreator.createError((BString)StringUtils.fromString((String)("{ballerina/java} Error while processing the typedesc parameter: " + e)));
            }
            try {
                BMap castObjAnnotation = (BMap)castObjType.getAnnotation(StringUtils.fromString((String)annotationType));
                castObjClass = castObjAnnotation.getStringValue(StringUtils.fromString((String)classAttribute));
            }
            catch (Exception e) {
                return ErrorCreator.createError((BString)StringUtils.fromString((String)("{ballerina/java} Error while retrieving details of the `@java:Binding` annotation from `" + castObjTypeName + "` typedesc: " + e)));
            }
            Class<?> objClassType = Class.forName(objClass.getValue());
            Class<?> castObjClassType = Class.forName(castObjClass.getValue());
            boolean isList = objClassType.isAssignableFrom(castObjClassType);
            if (isList) {
                BObject bObject;
                try {
                    bObject = ValueCreator.createObjectValue((Module)objType.getPackage(), (String)castObjType.getName(), (Object[])new Object[]{ValueCreator.createHandleValue((Object)jObj)});
                }
                catch (Exception e) {
                    return ErrorCreator.createError((BString)StringUtils.fromString((String)("{ballerina/java} Error while initializing the new object from `" + castObjTypeName + "` type: " + e)));
                }
                return bObject;
            }
            return ErrorCreator.createError((BString)StringUtils.fromString((String)("{ballerina/java} Cannot cast `" + valueObjName + "` to `" + castObjTypeName + "`")));
        }
        catch (Exception e) {
            return ErrorCreator.createError((BString)StringUtils.fromString((String)("{ballerina/java} Error while casting `" + valueObjName + "` object to the typedesc provided: " + e)));
        }
    }
}

