/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.repository.CompiledPackage;
import org.wso2.ballerinalang.compiler.BinaryFileWriter;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.FileSystemProjectDirectory;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLog;

public class GenerateBalo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String isBuiltinFlag = args[0];
        String sourceDir = args[1];
        String targetDir = args[2];
        String libDir = args[3];
        String originalShouldCompileBalOrg = System.getProperty("BALLERINA_DEV_COMPILE_BALLERINA_ORG");
        String originalIsBuiltin = System.getProperty("BALLERINA_DEV_LOAD_BUILTIN_FROM_SOURCE");
        String originalHome = System.getProperty("ballerina.home");
        try {
            System.setProperty("BALLERINA_DEV_COMPILE_BALLERINA_ORG", "true");
            System.setProperty("BALLERINA_DEV_LOAD_BUILTIN_FROM_SOURCE", Boolean.valueOf(isBuiltinFlag).toString());
            System.setProperty("ballerina.home", libDir);
            GenerateBalo.genBalo(targetDir, sourceDir);
        }
        finally {
            GenerateBalo.unsetProperty("BALLERINA_DEV_COMPILE_BALLERINA_ORG", originalShouldCompileBalOrg);
            GenerateBalo.unsetProperty("BALLERINA_DEV_LOAD_BUILTIN_FROM_SOURCE", originalIsBuiltin);
            GenerateBalo.unsetProperty("ballerina.home", originalHome);
        }
    }

    private static void unsetProperty(String key, String val) throws IOException {
        if (val == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, val);
        }
    }

    private static void genBalo(String targetDir, String sourceRootDir) throws IOException {
        Files.createDirectories(Paths.get(targetDir, new String[0]), new FileAttribute[0]);
        CompilerContext context = new CompilerContext();
        context.put(SourceDirectory.class, (Object)new MvnSourceDirectory(sourceRootDir, targetDir));
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRootDir);
        options.put(CompilerOptionName.OFFLINE, Boolean.TRUE.toString());
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.CODE_GEN.toString());
        SymbolTable symbolTable = SymbolTable.getInstance((CompilerContext)context);
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        compiler.build();
        BLangDiagnosticLog diagnosticLog = BLangDiagnosticLog.getInstance((CompilerContext)context);
        if (diagnosticLog.errorCount > 0) {
            throw new BLangCompilerException("Compilation failed with " + diagnosticLog.errorCount + " error(s).");
        }
        BinaryFileWriter writer = BinaryFileWriter.getInstance((CompilerContext)context);
        BPackageSymbol symbol = symbolTable.builtInPackageSymbol;
        if (symbol.compiledPackage != null) {
            writer.writeLibraryPackage(symbol, Names.BUILTIN_PACKAGE.getValue());
        }
    }

    private static class MvnSourceDirectory
    extends FileSystemProjectDirectory {
        private final String targetDir;

        MvnSourceDirectory(String sourceRoot, String targetDir) {
            super(Paths.get(sourceRoot, new String[0]));
            this.targetDir = targetDir;
        }

        public void saveCompiledPackage(CompiledPackage compiledPackage, Path dirPath, String fileName) throws IOException {
            String dirName = fileName.endsWith(".zip") ? fileName.substring(0, fileName.length() - ".zip".length()) : fileName;
            Path path = Paths.get(this.targetDir, dirName, Names.DEFAULT_VERSION.getValue());
            super.saveCompiledPackage(compiledPackage, path, fileName);
        }
    }
}

