/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.StringJoiner;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.launcher.util.CompileResult;
import org.ballerinalang.repository.CompiledPackage;
import org.ballerinalang.util.diagnostic.DiagnosticListener;
import org.wso2.ballerinalang.compiler.BinaryFileWriter;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.FileSystemProjectDirectory;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.Names;

public class GenerateBalo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String isBuiltinFlag = args[0];
        String sourceDir = args[1];
        String targetDir = args[2];
        String libDir = args[3];
        boolean skipReportingWarnings = args.length > 4 && Boolean.parseBoolean(args[4]);
        String originalShouldCompileBalOrg = System.getProperty("BALLERINA_DEV_COMPILE_BALLERINA_ORG");
        String originalIsBuiltin = System.getProperty("BALLERINA_DEV_LOAD_BUILTIN_FROM_SOURCE");
        String originalHome = System.getProperty("ballerina.home");
        try {
            System.setProperty("BALLERINA_DEV_COMPILE_BALLERINA_ORG", "true");
            boolean isBuiltin = Boolean.parseBoolean(isBuiltinFlag);
            System.setProperty("BALLERINA_DEV_LOAD_BUILTIN_FROM_SOURCE", Boolean.toString(isBuiltin));
            System.setProperty("ballerina.home", libDir);
            boolean reportWarnings = !skipReportingWarnings;
            GenerateBalo.genBalo(targetDir, sourceDir, isBuiltin, reportWarnings);
        }
        finally {
            GenerateBalo.unsetProperty("BALLERINA_DEV_COMPILE_BALLERINA_ORG", originalShouldCompileBalOrg);
            GenerateBalo.unsetProperty("BALLERINA_DEV_LOAD_BUILTIN_FROM_SOURCE", originalIsBuiltin);
            GenerateBalo.unsetProperty("ballerina.home", originalHome);
        }
    }

    private static void unsetProperty(String key, String val) throws IOException {
        if (val == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, val);
        }
    }

    private static void genBalo(String targetDir, String sourceRootDir, boolean saveBuiltin, boolean reportWarnings) throws IOException {
        Files.createDirectories(Paths.get(targetDir, new String[0]), new FileAttribute[0]);
        CompilerContext context = new CompilerContext();
        CompileResult.CompileResultDiagnosticListener diagListner = new CompileResult.CompileResultDiagnosticListener();
        context.put(DiagnosticListener.class, (Object)diagListner);
        context.put(SourceDirectory.class, (Object)new MvnSourceDirectory(sourceRootDir, targetDir));
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRootDir);
        options.put(CompilerOptionName.OFFLINE, Boolean.TRUE.toString());
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.CODE_GEN.toString());
        options.put(CompilerOptionName.SKIP_TESTS, Boolean.TRUE.toString());
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.TRUE.toString());
        SymbolTable symbolTable = SymbolTable.getInstance((CompilerContext)context);
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        List buildPackages = compiler.compilePackages(false);
        List diagnostics = diagListner.getDiagnostics();
        if (diagListner.getErrorCount() > 0 || reportWarnings && diagListner.getWarnCount() > 0) {
            StringJoiner sj = new StringJoiner("\n  ");
            diagnostics.forEach(e -> sj.add(e.toString()));
            String warnMsg = reportWarnings ? " and " + diagListner.getWarnCount() + " warning(s)" : "";
            throw new BLangCompilerException("Compilation failed with " + diagListner.getErrorCount() + " error(s)" + warnMsg + " \n  " + sj.toString());
        }
        compiler.write(buildPackages);
        BinaryFileWriter writer = BinaryFileWriter.getInstance((CompilerContext)context);
        BPackageSymbol buitlinSymbol = symbolTable.builtInPackageSymbol;
        if (saveBuiltin && buitlinSymbol != null && buitlinSymbol.compiledPackage != null) {
            writer.writeLibraryPackage(buitlinSymbol, Names.BUILTIN_PACKAGE.getValue());
        }
    }

    private static class MvnSourceDirectory
    extends FileSystemProjectDirectory {
        private final String targetDir;

        MvnSourceDirectory(String sourceRoot, String targetDir) {
            super(Paths.get(sourceRoot, new String[0]));
            this.targetDir = targetDir;
        }

        public void saveCompiledPackage(CompiledPackage compiledPackage, Path dirPath, String fileName) throws IOException {
            String dirName = fileName.endsWith(".zip") ? fileName.substring(0, fileName.length() - ".zip".length()) : fileName;
            Path path = Paths.get(this.targetDir, dirName, Names.DEFAULT_VERSION.getValue());
            super.saveCompiledPackage(compiledPackage, path, fileName);
        }
    }
}

