/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.LogException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public class LogFileLock {
    private static Logger LOGGER = LoggerFactory.createLogger(LogFileLock.class);
    private static final String FILE_SEPARATOR = String.valueOf(File.separatorChar);
    private File lockfileToPreventDoubleStartup_;
    private FileOutputStream lockfilestream_ = null;
    private FileLock lock_ = null;
    private String dir;
    private String fileName;

    public LogFileLock(String dir2, String fileName) {
        if (!dir2.endsWith(FILE_SEPARATOR)) {
            dir2 = dir2 + FILE_SEPARATOR;
        }
        this.dir = dir2;
        this.fileName = fileName;
    }

    public void acquireLock() throws LogException {
        try {
            File parent = new File(this.dir);
            if (!parent.exists()) {
                parent.mkdirs();
            }
            this.lockfileToPreventDoubleStartup_ = new File(this.dir, this.fileName + ".lck");
            this.lockfilestream_ = new FileOutputStream(this.lockfileToPreventDoubleStartup_);
            FileLock tryLock = this.lockfilestream_.getChannel().tryLock();
            if (tryLock != null) {
                this.lock_ = tryLock;
                this.lockfileToPreventDoubleStartup_.deleteOnExit();
                return;
            }
        }
        catch (IOException | OverlappingFileLockException parent) {
            // empty catch block
        }
        String msg = "The specified log seems to be in use already: " + this.fileName + " in " + this.dir + ". Make sure that no other instance is running, or kill any pending process if needed.";
        LOGGER.logFatal(msg);
        throw new LogException(msg);
    }

    public void releaseLock() {
        try {
            if (this.lock_ != null) {
                this.lock_.release();
            }
            if (this.lockfilestream_ != null) {
                this.lockfilestream_.close();
            }
        }
        catch (IOException e) {
            LOGGER.logWarning("Error releasing file lock: " + e.getMessage());
        }
        finally {
            this.lock_ = null;
        }
        if (this.lockfileToPreventDoubleStartup_ != null) {
            this.lockfileToPreventDoubleStartup_.delete();
            this.lockfileToPreventDoubleStartup_ = null;
        }
    }
}

