/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.api.impl.symbols.BallerinaAnnotationSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaClassSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaConstantSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaFunctionSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaMethodSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaModule;
import io.ballerina.compiler.api.impl.symbols.BallerinaParameterSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaServiceSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTypeDefinitionSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaVariableSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaWorkerSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaXMLNSSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BServiceSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class SymbolFactory {
    private static final CompilerContext.Key<SymbolFactory> SYMBOL_FACTORY_KEY = new CompilerContext.Key();
    private final CompilerContext context;
    private final TypesFactory typesFactory;

    private SymbolFactory(CompilerContext context) {
        context.put(SYMBOL_FACTORY_KEY, this);
        this.context = context;
        this.typesFactory = TypesFactory.getInstance(context);
    }

    public static SymbolFactory getInstance(CompilerContext context) {
        SymbolFactory symbolFactory = context.get(SYMBOL_FACTORY_KEY);
        if (symbolFactory == null) {
            symbolFactory = new SymbolFactory(context);
        }
        return symbolFactory;
    }

    public Symbol getBCompiledSymbol(BSymbol symbol, String name) {
        if (symbol == null) {
            throw new IllegalArgumentException("Symbol is 'null'");
        }
        if (symbol instanceof BVarSymbol) {
            if (symbol.kind == SymbolKind.FUNCTION) {
                if (Symbols.isFlagOn(symbol.flags, 8L)) {
                    return this.createMethodSymbol((BInvokableSymbol)symbol, name);
                }
                return this.createFunctionSymbol((BInvokableSymbol)symbol, name);
            }
            if (symbol.kind == SymbolKind.ERROR_CONSTRUCTOR) {
                return this.createTypeDefinition(symbol.type.tsymbol, name);
            }
            if (symbol instanceof BConstantSymbol) {
                return this.createConstantSymbol((BConstantSymbol)symbol, name);
            }
            if (symbol.type instanceof BFutureType && ((BFutureType)symbol.type).workerDerivative) {
                return this.createWorkerSymbol((BVarSymbol)symbol, name);
            }
            if (symbol instanceof BServiceSymbol) {
                return this.createServiceSymbol((BServiceSymbol)symbol, name);
            }
            return this.createVariableSymbol((BVarSymbol)symbol, name);
        }
        if (symbol instanceof BTypeSymbol) {
            if (symbol.kind == SymbolKind.ANNOTATION) {
                return this.createAnnotationSymbol((BAnnotationSymbol)symbol);
            }
            if (symbol instanceof BPackageSymbol) {
                return this.createModuleSymbol((BPackageSymbol)symbol, name);
            }
            if (symbol instanceof BClassSymbol) {
                return this.createClassSymbol((BClassSymbol)symbol, name);
            }
            return this.createTypeDefinition((BTypeSymbol)symbol, name);
        }
        if (symbol.kind == SymbolKind.XMLNS) {
            return this.createXMLNamespaceSymbol((BXMLNSSymbol)symbol);
        }
        throw new IllegalArgumentException("Unsupported symbol type: " + symbol.getClass().getName());
    }

    public BallerinaFunctionSymbol createFunctionSymbol(BInvokableSymbol invokableSymbol, String name) {
        PackageID pkgID = invokableSymbol.pkgID;
        BallerinaFunctionSymbol.FunctionSymbolBuilder builder = new BallerinaFunctionSymbol.FunctionSymbolBuilder(name, pkgID, invokableSymbol);
        if (SymbolFactory.isFlagOn(invokableSymbol.flags, 1L)) {
            builder.withQualifier(Qualifier.PUBLIC);
        }
        if (SymbolFactory.isFlagOn(invokableSymbol.flags, 1024L)) {
            builder.withQualifier(Qualifier.PRIVATE);
        }
        if (SymbolFactory.isFlagOn(invokableSymbol.flags, 0x20000000L)) {
            builder.withQualifier(Qualifier.ISOLATED);
        }
        if (SymbolFactory.isFlagOn(invokableSymbol.flags, 32768L)) {
            builder.withQualifier(Qualifier.REMOTE);
        }
        if (SymbolFactory.isFlagOn(invokableSymbol.flags, 131072L)) {
            builder.withQualifier(Qualifier.RESOURCE);
        }
        if (SymbolFactory.isFlagOn(invokableSymbol.flags, 0x2000000L)) {
            builder.withQualifier(Qualifier.TRANSACTIONAL);
        }
        return builder.withTypeDescriptor((FunctionTypeSymbol)this.typesFactory.getTypeDescriptor(invokableSymbol.type)).build();
    }

    public BallerinaMethodSymbol createMethodSymbol(BInvokableSymbol invokableSymbol, String name) {
        TypeSymbol typeDescriptor = this.typesFactory.getTypeDescriptor(invokableSymbol.type);
        BallerinaFunctionSymbol functionSymbol = this.createFunctionSymbol(invokableSymbol, name);
        if (typeDescriptor.typeKind() == TypeDescKind.FUNCTION) {
            return new BallerinaMethodSymbol(functionSymbol);
        }
        throw new AssertionError((Object)"Invalid type descriptor found");
    }

    public BallerinaVariableSymbol createVariableSymbol(BVarSymbol symbol, String name) {
        PackageID pkgID = symbol.pkgID;
        BallerinaVariableSymbol.VariableSymbolBuilder symbolBuilder = new BallerinaVariableSymbol.VariableSymbolBuilder(name, pkgID, symbol);
        if (SymbolFactory.isFlagOn(symbol.flags, 4L) || SymbolFactory.isFlagOn(symbol.flags, 64L)) {
            symbolBuilder.withQualifier(Qualifier.FINAL);
        }
        if (SymbolFactory.isFlagOn(symbol.flags, 524288L)) {
            symbolBuilder.withQualifier(Qualifier.LISTENER);
        }
        if (SymbolFactory.isFlagOn(symbol.flags, 32L)) {
            symbolBuilder.withQualifier(Qualifier.READONLY);
        }
        return symbolBuilder.withTypeDescriptor(this.typesFactory.getTypeDescriptor(symbol.type)).build();
    }

    public BallerinaWorkerSymbol createWorkerSymbol(BVarSymbol symbol, String name) {
        return new BallerinaWorkerSymbol.WorkerSymbolBuilder(name, symbol.pkgID, symbol).withReturnType(this.typesFactory.getTypeDescriptor(((BFutureType)symbol.type).constraint)).build();
    }

    public BallerinaServiceSymbol createServiceSymbol(BServiceSymbol symbol, String name) {
        return new BallerinaServiceSymbol.ServiceSymbolBuilder(this.context, name, symbol.pkgID, symbol).build();
    }

    public ParameterSymbol createBallerinaParameter(BVarSymbol symbol, ParameterKind kind) {
        if (symbol == null) {
            return null;
        }
        String name = symbol.getName().getValue().isBlank() ? null : symbol.getName().getValue();
        TypeSymbol typeDescriptor = this.typesFactory.getTypeDescriptor(symbol.getType());
        ArrayList<Qualifier> qualifiers = new ArrayList<Qualifier>();
        if ((symbol.flags & 1L) == 1L) {
            qualifiers.add(Qualifier.PUBLIC);
        }
        return new BallerinaParameterSymbol(name, typeDescriptor, qualifiers, kind);
    }

    public BallerinaTypeDefinitionSymbol createTypeDefinition(BTypeSymbol typeSymbol, String name) {
        BallerinaTypeDefinitionSymbol.TypeDefSymbolBuilder symbolBuilder = new BallerinaTypeDefinitionSymbol.TypeDefSymbolBuilder(name, typeSymbol.pkgID, typeSymbol);
        if (SymbolFactory.isFlagOn(typeSymbol.flags, 1L)) {
            symbolBuilder.withQualifier(Qualifier.PUBLIC);
        }
        return symbolBuilder.withTypeDescriptor(this.typesFactory.getTypeDescriptor(typeSymbol.type, true)).build();
    }

    public BallerinaClassSymbol createClassSymbol(BClassSymbol classSymbol, String name) {
        TypeSymbol type = this.typesFactory.getTypeDescriptor(classSymbol.type, true);
        return this.createClassSymbol(classSymbol, name, type);
    }

    public BallerinaClassSymbol createClassSymbol(BClassSymbol classSymbol, String name, TypeSymbol type) {
        BallerinaClassSymbol.ClassSymbolBuilder symbolBuilder = new BallerinaClassSymbol.ClassSymbolBuilder(this.context, name, classSymbol.pkgID, (BSymbol)classSymbol);
        if (SymbolFactory.isFlagOn(classSymbol.flags, 1L)) {
            symbolBuilder.withQualifier(Qualifier.PUBLIC);
        }
        if (SymbolFactory.isFlagOn(classSymbol.flags, 0x8000000L)) {
            symbolBuilder.withQualifier(Qualifier.DISTINCT);
        }
        if (SymbolFactory.isFlagOn(classSymbol.flags, 65536L)) {
            symbolBuilder.withQualifier(Qualifier.CLIENT);
        }
        if (SymbolFactory.isFlagOn(classSymbol.flags, 32L)) {
            symbolBuilder.withQualifier(Qualifier.READONLY);
        }
        if (type.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            type = ((TypeReferenceTypeSymbol)type).typeDescriptor();
        }
        return symbolBuilder.withTypeDescriptor((ObjectTypeSymbol)type).build();
    }

    public BallerinaConstantSymbol createConstantSymbol(BConstantSymbol constantSymbol, String name) {
        BallerinaConstantSymbol.ConstantSymbolBuilder symbolBuilder = new BallerinaConstantSymbol.ConstantSymbolBuilder(name, constantSymbol.pkgID, constantSymbol);
        symbolBuilder.withConstValue(constantSymbol.getConstValue()).withTypeDescriptor(this.typesFactory.getTypeDescriptor(constantSymbol.literalType));
        if ((constantSymbol.flags & 1L) == 1L) {
            symbolBuilder.withQualifier(Qualifier.PUBLIC);
        }
        return symbolBuilder.build();
    }

    public BallerinaAnnotationSymbol createAnnotationSymbol(BAnnotationSymbol symbol) {
        BallerinaAnnotationSymbol.AnnotationSymbolBuilder symbolBuilder = new BallerinaAnnotationSymbol.AnnotationSymbolBuilder(symbol.name.getValue(), symbol.pkgID, symbol);
        if ((symbol.flags & 1L) == 1L) {
            symbolBuilder.withQualifier(Qualifier.PUBLIC);
        }
        if (symbol.attachedType != null && symbol.attachedType.getType() != null) {
            symbolBuilder.withTypeDescriptor(this.typesFactory.getTypeDescriptor(symbol.attachedType.getType()));
        }
        return symbolBuilder.build();
    }

    public BallerinaXMLNSSymbol createXMLNamespaceSymbol(BXMLNSSymbol symbol) {
        BallerinaXMLNSSymbol.XmlNSSymbolBuilder symbolBuilder = new BallerinaXMLNSSymbol.XmlNSSymbolBuilder(symbol.name.getValue(), symbol.pkgID, symbol);
        return symbolBuilder.build();
    }

    public BallerinaModule createModuleSymbol(BPackageSymbol symbol, String name) {
        return new BallerinaModule.ModuleSymbolBuilder(this.context, name, symbol.pkgID, symbol).build();
    }

    public static boolean isFlagOn(long mask, long flags) {
        return (mask & flags) == flags;
    }
}

