/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.api.impl.PositionUtil;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import java.util.List;
import org.ballerinalang.model.clauses.OrderKeyNode;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.AnnotatableNode;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownReferenceDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangRetrySpec;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeySpecifier;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeyTypeConstraint;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangJoinClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLimitClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnConflictClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIgnoreExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIntRangeExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsLikeExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkDownDeprecatedParametersDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkDownDeprecationDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownDocumentationLine;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownReturnParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableMultiKeyExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementFilter;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWorkerSend;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;

class SymbolFinder
extends BLangNodeVisitor {
    private LinePosition cursorPos;
    private BSymbol symbolAtCursor;

    SymbolFinder() {
    }

    BSymbol lookup(BLangCompilationUnit unit, LinePosition cursorPos) {
        this.cursorPos = cursorPos;
        this.symbolAtCursor = null;
        for (TopLevelNode node : unit.topLevelNodes) {
            if (!PositionUtil.withinBlock(this.cursorPos, node.getPosition()) && !this.isWithinNodeMetaData(node) || this.isLambdaFunction(node)) continue;
            ((BLangNode)((Object)node)).accept(this);
        }
        return this.symbolAtCursor;
    }

    private void lookupNodes(List<? extends BLangNode> nodes) {
        for (BLangNode bLangNode : nodes) {
            if (!PositionUtil.withinBlock(this.cursorPos, bLangNode.pos)) continue;
            bLangNode.accept(this);
        }
    }

    private void lookupNode(BLangNode node) {
        if (node == null) {
            return;
        }
        if (PositionUtil.withinBlock(this.cursorPos, node.pos)) {
            node.accept(this);
        }
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
        if (importPkgNode.orgName.pos != null && this.setEnclosingNode(importPkgNode.symbol, importPkgNode.orgName.pos)) {
            return;
        }
        if (this.setEnclosingNode(importPkgNode.symbol, importPkgNode.alias.pos)) {
            return;
        }
        if (importPkgNode.version.pos != null) {
            this.setEnclosingNode(importPkgNode.symbol, importPkgNode.version.pos);
        }
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        if (this.setEnclosingNode(xmlnsNode.symbol, xmlnsNode.prefix.pos)) {
            return;
        }
        this.lookupNode(xmlnsNode.namespaceURI);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        if (this.setEnclosingNode(funcNode.symbol, funcNode.name.pos)) {
            return;
        }
        this.lookupNodes(funcNode.requiredParams);
        this.lookupNode(funcNode.restParam);
        this.lookupNode(funcNode.returnTypeNode);
        this.lookupNode(funcNode.body);
    }

    @Override
    public void visit(BLangBlockFunctionBody blockFuncBody) {
        this.lookupNodes(blockFuncBody.stmts);
    }

    @Override
    public void visit(BLangExprFunctionBody exprFuncBody) {
        this.lookupNode(exprFuncBody.expr);
    }

    @Override
    public void visit(BLangExternalFunctionBody externFuncBody) {
        this.lookupNodes(externFuncBody.annAttachments);
    }

    @Override
    public void visit(BLangService serviceNode) {
        if (this.setEnclosingNode(serviceNode.symbol, serviceNode.name.pos)) {
            return;
        }
        this.lookupNodes(serviceNode.resourceFunctions);
        this.lookupNodes(serviceNode.annAttachments);
        this.lookupNodes(serviceNode.attachedExprs);
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        if (this.setEnclosingNode(typeDefinition.symbol, typeDefinition.name.pos)) {
            return;
        }
        this.lookupNode(typeDefinition.typeNode);
    }

    @Override
    public void visit(BLangConstant constant) {
        if (this.setEnclosingNode(constant.symbol, constant.name.pos)) {
            return;
        }
        this.lookupNode(constant.typeNode);
        this.lookupNode(constant.expr);
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        if (this.setEnclosingNode(varNode.symbol, varNode.name.pos)) {
            return;
        }
        this.lookupNode(varNode.typeNode);
        this.lookupNode(varNode.expr);
    }

    @Override
    public void visit(BLangIdentifier identifierNode) {
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
        if (this.setEnclosingNode(annotationNode.symbol, annotationNode.name.pos)) {
            return;
        }
        this.lookupNode(annotationNode.typeNode);
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
        if (this.setEnclosingNode(annAttachmentNode.annotationSymbol, annAttachmentNode.annotationName.pos)) {
            return;
        }
        this.lookupNode(annAttachmentNode.expr);
    }

    @Override
    public void visit(BLangTableKeySpecifier tableKeySpecifierNode) {
    }

    @Override
    public void visit(BLangTableKeyTypeConstraint tableKeyTypeConstraint) {
        this.lookupNode(tableKeyTypeConstraint.keyType);
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        this.lookupNodes(blockNode.stmts);
    }

    @Override
    public void visit(BLangLock.BLangLockStmt lockStmtNode) {
        this.lookupNode(lockStmtNode.body);
    }

    @Override
    public void visit(BLangLock.BLangUnLockStmt unLockNode) {
        this.lookupNode(unLockNode.body);
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        this.lookupNode(varDefNode.var);
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        this.lookupNode(assignNode.varRef);
        this.lookupNode(assignNode.expr);
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignNode) {
        this.lookupNode(compoundAssignNode.varRef);
        this.lookupNode(compoundAssignNode.expr);
    }

    @Override
    public void visit(BLangRetry retryNode) {
        this.lookupNode(retryNode.retryBody);
        this.lookupNode(retryNode.retrySpec);
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction) {
        this.lookupNode(retryTransaction.transaction);
        this.lookupNode(retryTransaction.retrySpec);
    }

    @Override
    public void visit(BLangRetrySpec retrySpec) {
        this.lookupNode(retrySpec.retryManagerType);
        this.lookupNodes(retrySpec.argExprs);
    }

    @Override
    public void visit(BLangContinue continueNode) {
    }

    @Override
    public void visit(BLangBreak breakNode) {
    }

    @Override
    public void visit(BLangReturn returnNode) {
        this.lookupNode(returnNode.expr);
    }

    @Override
    public void visit(BLangPanic panicNode) {
        this.lookupNode(panicNode.expr);
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        this.lookupNode(xmlnsStmtNode.xmlnsDecl);
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        this.lookupNode(exprStmtNode.expr);
    }

    @Override
    public void visit(BLangIf ifNode) {
        this.lookupNode(ifNode.expr);
        this.lookupNode(ifNode.body);
        this.lookupNode(ifNode.elseStmt);
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        this.lookupNodes(queryAction.queryClauseList);
        this.lookupNode(queryAction.doClause);
    }

    @Override
    public void visit(BLangMatch matchNode) {
        this.lookupNode(matchNode.expr);
        this.lookupNodes(matchNode.patternClauses);
    }

    @Override
    public void visit(BLangMatch.BLangMatchTypedBindingPatternClause patternClauseNode) {
        this.lookupNode(patternClauseNode.matchExpr);
        this.lookupNode(patternClauseNode.variable);
        this.lookupNode(patternClauseNode.body);
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.lookupNode((BLangNode)((Object)foreach.variableDefinitionNode));
        this.lookupNode(foreach.collection);
        this.lookupNode(foreach.body);
    }

    @Override
    public void visit(BLangFromClause fromClause) {
        this.lookupNode(fromClause.collection);
        this.lookupNode((BLangNode)((Object)fromClause.variableDefinitionNode));
    }

    @Override
    public void visit(BLangJoinClause joinClause) {
        this.lookupNode(joinClause.collection);
        this.lookupNode((BLangNode)((Object)joinClause.variableDefinitionNode));
        this.lookupNode((BLangNode)((Object)joinClause.onClause));
    }

    @Override
    public void visit(BLangLetClause letClause) {
        for (BLangLetVariable var : letClause.letVarDeclarations) {
            this.lookupNode((BLangNode)((Object)var.definitionNode));
        }
    }

    @Override
    public void visit(BLangOnClause onClause) {
        this.lookupNode(onClause.lhsExpr);
        this.lookupNode(onClause.rhsExpr);
    }

    @Override
    public void visit(BLangOrderKey orderKeyClause) {
        this.lookupNode(orderKeyClause.expression);
    }

    @Override
    public void visit(BLangOrderByClause orderByClause) {
        for (OrderKeyNode key : orderByClause.orderByKeyList) {
            this.lookupNode((BLangNode)((Object)key));
        }
    }

    @Override
    public void visit(BLangSelectClause selectClause) {
        this.lookupNode(selectClause.expression);
    }

    @Override
    public void visit(BLangWhereClause whereClause) {
        this.lookupNode(whereClause.expression);
    }

    @Override
    public void visit(BLangDoClause doClause) {
        this.lookupNode(doClause.body);
    }

    @Override
    public void visit(BLangOnConflictClause onConflictClause) {
        this.lookupNode(onConflictClause.expression);
    }

    @Override
    public void visit(BLangLimitClause limitClause) {
        this.lookupNode(limitClause.expression);
    }

    @Override
    public void visit(BLangWhile whileNode) {
        this.lookupNode(whileNode.expr);
        this.lookupNode(whileNode.body);
    }

    @Override
    public void visit(BLangLock lockNode) {
        this.lookupNode(lockNode.body);
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        this.lookupNode(transactionNode.transactionBody);
    }

    @Override
    public void visit(BLangTupleDestructure stmt) {
        this.lookupNode(stmt.expr);
        this.lookupNode(stmt.varRef);
    }

    @Override
    public void visit(BLangRecordDestructure stmt) {
        this.lookupNode(stmt.expr);
        this.lookupNode(stmt.varRef);
    }

    @Override
    public void visit(BLangErrorDestructure stmt) {
        this.lookupNode(stmt.expr);
        this.lookupNode(stmt.varRef);
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        this.lookupNodes(forkJoin.workers);
    }

    @Override
    public void visit(BLangWorkerSend workerSendNode) {
        if (this.setEnclosingNode(workerSendNode.workerSymbol, workerSendNode.workerIdentifier.pos)) {
            return;
        }
        this.lookupNode(workerSendNode.expr);
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        this.setEnclosingNode(workerReceiveNode.workerSymbol, workerReceiveNode.workerIdentifier.pos);
    }

    @Override
    public void visit(BLangRollback rollbackNode) {
        this.lookupNode(rollbackNode.expr);
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
    }

    @Override
    public void visit(BLangConstRef constRef) {
        this.symbolAtCursor = constRef.symbol;
    }

    @Override
    public void visit(BLangNumericLiteral literalExpr) {
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            this.lookupNode((BLangNode)((Object)field));
        }
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
        this.lookupNodes(varRefExpr.expressions);
        this.lookupNode((BLangNode)((Object)varRefExpr.restParam));
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        this.lookupNode(varRefExpr.message);
        this.lookupNodes(varRefExpr.detail);
        this.lookupNode(varRefExpr.cause);
        this.lookupNode(varRefExpr.restVar);
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        if (this.setEnclosingNode(varRefExpr.symbol, varRefExpr.variableName.pos)) {
            return;
        }
        this.setEnclosingNode(varRefExpr.pkgSymbol, varRefExpr.pkgAlias.pos);
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        if (this.setEnclosingNode(fieldAccessExpr.symbol, fieldAccessExpr.field.pos)) {
            return;
        }
        this.lookupNode(fieldAccessExpr.expr);
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        this.lookupNode(indexAccessExpr.expr);
        if (indexAccessExpr.indexExpr instanceof BLangLiteral) {
            this.setEnclosingNode(indexAccessExpr.symbol, indexAccessExpr.indexExpr.pos);
        } else {
            this.lookupNode(indexAccessExpr.indexExpr);
        }
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        if (invocationExpr.symbol != null && this.setEnclosingNode(invocationExpr.symbol.owner, invocationExpr.pkgAlias.pos) || this.setEnclosingNode(invocationExpr.symbol, invocationExpr.name.pos)) {
            return;
        }
        this.lookupNodes(invocationExpr.requiredArgs);
        this.lookupNodes(invocationExpr.restArgs);
        this.lookupNode(invocationExpr.expr);
    }

    @Override
    public void visit(BLangTypeInit typeInit) {
        this.lookupNodes(typeInit.argsExpr);
        this.setEnclosingNode(typeInit.type.tsymbol, typeInit.pos);
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInvocationExpr) {
        if (actionInvocationExpr.symbol != null && this.setEnclosingNode(actionInvocationExpr.symbol.owner, actionInvocationExpr.pkgAlias.pos) || this.setEnclosingNode(actionInvocationExpr.symbol, actionInvocationExpr.name.pos)) {
            return;
        }
        this.lookupNodes(actionInvocationExpr.requiredArgs);
        this.lookupNodes(actionInvocationExpr.restArgs);
        this.lookupNode(actionInvocationExpr.expr);
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        this.lookupNode(ternaryExpr.expr);
        this.lookupNode(ternaryExpr.thenExpr);
        this.lookupNode(ternaryExpr.elseExpr);
    }

    @Override
    public void visit(BLangWaitExpr awaitExpr) {
        this.lookupNodes(awaitExpr.exprList);
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        this.lookupNode(trapExpr.expr);
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        this.lookupNode(binaryExpr.lhsExpr);
        this.lookupNode(binaryExpr.rhsExpr);
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        this.lookupNode(elvisExpr.lhsExpr);
        this.lookupNode(elvisExpr.rhsExpr);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        this.lookupNode(groupExpr.expression);
    }

    @Override
    public void visit(BLangLetExpression letExpr) {
        for (BLangLetVariable var : letExpr.letVarDeclarations) {
            this.lookupNode((BLangNode)((Object)var.definitionNode));
        }
        this.lookupNode(letExpr.expr);
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        this.lookupNodes(listConstructorExpr.exprs);
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        this.lookupNode(tableConstructorExpr.tableKeySpecifier);
        this.lookupNodes(tableConstructorExpr.recordLiteralList);
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangTupleLiteral tupleLiteral) {
        this.lookupNodes(tupleLiteral.exprs);
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangArrayLiteral arrayLiteral) {
        this.lookupNodes(arrayLiteral.exprs);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        this.lookupNode(unaryExpr.expr);
    }

    @Override
    public void visit(BLangTypedescExpr typedescExpr) {
        this.lookupNode(typedescExpr.typeNode);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        this.lookupNodes(conversionExpr.annAttachments);
        this.lookupNode(conversionExpr.typeNode);
        this.lookupNode(conversionExpr.expr);
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
        if (this.setEnclosingNode(xmlQName.nsSymbol, xmlQName.prefix.pos)) {
            return;
        }
        this.setEnclosingNode(xmlQName.nsSymbol, xmlQName.localname.pos);
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        this.lookupNode(xmlAttribute.name);
        this.lookupNode(xmlAttribute.value);
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        this.lookupNode(xmlElementLiteral.startTagName);
        this.lookupNodes(xmlElementLiteral.attributes);
        this.lookupNodes(xmlElementLiteral.children);
        this.lookupNode(xmlElementLiteral.endTagName);
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        this.lookupNode(xmlTextLiteral.concatExpr);
        this.lookupNodes(xmlTextLiteral.textFragments);
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        this.lookupNode(xmlCommentLiteral.concatExpr);
        this.lookupNodes(xmlCommentLiteral.textFragments);
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        this.lookupNode(xmlProcInsLiteral.dataConcatExpr);
        this.lookupNodes(xmlProcInsLiteral.dataFragments);
        this.lookupNode(xmlProcInsLiteral.target);
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        this.lookupNode(xmlQuotedString.concatExpr);
        this.lookupNodes(xmlQuotedString.textFragments);
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        this.lookupNodes(stringTemplateLiteral.exprs);
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral) {
        this.lookupNodes(rawTemplateLiteral.strings);
        this.lookupNodes(rawTemplateLiteral.insertions);
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        this.lookupNode(bLangLambdaFunction.function);
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        this.lookupNodes(bLangArrowFunction.params);
        this.lookupNode(bLangArrowFunction.body);
    }

    @Override
    public void visit(BLangIntRangeExpression intRangeExpression) {
        this.lookupNode(intRangeExpression.startExpr);
        this.lookupNode(intRangeExpression.endExpr);
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.lookupNode(bLangVarArgsExpression.expr);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        this.lookupNode(bLangNamedArgsExpression.expr);
    }

    @Override
    public void visit(BLangIsAssignableExpr assignableExpr) {
        this.lookupNode(assignableExpr.lhsExpr);
        this.lookupNode(assignableExpr.typeNode);
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.lookupNode(checkedExpr.expr);
    }

    @Override
    public void visit(BLangFail failExpr) {
        this.lookupNode(failExpr.expr);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkPanickedExpr) {
        this.lookupNode(checkPanickedExpr.expr);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        this.lookupNode(serviceConstructorExpr.serviceNode);
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        this.lookupNode(typeTestExpr.expr);
        this.lookupNode(typeTestExpr.typeNode);
    }

    @Override
    public void visit(BLangIsLikeExpr typeTestExpr) {
        this.lookupNode(typeTestExpr.expr);
        this.lookupNode(typeTestExpr.typeNode);
    }

    @Override
    public void visit(BLangIgnoreExpr ignoreExpr) {
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
    }

    @Override
    public void visit(BLangTableMultiKeyExpr tableMultiKeyExpr) {
        super.visit(tableMultiKeyExpr);
    }

    @Override
    public void visit(BLangTransactionalExpr transactionalExpr) {
        super.visit(transactionalExpr);
    }

    @Override
    public void visit(BLangCommitExpr commitExpr) {
        super.visit(commitExpr);
    }

    @Override
    public void visit(BLangValueType valueType) {
        this.symbolAtCursor = valueType.type.tsymbol;
    }

    @Override
    public void visit(BLangArrayType arrayType) {
        this.lookupNode(arrayType.elemtype);
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefType) {
        this.symbolAtCursor = builtInRefType.type.tsymbol;
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
        this.lookupNode(constrainedType.constraint);
        if (this.symbolAtCursor == null) {
            this.symbolAtCursor = ((BLangNode)constrainedType).type.tsymbol;
        }
    }

    @Override
    public void visit(BLangStreamType streamType) {
        this.lookupNode(streamType.constraint);
        this.lookupNode(streamType.error);
    }

    @Override
    public void visit(BLangTableTypeNode tableType) {
        this.lookupNode(tableType.constraint);
        this.lookupNode(tableType.tableKeySpecifier);
        this.lookupNode(tableType.tableKeyTypeConstraint);
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
        if (userDefinedType.type.tsymbol == null) {
            return;
        }
        if (userDefinedType.type.tsymbol.origin == SymbolOrigin.VIRTUAL || this.setEnclosingNode(userDefinedType.type.tsymbol, userDefinedType.typeName.pos)) {
            return;
        }
        this.setEnclosingNode(userDefinedType.type.tsymbol.owner, userDefinedType.pkgAlias.pos);
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        this.lookupNodes(functionTypeNode.params);
        this.lookupNode(functionTypeNode.restParam);
        this.lookupNode(functionTypeNode.returnTypeNode);
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        this.lookupNodes(unionTypeNode.memberTypeNodes);
    }

    @Override
    public void visit(BLangIntersectionTypeNode intersectionTypeNode) {
        this.lookupNodes(intersectionTypeNode.constituentTypeNodes);
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        if (classDefinition.flagSet.contains((Object)Flag.SERVICE)) {
            return;
        }
        if (this.setEnclosingNode(classDefinition.symbol, classDefinition.name.pos)) {
            return;
        }
        this.lookupNodes(classDefinition.annAttachments);
        this.lookupNodes(classDefinition.fields);
        this.lookupNodes(classDefinition.referencedFields);
        this.lookupNode(classDefinition.initFunction);
        this.lookupNodes(classDefinition.functions);
        this.lookupNodes(classDefinition.typeRefs);
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        this.lookupNodes(objectTypeNode.fields);
        this.lookupNodes(objectTypeNode.functions);
        this.lookupNodes(objectTypeNode.typeRefs);
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        this.lookupNodes(recordTypeNode.fields);
        this.lookupNodes(recordTypeNode.typeRefs);
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
        this.lookupNodes(finiteTypeNode.valueSpace);
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        this.lookupNodes(tupleTypeNode.memberTypeNodes);
        this.lookupNode(tupleTypeNode.restParamType);
    }

    @Override
    public void visit(BLangErrorType errorType) {
        this.lookupNode(errorType.detailType);
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangLocalVarRef localVarRef) {
        this.symbolAtCursor = localVarRef.symbol;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFieldVarRef fieldVarRef) {
        this.symbolAtCursor = fieldVarRef.symbol;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangPackageVarRef packageVarRef) {
        this.symbolAtCursor = packageVarRef.symbol;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFunctionVarRef functionVarRef) {
        this.symbolAtCursor = functionVarRef.symbol;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangTypeLoad typeLoad) {
        this.symbolAtCursor = typeLoad.symbol;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStructFieldAccessExpr fieldAccessExpr) {
        this.lookupNode(fieldAccessExpr.expr);
        this.setEnclosingNode(fieldAccessExpr.symbol, fieldAccessExpr.indexExpr.pos);
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangStructFunctionVarRef functionVarRef) {
        if (this.setEnclosingNode(functionVarRef.symbol, functionVarRef.field.pos)) {
            return;
        }
        this.lookupNode(functionVarRef.expr);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangMapAccessExpr mapKeyAccessExpr) {
        this.lookupNode(mapKeyAccessExpr.expr);
        this.lookupNode(mapKeyAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangArrayAccessExpr arrayIndexAccessExpr) {
        this.lookupNode(arrayIndexAccessExpr.expr);
        this.lookupNode(arrayIndexAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTableAccessExpr tableKeyAccessExpr) {
        this.lookupNode(tableKeyAccessExpr.expr);
        this.lookupNode(tableKeyAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangXMLAccessExpr xmlAccessExpr) {
        this.lookupNode(xmlAccessExpr.expr);
        this.lookupNode(xmlAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangRecordLiteral.BLangMapLiteral mapLiteral) {
        for (RecordLiteralNode.RecordField field : mapLiteral.fields) {
            this.lookupNode((BLangNode)((Object)field));
        }
    }

    @Override
    public void visit(BLangRecordLiteral.BLangStructLiteral structLiteral) {
        for (RecordLiteralNode.RecordField field : structLiteral.fields) {
            this.lookupNode((BLangNode)((Object)field));
        }
    }

    @Override
    public void visit(BLangInvocation.BFunctionPointerInvocation bFunctionPointerInvocation) {
        if (this.setEnclosingNode(bFunctionPointerInvocation.symbol, bFunctionPointerInvocation.name.pos)) {
            return;
        }
        this.lookupNodes(bFunctionPointerInvocation.requiredArgs);
        this.lookupNodes(bFunctionPointerInvocation.restArgs);
    }

    @Override
    public void visit(BLangInvocation.BLangAttachedFunctionInvocation iExpr) {
        if (this.setEnclosingNode(iExpr.symbol, iExpr.name.pos)) {
            return;
        }
        this.lookupNode(iExpr.expr);
        this.lookupNodes(iExpr.requiredArgs);
        this.lookupNodes(iExpr.restArgs);
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangJSONArrayLiteral jsonArrayLiteral) {
        this.lookupNodes(jsonArrayLiteral.exprs);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangJSONAccessExpr jsonAccessExpr) {
        this.lookupNode(jsonAccessExpr.expr);
        this.lookupNode(jsonAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStringAccessExpr stringAccessExpr) {
        this.lookupNode(stringAccessExpr.expr);
        this.lookupNode(stringAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangXMLNS.BLangLocalXMLNS xmlnsNode) {
        if (this.setEnclosingNode(xmlnsNode.symbol, xmlnsNode.prefix.pos)) {
            return;
        }
        this.lookupNode(xmlnsNode.namespaceURI);
    }

    @Override
    public void visit(BLangXMLNS.BLangPackageXMLNS xmlnsNode) {
        if (this.setEnclosingNode(xmlnsNode.symbol, xmlnsNode.prefix.pos)) {
            return;
        }
        this.lookupNode(xmlnsNode.namespaceURI);
    }

    @Override
    public void visit(BLangXMLSequenceLiteral bLangXMLSequenceLiteral) {
        this.lookupNodes(bLangXMLSequenceLiteral.xmlItems);
    }

    @Override
    public void visit(BLangStatementExpression bLangStatementExpression) {
        this.lookupNode(bLangStatementExpression.expr);
    }

    @Override
    public void visit(BLangMarkdownDocumentationLine bLangMarkdownDocumentationLine) {
    }

    @Override
    public void visit(BLangMarkdownParameterDocumentation bLangDocumentationParameter) {
    }

    @Override
    public void visit(BLangMarkdownReturnParameterDocumentation bLangMarkdownReturnParameterDocumentation) {
    }

    @Override
    public void visit(BLangMarkDownDeprecationDocumentation bLangMarkDownDeprecationDocumentation) {
    }

    @Override
    public void visit(BLangMarkDownDeprecatedParametersDocumentation bLangMarkDownDeprecatedParametersDocumentation) {
    }

    @Override
    public void visit(BLangMarkdownDocumentation bLangMarkdownDocumentation) {
    }

    @Override
    public void visit(BLangTupleVariable bLangTupleVariable) {
        this.lookupNodes(bLangTupleVariable.memberVariables);
        this.lookupNode(bLangTupleVariable.restVariable);
        this.lookupNode(bLangTupleVariable.expr);
    }

    @Override
    public void visit(BLangTupleVariableDef bLangTupleVariableDef) {
        this.lookupNode(bLangTupleVariableDef.var);
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable) {
        for (BLangRecordVariable.BLangRecordVariableKeyValue var : bLangRecordVariable.variableList) {
            this.lookupNode(var.valueBindingPattern);
        }
        this.lookupNode((BLangNode)((Object)bLangRecordVariable.restParam));
        this.lookupNodes(bLangRecordVariable.annAttachments);
    }

    @Override
    public void visit(BLangRecordVariableDef bLangRecordVariableDef) {
        this.lookupNode(bLangRecordVariableDef.var);
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable) {
        this.lookupNode(bLangErrorVariable.message);
        for (BLangErrorVariable.BLangErrorDetailEntry detail : bLangErrorVariable.detail) {
            this.lookupNode(detail.valueBindingPattern);
        }
        this.lookupNode(bLangErrorVariable.detailExpr);
        this.lookupNode(bLangErrorVariable.cause);
        this.lookupNode(bLangErrorVariable.reasonMatchConst);
        this.lookupNode(bLangErrorVariable.restDetail);
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef) {
        this.lookupNode(bLangErrorVariableDef.errorVariable);
    }

    @Override
    public void visit(BLangMatch.BLangMatchStaticBindingPatternClause bLangMatchStmtStaticBindingPatternClause) {
        this.lookupNode(bLangMatchStmtStaticBindingPatternClause.matchExpr);
        this.lookupNode(bLangMatchStmtStaticBindingPatternClause.literal);
        this.lookupNode(bLangMatchStmtStaticBindingPatternClause.body);
    }

    @Override
    public void visit(BLangMatch.BLangMatchStructuredBindingPatternClause bLangMatchStmtStructuredBindingPatternClause) {
        this.lookupNode(bLangMatchStmtStructuredBindingPatternClause.bindingPatternVariable);
        this.lookupNode(bLangMatchStmtStructuredBindingPatternClause.typeGuardExpr);
        this.lookupNode(bLangMatchStmtStructuredBindingPatternClause.matchExpr);
        this.lookupNode(bLangMatchStmtStructuredBindingPatternClause.body);
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        this.setEnclosingNode(workerFlushExpr.workerSymbol, workerFlushExpr.workerIdentifier.pos);
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        if (this.setEnclosingNode(syncSendExpr.workerSymbol, syncSendExpr.workerIdentifier.pos)) {
            return;
        }
        this.lookupNode(syncSendExpr.expr);
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr) {
        super.visit(waitForAllExpr);
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitLiteral waitLiteral) {
        super.visit(waitLiteral);
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordKeyValueField recordKeyValue) {
        this.lookupNode(recordKeyValue.key);
        this.lookupNode(recordKeyValue.valueExpr);
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordSpreadOperatorField spreadOperatorField) {
        this.lookupNode(spreadOperatorField.expr);
    }

    @Override
    public void visit(BLangMarkdownReferenceDocumentation bLangMarkdownReferenceDocumentation) {
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitKeyValue waitKeyValue) {
        super.visit(waitKeyValue);
    }

    @Override
    public void visit(BLangXMLElementFilter xmlElementFilter) {
        this.setEnclosingNode(xmlElementFilter.namespaceSymbol, xmlElementFilter.elemNamePos);
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        this.lookupNode(xmlElementAccess.expr);
        this.lookupNodes(xmlElementAccess.filters);
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        this.lookupNode(xmlNavigation.expr);
        this.lookupNode(xmlNavigation.childIndex);
        this.lookupNodes(xmlNavigation.filters);
    }

    private boolean setEnclosingNode(BSymbol symbol, Location pos) {
        if (PositionUtil.withinBlock(this.cursorPos, pos)) {
            this.symbolAtCursor = symbol;
            return true;
        }
        return false;
    }

    private boolean isLambdaFunction(TopLevelNode node) {
        if (node.getKind() != NodeKind.FUNCTION) {
            return false;
        }
        BLangFunction func = (BLangFunction)node;
        return func.flagSet.contains((Object)Flag.LAMBDA);
    }

    private boolean isWithinNodeMetaData(TopLevelNode node) {
        if (!(node instanceof AnnotatableNode)) {
            return false;
        }
        List<? extends AnnotationAttachmentNode> nodes = ((AnnotatableNode)((Object)node)).getAnnotationAttachments();
        for (AnnotationAttachmentNode annotationAttachmentNode : nodes) {
            if (!PositionUtil.withinBlock(this.cursorPos, annotationAttachmentNode.getPosition())) continue;
            return true;
        }
        return false;
    }
}

