/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;

public class BallerinaFunctionSymbol
extends BallerinaSymbol
implements FunctionSymbol {
    private final FunctionTypeSymbol typeDescriptor;
    private final List<Qualifier> qualifiers;
    private final boolean isExternal;
    private final boolean deprecated;

    protected BallerinaFunctionSymbol(String name, PackageID moduleID, List<Qualifier> qualifiers, FunctionTypeSymbol typeDescriptor, BInvokableSymbol invokableSymbol) {
        super(name, moduleID, SymbolKind.FUNCTION, invokableSymbol);
        this.qualifiers = Collections.unmodifiableList(qualifiers);
        this.typeDescriptor = typeDescriptor;
        this.isExternal = Symbols.isFlagOn(invokableSymbol.flags, 2L);
        this.deprecated = Symbols.isFlagOn(invokableSymbol.flags, 16L);
    }

    @Override
    public List<Qualifier> qualifiers() {
        return this.qualifiers;
    }

    @Override
    public FunctionTypeSymbol typeDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    public boolean external() {
        return this.isExternal;
    }

    @Override
    public boolean deprecated() {
        return this.deprecated;
    }

    public static class FunctionSymbolBuilder
    extends BallerinaSymbol.SymbolBuilder<FunctionSymbolBuilder> {
        protected List<Qualifier> qualifiers = new ArrayList<Qualifier>();
        protected FunctionTypeSymbol typeDescriptor;

        public FunctionSymbolBuilder(String name, PackageID moduleID, BInvokableSymbol bSymbol) {
            this(name, moduleID, SymbolKind.FUNCTION, bSymbol);
        }

        public FunctionSymbolBuilder(String name, PackageID moduleID, SymbolKind kind, BInvokableSymbol bSymbol) {
            super(name, moduleID, kind, bSymbol);
        }

        public FunctionSymbolBuilder withTypeDescriptor(FunctionTypeSymbol typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public FunctionSymbolBuilder withQualifier(Qualifier qualifier) {
            this.qualifiers.add(qualifier);
            return this;
        }

        public FunctionSymbolBuilder withQualifiers(List<Qualifier> qualifiers) {
            this.qualifiers.addAll(qualifiers);
            return this;
        }

        @Override
        public BallerinaFunctionSymbol build() {
            return new BallerinaFunctionSymbol(this.name, this.moduleID, this.qualifiers, this.typeDescriptor, (BInvokableSymbol)this.bSymbol);
        }
    }
}

