/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaFunctionTypeSymbol
extends AbstractTypeSymbol
implements FunctionTypeSymbol {
    private List<ParameterSymbol> requiredParams;
    private ParameterSymbol restParam;
    private TypeSymbol returnType;
    private final BInvokableTypeSymbol typeSymbol;

    public BallerinaFunctionTypeSymbol(CompilerContext context, ModuleID moduleID, BInvokableTypeSymbol invokableSymbol) {
        super(context, TypeDescKind.FUNCTION, moduleID, invokableSymbol.type);
        this.typeSymbol = invokableSymbol;
    }

    @Override
    public List<ParameterSymbol> parameters() {
        if (this.requiredParams == null) {
            SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
            this.requiredParams = this.typeSymbol.params.stream().map(symbol -> {
                ParameterKind parameterKind = symbol.defaultableParam ? ParameterKind.DEFAULTABLE : ParameterKind.REQUIRED;
                return symbolFactory.createBallerinaParameter((BVarSymbol)symbol, parameterKind);
            }).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return this.requiredParams;
    }

    @Override
    public Optional<ParameterSymbol> restParam() {
        if (this.restParam == null) {
            SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
            this.restParam = symbolFactory.createBallerinaParameter(this.typeSymbol.restParam, ParameterKind.REST);
        }
        return Optional.ofNullable(this.restParam);
    }

    @Override
    public Optional<TypeSymbol> returnTypeDescriptor() {
        if (this.returnType == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.returnType = typesFactory.getTypeDescriptor(this.typeSymbol.returnType);
        }
        return Optional.ofNullable(this.returnType);
    }

    @Override
    public String signature() {
        StringBuilder signature = new StringBuilder("function (");
        StringJoiner joiner = new StringJoiner(", ");
        for (ParameterSymbol requiredParam : this.parameters()) {
            String ballerinaParameterSignature = requiredParam.signature();
            joiner.add(ballerinaParameterSignature);
        }
        this.restParam().ifPresent(ballerinaParameter -> joiner.add(ballerinaParameter.signature()));
        signature.append(joiner.toString()).append(")");
        this.returnTypeDescriptor().ifPresent(typeDescriptor -> signature.append(" returns ").append(typeDescriptor.signature()));
        return signature.toString();
    }
}

