/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaTupleTypeSymbol
extends AbstractTypeSymbol
implements TupleTypeSymbol {
    private List<TypeSymbol> memberTypes;
    private TypeSymbol restTypeDesc;

    public BallerinaTupleTypeSymbol(CompilerContext context, ModuleID moduleID, BTupleType tupleType) {
        super(context, TypeDescKind.TUPLE, moduleID, tupleType);
    }

    @Override
    public List<TypeSymbol> memberTypeDescriptors() {
        if (this.memberTypes == null) {
            ArrayList<TypeSymbol> types = new ArrayList<TypeSymbol>();
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            for (BType type : ((BTupleType)this.getBType()).tupleTypes) {
                types.add(typesFactory.getTypeDescriptor(type));
            }
            this.memberTypes = Collections.unmodifiableList(types);
        }
        return this.memberTypes;
    }

    @Override
    public Optional<TypeSymbol> restTypeDescriptor() {
        if (this.restTypeDesc == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.restTypeDesc = typesFactory.getTypeDescriptor(((BTupleType)this.getBType()).restType);
        }
        return Optional.ofNullable(this.restTypeDesc);
    }

    @Override
    public String signature() {
        StringJoiner joiner = new StringJoiner(", ");
        for (TypeSymbol typeDescriptorImpl : this.memberTypeDescriptors()) {
            String typeDescriptorSignature = typeDescriptorImpl.signature();
            joiner.add(typeDescriptorSignature);
        }
        if (this.restTypeDescriptor().isPresent()) {
            joiner.add("..." + this.restTypeDescriptor().get().signature());
        }
        return "[" + joiner.toString() + "]";
    }
}

