/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;

public class BallerinaTypeDefinitionSymbol
extends BallerinaSymbol
implements TypeDefinitionSymbol {
    private final List<Qualifier> qualifiers;
    private final TypeSymbol typeDescriptor;
    private final boolean deprecated;
    private final boolean readonly;

    protected BallerinaTypeDefinitionSymbol(String name, PackageID moduleID, List<Qualifier> qualifiers, TypeSymbol typeDescriptor, BSymbol bSymbol) {
        super(name, moduleID, SymbolKind.TYPE, bSymbol);
        this.qualifiers = Collections.unmodifiableList(qualifiers);
        this.typeDescriptor = typeDescriptor;
        this.deprecated = Symbols.isFlagOn(bSymbol.flags, 16L);
        this.readonly = Symbols.isFlagOn(bSymbol.flags, 32L);
    }

    @Override
    public String moduleQualifiedName() {
        return this.moduleID().moduleName() + ":" + this.name();
    }

    @Override
    public List<Qualifier> qualifiers() {
        return this.qualifiers;
    }

    @Override
    public TypeSymbol typeDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    public boolean deprecated() {
        return this.deprecated;
    }

    @Override
    public boolean readonly() {
        return this.readonly;
    }

    public static class TypeDefSymbolBuilder
    extends BallerinaSymbol.SymbolBuilder<TypeDefSymbolBuilder> {
        protected List<Qualifier> qualifiers = new ArrayList<Qualifier>();
        protected TypeSymbol typeDescriptor;

        public TypeDefSymbolBuilder(String name, PackageID moduleID, BSymbol symbol) {
            super(name, moduleID, SymbolKind.TYPE, symbol);
        }

        public TypeDefSymbolBuilder withTypeDescriptor(TypeSymbol typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public TypeDefSymbolBuilder withQualifier(Qualifier qualifier) {
            this.qualifiers.add(qualifier);
            return this;
        }

        @Override
        public BallerinaTypeDefinitionSymbol build() {
            return new BallerinaTypeDefinitionSymbol(this.name, this.moduleID, this.qualifiers, this.typeDescriptor, this.bSymbol);
        }
    }
}

