/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaSingletonTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaUnionTypeSymbol
extends AbstractTypeSymbol
implements UnionTypeSymbol {
    private List<TypeSymbol> memberTypes;

    public BallerinaUnionTypeSymbol(CompilerContext context, ModuleID moduleID, BUnionType unionType) {
        super(context, TypeDescKind.UNION, moduleID, unionType);
    }

    public BallerinaUnionTypeSymbol(CompilerContext context, ModuleID moduleID, BFiniteType finiteType) {
        super(context, TypeDescKind.UNION, moduleID, finiteType);
    }

    @Override
    public List<TypeSymbol> memberTypeDescriptors() {
        if (this.memberTypes == null) {
            ArrayList<TypeSymbol> members = new ArrayList<TypeSymbol>();
            if (this.getBType().tag == 20) {
                TypesFactory typesFactory = TypesFactory.getInstance(this.context);
                for (BType memberType : ((BUnionType)this.getBType()).getMemberTypes()) {
                    members.add(typesFactory.getTypeDescriptor(memberType));
                }
            } else {
                for (BLangExpression value : ((BFiniteType)this.getBType()).getValueSpace()) {
                    members.add(new BallerinaSingletonTypeSymbol(this.context, this.moduleID(), value, value.type));
                }
            }
            this.memberTypes = Collections.unmodifiableList(members);
        }
        return this.memberTypes;
    }

    @Override
    public String signature() {
        List<TypeSymbol> memberTypes = this.memberTypeDescriptors();
        if (memberTypes.size() == 2 && memberTypes.get(1).typeKind() == TypeDescKind.NIL) {
            return memberTypes.get(0).signature() + "?";
        }
        StringJoiner joiner = new StringJoiner("|");
        memberTypes.forEach(typeDescriptor -> joiner.add(typeDescriptor.signature()));
        return joiner.toString();
    }
}

