/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;

public class BallerinaVariableSymbol
extends BallerinaSymbol
implements VariableSymbol {
    private final List<Qualifier> qualifiers;
    private final TypeSymbol typeDescriptorImpl;
    private final boolean deprecated;

    protected BallerinaVariableSymbol(String name, PackageID moduleID, SymbolKind ballerinaSymbolKind, List<Qualifier> qualifiers, TypeSymbol typeDescriptorImpl, BSymbol bSymbol) {
        super(name, moduleID, ballerinaSymbolKind, bSymbol);
        this.qualifiers = Collections.unmodifiableList(qualifiers);
        this.typeDescriptorImpl = typeDescriptorImpl;
        this.deprecated = Symbols.isFlagOn(bSymbol.flags, 16L);
    }

    @Override
    public List<Qualifier> qualifiers() {
        return this.qualifiers;
    }

    @Override
    public TypeSymbol typeDescriptor() {
        return this.typeDescriptorImpl;
    }

    @Override
    public boolean deprecated() {
        return this.deprecated;
    }

    public static class VariableSymbolBuilder
    extends BallerinaSymbol.SymbolBuilder<VariableSymbolBuilder> {
        protected List<Qualifier> qualifiers = new ArrayList<Qualifier>();
        protected TypeSymbol typeDescriptor;

        public VariableSymbolBuilder(String name, PackageID moduleID, BSymbol bSymbol) {
            super(name, moduleID, SymbolKind.VARIABLE, bSymbol);
        }

        @Override
        public BallerinaVariableSymbol build() {
            return new BallerinaVariableSymbol(this.name, this.moduleID, this.ballerinaSymbolKind, this.qualifiers, this.typeDescriptor, this.bSymbol);
        }

        public VariableSymbolBuilder withTypeDescriptor(TypeSymbol typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public VariableSymbolBuilder withQualifier(Qualifier qualifier) {
            this.qualifiers.add(qualifier);
            return this;
        }
    }
}

