/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.XMLTypeSymbol;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaXMLTypeSymbol
extends AbstractTypeSymbol
implements XMLTypeSymbol {
    private TypeSymbol typeParameter;
    private String typeName;

    public BallerinaXMLTypeSymbol(CompilerContext context, ModuleID moduleID, BXMLType xmlType) {
        super(context, TypeDescKind.XML, moduleID, xmlType);
    }

    public BallerinaXMLTypeSymbol(CompilerContext context, ModuleID moduleID, BXMLSubType xmlSubType) {
        super(context, TypeDescKind.XML, moduleID, xmlSubType);
        this.typeName = xmlSubType.name.getValue();
    }

    @Override
    public Optional<TypeSymbol> typeParameter() {
        if (this.typeParameter == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.typeParameter = typesFactory.getTypeDescriptor(((BXMLType)this.getBType()).constraint);
        }
        return Optional.ofNullable(this.typeParameter);
    }

    @Override
    public String name() {
        if (this.typeName == null) {
            BXMLType xmlType = (BXMLType)this.getBType();
            SymbolTable symbolTable = SymbolTable.getInstance(this.context);
            this.typeName = xmlType == symbolTable.xmlType || this.typeParameter().isEmpty() ? "xml" : "xml<" + this.typeParameter().get().name() + ">";
        }
        return this.typeName;
    }

    @Override
    public String signature() {
        return this.name();
    }
}

