/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.compiler.internal.parser.AbstractParser;
import io.ballerina.compiler.internal.parser.AbstractParserErrorHandler;
import io.ballerina.compiler.internal.parser.AbstractTokenReader;
import io.ballerina.compiler.internal.parser.BallerinaParserErrorHandler;
import io.ballerina.compiler.internal.parser.DocumentationLexer;
import io.ballerina.compiler.internal.parser.DocumentationParser;
import io.ballerina.compiler.internal.parser.OperatorPrecedence;
import io.ballerina.compiler.internal.parser.ParserMode;
import io.ballerina.compiler.internal.parser.ParserRuleContext;
import io.ballerina.compiler.internal.parser.SyntaxErrors;
import io.ballerina.compiler.internal.parser.TokenReader;
import io.ballerina.compiler.internal.parser.XMLLexer;
import io.ballerina.compiler.internal.parser.XMLParser;
import io.ballerina.compiler.internal.parser.tree.STAmbiguousCollectionNode;
import io.ballerina.compiler.internal.parser.tree.STAnnotAccessExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STArrayTypeDescriptorNode;
import io.ballerina.compiler.internal.parser.tree.STAsyncSendActionNode;
import io.ballerina.compiler.internal.parser.tree.STBinaryExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STBracedExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STConditionalExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STDefaultableParameterNode;
import io.ballerina.compiler.internal.parser.tree.STFieldAccessExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STFunctionArgumentNode;
import io.ballerina.compiler.internal.parser.tree.STFunctionCallExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STFunctionSignatureNode;
import io.ballerina.compiler.internal.parser.tree.STFunctionTypeDescriptorNode;
import io.ballerina.compiler.internal.parser.tree.STIndexedExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STIntersectionTypeDescriptorNode;
import io.ballerina.compiler.internal.parser.tree.STListConstructorExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STMappingConstructorExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STMissingToken;
import io.ballerina.compiler.internal.parser.tree.STNamedArgumentNode;
import io.ballerina.compiler.internal.parser.tree.STNilLiteralNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STNodeList;
import io.ballerina.compiler.internal.parser.tree.STObjectTypeDescriptorNode;
import io.ballerina.compiler.internal.parser.tree.STOptionalFieldAccessExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STOptionalTypeDescriptorNode;
import io.ballerina.compiler.internal.parser.tree.STPositionalArgumentNode;
import io.ballerina.compiler.internal.parser.tree.STQualifiedNameReferenceNode;
import io.ballerina.compiler.internal.parser.tree.STRemoteMethodCallActionNode;
import io.ballerina.compiler.internal.parser.tree.STRequiredParameterNode;
import io.ballerina.compiler.internal.parser.tree.STRestArgumentNode;
import io.ballerina.compiler.internal.parser.tree.STRestBindingPatternNode;
import io.ballerina.compiler.internal.parser.tree.STRestParameterNode;
import io.ballerina.compiler.internal.parser.tree.STSimpleNameReferenceNode;
import io.ballerina.compiler.internal.parser.tree.STSpecificFieldNode;
import io.ballerina.compiler.internal.parser.tree.STSyncSendActionNode;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.internal.parser.tree.STTypeReferenceTypeDescNode;
import io.ballerina.compiler.internal.parser.tree.STTypeTestExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STTypedBindingPatternNode;
import io.ballerina.compiler.internal.parser.tree.STUnaryExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STUnionTypeDescriptorNode;
import io.ballerina.compiler.internal.syntax.SyntaxUtils;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.text.CharReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class BallerinaParser
extends AbstractParser {
    private static final OperatorPrecedence DEFAULT_OP_PRECEDENCE = OperatorPrecedence.DEFAULT;

    protected BallerinaParser(AbstractTokenReader tokenReader) {
        super(tokenReader, new BallerinaParserErrorHandler(tokenReader));
    }

    @Override
    public STNode parse() {
        return this.parseCompUnit();
    }

    public STNode parse(ParserRuleContext context) {
        switch (context) {
            case COMP_UNIT: {
                return this.parseCompUnit();
            }
            case TOP_LEVEL_NODE: {
                this.startContext(ParserRuleContext.COMP_UNIT);
                return this.parseTopLevelNode();
            }
            case STATEMENT: {
                this.startContext(ParserRuleContext.COMP_UNIT);
                this.startContext(ParserRuleContext.FUNC_BODY_BLOCK);
                return this.parseStatement();
            }
            case EXPRESSION: {
                this.startContext(ParserRuleContext.COMP_UNIT);
                this.startContext(ParserRuleContext.FUNC_BODY_BLOCK);
                this.startContext(ParserRuleContext.STATEMENT);
                return this.parseExpression();
            }
        }
        throw new UnsupportedOperationException("Cannot start parsing from: " + context);
    }

    private STNode parseCompUnit() {
        STNode decl;
        this.startContext(ParserRuleContext.COMP_UNIT);
        ArrayList<STNode> otherDecls = new ArrayList<STNode>();
        ArrayList<STNode> importDecls = new ArrayList<STNode>();
        boolean processImports = true;
        STToken token = this.peek();
        while (token.kind != SyntaxKind.EOF_TOKEN && (decl = this.parseTopLevelNode()) != null) {
            if (decl.kind == SyntaxKind.IMPORT_DECLARATION) {
                if (processImports) {
                    importDecls.add(decl);
                } else {
                    this.updateLastNodeInListWithInvalidNode(otherDecls, decl, DiagnosticErrorCode.ERROR_IMPORT_DECLARATION_AFTER_OTHER_DECLARATIONS, new Object[0]);
                }
            } else {
                if (processImports) {
                    processImports = false;
                }
                otherDecls.add(decl);
            }
            token = this.peek();
        }
        STToken eof = this.consume();
        this.endContext();
        return STNodeFactory.createModulePartNode(STNodeFactory.createNodeList(importDecls), STNodeFactory.createNodeList(otherDecls), eof);
    }

    protected STNode parseTopLevelNode() {
        STNode metadata;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EOF_TOKEN: {
                return null;
            }
            case DOCUMENTATION_STRING: 
            case AT_TOKEN: {
                STNode metadata2 = this.parseMetaData();
                return this.parseTopLevelNode(metadata2);
            }
            case IMPORT_KEYWORD: 
            case FINAL_KEYWORD: 
            case PUBLIC_KEYWORD: 
            case FUNCTION_KEYWORD: 
            case TYPE_KEYWORD: 
            case LISTENER_KEYWORD: 
            case CONST_KEYWORD: 
            case ANNOTATION_KEYWORD: 
            case XMLNS_KEYWORD: 
            case SERVICE_KEYWORD: 
            case ENUM_KEYWORD: 
            case CLASS_KEYWORD: 
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: 
            case DISTINCT_KEYWORD: 
            case CLIENT_KEYWORD: 
            case READONLY_KEYWORD: 
            case CONFIGURABLE_KEYWORD: {
                metadata = STNodeFactory.createEmptyNode();
                break;
            }
            case IDENTIFIER_TOKEN: {
                if (this.isModuleVarDeclStart(1)) {
                    return this.parseModuleVarDecl(STNodeFactory.createEmptyNode());
                }
            }
            default: {
                if (this.isTypeStartingToken(nextToken.kind) && nextToken.kind != SyntaxKind.IDENTIFIER_TOKEN) {
                    metadata = STNodeFactory.createEmptyNode();
                    break;
                }
                STToken token = this.peek();
                AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.TOP_LEVEL_NODE, new Object[0]);
                if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
                    metadata = STNodeFactory.createEmptyNodeList();
                    break;
                }
                return this.parseTopLevelNode();
            }
        }
        return this.parseTopLevelNode(metadata);
    }

    private STNode parseTopLevelNode(STNode metadata) {
        STToken nextToken = this.peek();
        STNode publicQualifier = null;
        switch (nextToken.kind) {
            case EOF_TOKEN: {
                if (metadata != null) {
                    this.addInvalidNodeToNextToken(metadata, DiagnosticErrorCode.ERROR_INVALID_METADATA, new Object[0]);
                }
                return null;
            }
            case PUBLIC_KEYWORD: {
                publicQualifier = this.consume();
                break;
            }
            case IMPORT_KEYWORD: 
            case FINAL_KEYWORD: 
            case FUNCTION_KEYWORD: 
            case TYPE_KEYWORD: 
            case LISTENER_KEYWORD: 
            case CONST_KEYWORD: 
            case ANNOTATION_KEYWORD: 
            case XMLNS_KEYWORD: 
            case ENUM_KEYWORD: 
            case CLASS_KEYWORD: 
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: 
            case DISTINCT_KEYWORD: 
            case CLIENT_KEYWORD: 
            case READONLY_KEYWORD: 
            case CONFIGURABLE_KEYWORD: {
                break;
            }
            case IDENTIFIER_TOKEN: {
                if (this.isModuleVarDeclStart(1)) {
                    return this.parseModuleVarDecl(metadata);
                }
            }
            default: {
                if (this.isTypeStartingToken(nextToken.kind) && nextToken.kind != SyntaxKind.IDENTIFIER_TOKEN) break;
                STToken token = this.peek();
                AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.TOP_LEVEL_NODE_WITHOUT_METADATA, metadata);
                if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
                    publicQualifier = STNodeFactory.createEmptyNode();
                    break;
                }
                return this.parseTopLevelNode(metadata);
            }
        }
        return this.parseTopLevelNode(metadata, publicQualifier);
    }

    private boolean isModuleVarDeclStart(int lookahead) {
        STToken nextToken = this.peek(lookahead + 1);
        switch (nextToken.kind) {
            case EOF_TOKEN: 
            case EQUAL_TOKEN: 
            case OPEN_BRACKET_TOKEN: 
            case QUESTION_MARK_TOKEN: 
            case PIPE_TOKEN: 
            case BITWISE_AND_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: {
                return true;
            }
            case IDENTIFIER_TOKEN: {
                switch (this.peek((int)(lookahead + 2)).kind) {
                    case EOF_TOKEN: 
                    case EQUAL_TOKEN: 
                    case SEMICOLON_TOKEN: {
                        return true;
                    }
                }
                return false;
            }
            case COLON_TOKEN: {
                if (lookahead > 1) {
                    return false;
                }
                switch (this.peek((int)(lookahead + 2)).kind) {
                    case IDENTIFIER_TOKEN: {
                        return this.isModuleVarDeclStart(lookahead + 2);
                    }
                    case EOF_TOKEN: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private STNode parseImportDecl() {
        this.startContext(ParserRuleContext.IMPORT_DECL);
        this.tokenReader.startMode(ParserMode.IMPORT);
        STNode importKeyword = this.parseImportKeyword();
        STNode identifier = this.parseIdentifier(ParserRuleContext.IMPORT_ORG_OR_MODULE_NAME);
        STNode importDecl = this.parseImportDecl(importKeyword, identifier);
        this.tokenReader.endMode();
        this.endContext();
        return importDecl;
    }

    private STNode parseImportKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IMPORT_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.IMPORT_KEYWORD, new Object[0]);
        return this.parseImportKeyword();
    }

    private STNode parseIdentifier(ParserRuleContext currentCtx) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        if (token.kind == SyntaxKind.MAP_KEYWORD) {
            STToken mapKeyword = this.consume();
            return STNodeFactory.createIdentifierToken(mapKeyword.text(), mapKeyword.leadingMinutiae(), mapKeyword.trailingMinutiae(), mapKeyword.diagnostics());
        }
        this.recover(token, currentCtx, new Object[0]);
        return this.parseIdentifier(currentCtx);
    }

    private STNode parseImportDecl(STNode importKeyword, STNode identifier) {
        STNode alias;
        STNode moduleName;
        STNode orgName;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case SLASH_TOKEN: {
                STNode slash = this.parseSlashToken();
                orgName = STNodeFactory.createImportOrgNameNode(identifier, slash);
                moduleName = this.parseModuleName();
                this.parseVersion();
                alias = this.parseImportPrefixDecl();
                break;
            }
            case DOT_TOKEN: 
            case VERSION_KEYWORD: {
                orgName = STNodeFactory.createEmptyNode();
                moduleName = this.parseModuleName(identifier);
                this.parseVersion();
                alias = this.parseImportPrefixDecl();
                break;
            }
            case AS_KEYWORD: {
                orgName = STNodeFactory.createEmptyNode();
                moduleName = this.parseModuleName(identifier);
                alias = this.parseImportPrefixDecl();
                break;
            }
            case SEMICOLON_TOKEN: {
                orgName = STNodeFactory.createEmptyNode();
                moduleName = this.parseModuleName(identifier);
                alias = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.IMPORT_DECL_RHS, importKeyword, identifier);
                return this.parseImportDecl(importKeyword, identifier);
            }
        }
        STNode semicolon = this.parseSemicolon();
        return STNodeFactory.createImportDeclarationNode(importKeyword, orgName, moduleName, alias, semicolon);
    }

    private STNode parseSlashToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.SLASH_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.SLASH, new Object[0]);
        return this.parseSlashToken();
    }

    private STNode parseDotToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.DOT_TOKEN) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.DOT, new Object[0]);
        return this.parseDotToken();
    }

    private STNode parseModuleName() {
        STNode moduleNameStart = this.parseIdentifier(ParserRuleContext.IMPORT_MODULE_NAME);
        return this.parseModuleName(moduleNameStart);
    }

    private STNode parseModuleName(STNode moduleNameStart) {
        ArrayList<STNode> moduleNameParts = new ArrayList<STNode>();
        moduleNameParts.add(moduleNameStart);
        STToken nextToken = this.peek();
        while (!this.isEndOfImportModuleName(nextToken)) {
            moduleNameParts.add(this.parseDotToken());
            moduleNameParts.add(this.parseIdentifier(ParserRuleContext.IMPORT_MODULE_NAME));
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(moduleNameParts);
    }

    private boolean isEndOfImportModuleName(STToken nextToken) {
        return nextToken.kind != SyntaxKind.DOT_TOKEN && nextToken.kind != SyntaxKind.IDENTIFIER_TOKEN;
    }

    private boolean isEndOfImportDecl(STToken nextToken) {
        switch (nextToken.kind) {
            case EOF_TOKEN: 
            case IMPORT_KEYWORD: 
            case FINAL_KEYWORD: 
            case PUBLIC_KEYWORD: 
            case FUNCTION_KEYWORD: 
            case TYPE_KEYWORD: 
            case CONST_KEYWORD: 
            case SERVICE_KEYWORD: 
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: 
            case SEMICOLON_TOKEN: 
            case ABSTRACT_KEYWORD: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    private void parseVersion() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case VERSION_KEYWORD: {
                STNode versionKeyword = this.parseVersionKeyword();
                STNode versionNumber = this.parseVersionNumber();
                this.addInvalidNodeToNextToken(versionKeyword, DiagnosticErrorCode.ERROR_VERSION_IN_IMPORT_DECLARATION_NO_LONGER_SUPPORTED, new Object[0]);
                this.addInvalidNodeToNextToken(versionNumber, null, new Object[0]);
                return;
            }
            case SEMICOLON_TOKEN: 
            case AS_KEYWORD: {
                break;
            }
            default: {
                if (this.isEndOfImportDecl(nextToken)) {
                    return;
                }
                this.recover(this.peek(), ParserRuleContext.IMPORT_VERSION_DECL, new Object[0]);
                this.parseVersion();
            }
        }
    }

    private STNode parseVersionKeyword() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.VERSION_KEYWORD) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.VERSION_KEYWORD, new Object[0]);
        return this.parseVersionKeyword();
    }

    private STNode parseVersionNumber() {
        STNode majorVersion;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case DECIMAL_INTEGER_LITERAL_TOKEN: {
                majorVersion = this.parseMajorVersion();
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.VERSION_NUMBER, new Object[0]);
                return this.parseVersionNumber();
            }
        }
        ArrayList<STNode> versionParts = new ArrayList<STNode>();
        versionParts.add(majorVersion);
        STNode minorVersionEnd = this.parseSubVersionEnd();
        if (minorVersionEnd != null) {
            versionParts.add(minorVersionEnd);
            STNode minorVersion = this.parseMinorVersion();
            versionParts.add(minorVersion);
            STNode patchVersionEnd = this.parseSubVersionEnd();
            if (patchVersionEnd != null) {
                versionParts.add(patchVersionEnd);
                STNode patchVersion = this.parsePatchVersion();
                versionParts.add(patchVersion);
            }
        }
        return STNodeFactory.createNodeList(versionParts);
    }

    private STNode parseMajorVersion() {
        return this.parseDecimalIntLiteral(ParserRuleContext.MAJOR_VERSION);
    }

    private STNode parseMinorVersion() {
        return this.parseDecimalIntLiteral(ParserRuleContext.MINOR_VERSION);
    }

    private STNode parsePatchVersion() {
        return this.parseDecimalIntLiteral(ParserRuleContext.PATCH_VERSION);
    }

    private STNode parseDecimalIntLiteral(ParserRuleContext context) {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN) {
            return this.consume();
        }
        this.recover(this.peek(), context, new Object[0]);
        return this.parseDecimalIntLiteral(context);
    }

    private STNode parseSubVersionEnd() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EOF_TOKEN: 
            case SEMICOLON_TOKEN: 
            case AS_KEYWORD: {
                return null;
            }
            case DOT_TOKEN: {
                return this.parseDotToken();
            }
        }
        this.recover(nextToken, ParserRuleContext.IMPORT_SUB_VERSION, new Object[0]);
        return this.parseSubVersionEnd();
    }

    private STNode parseImportPrefixDecl() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case AS_KEYWORD: {
                STNode asKeyword = this.parseAsKeyword();
                STNode prefix = this.parseImportPrefix();
                return STNodeFactory.createImportPrefixNode(asKeyword, prefix);
            }
            case SEMICOLON_TOKEN: {
                return STNodeFactory.createEmptyNode();
            }
        }
        if (this.isEndOfImportDecl(nextToken)) {
            return STNodeFactory.createEmptyNode();
        }
        this.recover(this.peek(), ParserRuleContext.IMPORT_PREFIX_DECL, new Object[0]);
        return this.parseImportPrefixDecl();
    }

    private STNode parseAsKeyword() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.AS_KEYWORD) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.AS_KEYWORD, new Object[0]);
        return this.parseAsKeyword();
    }

    private STNode parseImportPrefix() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.IMPORT_PREFIX, new Object[0]);
        return this.parseImportPrefix();
    }

    private STNode parseTopLevelNode(STNode metadata, STNode publicQualifier) {
        ArrayList<STNode> topLevelQualifiers = new ArrayList<STNode>();
        return this.parseTopLevelNode(metadata, publicQualifier, topLevelQualifiers);
    }

    private STNode parseTopLevelNode(STNode metadata, STNode publicQualifier, List<STNode> qualifiers) {
        this.parseTopLevelQualifiers(qualifiers);
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EOF_TOKEN: {
                this.reportInvalidMetaData(metadata);
                this.reportInvalidQualifier(publicQualifier);
                this.reportInvalidQualifierList(qualifiers);
                return null;
            }
            case FUNCTION_KEYWORD: {
                return this.parseFuncDefOrFuncTypeDesc(metadata, publicQualifier, qualifiers, false, false);
            }
            case TYPE_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseModuleTypeDefinition(metadata, publicQualifier);
            }
            case CLASS_KEYWORD: {
                return this.parseClassDefinition(metadata, publicQualifier, qualifiers);
            }
            case LISTENER_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseListenerDeclaration(metadata, publicQualifier);
            }
            case CONST_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseConstantDeclaration(metadata, publicQualifier);
            }
            case ANNOTATION_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                STNode constKeyword = STNodeFactory.createEmptyNode();
                return this.parseAnnotationDeclaration(metadata, publicQualifier, constKeyword);
            }
            case IMPORT_KEYWORD: {
                this.reportInvalidMetaData(metadata);
                this.reportInvalidQualifier(publicQualifier);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseImportDecl();
            }
            case XMLNS_KEYWORD: {
                this.reportInvalidMetaData(metadata);
                this.reportInvalidQualifier(publicQualifier);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseXMLNamespaceDeclaration(true);
            }
            case SERVICE_KEYWORD: {
                this.reportInvalidQualifier(publicQualifier);
                if (this.isServiceDeclStart(ParserRuleContext.TOP_LEVEL_NODE, 1)) {
                    return this.parseServiceDecl(metadata, qualifiers);
                }
                return this.parseModuleVarDecl(metadata, qualifiers);
            }
            case ENUM_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseEnumDeclaration(metadata, publicQualifier);
            }
            case IDENTIFIER_TOKEN: {
                if (!this.isModuleVarDeclStart(1)) break;
                this.reportInvalidQualifier(publicQualifier);
                return this.parseModuleVarDecl(metadata, qualifiers);
            }
        }
        if (this.isTypeStartingToken(nextToken.kind) && nextToken.kind != SyntaxKind.IDENTIFIER_TOKEN) {
            this.reportInvalidQualifier(publicQualifier);
            return this.parseModuleVarDecl(metadata, qualifiers);
        }
        STToken token = this.peek();
        AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.TOP_LEVEL_NODE_WITHOUT_MODIFIER, metadata, publicQualifier, qualifiers);
        if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
            this.reportInvalidQualifier(publicQualifier);
            return this.parseModuleVarDecl(metadata, qualifiers);
        }
        return this.parseTopLevelNode(metadata, publicQualifier, qualifiers);
    }

    private STNode parseModuleVarDecl(STNode metadata) {
        ArrayList<STNode> emptyList = new ArrayList<STNode>();
        return this.parseVariableDecl(metadata, emptyList, emptyList, true);
    }

    private STNode parseModuleVarDecl(STNode metadata, List<STNode> topLevelQualifiers) {
        List<STNode> varDeclQuals = this.extractVarDeclQualifiers(topLevelQualifiers);
        return this.parseVariableDecl(metadata, varDeclQuals, topLevelQualifiers, true);
    }

    private List<STNode> extractVarDeclQualifiers(List<STNode> qualifiers) {
        SyntaxKind qualifierKind;
        ArrayList<STNode> varDeclQualList = new ArrayList<STNode>();
        int initialListSize = qualifiers.size();
        for (int i = 0; i < 3 && i < initialListSize && !this.isSyntaxKindInList(varDeclQualList, qualifierKind = qualifiers.get((int)0).kind) && this.isModuleVarDeclQualifier(qualifierKind); ++i) {
            varDeclQualList.add(qualifiers.remove(0));
        }
        return varDeclQualList;
    }

    boolean isModuleVarDeclQualifier(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case FINAL_KEYWORD: 
            case ISOLATED_KEYWORD: 
            case CONFIGURABLE_KEYWORD: {
                return true;
            }
        }
        return false;
    }

    private void reportInvalidQualifier(STNode qualifier) {
        if (qualifier != null && qualifier.kind != SyntaxKind.NONE) {
            this.addInvalidNodeToNextToken(qualifier, DiagnosticErrorCode.ERROR_INVALID_QUALIFIER, ((STToken)qualifier).text());
        }
    }

    private void reportInvalidMetaData(STNode metadata) {
        if (metadata != null && metadata.kind != SyntaxKind.NONE) {
            this.addInvalidNodeToNextToken(metadata, DiagnosticErrorCode.ERROR_INVALID_METADATA, new Object[0]);
        }
    }

    private void reportInvalidQualifierList(List<STNode> qualifiers) {
        for (STNode qual : qualifiers) {
            this.addInvalidNodeToNextToken(qual, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qual).text());
        }
    }

    private void reportInvalidStatementAnnots(STNode annots, List<STNode> qualifiers) {
        DiagnosticErrorCode diagnosticErrorCode = DiagnosticErrorCode.ERROR_ANNOTATIONS_ATTACHED_TO_STATEMENT;
        this.reportInvalidAnnotations(annots, qualifiers, diagnosticErrorCode);
    }

    private void reportInvalidExpressionAnnots(STNode annots, List<STNode> qualifiers) {
        DiagnosticErrorCode diagnosticErrorCode = DiagnosticErrorCode.ERROR_ANNOTATIONS_ATTACHED_TO_EXPRESSION;
        this.reportInvalidAnnotations(annots, qualifiers, diagnosticErrorCode);
    }

    private void reportInvalidAnnotations(STNode annots, List<STNode> qualifiers, DiagnosticErrorCode errorCode) {
        if (this.isNodeListEmpty(annots)) {
            return;
        }
        if (qualifiers.isEmpty()) {
            this.addInvalidNodeToNextToken(annots, errorCode, new Object[0]);
        } else {
            this.updateFirstNodeInListWithLeadingInvalidNode(qualifiers, annots, errorCode, new Object[0]);
        }
    }

    private boolean isTopLevelQualifier(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case FINAL_KEYWORD: 
            case CONFIGURABLE_KEYWORD: {
                return true;
            }
            case READONLY_KEYWORD: {
                STToken nextNextToken = this.getNextNextToken();
                switch (nextNextToken.kind) {
                    case CLASS_KEYWORD: 
                    case ISOLATED_KEYWORD: 
                    case DISTINCT_KEYWORD: 
                    case CLIENT_KEYWORD: {
                        return true;
                    }
                }
                return false;
            }
            case DISTINCT_KEYWORD: {
                STToken nextNextToken = this.getNextNextToken();
                switch (nextNextToken.kind) {
                    case CLASS_KEYWORD: 
                    case ISOLATED_KEYWORD: 
                    case CLIENT_KEYWORD: 
                    case READONLY_KEYWORD: {
                        return true;
                    }
                }
                return false;
            }
        }
        return this.isTypeDescQualifier(tokenKind);
    }

    private boolean isTypeDescQualifier(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: 
            case CLIENT_KEYWORD: 
            case ABSTRACT_KEYWORD: {
                return true;
            }
        }
        return false;
    }

    private boolean isObjectMemberQualifier(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case REMOTE_KEYWORD: 
            case RESOURCE_KEYWORD: {
                return true;
            }
        }
        return this.isTypeDescQualifier(tokenKind);
    }

    private boolean isExprQualifier(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case TRANSACTIONAL_KEYWORD: {
                STToken nextNextToken = this.getNextNextToken();
                switch (nextNextToken.kind) {
                    case FUNCTION_KEYWORD: 
                    case ISOLATED_KEYWORD: 
                    case CLIENT_KEYWORD: 
                    case ABSTRACT_KEYWORD: 
                    case OBJECT_KEYWORD: {
                        return true;
                    }
                }
                return false;
            }
        }
        return this.isTypeDescQualifier(tokenKind);
    }

    private void parseTopLevelQualifiers(List<STNode> qualifiers) {
        while (this.isTopLevelQualifier(this.peek().kind)) {
            STToken qualifier = this.consume();
            qualifiers.add(qualifier);
        }
    }

    private void parseTypeDescQualifiers(List<STNode> qualifiers) {
        while (this.isTypeDescQualifier(this.peek().kind)) {
            STToken qualifier = this.consume();
            qualifiers.add(qualifier);
        }
    }

    private void parseObjectMemberQualifiers(List<STNode> qualifiers) {
        while (this.isObjectMemberQualifier(this.peek().kind)) {
            STToken qualifier = this.consume();
            qualifiers.add(qualifier);
        }
    }

    private void parseExprQualifiers(List<STNode> qualifiers) {
        while (this.isExprQualifier(this.peek().kind)) {
            STToken qualifier = this.consume();
            qualifiers.add(qualifier);
        }
    }

    private STNode parseFuncDefinition(STNode metadata, STNode qualifiers) {
        this.startContext(ParserRuleContext.FUNC_DEF);
        STNode functionKeyword = this.parseFunctionKeyword();
        STNode name = this.parseFunctionName();
        STNode funcSignature = this.parseFuncSignature(false);
        STNode funcDef = this.createFuncDefOrMethodDecl(metadata, functionKeyword, name, funcSignature, qualifiers, false, false);
        this.endContext();
        return funcDef;
    }

    private STNode parseFuncDefOrFuncTypeDesc(STNode metadata, STNode visibilityQualifier, List<STNode> qualifiers, boolean isObjectMember, boolean isObjectTypeDesc) {
        this.startContext(ParserRuleContext.FUNC_DEF_OR_FUNC_TYPE);
        STNode functionKeyword = this.parseFunctionKeyword();
        STNode funcDefOrType = this.parseFunctionKeywordRhs(metadata, visibilityQualifier, qualifiers, functionKeyword, isObjectMember, isObjectTypeDesc);
        return funcDefOrType;
    }

    private STNode createFuncDefNodeList(List<STNode> qualifierList) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (this.isValidFuncDefQualifier(qualifier.kind)) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) continue;
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        return STNodeFactory.createNodeList(validatedList);
    }

    private STNode createMethodQualNodeList(List<STNode> qualifierList) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (this.isValidMethodQualifier(qualifier.kind)) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) continue;
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        return STNodeFactory.createNodeList(validatedList);
    }

    boolean isValidMethodQualifier(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case REMOTE_KEYWORD: 
            case PRIVATE_KEYWORD: {
                return true;
            }
        }
        return this.isValidFuncDefQualifier(tokenKind);
    }

    boolean isValidFuncDefQualifier(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case PUBLIC_KEYWORD: 
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: {
                return true;
            }
        }
        return false;
    }

    private STNode parseFunctionKeywordRhs(STNode metadata, STNode visibilityQualifier, List<STNode> qualifiers, STNode functionKeyword, boolean isObjectMember, boolean isObjectTypeDesc) {
        switch (this.peek().kind) {
            case IDENTIFIER_TOKEN: {
                STNode name = this.parseFunctionName();
                this.switchContext(ParserRuleContext.FUNC_DEF);
                STNode funcSignature = this.parseFuncSignature(false);
                if (visibilityQualifier != null) {
                    qualifiers.add(0, visibilityQualifier);
                }
                STNode qualifierNodeList = isObjectMember ? this.createMethodQualNodeList(qualifiers) : this.createFuncDefNodeList(qualifiers);
                STNode funcDef = this.createFuncDefOrMethodDecl(metadata, functionKeyword, name, funcSignature, qualifierNodeList, isObjectMember, isObjectTypeDesc);
                this.endContext();
                return funcDef;
            }
            case OPEN_PAREN_TOKEN: {
                STNode funcSignature = this.parseFuncSignature(true);
                return this.parseReturnTypeDescRhs(metadata, visibilityQualifier, qualifiers, functionKeyword, funcSignature, isObjectMember, isObjectTypeDesc);
            }
        }
        STToken token = this.peek();
        this.recover(token, ParserRuleContext.FUNCTION_KEYWORD_RHS, metadata, visibilityQualifier, qualifiers, functionKeyword, isObjectMember, isObjectTypeDesc);
        return this.parseFunctionKeywordRhs(metadata, visibilityQualifier, qualifiers, functionKeyword, isObjectMember, isObjectTypeDesc);
    }

    private STNode createFuncDefOrMethodDecl(STNode metadata, STNode functionKeyword, STNode name, STNode funcSignature, STNode qualifierList, boolean isObjectMethod, boolean isObjectTypeDesc) {
        if (isObjectTypeDesc) {
            STNode semicolon = this.parseSemicolon();
            return STNodeFactory.createMethodDeclarationNode(metadata, qualifierList, functionKeyword, name, funcSignature, semicolon);
        }
        STNode body = this.parseFunctionBody();
        if (isObjectMethod) {
            return STNodeFactory.createFunctionDefinitionNode(SyntaxKind.OBJECT_METHOD_DEFINITION, metadata, qualifierList, functionKeyword, name, funcSignature, body);
        }
        return STNodeFactory.createFunctionDefinitionNode(SyntaxKind.FUNCTION_DEFINITION, metadata, qualifierList, functionKeyword, name, funcSignature, body);
    }

    private STNode parseFuncSignature(boolean isParamNameOptional) {
        STNode openParenthesis = this.parseOpenParenthesis(ParserRuleContext.OPEN_PARENTHESIS);
        STNode parameters = this.parseParamList(isParamNameOptional);
        STNode closeParenthesis = this.parseCloseParenthesis();
        this.endContext();
        STNode returnTypeDesc = this.parseFuncReturnTypeDescriptor();
        return STNodeFactory.createFunctionSignatureNode(openParenthesis, parameters, closeParenthesis, returnTypeDesc);
    }

    private STNode parseReturnTypeDescRhs(STNode metadata, STNode visibilityQualifier, List<STNode> qualifiers, STNode functionKeyword, STNode funcSignature, boolean isObjectMember, boolean isObjectTypeDesc) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EQUAL_TOKEN: 
            case OPEN_BRACE_TOKEN: {
                break;
            }
            default: {
                this.endContext();
                return this.parseVarDeclWithFunctionType(metadata, visibilityQualifier, qualifiers, functionKeyword, funcSignature, isObjectMember, isObjectTypeDesc);
            }
        }
        STToken name = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_FUNCTION_NAME);
        funcSignature = this.validateAndGetFuncParams((STFunctionSignatureNode)funcSignature);
        if (visibilityQualifier != null) {
            qualifiers.add(0, visibilityQualifier);
        }
        STNode qualifierNodeList = isObjectMember ? this.createMethodQualNodeList(qualifiers) : this.createFuncDefNodeList(qualifiers);
        STNode funcDef = this.createFuncDefOrMethodDecl(metadata, functionKeyword, name, funcSignature, qualifierNodeList, isObjectMember, isObjectTypeDesc);
        this.endContext();
        return funcDef;
    }

    private STNode parseVarDeclWithFunctionType(STNode metadata, STNode visibilityQualifier, List<STNode> qualifierList, STNode functionKeyword, STNode funcSignature, boolean isObjectMember, boolean isObjectTypeDesc) {
        ArrayList<STNode> varDeclQualifiers = new ArrayList();
        if (!isObjectMember) {
            if (visibilityQualifier != null) {
                STToken invalidQualifier = (STToken)visibilityQualifier;
                if (qualifierList.isEmpty()) {
                    functionKeyword = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(functionKeyword, visibilityQualifier, (DiagnosticCode)DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)visibilityQualifier).text());
                } else {
                    this.updateFirstNodeInListWithLeadingInvalidNode(qualifierList, invalidQualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, invalidQualifier.text());
                }
            }
            varDeclQualifiers = this.extractVarDeclQualifiers(qualifierList);
        }
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (this.isRegularFuncQualifier(qualifier.kind)) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) {
                functionKeyword = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(functionKeyword, qualifier, (DiagnosticCode)DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
                continue;
            }
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        STNode qualifierNodeList = STNodeFactory.createNodeList(validatedList);
        STNode typeDesc = STNodeFactory.createFunctionTypeDescriptorNode(qualifierNodeList, functionKeyword, funcSignature);
        typeDesc = this.parseComplexTypeDescriptor(typeDesc, ParserRuleContext.TOP_LEVEL_FUNC_DEF_OR_FUNC_TYPE_DESC, false);
        if (isObjectMember) {
            STNode finalQualifier = STNodeFactory.createEmptyNode();
            STNode fieldName = this.parseVariableName();
            return this.parseObjectFieldRhs(metadata, visibilityQualifier, finalQualifier, typeDesc, fieldName, isObjectTypeDesc);
        }
        this.startContext(ParserRuleContext.VAR_DECL_STMT);
        STNode typedBindingPattern = this.parseTypedBindingPatternTypeRhs(typeDesc, ParserRuleContext.VAR_DECL_STMT);
        return this.parseVarDeclRhs(metadata, varDeclQualifiers, typedBindingPattern, true);
    }

    private STNode validateAndGetFuncParams(STFunctionSignatureNode signature) {
        int index;
        STNode parameters = signature.parameters;
        int paramCount = parameters.bucketCount();
        block5: for (index = 0; index < paramCount; ++index) {
            STNode param = parameters.childInBucket(index);
            switch (param.kind) {
                case REQUIRED_PARAM: {
                    STRequiredParameterNode requiredParam = (STRequiredParameterNode)param;
                    if (!this.isEmpty(requiredParam.paramName)) continue block5;
                    break block5;
                }
                case DEFAULTABLE_PARAM: {
                    STDefaultableParameterNode defaultableParam = (STDefaultableParameterNode)param;
                    if (!this.isEmpty(defaultableParam.paramName)) continue block5;
                    break block5;
                }
                case REST_PARAM: {
                    STRestParameterNode restParam = (STRestParameterNode)param;
                    if (!this.isEmpty(restParam.paramName)) continue block5;
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
        }
        if (index == paramCount) {
            return signature;
        }
        STNode updatedParams = this.getUpdatedParamList(parameters, index);
        return STNodeFactory.createFunctionSignatureNode(signature.openParenToken, updatedParams, signature.closeParenToken, signature.returnTypeDesc);
    }

    private STNode getUpdatedParamList(STNode parameters, int index) {
        int newIndex;
        int paramCount = parameters.bucketCount();
        ArrayList<STNode> newParams = new ArrayList<STNode>();
        for (newIndex = 0; newIndex < index; ++newIndex) {
            newParams.add(parameters.childInBucket(index));
        }
        while (newIndex < paramCount) {
            STNode param = parameters.childInBucket(newIndex);
            STToken paramName = STNodeFactory.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
            switch (param.kind) {
                case REQUIRED_PARAM: {
                    STRequiredParameterNode requiredParam = (STRequiredParameterNode)param;
                    if (!this.isEmpty(requiredParam.paramName)) break;
                    param = STNodeFactory.createRequiredParameterNode(requiredParam.annotations, requiredParam.typeName, paramName);
                    break;
                }
                case DEFAULTABLE_PARAM: {
                    STDefaultableParameterNode defaultableParam = (STDefaultableParameterNode)param;
                    if (!this.isEmpty(defaultableParam.paramName)) break;
                    param = STNodeFactory.createDefaultableParameterNode(defaultableParam.annotations, defaultableParam.typeName, paramName, defaultableParam.equalsToken, defaultableParam.expression);
                    break;
                }
                case REST_PARAM: {
                    STRestParameterNode restParam = (STRestParameterNode)param;
                    if (!this.isEmpty(restParam.paramName)) break;
                    param = STNodeFactory.createRestParameterNode(restParam.annotations, restParam.typeName, restParam.ellipsisToken, paramName);
                    break;
                }
            }
            newParams.add(param);
            ++newIndex;
        }
        return STNodeFactory.createNodeList(newParams);
    }

    private boolean isEmpty(STNode node) {
        return !SyntaxUtils.isSTNodePresent(node);
    }

    private STNode parseFunctionKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FUNCTION_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FUNCTION_KEYWORD, new Object[0]);
        return this.parseFunctionKeyword();
    }

    private STNode parseFunctionName() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FUNC_NAME, new Object[0]);
        return this.parseFunctionName();
    }

    private STNode parseOpenParenthesis(ParserRuleContext ctx) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OPEN_PAREN_TOKEN) {
            return this.consume();
        }
        this.recover(token, ctx, new Object[0]);
        return this.parseOpenParenthesis(ctx);
    }

    private STNode parseCloseParenthesis() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CLOSE_PAREN_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CLOSE_PARENTHESIS, new Object[0]);
        return this.parseCloseParenthesis();
    }

    private STNode parseParamList(boolean isParamNameOptional) {
        STNode paramEnd;
        this.startContext(ParserRuleContext.PARAM_LIST);
        STToken token = this.peek();
        if (this.isEndOfParametersList(token.kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        ArrayList<STNode> paramsList = new ArrayList<STNode>();
        this.startContext(ParserRuleContext.REQUIRED_PARAM);
        STNode firstParam = this.parseParameter(SyntaxKind.REQUIRED_PARAM, isParamNameOptional);
        SyntaxKind prevParamKind = firstParam.kind;
        paramsList.add(firstParam);
        boolean paramOrderErrorPresent = false;
        token = this.peek();
        while (!this.isEndOfParametersList(token.kind) && (paramEnd = this.parseParameterRhs()) != null) {
            this.endContext();
            if (prevParamKind == SyntaxKind.DEFAULTABLE_PARAM) {
                this.startContext(ParserRuleContext.DEFAULTABLE_PARAM);
            } else {
                this.startContext(ParserRuleContext.REQUIRED_PARAM);
            }
            STNode param = this.parseParameter(prevParamKind, isParamNameOptional);
            if (paramOrderErrorPresent) {
                this.updateLastNodeInListWithInvalidNode(paramsList, paramEnd, null, new Object[0]);
                this.updateLastNodeInListWithInvalidNode(paramsList, param, null, new Object[0]);
            } else {
                DiagnosticCode paramOrderError = this.validateParamOrder(param, prevParamKind);
                if (paramOrderError == null) {
                    paramsList.add(paramEnd);
                    paramsList.add(param);
                } else {
                    paramOrderErrorPresent = true;
                    this.updateLastNodeInListWithInvalidNode(paramsList, paramEnd, paramOrderError, new Object[0]);
                    this.updateLastNodeInListWithInvalidNode(paramsList, param, null, new Object[0]);
                }
            }
            prevParamKind = param.kind;
            token = this.peek();
        }
        this.endContext();
        return STNodeFactory.createNodeList(paramsList);
    }

    private DiagnosticCode validateParamOrder(STNode param, SyntaxKind prevParamKind) {
        if (prevParamKind == SyntaxKind.REST_PARAM) {
            return DiagnosticErrorCode.ERROR_PARAMETER_AFTER_THE_REST_PARAMETER;
        }
        if (prevParamKind == SyntaxKind.DEFAULTABLE_PARAM && param.kind == SyntaxKind.REQUIRED_PARAM) {
            return DiagnosticErrorCode.ERROR_REQUIRED_PARAMETER_AFTER_THE_DEFAULTABLE_PARAMETER;
        }
        return null;
    }

    private boolean isSyntaxKindInList(List<STNode> nodeList, SyntaxKind kind) {
        for (STNode node : nodeList) {
            if (node.kind != kind) continue;
            return true;
        }
        return false;
    }

    private STNode parseParameterRhs() {
        return this.parseParameterRhs(this.peek().kind);
    }

    private STNode parseParameterRhs(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case CLOSE_PAREN_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.PARAM_END, new Object[0]);
        return this.parseParameterRhs();
    }

    private STNode parseParameter(SyntaxKind prevParamKind, boolean isParamNameOptional) {
        STNode annots;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case AT_TOKEN: {
                annots = this.parseOptionalAnnotations();
                break;
            }
            case IDENTIFIER_TOKEN: {
                annots = STNodeFactory.createEmptyNodeList();
                break;
            }
            default: {
                if (this.isTypeStartingToken(nextToken.kind)) {
                    annots = STNodeFactory.createEmptyNodeList();
                    break;
                }
                STToken token = this.peek();
                AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.PARAMETER_START, new Object[]{prevParamKind, isParamNameOptional});
                if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
                    annots = STNodeFactory.createEmptyNodeList();
                    break;
                }
                return this.parseParameter(prevParamKind, isParamNameOptional);
            }
        }
        STNode type = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_BEFORE_IDENTIFIER);
        STNode param = this.parseAfterParamType(prevParamKind, annots, type, isParamNameOptional);
        return param;
    }

    private STNode parseAfterParamType(SyntaxKind prevParamKind, STNode annots, STNode type, boolean isParamNameOptional) {
        STToken token = this.peek();
        switch (token.kind) {
            case ELLIPSIS_TOKEN: {
                this.switchContext(ParserRuleContext.REST_PARAM);
                STNode ellipsis = this.parseEllipsis();
                STNode paramName = isParamNameOptional && this.peek().kind != SyntaxKind.IDENTIFIER_TOKEN ? STNodeFactory.createEmptyNode() : this.parseVariableName();
                return STNodeFactory.createRestParameterNode(annots, type, ellipsis, paramName);
            }
            case IDENTIFIER_TOKEN: {
                STNode paramName = this.parseVariableName();
                return this.parseParameterRhs(prevParamKind, annots, type, paramName);
            }
            case EQUAL_TOKEN: {
                if (!isParamNameOptional) break;
                STNode paramName = STNodeFactory.createEmptyNode();
                return this.parseParameterRhs(prevParamKind, annots, type, paramName);
            }
            default: {
                if (!isParamNameOptional) break;
                STNode paramName = STNodeFactory.createEmptyNode();
                return this.parseParameterRhs(prevParamKind, annots, type, paramName);
            }
        }
        this.recover(token, ParserRuleContext.AFTER_PARAMETER_TYPE, new Object[]{prevParamKind, annots, type, isParamNameOptional});
        return this.parseAfterParamType(prevParamKind, annots, type, isParamNameOptional);
    }

    private STNode parseEllipsis() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ELLIPSIS_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ELLIPSIS, new Object[0]);
        return this.parseEllipsis();
    }

    private STNode parseParameterRhs(SyntaxKind prevParamKind, STNode annots, STNode type, STNode paramName) {
        STToken nextToken = this.peek();
        if (this.isEndOfParameter(nextToken.kind)) {
            return STNodeFactory.createRequiredParameterNode(annots, type, paramName);
        }
        if (nextToken.kind == SyntaxKind.EQUAL_TOKEN) {
            if (prevParamKind == SyntaxKind.REQUIRED_PARAM) {
                this.switchContext(ParserRuleContext.DEFAULTABLE_PARAM);
            }
            STNode equal = this.parseAssignOp();
            STNode expr = this.parseExpression();
            return STNodeFactory.createDefaultableParameterNode(annots, type, paramName, equal, expr);
        }
        this.recover(nextToken, ParserRuleContext.PARAMETER_NAME_RHS, new Object[]{prevParamKind, annots, type, paramName});
        return this.parseParameterRhs(prevParamKind, annots, type, paramName);
    }

    private STNode parseComma() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.COMMA_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.COMMA, new Object[0]);
        return this.parseComma();
    }

    private STNode parseFuncReturnTypeDescriptor() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EQUAL_TOKEN: 
            case OPEN_BRACE_TOKEN: {
                return STNodeFactory.createEmptyNode();
            }
            case RETURNS_KEYWORD: {
                break;
            }
            default: {
                STToken nextNextToken = this.getNextNextToken();
                if (nextNextToken.kind == SyntaxKind.RETURNS_KEYWORD) break;
                return STNodeFactory.createEmptyNode();
            }
        }
        STNode returnsKeyword = this.parseReturnsKeyword();
        STNode annot = this.parseOptionalAnnotations();
        STNode type = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_RETURN_TYPE_DESC);
        return STNodeFactory.createReturnTypeDescriptorNode(returnsKeyword, annot, type);
    }

    private STNode parseReturnsKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.RETURNS_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.RETURNS_KEYWORD, new Object[0]);
        return this.parseReturnsKeyword();
    }

    private STNode parseTypeDescriptor(ParserRuleContext context) {
        return this.parseTypeDescriptor(context, false, false);
    }

    private STNode parseTypeDescriptor(List<STNode> qualifiers, ParserRuleContext context) {
        return this.parseTypeDescriptor(qualifiers, context, false, false);
    }

    private STNode parseTypeDescriptorInExpression(boolean isInConditionalExpr) {
        return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_EXPRESSION, false, isInConditionalExpr);
    }

    private STNode parseTypeDescriptor(ParserRuleContext context, boolean isTypedBindingPattern, boolean isInConditionalExpr) {
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        return this.parseTypeDescriptor(typeDescQualifiers, context, isTypedBindingPattern, isInConditionalExpr);
    }

    private STNode parseTypeDescriptor(List<STNode> qualifiers, ParserRuleContext context, boolean isTypedBindingPattern, boolean isInConditionalExpr) {
        this.startContext(context);
        STNode typeDesc = this.parseTypeDescriptorInternal(qualifiers, context, isTypedBindingPattern, isInConditionalExpr);
        this.endContext();
        return typeDesc;
    }

    private STNode parseTypeDescriptorInternal(List<STNode> qualifiers, ParserRuleContext context, boolean isTypedBindingPattern, boolean isInConditionalExpr) {
        STNode typeDesc = this.parseTypeDescriptorInternal(qualifiers, context, isInConditionalExpr);
        if (typeDesc.kind == SyntaxKind.VAR_TYPE_DESC && context != ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN) {
            STToken missingToken = STNodeFactory.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
            missingToken = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(missingToken, typeDesc, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_USAGE_OF_VAR, new Object[0]);
            typeDesc = STNodeFactory.createSimpleNameReferenceNode(missingToken);
        }
        return this.parseComplexTypeDescriptor(typeDesc, context, isTypedBindingPattern);
    }

    private STNode parseComplexTypeDescriptor(STNode typeDesc, ParserRuleContext context, boolean isTypedBindingPattern) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case QUESTION_MARK_TOKEN: {
                if (context == ParserRuleContext.TYPE_DESC_IN_EXPRESSION && !this.isValidTypeContinuationToken(this.getNextNextToken()) && this.isValidExprStart(this.getNextNextToken().kind)) {
                    return typeDesc;
                }
                return this.parseComplexTypeDescriptor(this.parseOptionalTypeDescriptor(typeDesc), context, isTypedBindingPattern);
            }
            case OPEN_BRACKET_TOKEN: {
                if (isTypedBindingPattern) {
                    return typeDesc;
                }
                return this.parseComplexTypeDescriptor(this.parseArrayTypeDescriptor(typeDesc), context, isTypedBindingPattern);
            }
            case PIPE_TOKEN: {
                return this.parseUnionTypeDescriptor(typeDesc, context, isTypedBindingPattern);
            }
            case BITWISE_AND_TOKEN: {
                return this.parseIntersectionTypeDescriptor(typeDesc, context, isTypedBindingPattern);
            }
        }
        return typeDesc;
    }

    private boolean isValidTypeContinuationToken(STToken nextToken) {
        switch (nextToken.kind) {
            case OPEN_BRACKET_TOKEN: 
            case QUESTION_MARK_TOKEN: 
            case PIPE_TOKEN: 
            case BITWISE_AND_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode validateForUsageOfVar(STNode typeDesc) {
        if (typeDesc.kind != SyntaxKind.VAR_TYPE_DESC) {
            return typeDesc;
        }
        STToken missingToken = STNodeFactory.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
        missingToken = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(missingToken, typeDesc, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_USAGE_OF_VAR, new Object[0]);
        return STNodeFactory.createSimpleNameReferenceNode(missingToken);
    }

    private STNode parseTypeDescriptorInternal(List<STNode> qualifiers, ParserRuleContext context, boolean isInConditionalExpr) {
        this.parseTypeDescQualifiers(qualifiers);
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseTypeReference(isInConditionalExpr);
            }
            case RECORD_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseRecordTypeDescriptor();
            }
            case OBJECT_KEYWORD: {
                return this.parseObjectTypeDescriptor(qualifiers);
            }
            case OPEN_PAREN_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseNilOrParenthesisedTypeDesc();
            }
            case MAP_KEYWORD: 
            case FUTURE_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseParameterizedTypeDescriptor();
            }
            case TYPEDESC_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseTypedescTypeDescriptor();
            }
            case ERROR_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseErrorTypeDescriptor();
            }
            case XML_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseXmlTypeDescriptor();
            }
            case STREAM_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseStreamTypeDescriptor();
            }
            case TABLE_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseTableTypeDescriptor();
            }
            case FUNCTION_KEYWORD: {
                return this.parseFunctionTypeDesc(qualifiers);
            }
            case OPEN_BRACKET_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseTupleTypeDesc();
            }
            case DISTINCT_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                STToken distinctKeyword = this.consume();
                return this.parseDistinctTypeDesc(distinctKeyword, context);
            }
        }
        if (this.isSingletonTypeDescStart(nextToken.kind, true)) {
            this.reportInvalidQualifierList(qualifiers);
            return this.parseSingletonTypeDesc();
        }
        if (BallerinaParser.isSimpleType(nextToken.kind)) {
            this.reportInvalidQualifierList(qualifiers);
            return this.parseSimpleTypeDescriptor();
        }
        AbstractParserErrorHandler.Solution solution = this.recover(this.peek(), ParserRuleContext.TYPE_DESCRIPTOR, new Object[]{qualifiers, context, isInConditionalExpr});
        if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
            this.reportInvalidQualifierList(qualifiers);
            return this.parseSingletonTypeDesc();
        }
        return this.parseTypeDescriptorInternal(qualifiers, context, isInConditionalExpr);
    }

    private STNode parseDistinctTypeDesc(STNode distinctKeyword, ParserRuleContext context) {
        STNode typeDesc = this.parseTypeDescriptor(context);
        return STNodeFactory.createDistinctTypeDescriptorNode(distinctKeyword, typeDesc);
    }

    private STNode parseNilOrParenthesisedTypeDesc() {
        STNode openParen = this.parseOpenParenthesis(ParserRuleContext.OPEN_PARENTHESIS);
        return this.parseNilOrParenthesisedTypeDescRhs(openParen);
    }

    private STNode parseNilOrParenthesisedTypeDescRhs(STNode openParen) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case CLOSE_PAREN_TOKEN: {
                STNode closeParen = this.parseCloseParenthesis();
                return STNodeFactory.createNilTypeDescriptorNode(openParen, closeParen);
            }
        }
        if (this.isTypeStartingToken(nextToken.kind)) {
            STNode typedesc = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_PARENTHESIS);
            STNode closeParen = this.parseCloseParenthesis();
            return STNodeFactory.createParenthesisedTypeDescriptorNode(openParen, typedesc, closeParen);
        }
        this.recover(this.peek(), ParserRuleContext.NIL_OR_PARENTHESISED_TYPE_DESC_RHS, openParen);
        return this.parseNilOrParenthesisedTypeDescRhs(openParen);
    }

    private STNode parseSimpleTypeDescriptor() {
        STToken nextToken = this.peek();
        if (BallerinaParser.isSimpleType(nextToken.kind)) {
            STToken token = this.consume();
            return this.createBuiltinSimpleNameReference(token);
        }
        this.recover(nextToken, ParserRuleContext.SIMPLE_TYPE_DESCRIPTOR, new Object[0]);
        return this.parseSimpleTypeDescriptor();
    }

    private STNode createBuiltinSimpleNameReference(STNode token) {
        SyntaxKind typeKind = this.getTypeSyntaxKind(token.kind);
        return STNodeFactory.createBuiltinSimpleNameReferenceNode(typeKind, token);
    }

    protected STNode parseFunctionBody() {
        STToken token = this.peek();
        switch (token.kind) {
            case EQUAL_TOKEN: {
                return this.parseExternalFunctionBody();
            }
            case OPEN_BRACE_TOKEN: {
                return this.parseFunctionBodyBlock(false);
            }
            case RIGHT_DOUBLE_ARROW_TOKEN: {
                return this.parseExpressionFuncBody(false, false);
            }
        }
        this.recover(token, ParserRuleContext.FUNC_BODY, new Object[0]);
        return this.parseFunctionBody();
    }

    private STNode parseFunctionBodyBlock(boolean isAnonFunc) {
        STNode statements;
        STNode namedWorkersList;
        STNode stmt;
        this.startContext(ParserRuleContext.FUNC_BODY_BLOCK);
        STNode openBrace = this.parseOpenBrace();
        STToken token = this.peek();
        ArrayList<STNode> firstStmtList = new ArrayList<STNode>();
        ArrayList<STNode> workers = new ArrayList<STNode>();
        ArrayList<STNode> secondStmtList = new ArrayList<STNode>();
        ParserRuleContext currentCtx = ParserRuleContext.DEFAULT_WORKER_INIT;
        boolean hasNamedWorkers = false;
        while (!this.isEndOfFuncBodyBlock(token.kind, isAnonFunc) && (stmt = this.parseStatement()) != null) {
            if (stmt.kind == SyntaxKind.LOCAL_TYPE_DEFINITION_STATEMENT) {
                this.addInvalidNodeToNextToken(stmt, DiagnosticErrorCode.ERROR_LOCAL_TYPE_DEFINITION_NOT_ALLOWED, new Object[0]);
                continue;
            }
            switch (currentCtx) {
                case DEFAULT_WORKER_INIT: {
                    if (stmt.kind != SyntaxKind.NAMED_WORKER_DECLARATION) {
                        firstStmtList.add(stmt);
                        break;
                    }
                    currentCtx = ParserRuleContext.NAMED_WORKERS;
                    hasNamedWorkers = true;
                }
                case NAMED_WORKERS: {
                    if (stmt.kind == SyntaxKind.NAMED_WORKER_DECLARATION) {
                        workers.add(stmt);
                        break;
                    }
                    currentCtx = ParserRuleContext.DEFAULT_WORKER;
                }
                default: {
                    if (stmt.kind == SyntaxKind.NAMED_WORKER_DECLARATION) {
                        this.updateLastNodeInListWithInvalidNode(secondStmtList, stmt, DiagnosticErrorCode.ERROR_NAMED_WORKER_NOT_ALLOWED_HERE, new Object[0]);
                        break;
                    }
                    secondStmtList.add(stmt);
                }
            }
            token = this.peek();
        }
        if (hasNamedWorkers) {
            STNode workerInitStatements = STNodeFactory.createNodeList(firstStmtList);
            STNode namedWorkers = STNodeFactory.createNodeList(workers);
            namedWorkersList = STNodeFactory.createNamedWorkerDeclarator(workerInitStatements, namedWorkers);
            statements = STNodeFactory.createNodeList(secondStmtList);
        } else {
            namedWorkersList = STNodeFactory.createEmptyNode();
            statements = STNodeFactory.createNodeList(firstStmtList);
        }
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createFunctionBodyBlockNode(openBrace, namedWorkersList, statements, closeBrace);
    }

    private boolean isEndOfFuncBodyBlock(SyntaxKind nextTokenKind, boolean isAnonFunc) {
        if (isAnonFunc) {
            switch (nextTokenKind) {
                case EOF_TOKEN: 
                case PUBLIC_KEYWORD: 
                case EQUAL_TOKEN: 
                case SEMICOLON_TOKEN: 
                case OPEN_BRACE_TOKEN: 
                case COMMA_TOKEN: 
                case CLOSE_PAREN_TOKEN: 
                case CLOSE_BRACE_TOKEN: 
                case CLOSE_BRACKET_TOKEN: 
                case BACKTICK_TOKEN: {
                    return true;
                }
            }
        }
        return this.isEndOfStatements();
    }

    private boolean isEndOfRecordTypeNode(SyntaxKind nextTokenKind) {
        switch (nextTokenKind) {
            default: 
        }
        return this.endOfModuleLevelNode(1);
    }

    private boolean isEndOfObjectTypeNode() {
        return this.endOfModuleLevelNode(1, true);
    }

    private boolean isEndOfStatements() {
        switch (this.peek().kind) {
            case RESOURCE_KEYWORD: {
                return true;
            }
        }
        return this.endOfModuleLevelNode(1);
    }

    private boolean endOfModuleLevelNode(int peekIndex) {
        return this.endOfModuleLevelNode(peekIndex, false);
    }

    private boolean endOfModuleLevelNode(int peekIndex, boolean isObject) {
        switch (this.peek((int)peekIndex).kind) {
            case EOF_TOKEN: 
            case IMPORT_KEYWORD: 
            case LISTENER_KEYWORD: 
            case CONST_KEYWORD: 
            case ANNOTATION_KEYWORD: 
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACE_PIPE_TOKEN: {
                return true;
            }
            case SERVICE_KEYWORD: {
                return this.isServiceDeclStart(ParserRuleContext.OBJECT_MEMBER, 1);
            }
            case PUBLIC_KEYWORD: {
                return this.endOfModuleLevelNode(peekIndex + 1, isObject);
            }
            case FUNCTION_KEYWORD: {
                if (isObject) {
                    return false;
                }
                return this.peek((int)(peekIndex + 1)).kind == SyntaxKind.IDENTIFIER_TOKEN;
            }
        }
        return false;
    }

    private boolean isEndOfParameter(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case AT_TOKEN: 
            case TYPE_KEYWORD: 
            case SEMICOLON_TOKEN: 
            case COMMA_TOKEN: 
            case CLOSE_PAREN_TOKEN: 
            case RETURNS_KEYWORD: 
            case CLOSE_BRACKET_TOKEN: 
            case IF_KEYWORD: 
            case WHILE_KEYWORD: 
            case DO_KEYWORD: {
                return true;
            }
        }
        return this.endOfModuleLevelNode(1);
    }

    private boolean isEndOfParametersList(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case TYPE_KEYWORD: 
            case SEMICOLON_TOKEN: 
            case CLOSE_PAREN_TOKEN: 
            case RETURNS_KEYWORD: 
            case IF_KEYWORD: 
            case WHILE_KEYWORD: 
            case DO_KEYWORD: {
                return true;
            }
        }
        return this.endOfModuleLevelNode(1);
    }

    private STNode parseStatementStartIdentifier() {
        return this.parseQualifiedIdentifier(ParserRuleContext.TYPE_NAME_OR_VAR_NAME);
    }

    private STNode parseVariableName() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.VARIABLE_NAME, new Object[0]);
        return this.parseVariableName();
    }

    private STNode parseOpenBrace() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OPEN_BRACE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.OPEN_BRACE, new Object[0]);
        return this.parseOpenBrace();
    }

    private STNode parseCloseBrace() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CLOSE_BRACE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CLOSE_BRACE, new Object[0]);
        return this.parseCloseBrace();
    }

    private STNode parseExternalFunctionBody() {
        this.startContext(ParserRuleContext.EXTERNAL_FUNC_BODY);
        STNode assign = this.parseAssignOp();
        return this.parseExternalFuncBodyRhs(assign);
    }

    private STNode parseExternalFuncBodyRhs(STNode assign) {
        STNode annotation;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case AT_TOKEN: {
                annotation = this.parseAnnotations();
                break;
            }
            case EXTERNAL_KEYWORD: {
                annotation = STNodeFactory.createEmptyNodeList();
                break;
            }
            default: {
                this.recover(nextToken, ParserRuleContext.EXTERNAL_FUNC_BODY_OPTIONAL_ANNOTS, assign);
                return this.parseExternalFuncBodyRhs(assign);
            }
        }
        STNode externalKeyword = this.parseExternalKeyword();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createExternalFunctionBodyNode(assign, annotation, externalKeyword, semicolon);
    }

    private STNode parseSemicolon() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.SEMICOLON_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.SEMICOLON, new Object[0]);
        return this.parseSemicolon();
    }

    private STNode parseExternalKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.EXTERNAL_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.EXTERNAL_KEYWORD, new Object[0]);
        return this.parseExternalKeyword();
    }

    private STNode parseAssignOp() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.EQUAL_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ASSIGN_OP, new Object[0]);
        return this.parseAssignOp();
    }

    private STNode parseBinaryOperator() {
        STToken token = this.peek();
        if (this.isBinaryOperator(token.kind)) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.BINARY_OPERATOR, new Object[0]);
        return this.parseBinaryOperator();
    }

    private boolean isBinaryOperator(SyntaxKind kind) {
        switch (kind) {
            case PIPE_TOKEN: 
            case BITWISE_AND_TOKEN: 
            case SLASH_TOKEN: 
            case ELLIPSIS_TOKEN: 
            case PLUS_TOKEN: 
            case MINUS_TOKEN: 
            case ASTERISK_TOKEN: 
            case GT_TOKEN: 
            case LT_TOKEN: 
            case DOUBLE_EQUAL_TOKEN: 
            case TRIPPLE_EQUAL_TOKEN: 
            case LT_EQUAL_TOKEN: 
            case GT_EQUAL_TOKEN: 
            case NOT_EQUAL_TOKEN: 
            case NOT_DOUBLE_EQUAL_TOKEN: 
            case BITWISE_XOR_TOKEN: 
            case LOGICAL_AND_TOKEN: 
            case LOGICAL_OR_TOKEN: 
            case PERCENT_TOKEN: 
            case DOUBLE_LT_TOKEN: 
            case DOUBLE_GT_TOKEN: 
            case TRIPPLE_GT_TOKEN: 
            case DOUBLE_DOT_LT_TOKEN: 
            case ELVIS_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private OperatorPrecedence getOpPrecedence(SyntaxKind binaryOpKind) {
        switch (binaryOpKind) {
            case SLASH_TOKEN: 
            case ASTERISK_TOKEN: 
            case PERCENT_TOKEN: {
                return OperatorPrecedence.MULTIPLICATIVE;
            }
            case PLUS_TOKEN: 
            case MINUS_TOKEN: {
                return OperatorPrecedence.ADDITIVE;
            }
            case GT_TOKEN: 
            case LT_TOKEN: 
            case LT_EQUAL_TOKEN: 
            case GT_EQUAL_TOKEN: 
            case IS_KEYWORD: {
                return OperatorPrecedence.BINARY_COMPARE;
            }
            case OPEN_BRACKET_TOKEN: 
            case DOT_TOKEN: 
            case OPEN_PAREN_TOKEN: 
            case ANNOT_CHAINING_TOKEN: 
            case OPTIONAL_CHAINING_TOKEN: 
            case DOT_LT_TOKEN: 
            case SLASH_LT_TOKEN: 
            case DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN: 
            case SLASH_ASTERISK_TOKEN: {
                return OperatorPrecedence.MEMBER_ACCESS;
            }
            case DOUBLE_EQUAL_TOKEN: 
            case TRIPPLE_EQUAL_TOKEN: 
            case NOT_EQUAL_TOKEN: 
            case NOT_DOUBLE_EQUAL_TOKEN: {
                return OperatorPrecedence.EQUALITY;
            }
            case BITWISE_AND_TOKEN: {
                return OperatorPrecedence.BITWISE_AND;
            }
            case BITWISE_XOR_TOKEN: {
                return OperatorPrecedence.BITWISE_XOR;
            }
            case PIPE_TOKEN: {
                return OperatorPrecedence.BITWISE_OR;
            }
            case LOGICAL_AND_TOKEN: {
                return OperatorPrecedence.LOGICAL_AND;
            }
            case LOGICAL_OR_TOKEN: {
                return OperatorPrecedence.LOGICAL_OR;
            }
            case RIGHT_ARROW_TOKEN: {
                return OperatorPrecedence.REMOTE_CALL_ACTION;
            }
            case RIGHT_DOUBLE_ARROW_TOKEN: {
                return OperatorPrecedence.ANON_FUNC_OR_LET;
            }
            case SYNC_SEND_TOKEN: {
                return OperatorPrecedence.ACTION;
            }
            case DOUBLE_LT_TOKEN: 
            case DOUBLE_GT_TOKEN: 
            case TRIPPLE_GT_TOKEN: {
                return OperatorPrecedence.SHIFT;
            }
            case ELLIPSIS_TOKEN: 
            case DOUBLE_DOT_LT_TOKEN: {
                return OperatorPrecedence.RANGE;
            }
            case ELVIS_TOKEN: {
                return OperatorPrecedence.ELVIS_CONDITIONAL;
            }
            case QUESTION_MARK_TOKEN: 
            case COLON_TOKEN: {
                return OperatorPrecedence.CONDITIONAL;
            }
        }
        throw new UnsupportedOperationException("Unsupported binary operator '" + binaryOpKind + "'");
    }

    private SyntaxKind getBinaryOperatorKindToInsert(OperatorPrecedence opPrecedenceLevel) {
        switch (opPrecedenceLevel) {
            case MULTIPLICATIVE: {
                return SyntaxKind.ASTERISK_TOKEN;
            }
            case DEFAULT: 
            case UNARY: 
            case ACTION: 
            case EXPRESSION_ACTION: 
            case REMOTE_CALL_ACTION: 
            case ANON_FUNC_OR_LET: 
            case QUERY: 
            case ADDITIVE: {
                return SyntaxKind.PLUS_TOKEN;
            }
            case SHIFT: {
                return SyntaxKind.DOUBLE_LT_TOKEN;
            }
            case RANGE: {
                return SyntaxKind.ELLIPSIS_TOKEN;
            }
            case BINARY_COMPARE: {
                return SyntaxKind.LT_TOKEN;
            }
            case EQUALITY: {
                return SyntaxKind.DOUBLE_EQUAL_TOKEN;
            }
            case BITWISE_AND: {
                return SyntaxKind.BITWISE_AND_TOKEN;
            }
            case BITWISE_XOR: {
                return SyntaxKind.BITWISE_XOR_TOKEN;
            }
            case BITWISE_OR: {
                return SyntaxKind.PIPE_TOKEN;
            }
            case LOGICAL_AND: {
                return SyntaxKind.LOGICAL_AND_TOKEN;
            }
            case LOGICAL_OR: {
                return SyntaxKind.LOGICAL_OR_TOKEN;
            }
            case ELVIS_CONDITIONAL: {
                return SyntaxKind.ELVIS_TOKEN;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator precedence level'" + opPrecedenceLevel + "'");
    }

    private ParserRuleContext getMissingBinaryOperatorContext(OperatorPrecedence opPrecedenceLevel) {
        switch (opPrecedenceLevel) {
            case MULTIPLICATIVE: {
                return ParserRuleContext.ASTERISK;
            }
            case DEFAULT: 
            case UNARY: 
            case ACTION: 
            case EXPRESSION_ACTION: 
            case REMOTE_CALL_ACTION: 
            case ANON_FUNC_OR_LET: 
            case QUERY: 
            case ADDITIVE: {
                return ParserRuleContext.PLUS_TOKEN;
            }
            case SHIFT: {
                return ParserRuleContext.DOUBLE_LT;
            }
            case RANGE: {
                return ParserRuleContext.ELLIPSIS;
            }
            case BINARY_COMPARE: {
                return ParserRuleContext.LT_TOKEN;
            }
            case EQUALITY: {
                return ParserRuleContext.DOUBLE_EQUAL;
            }
            case BITWISE_AND: {
                return ParserRuleContext.BITWISE_AND_OPERATOR;
            }
            case BITWISE_XOR: {
                return ParserRuleContext.BITWISE_XOR;
            }
            case BITWISE_OR: {
                return ParserRuleContext.PIPE;
            }
            case LOGICAL_AND: {
                return ParserRuleContext.LOGICAL_AND;
            }
            case LOGICAL_OR: {
                return ParserRuleContext.LOGICAL_OR;
            }
            case ELVIS_CONDITIONAL: {
                return ParserRuleContext.ELVIS;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator precedence level'" + opPrecedenceLevel + "'");
    }

    private STNode parseModuleTypeDefinition(STNode metadata, STNode qualifier) {
        this.startContext(ParserRuleContext.MODULE_TYPE_DEFINITION);
        STNode typeKeyword = this.parseTypeKeyword();
        STNode typeName = this.parseTypeName();
        STNode typeDescriptor = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TYPE_DEF);
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createTypeDefinitionNode(metadata, qualifier, typeKeyword, typeName, typeDescriptor, semicolon);
    }

    private STNode parseClassDefinition(STNode metadata, STNode qualifier, List<STNode> qualifiers) {
        this.startContext(ParserRuleContext.MODULE_CLASS_DEFINITION);
        STNode classTypeQualifiers = this.createClassTypeQualNodeList(qualifiers);
        STNode classKeyword = this.parseClassKeyword();
        STNode className = this.parseClassName();
        STNode openBrace = this.parseOpenBrace();
        STNode classMembers = this.parseObjectMembers(ParserRuleContext.CLASS_MEMBER);
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createClassDefinitionNode(metadata, qualifier, classTypeQualifiers, classKeyword, className, openBrace, classMembers, closeBrace);
    }

    private boolean isClassTypeQual(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case ISOLATED_KEYWORD: 
            case DISTINCT_KEYWORD: 
            case CLIENT_KEYWORD: 
            case READONLY_KEYWORD: {
                return true;
            }
        }
        return false;
    }

    private boolean isObjectTypeQual(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case ISOLATED_KEYWORD: 
            case CLIENT_KEYWORD: {
                return true;
            }
        }
        return false;
    }

    private STNode createClassTypeQualNodeList(List<STNode> qualifierList) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (this.isClassTypeQual(qualifier.kind)) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) {
                this.addInvalidNodeToNextToken(qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
                continue;
            }
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        return STNodeFactory.createNodeList(validatedList);
    }

    private STNode createObjectTypeQualNodeList(List<STNode> qualifierList) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (this.isObjectTypeQual(qualifier.kind)) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) {
                this.addInvalidNodeToNextToken(qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
                continue;
            }
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        return STNodeFactory.createNodeList(validatedList);
    }

    private STNode parseClassKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CLASS_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CLASS_KEYWORD, new Object[0]);
        return this.parseClassKeyword();
    }

    private STNode parseTypeKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.TYPE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.TYPE_KEYWORD, new Object[0]);
        return this.parseTypeKeyword();
    }

    private STNode parseTypeName() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.TYPE_NAME, new Object[0]);
        return this.parseTypeName();
    }

    private STNode parseClassName() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CLASS_NAME, new Object[0]);
        return this.parseClassName();
    }

    private STNode parseRecordTypeDescriptor() {
        STNode field;
        this.startContext(ParserRuleContext.RECORD_TYPE_DESCRIPTOR);
        STNode recordKeyword = this.parseRecordKeyword();
        STNode bodyStartDelimiter = this.parseRecordBodyStartDelimiter();
        boolean isInclusive = bodyStartDelimiter.kind == SyntaxKind.OPEN_BRACE_TOKEN;
        ArrayList<STNode> recordFields = new ArrayList<STNode>();
        STToken token = this.peek();
        STNode recordRestDescriptor = null;
        while (!this.isEndOfRecordTypeNode(token.kind) && (field = this.parseFieldOrRestDescriptor(isInclusive)) != null) {
            token = this.peek();
            if (field.kind == SyntaxKind.RECORD_REST_TYPE) {
                recordRestDescriptor = field;
                break;
            }
            recordFields.add(field);
        }
        while (recordRestDescriptor != null && !this.isEndOfRecordTypeNode(token.kind)) {
            STNode invalidField = this.parseFieldOrRestDescriptor(isInclusive);
            recordRestDescriptor = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(recordRestDescriptor, invalidField, (DiagnosticCode)DiagnosticErrorCode.ERROR_MORE_RECORD_FIELDS_AFTER_REST_FIELD, new Object[0]);
            token = this.peek();
        }
        STNode fields = STNodeFactory.createNodeList(recordFields);
        STNode bodyEndDelimiter = this.parseRecordBodyCloseDelimiter(bodyStartDelimiter.kind);
        this.endContext();
        return STNodeFactory.createRecordTypeDescriptorNode(recordKeyword, bodyStartDelimiter, fields, recordRestDescriptor, bodyEndDelimiter);
    }

    private STNode parseRecordBodyStartDelimiter() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_BRACE_PIPE_TOKEN: {
                return this.parseClosedRecordBodyStart();
            }
            case OPEN_BRACE_TOKEN: {
                return this.parseOpenBrace();
            }
        }
        this.recover(nextToken, ParserRuleContext.RECORD_BODY_START, new Object[0]);
        return this.parseRecordBodyStartDelimiter();
    }

    private STNode parseClosedRecordBodyStart() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OPEN_BRACE_PIPE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CLOSED_RECORD_BODY_START, new Object[0]);
        return this.parseClosedRecordBodyStart();
    }

    private STNode parseRecordBodyCloseDelimiter(SyntaxKind startingDelimeter) {
        if (startingDelimeter == SyntaxKind.OPEN_BRACE_PIPE_TOKEN) {
            return this.parseClosedRecordBodyEnd();
        }
        return this.parseCloseBrace();
    }

    private STNode parseClosedRecordBodyEnd() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CLOSE_BRACE_PIPE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CLOSED_RECORD_BODY_END, new Object[0]);
        return this.parseClosedRecordBodyEnd();
    }

    private STNode parseRecordKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.RECORD_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.RECORD_KEYWORD, new Object[0]);
        return this.parseRecordKeyword();
    }

    private STNode parseFieldOrRestDescriptor(boolean isInclusive) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACE_PIPE_TOKEN: {
                return null;
            }
            case ASTERISK_TOKEN: {
                this.startContext(ParserRuleContext.RECORD_FIELD);
                STToken asterisk = this.consume();
                STNode type = this.parseTypeReference();
                STNode semicolonToken = this.parseSemicolon();
                this.endContext();
                return STNodeFactory.createTypeReferenceNode(asterisk, type, semicolonToken);
            }
            case DOCUMENTATION_STRING: 
            case AT_TOKEN: {
                this.startContext(ParserRuleContext.RECORD_FIELD);
                STNode metadata = this.parseMetaData();
                nextToken = this.peek();
                return this.parseRecordField(nextToken, isInclusive, metadata);
            }
        }
        if (this.isTypeStartingToken(nextToken.kind)) {
            this.startContext(ParserRuleContext.RECORD_FIELD);
            STNode metadata = STNodeFactory.createEmptyNode();
            return this.parseRecordField(nextToken, isInclusive, metadata);
        }
        this.recover(this.peek(), ParserRuleContext.RECORD_FIELD_OR_RECORD_END, isInclusive);
        return this.parseFieldOrRestDescriptor(isInclusive);
    }

    private STNode parseRecordField(STToken nextToken, boolean isInclusive, STNode metadata) {
        STNode type;
        if (nextToken.kind != SyntaxKind.READONLY_KEYWORD) {
            STNode type2 = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_RECORD_FIELD);
            STNode fieldOrRestDesc = this.parseFieldDescriptor(isInclusive, metadata, type2);
            this.endContext();
            return fieldOrRestDesc;
        }
        STNode readOnlyQualifier = this.parseReadonlyKeyword();
        nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            STNode fieldNameOrTypeDesc = this.parseQualifiedIdentifier(ParserRuleContext.RECORD_FIELD_NAME_OR_TYPE_NAME);
            if (fieldNameOrTypeDesc.kind == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
                type = fieldNameOrTypeDesc;
            } else {
                nextToken = this.peek();
                switch (nextToken.kind) {
                    case EQUAL_TOKEN: 
                    case SEMICOLON_TOKEN: {
                        STNode type3 = this.createBuiltinSimpleNameReference(readOnlyQualifier);
                        readOnlyQualifier = STNodeFactory.createEmptyNode();
                        STNode fieldName = ((STSimpleNameReferenceNode)fieldNameOrTypeDesc).name;
                        return this.parseFieldDescriptorRhs(metadata, readOnlyQualifier, type3, fieldName);
                    }
                }
                type = this.parseComplexTypeDescriptor(fieldNameOrTypeDesc, ParserRuleContext.TYPE_DESC_IN_RECORD_FIELD, false);
            }
        } else {
            if (nextToken.kind == SyntaxKind.ELLIPSIS_TOKEN) {
                STNode type4 = this.createBuiltinSimpleNameReference(readOnlyQualifier);
                STNode fieldOrRestDesc = this.parseFieldDescriptor(isInclusive, metadata, type4);
                this.endContext();
                return fieldOrRestDesc;
            }
            if (this.isTypeStartingToken(nextToken.kind)) {
                type = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_RECORD_FIELD);
            } else {
                readOnlyQualifier = this.createBuiltinSimpleNameReference(readOnlyQualifier);
                type = this.parseComplexTypeDescriptor(readOnlyQualifier, ParserRuleContext.TYPE_DESC_IN_RECORD_FIELD, false);
                readOnlyQualifier = STNodeFactory.createEmptyNode();
            }
        }
        STNode fieldOrRestDesc = this.parseIndividualRecordField(metadata, readOnlyQualifier, type);
        this.endContext();
        return fieldOrRestDesc;
    }

    private STNode parseFieldDescriptor(boolean isInclusive, STNode metadata, STNode type) {
        if (isInclusive) {
            STNode readOnlyQualifier = STNodeFactory.createEmptyNode();
            return this.parseIndividualRecordField(metadata, readOnlyQualifier, type);
        }
        return this.parseFieldOrRestDescriptorRhs(metadata, type);
    }

    private STNode parseIndividualRecordField(STNode metadata, STNode readOnlyQualifier, STNode type) {
        STNode fieldName = this.parseVariableName();
        return this.parseFieldDescriptorRhs(metadata, readOnlyQualifier, type, fieldName);
    }

    private STNode parseTypeReference() {
        STNode typeReference = this.parseTypeDescriptor(ParserRuleContext.TYPE_REFERENCE);
        if (typeReference.kind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            if (typeReference.hasDiagnostics()) {
                STNode emptyNameReference = STNodeFactory.createSimpleNameReferenceNode(SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_IDENTIFIER));
                return emptyNameReference;
            }
            return typeReference;
        }
        if (typeReference.kind == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return typeReference;
        }
        STNode emptyNameReference = STNodeFactory.createSimpleNameReferenceNode(SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN));
        emptyNameReference = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(emptyNameReference, typeReference, (DiagnosticCode)DiagnosticErrorCode.ERROR_ONLY_TYPE_REFERENCE_ALLOWED_AS_TYPE_INCLUSIONS, new Object[0]);
        return emptyNameReference;
    }

    private STNode parseTypeReference(boolean isInConditionalExpr) {
        return this.parseQualifiedIdentifier(ParserRuleContext.TYPE_REFERENCE, isInConditionalExpr);
    }

    private STNode parseQualifiedIdentifier(ParserRuleContext currentCtx) {
        return this.parseQualifiedIdentifier(currentCtx, false);
    }

    private STNode parseQualifiedIdentifier(ParserRuleContext currentCtx, boolean isInConditionalExpr) {
        STToken typeRefOrPkgRef;
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            typeRefOrPkgRef = this.consume();
        } else {
            this.recover(token, currentCtx, isInConditionalExpr);
            if (this.peek().kind != SyntaxKind.IDENTIFIER_TOKEN) {
                this.addInvalidTokenToNextToken(this.errorHandler.consumeInvalidToken());
                return this.parseQualifiedIdentifier(currentCtx, isInConditionalExpr);
            }
            typeRefOrPkgRef = this.consume();
        }
        return this.parseQualifiedIdentifier(typeRefOrPkgRef, isInConditionalExpr);
    }

    private STNode parseQualifiedIdentifier(STNode identifier, boolean isInConditionalExpr) {
        STToken nextToken = this.peek(1);
        if (nextToken.kind != SyntaxKind.COLON_TOKEN) {
            return STNodeFactory.createSimpleNameReferenceNode(identifier);
        }
        STToken nextNextToken = this.peek(2);
        switch (nextNextToken.kind) {
            case IDENTIFIER_TOKEN: {
                STToken colon = this.consume();
                STToken varOrFuncName = this.consume();
                return STNodeFactory.createQualifiedNameReferenceNode(identifier, colon, varOrFuncName);
            }
            case MAP_KEYWORD: {
                STToken colon = this.consume();
                STToken mapKeyword = this.consume();
                STToken refName = STNodeFactory.createIdentifierToken(mapKeyword.text(), mapKeyword.leadingMinutiae(), mapKeyword.trailingMinutiae(), mapKeyword.diagnostics());
                return STNodeFactory.createQualifiedNameReferenceNode(identifier, colon, refName);
            }
            case COLON_TOKEN: {
                this.addInvalidTokenToNextToken(this.errorHandler.consumeInvalidToken());
                return this.parseQualifiedIdentifier(identifier, isInConditionalExpr);
            }
        }
        if (isInConditionalExpr) {
            return STNodeFactory.createSimpleNameReferenceNode(identifier);
        }
        STToken colon = this.consume();
        STToken varOrFuncName = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_IDENTIFIER);
        return STNodeFactory.createQualifiedNameReferenceNode(identifier, colon, varOrFuncName);
    }

    private STNode parseFieldOrRestDescriptorRhs(STNode metadata, STNode type) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case ELLIPSIS_TOKEN: {
                this.reportInvalidMetaData(metadata);
                STNode ellipsis = this.parseEllipsis();
                STNode semicolonToken = this.parseSemicolon();
                return STNodeFactory.createRecordRestDescriptorNode(type, ellipsis, semicolonToken);
            }
            case IDENTIFIER_TOKEN: {
                STNode readonlyQualifier = STNodeFactory.createEmptyNode();
                return this.parseIndividualRecordField(metadata, readonlyQualifier, type);
            }
        }
        this.recover(nextToken, ParserRuleContext.FIELD_OR_REST_DESCIPTOR_RHS, metadata, type);
        return this.parseFieldOrRestDescriptorRhs(metadata, type);
    }

    private STNode parseFieldDescriptorRhs(STNode metadata, STNode readonlyQualifier, STNode type, STNode fieldName) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case SEMICOLON_TOKEN: {
                STNode questionMarkToken = STNodeFactory.createEmptyNode();
                STNode semicolonToken = this.parseSemicolon();
                return STNodeFactory.createRecordFieldNode(metadata, readonlyQualifier, type, fieldName, questionMarkToken, semicolonToken);
            }
            case QUESTION_MARK_TOKEN: {
                STNode questionMarkToken = this.parseQuestionMark();
                STNode semicolonToken = this.parseSemicolon();
                return STNodeFactory.createRecordFieldNode(metadata, readonlyQualifier, type, fieldName, questionMarkToken, semicolonToken);
            }
            case EQUAL_TOKEN: {
                STNode equalsToken = this.parseAssignOp();
                STNode expression = this.parseExpression();
                STNode semicolonToken = this.parseSemicolon();
                return STNodeFactory.createRecordFieldWithDefaultValueNode(metadata, readonlyQualifier, type, fieldName, equalsToken, expression, semicolonToken);
            }
        }
        this.recover(nextToken, ParserRuleContext.FIELD_DESCRIPTOR_RHS, metadata, readonlyQualifier, type, fieldName);
        return this.parseFieldDescriptorRhs(metadata, readonlyQualifier, type, fieldName);
    }

    private STNode parseQuestionMark() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.QUESTION_MARK_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.QUESTION_MARK, new Object[0]);
        return this.parseQuestionMark();
    }

    private STNode parseStatements() {
        ArrayList<STNode> stmts = new ArrayList<STNode>();
        return this.parseStatements(stmts);
    }

    private STNode parseStatements(ArrayList<STNode> stmts) {
        STNode stmt;
        while (!this.isEndOfStatements() && (stmt = this.parseStatement()) != null) {
            if (stmt.kind == SyntaxKind.NAMED_WORKER_DECLARATION) {
                this.addInvalidNodeToNextToken(stmt, DiagnosticErrorCode.ERROR_NAMED_WORKER_NOT_ALLOWED_HERE, new Object[0]);
                continue;
            }
            if (stmt.kind == SyntaxKind.LOCAL_TYPE_DEFINITION_STATEMENT) {
                this.addInvalidNodeToNextToken(stmt, DiagnosticErrorCode.ERROR_LOCAL_TYPE_DEFINITION_NOT_ALLOWED, new Object[0]);
                continue;
            }
            stmts.add(stmt);
        }
        return STNodeFactory.createNodeList(stmts);
    }

    protected STNode parseStatement() {
        STToken nextToken = this.peek();
        STNode annots = STNodeFactory.createEmptyNodeList();
        switch (nextToken.kind) {
            case CLOSE_BRACE_TOKEN: {
                return null;
            }
            case SEMICOLON_TOKEN: {
                this.addInvalidTokenToNextToken(this.errorHandler.consumeInvalidToken());
                return this.parseStatement();
            }
            case AT_TOKEN: {
                annots = this.parseOptionalAnnotations();
                break;
            }
            default: {
                if (this.isStatementStartingToken(nextToken.kind)) break;
                STToken token = this.peek();
                AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.STATEMENT, new Object[0]);
                if (solution.action == AbstractParserErrorHandler.Action.KEEP) break;
                return this.parseStatement();
            }
        }
        return this.parseStatement(annots);
    }

    private STNode getAnnotations(STNode nullbaleAnnot) {
        if (nullbaleAnnot != null) {
            return nullbaleAnnot;
        }
        return STNodeFactory.createEmptyNodeList();
    }

    private STNode parseStatement(STNode annots) {
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        return this.parseStatement(annots, typeDescQualifiers);
    }

    private STNode parseStatement(STNode annots, List<STNode> qualifiers) {
        this.parseTypeDescQualifiers(qualifiers);
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case CLOSE_BRACE_TOKEN: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return null;
            }
            case SEMICOLON_TOKEN: {
                this.addInvalidTokenToNextToken(this.errorHandler.consumeInvalidToken());
                return this.parseStatement(annots, qualifiers);
            }
            case FINAL_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                STToken finalKeyword = this.consume();
                return this.parseVariableDecl(this.getAnnotations(annots), finalKeyword);
            }
            case IF_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseIfElseBlock();
            }
            case WHILE_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseWhileStatement();
            }
            case DO_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseDoStatement();
            }
            case PANIC_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parsePanicStatement();
            }
            case CONTINUE_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseContinueStatement();
            }
            case BREAK_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseBreakStatement();
            }
            case RETURN_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseReturnStatement();
            }
            case FAIL_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseFailStatement();
            }
            case TYPE_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseLocalTypeDefinitionStatement(this.getAnnotations(annots));
            }
            case LOCK_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseLockStatement();
            }
            case OPEN_BRACE_TOKEN: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseStatementStartsWithOpenBrace();
            }
            case WORKER_KEYWORD: {
                return this.parseNamedWorkerDeclaration(this.getAnnotations(annots), qualifiers);
            }
            case FORK_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseForkStatement();
            }
            case FOREACH_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseForEachStatement();
            }
            case START_KEYWORD: 
            case CHECK_KEYWORD: 
            case CHECKPANIC_KEYWORD: 
            case TRAP_KEYWORD: 
            case FLUSH_KEYWORD: 
            case LEFT_ARROW_TOKEN: 
            case WAIT_KEYWORD: 
            case FROM_KEYWORD: 
            case COMMIT_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseExpressionStatement(this.getAnnotations(annots));
            }
            case XMLNS_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseXMLNamespaceDeclaration(false);
            }
            case TRANSACTION_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseTransactionStatement();
            }
            case RETRY_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseRetryStatement();
            }
            case ROLLBACK_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseRollbackStatement();
            }
            case OPEN_BRACKET_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseStatementStartsWithOpenBracket(this.getAnnotations(annots), false);
            }
            case FUNCTION_KEYWORD: 
            case IDENTIFIER_TOKEN: 
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case OPEN_PAREN_TOKEN: 
            case XML_KEYWORD: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: 
            case STRING_KEYWORD: {
                return this.parseStmtStartsWithTypeOrExpr(this.getAnnotations(annots), qualifiers);
            }
            case MATCH_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseMatchStatement();
            }
            case ERROR_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseErrorTypeDescOrErrorBP(this.getAnnotations(annots));
            }
        }
        if (this.isValidExpressionStart(nextToken.kind, 1)) {
            this.reportInvalidQualifierList(qualifiers);
            return this.parseStatementStartWithExpr(this.getAnnotations(annots));
        }
        if (this.isTypeStartingToken(nextToken.kind)) {
            return this.parseVariableDecl(this.getAnnotations(annots), new ArrayList<STNode>(), qualifiers, false);
        }
        STToken token = this.peek();
        AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.STATEMENT_WITHOUT_ANNOTS, annots, qualifiers);
        if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
            this.reportInvalidQualifierList(qualifiers);
            STNode finalKeyword = STNodeFactory.createEmptyNode();
            return this.parseVariableDecl(this.getAnnotations(annots), finalKeyword);
        }
        return this.parseStatement(annots, qualifiers);
    }

    private STNode parseVariableDecl(STNode annots, STNode finalKeyword) {
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        ArrayList<STNode> varDecQualifiers = new ArrayList<STNode>();
        if (finalKeyword != null) {
            varDecQualifiers.add(finalKeyword);
        }
        return this.parseVariableDecl(annots, varDecQualifiers, typeDescQualifiers, false);
    }

    private STNode parseVariableDecl(STNode annots, List<STNode> varDeclQuals, List<STNode> typeDescQualifiers, boolean isModuleVar) {
        this.startContext(ParserRuleContext.VAR_DECL_STMT);
        STNode typeBindingPattern = this.parseTypedBindingPattern(typeDescQualifiers, ParserRuleContext.VAR_DECL_STMT);
        return this.parseVarDeclRhs(annots, varDeclQuals, typeBindingPattern, isModuleVar);
    }

    private STNode parseVarDeclRhs(STNode metadata, List<STNode> varDeclQuals, STNode typedBindingPattern, boolean isModuleVar) {
        STNode semicolon;
        STNode expr;
        STNode assign;
        boolean hasVarInit = false;
        boolean isConfigurable = false;
        if (isModuleVar && this.isSyntaxKindInList(varDeclQuals, SyntaxKind.CONFIGURABLE_KEYWORD)) {
            isConfigurable = true;
        }
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EQUAL_TOKEN: {
                assign = this.parseAssignOp();
                expr = isModuleVar ? (isConfigurable ? this.parseConfigurableVarDeclRhs() : this.parseExpression()) : this.parseActionOrExpression();
                semicolon = this.parseSemicolon();
                hasVarInit = true;
                break;
            }
            case SEMICOLON_TOKEN: {
                assign = STNodeFactory.createEmptyNode();
                expr = STNodeFactory.createEmptyNode();
                semicolon = this.parseSemicolon();
                break;
            }
            default: {
                this.recover(nextToken, ParserRuleContext.VAR_DECL_STMT_RHS, metadata, varDeclQuals, typedBindingPattern, isModuleVar);
                return this.parseVarDeclRhs(metadata, varDeclQuals, typedBindingPattern, isModuleVar);
            }
        }
        this.endContext();
        if (isModuleVar) {
            return this.createModuleVarDeclaration(metadata, varDeclQuals, typedBindingPattern, assign, expr, semicolon, isConfigurable, hasVarInit);
        }
        STNode finalKeyword = varDeclQuals.isEmpty() ? STNodeFactory.createEmptyNode() : varDeclQuals.get(0);
        assert (metadata.kind == SyntaxKind.LIST);
        return STNodeFactory.createVariableDeclarationNode(metadata, finalKeyword, typedBindingPattern, assign, expr, semicolon);
    }

    private STNode parseConfigurableVarDeclRhs() {
        STNode expr;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case QUESTION_MARK_TOKEN: {
                expr = STNodeFactory.createRequiredExpressionNode(this.consume());
                break;
            }
            default: {
                if (this.isValidExprStart(nextToken.kind)) {
                    expr = this.parseExpression();
                    break;
                }
                this.recover(nextToken, ParserRuleContext.CONFIG_VAR_DECL_RHS, new Object[0]);
                return this.parseConfigurableVarDeclRhs();
            }
        }
        return expr;
    }

    private STNode createModuleVarDeclaration(STNode metadata, List<STNode> varDeclQuals, STNode typedBindingPattern, STNode assign, STNode expr, STNode semicolon, boolean isConfigurable, boolean hasVarInit) {
        if (hasVarInit || varDeclQuals.isEmpty()) {
            return this.createModuleVarDeclaration(metadata, varDeclQuals, typedBindingPattern, assign, expr, semicolon);
        }
        if (isConfigurable) {
            assign = SyntaxErrors.createMissingToken(SyntaxKind.EQUAL_TOKEN);
            assign = SyntaxErrors.addDiagnostic(assign, DiagnosticErrorCode.ERROR_CONFIGURABLE_VARIABLE_MUST_BE_INITIALIZED, new Object[0]);
            STToken questionMarkToken = SyntaxErrors.createMissingToken(SyntaxKind.QUESTION_MARK_TOKEN);
            expr = STNodeFactory.createRequiredExpressionNode(questionMarkToken);
            return this.createModuleVarDeclaration(metadata, varDeclQuals, typedBindingPattern, assign, expr, semicolon);
        }
        STNode lastQualifier = varDeclQuals.get(varDeclQuals.size() - 1);
        if (lastQualifier.kind == SyntaxKind.ISOLATED_KEYWORD) {
            lastQualifier = varDeclQuals.remove(varDeclQuals.size() - 1);
            typedBindingPattern = this.modifyTypedBindingPatternWithIsolatedQualifier(typedBindingPattern, lastQualifier);
        }
        return this.createModuleVarDeclaration(metadata, varDeclQuals, typedBindingPattern, assign, expr, semicolon);
    }

    private STNode createModuleVarDeclaration(STNode metadata, List<STNode> varDeclQuals, STNode typedBindingPattern, STNode assign, STNode expr, STNode semicolon) {
        STNode varDeclQualifiersNode = STNodeFactory.createNodeList(varDeclQuals);
        return STNodeFactory.createModuleVariableDeclarationNode(metadata, varDeclQualifiersNode, typedBindingPattern, assign, expr, semicolon);
    }

    private STNode modifyTypedBindingPatternWithIsolatedQualifier(STNode typedBindingPattern, STNode isolatedQualifier) {
        STTypedBindingPatternNode typedBindingPatternNode = (STTypedBindingPatternNode)typedBindingPattern;
        STNode typeDescriptor = typedBindingPatternNode.typeDescriptor;
        STNode bindingPattern = typedBindingPatternNode.bindingPattern;
        switch (typeDescriptor.kind) {
            case OBJECT_TYPE_DESC: {
                typeDescriptor = this.modifyObjectTypeDescWithIsolatedQualifier(typeDescriptor, isolatedQualifier);
                break;
            }
            case FUNCTION_TYPE_DESC: {
                typeDescriptor = this.modifyFuncTypeDescWithIsolatedQualifier(typeDescriptor, isolatedQualifier);
                break;
            }
            default: {
                typeDescriptor = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(typeDescriptor, isolatedQualifier, (DiagnosticCode)DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)isolatedQualifier).text());
            }
        }
        return STNodeFactory.createTypedBindingPatternNode(typeDescriptor, bindingPattern);
    }

    private STNode modifyObjectTypeDescWithIsolatedQualifier(STNode objectTypeDesc, STNode isolatedKeyword) {
        STObjectTypeDescriptorNode objectTypeDescriptorNode = (STObjectTypeDescriptorNode)objectTypeDesc;
        STNodeList qualifierList = (STNodeList)objectTypeDescriptorNode.objectTypeQualifiers;
        STNode newObjectTypeQualifiers = this.modifyNodeListWithIsolatedQualifier(qualifierList, isolatedKeyword);
        return objectTypeDescriptorNode.modify(newObjectTypeQualifiers, objectTypeDescriptorNode.objectKeyword, objectTypeDescriptorNode.openBrace, objectTypeDescriptorNode.members, objectTypeDescriptorNode.closeBrace);
    }

    private STNode modifyFuncTypeDescWithIsolatedQualifier(STNode funcTypeDesc, STNode isolatedKeyword) {
        STFunctionTypeDescriptorNode funcTypeDescriptorNode = (STFunctionTypeDescriptorNode)funcTypeDesc;
        STNode qualifierList = funcTypeDescriptorNode.qualifierList;
        STNode newfuncTypeQualifiers = this.modifyNodeListWithIsolatedQualifier(qualifierList, isolatedKeyword);
        return funcTypeDescriptorNode.modify(newfuncTypeQualifiers, funcTypeDescriptorNode.functionKeyword, funcTypeDescriptorNode.functionSignature);
    }

    private STNode modifyNodeListWithIsolatedQualifier(STNode qualifiers, STNode isolatedKeyword) {
        ArrayList<STNode> newQualifierList = new ArrayList<STNode>();
        newQualifierList.add(isolatedKeyword);
        STNodeList qualifierNodeList = (STNodeList)qualifiers;
        for (int i = 0; i < qualifierNodeList.size(); ++i) {
            STNode qualifier = qualifierNodeList.get(i);
            if (qualifier.kind == SyntaxKind.ISOLATED_KEYWORD) {
                this.updateLastNodeInListWithInvalidNode(newQualifierList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            newQualifierList.add(qualifier);
        }
        return STNodeFactory.createNodeList(newQualifierList);
    }

    private STNode parseAssignmentStmtRhs(STNode lvExpr) {
        boolean lvExprValid;
        STNode assign = this.parseAssignOp();
        STNode expr = this.parseActionOrExpression();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        if (lvExpr.kind == SyntaxKind.FUNCTION_CALL && this.isPossibleErrorBindingPattern((STFunctionCallExpressionNode)lvExpr)) {
            lvExpr = this.getBindingPattern(lvExpr);
        }
        if (!(lvExprValid = this.isValidLVExpr(lvExpr))) {
            STToken identifier = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
            STNode simpleNameRef = STNodeFactory.createSimpleNameReferenceNode(identifier);
            lvExpr = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(simpleNameRef, lvExpr, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_EXPR_IN_ASSIGNMENT_LHS, new Object[0]);
        }
        return STNodeFactory.createAssignmentStatementNode(lvExpr, assign, expr, semicolon);
    }

    protected STNode parseExpression() {
        return this.parseExpression(DEFAULT_OP_PRECEDENCE, true, false);
    }

    private STNode parseActionOrExpression() {
        return this.parseExpression(DEFAULT_OP_PRECEDENCE, true, true);
    }

    private STNode parseActionOrExpressionInLhs(STNode annots) {
        return this.parseExpression(DEFAULT_OP_PRECEDENCE, annots, false, true, false);
    }

    private STNode parseExpression(boolean isRhsExpr) {
        return this.parseExpression(DEFAULT_OP_PRECEDENCE, isRhsExpr, false);
    }

    private boolean isValidLVExpr(STNode expression) {
        switch (expression.kind) {
            case SIMPLE_NAME_REFERENCE: 
            case QUALIFIED_NAME_REFERENCE: 
            case LIST_BINDING_PATTERN: 
            case MAPPING_BINDING_PATTERN: 
            case ERROR_BINDING_PATTERN: {
                return true;
            }
            case FIELD_ACCESS: {
                return this.isValidLVMemberExpr(((STFieldAccessExpressionNode)expression).expression);
            }
            case INDEXED_EXPRESSION: {
                return this.isValidLVMemberExpr(((STIndexedExpressionNode)expression).containerExpression);
            }
        }
        return expression instanceof STMissingToken;
    }

    private boolean isValidLVMemberExpr(STNode expression) {
        switch (expression.kind) {
            case SIMPLE_NAME_REFERENCE: 
            case QUALIFIED_NAME_REFERENCE: {
                return true;
            }
            case FIELD_ACCESS: {
                return this.isValidLVMemberExpr(((STFieldAccessExpressionNode)expression).expression);
            }
            case INDEXED_EXPRESSION: {
                return this.isValidLVMemberExpr(((STIndexedExpressionNode)expression).containerExpression);
            }
            case BRACED_EXPRESSION: {
                return this.isValidLVMemberExpr(((STBracedExpressionNode)expression).expression);
            }
        }
        return expression instanceof STMissingToken;
    }

    private STNode parseExpression(OperatorPrecedence precedenceLevel, boolean isRhsExpr, boolean allowActions) {
        return this.parseExpression(precedenceLevel, isRhsExpr, allowActions, false);
    }

    private STNode parseExpression(OperatorPrecedence precedenceLevel, boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        return this.parseExpression(precedenceLevel, isRhsExpr, allowActions, false, isInConditionalExpr);
    }

    private STNode parseExpression(OperatorPrecedence precedenceLevel, boolean isRhsExpr, boolean allowActions, boolean isInMatchGuard, boolean isInConditionalExpr) {
        STNode expr = this.parseTerminalExpression(isRhsExpr, allowActions, isInConditionalExpr);
        return this.parseExpressionRhs(precedenceLevel, expr, isRhsExpr, allowActions, isInMatchGuard, isInConditionalExpr);
    }

    private STNode attachErrorExpectedActionFoundDiagnostic(STNode node) {
        return SyntaxErrors.addDiagnostic(node, DiagnosticErrorCode.ERROR_EXPRESSION_EXPECTED_ACTION_FOUND, new Object[0]);
    }

    private STNode parseExpression(OperatorPrecedence precedenceLevel, STNode annots, boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        STNode expr = this.parseTerminalExpression(annots, isRhsExpr, allowActions, isInConditionalExpr);
        return this.parseExpressionRhs(precedenceLevel, expr, isRhsExpr, allowActions, false, isInConditionalExpr);
    }

    private STNode parseTerminalExpression(boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        STNode annots = STNodeFactory.createEmptyNodeList();
        if (this.peek().kind == SyntaxKind.AT_TOKEN) {
            annots = this.parseOptionalAnnotations();
        }
        return this.parseTerminalExpression(annots, isRhsExpr, allowActions, isInConditionalExpr);
    }

    private STNode parseTerminalExpression(STNode annots, boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        ArrayList<STNode> qualifiers = new ArrayList<STNode>();
        return this.parseTerminalExpression(annots, qualifiers, isRhsExpr, allowActions, isInConditionalExpr);
    }

    private STNode parseTerminalExpression(STNode annots, List<STNode> qualifiers, boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        this.parseExprQualifiers(qualifiers);
        STToken nextToken = this.peek();
        this.validateExprAnnotsAndQualifiers(nextToken, annots, qualifiers);
        switch (nextToken.kind) {
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                return this.parseBasicLiteral();
            }
            case IDENTIFIER_TOKEN: {
                return this.parseQualifiedIdentifier(ParserRuleContext.VARIABLE_REF, isInConditionalExpr);
            }
            case OPEN_PAREN_TOKEN: {
                return this.parseBracedExpression(isRhsExpr, allowActions);
            }
            case CHECK_KEYWORD: 
            case CHECKPANIC_KEYWORD: {
                return this.parseCheckExpression(isRhsExpr, allowActions, isInConditionalExpr);
            }
            case OPEN_BRACE_TOKEN: {
                return this.parseMappingConstructorExpr();
            }
            case TYPEOF_KEYWORD: {
                return this.parseTypeofExpression(isRhsExpr, isInConditionalExpr);
            }
            case PLUS_TOKEN: 
            case MINUS_TOKEN: 
            case NEGATION_TOKEN: 
            case EXCLAMATION_MARK_TOKEN: {
                return this.parseUnaryExpression(isRhsExpr, isInConditionalExpr);
            }
            case TRAP_KEYWORD: {
                return this.parseTrapExpression(isRhsExpr, allowActions, isInConditionalExpr);
            }
            case OPEN_BRACKET_TOKEN: {
                return this.parseListConstructorExpr();
            }
            case LT_TOKEN: {
                return this.parseTypeCastExpr(isRhsExpr, allowActions, isInConditionalExpr);
            }
            case STREAM_KEYWORD: 
            case TABLE_KEYWORD: 
            case FROM_KEYWORD: {
                return this.parseTableConstructorOrQuery(isRhsExpr);
            }
            case ERROR_KEYWORD: {
                if (this.peek((int)2).kind == SyntaxKind.IDENTIFIER_TOKEN) {
                    return this.parseErrorBindingPattern();
                }
                return this.parseErrorConstructorExpr();
            }
            case LET_KEYWORD: {
                return this.parseLetExpression(isRhsExpr);
            }
            case BACKTICK_TOKEN: {
                return this.parseTemplateExpression();
            }
            case OBJECT_KEYWORD: {
                return this.parseObjectConstructorExpression(annots, qualifiers);
            }
            case XML_KEYWORD: {
                STToken nextNextToken = this.getNextNextToken();
                if (nextNextToken.kind == SyntaxKind.BACKTICK_TOKEN) {
                    return this.parseXMLTemplateExpression();
                }
                return this.parseSimpleTypeDescriptor();
            }
            case STRING_KEYWORD: {
                STToken nextNextToken = this.getNextNextToken();
                if (nextNextToken.kind == SyntaxKind.BACKTICK_TOKEN) {
                    return this.parseStringTemplateExpression();
                }
                return this.parseSimpleTypeDescriptor();
            }
            case FUNCTION_KEYWORD: {
                return this.parseExplicitFunctionExpression(annots, qualifiers, isRhsExpr);
            }
            case NEW_KEYWORD: {
                return this.parseNewExpression();
            }
            case START_KEYWORD: {
                return this.parseStartAction(annots);
            }
            case FLUSH_KEYWORD: {
                return this.parseFlushAction();
            }
            case LEFT_ARROW_TOKEN: {
                return this.parseReceiveAction();
            }
            case WAIT_KEYWORD: {
                return this.parseWaitAction();
            }
            case COMMIT_KEYWORD: {
                return this.parseCommitAction();
            }
            case TRANSACTIONAL_KEYWORD: {
                return this.parseTransactionalExpression();
            }
            case SERVICE_KEYWORD: {
                return this.parseServiceConstructorExpression(annots);
            }
            case BASE16_KEYWORD: 
            case BASE64_KEYWORD: {
                return this.parseByteArrayLiteral();
            }
        }
        if (BallerinaParser.isSimpleType(nextToken.kind)) {
            return this.parseSimpleTypeDescriptor();
        }
        this.recover(this.peek(), ParserRuleContext.TERMINAL_EXPRESSION, annots, qualifiers, isRhsExpr, allowActions, isInConditionalExpr);
        return this.parseTerminalExpression(annots, qualifiers, isRhsExpr, allowActions, isInConditionalExpr);
    }

    private void validateExprAnnotsAndQualifiers(STToken nextToken, STNode annots, List<STNode> qualifiers) {
        switch (nextToken.kind) {
            case SERVICE_KEYWORD: 
            case START_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                break;
            }
            case AT_TOKEN: 
            case FUNCTION_KEYWORD: 
            case OBJECT_KEYWORD: {
                break;
            }
            default: {
                if (!this.isValidExprStart(nextToken.kind)) break;
                this.reportInvalidExpressionAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
            }
        }
    }

    private boolean isValidExprStart(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case AT_TOKEN: 
            case FUNCTION_KEYWORD: 
            case SERVICE_KEYWORD: 
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: 
            case CLIENT_KEYWORD: 
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACKET_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: 
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case OBJECT_KEYWORD: 
            case OPEN_PAREN_TOKEN: 
            case XML_KEYWORD: 
            case STREAM_KEYWORD: 
            case TABLE_KEYWORD: 
            case BACKTICK_TOKEN: 
            case PLUS_TOKEN: 
            case MINUS_TOKEN: 
            case LT_TOKEN: 
            case START_KEYWORD: 
            case CHECK_KEYWORD: 
            case CHECKPANIC_KEYWORD: 
            case TRAP_KEYWORD: 
            case FLUSH_KEYWORD: 
            case LEFT_ARROW_TOKEN: 
            case WAIT_KEYWORD: 
            case FROM_KEYWORD: 
            case COMMIT_KEYWORD: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: 
            case STRING_KEYWORD: 
            case TYPEOF_KEYWORD: 
            case NEGATION_TOKEN: 
            case EXCLAMATION_MARK_TOKEN: 
            case LET_KEYWORD: 
            case NEW_KEYWORD: 
            case BASE16_KEYWORD: 
            case BASE64_KEYWORD: {
                return true;
            }
        }
        return BallerinaParser.isSimpleType(tokenKind);
    }

    private STNode parseNewExpression() {
        STNode newKeyword = this.parseNewKeyword();
        return this.parseNewKeywordRhs(newKeyword);
    }

    private STNode parseNewKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.NEW_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.NEW_KEYWORD, new Object[0]);
        return this.parseNewKeyword();
    }

    private STNode parseNewKeywordRhs(STNode newKeyword) {
        STToken token = this.peek();
        return this.parseNewKeywordRhs(token.kind, newKeyword);
    }

    private STNode parseNewKeywordRhs(SyntaxKind kind, STNode newKeyword) {
        switch (kind) {
            case OPEN_PAREN_TOKEN: {
                return this.parseImplicitNewRhs(newKeyword);
            }
            case SEMICOLON_TOKEN: {
                break;
            }
            case IDENTIFIER_TOKEN: 
            case OBJECT_KEYWORD: 
            case STREAM_KEYWORD: {
                return this.parseTypeDescriptorInNewExpr(newKeyword);
            }
        }
        return STNodeFactory.createImplicitNewExpressionNode(newKeyword, STNodeFactory.createEmptyNode());
    }

    private STNode parseTypeDescriptorInNewExpr(STNode newKeyword) {
        STNode typeDescriptor = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_NEW_EXPR);
        STNode parenthesizedArgsList = this.parseParenthesizedArgList();
        return STNodeFactory.createExplicitNewExpressionNode(newKeyword, typeDescriptor, parenthesizedArgsList);
    }

    private STNode parseImplicitNewRhs(STNode newKeyword) {
        STNode implicitNewArgList = this.parseParenthesizedArgList();
        return STNodeFactory.createImplicitNewExpressionNode(newKeyword, implicitNewArgList);
    }

    private STNode parseParenthesizedArgList() {
        STNode openParan = this.parseOpenParenthesis(ParserRuleContext.ARG_LIST_START);
        STNode arguments = this.parseArgsList();
        STNode closeParan = this.parseCloseParenthesis();
        return STNodeFactory.createParenthesizedArgList(openParan, arguments, closeParan);
    }

    private STNode parseExpressionRhs(OperatorPrecedence precedenceLevel, STNode lhsExpr, boolean isRhsExpr, boolean allowActions) {
        return this.parseExpressionRhs(precedenceLevel, lhsExpr, isRhsExpr, allowActions, false, false);
    }

    private STNode parseExpressionRhs(OperatorPrecedence currentPrecedenceLevel, STNode lhsExpr, boolean isRhsExpr, boolean allowActions, boolean isInMatchGuard, boolean isInConditionalExpr) {
        STNode actionOrExpression = this.parseExpressionRhsInternal(currentPrecedenceLevel, lhsExpr, isRhsExpr, allowActions, isInMatchGuard, isInConditionalExpr);
        if (!allowActions && this.isAction(actionOrExpression) && actionOrExpression.kind != SyntaxKind.BRACED_ACTION) {
            actionOrExpression = this.attachErrorExpectedActionFoundDiagnostic(actionOrExpression);
        }
        return actionOrExpression;
    }

    private STNode parseExpressionRhsInternal(OperatorPrecedence currentPrecedenceLevel, STNode lhsExpr, boolean isRhsExpr, boolean allowActions, boolean isInMatchGuard, boolean isInConditionalExpr) {
        STNode newLhsExpr;
        OperatorPrecedence nextOperatorPrecedence;
        SyntaxKind nextTokenKind = this.peek().kind;
        if (this.isEndOfExpression(nextTokenKind, isRhsExpr, isInMatchGuard, lhsExpr.kind)) {
            return lhsExpr;
        }
        if (lhsExpr.kind == SyntaxKind.ASYNC_SEND_ACTION) {
            return lhsExpr;
        }
        if (!this.isValidExprRhsStart(nextTokenKind, lhsExpr.kind)) {
            return this.recoverExpressionRhs(currentPrecedenceLevel, lhsExpr, isRhsExpr, allowActions, isInMatchGuard, isInConditionalExpr);
        }
        if (nextTokenKind == SyntaxKind.GT_TOKEN && this.peek((int)2).kind == SyntaxKind.GT_TOKEN) {
            nextTokenKind = this.peek((int)3).kind == SyntaxKind.GT_TOKEN ? SyntaxKind.TRIPPLE_GT_TOKEN : SyntaxKind.DOUBLE_GT_TOKEN;
        }
        if (currentPrecedenceLevel.isHigherThanOrEqual(nextOperatorPrecedence = this.getOpPrecedence(nextTokenKind), allowActions)) {
            return lhsExpr;
        }
        switch (nextTokenKind) {
            case OPEN_PAREN_TOKEN: {
                newLhsExpr = this.parseFuncCall(lhsExpr);
                break;
            }
            case OPEN_BRACKET_TOKEN: {
                newLhsExpr = this.parseMemberAccessExpr(lhsExpr, isRhsExpr);
                break;
            }
            case DOT_TOKEN: {
                newLhsExpr = this.parseFieldAccessOrMethodCall(lhsExpr, isInConditionalExpr);
                break;
            }
            case IS_KEYWORD: {
                newLhsExpr = this.parseTypeTestExpression(lhsExpr, isInConditionalExpr);
                break;
            }
            case RIGHT_ARROW_TOKEN: {
                newLhsExpr = this.parseRemoteMethodCallOrAsyncSendAction(lhsExpr, isRhsExpr);
                break;
            }
            case SYNC_SEND_TOKEN: {
                newLhsExpr = this.parseSyncSendAction(lhsExpr);
                break;
            }
            case RIGHT_DOUBLE_ARROW_TOKEN: {
                newLhsExpr = this.parseImplicitAnonFunc(lhsExpr, isRhsExpr);
                break;
            }
            case ANNOT_CHAINING_TOKEN: {
                newLhsExpr = this.parseAnnotAccessExpression(lhsExpr, isInConditionalExpr);
                break;
            }
            case OPTIONAL_CHAINING_TOKEN: {
                newLhsExpr = this.parseOptionalFieldAccessExpression(lhsExpr, isInConditionalExpr);
                break;
            }
            case QUESTION_MARK_TOKEN: {
                newLhsExpr = this.parseConditionalExpression(lhsExpr);
                break;
            }
            case DOT_LT_TOKEN: {
                newLhsExpr = this.parseXMLFilterExpression(lhsExpr);
                break;
            }
            case SLASH_LT_TOKEN: 
            case DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN: 
            case SLASH_ASTERISK_TOKEN: {
                newLhsExpr = this.parseXMLStepExpression(lhsExpr);
                break;
            }
            default: {
                SyntaxKind expectedNodeType;
                if (nextTokenKind == SyntaxKind.SLASH_TOKEN && this.peek((int)2).kind == SyntaxKind.LT_TOKEN && (expectedNodeType = this.getExpectedNodeKind(3, isRhsExpr, isInMatchGuard, lhsExpr.kind)) == SyntaxKind.XML_STEP_EXPRESSION) {
                    newLhsExpr = this.createXMLStepExpression(lhsExpr);
                    break;
                }
                STNode operator = nextTokenKind == SyntaxKind.DOUBLE_GT_TOKEN ? this.parseSignedRightShiftToken() : (nextTokenKind == SyntaxKind.TRIPPLE_GT_TOKEN ? this.parseUnsignedRightShiftToken() : this.parseBinaryOperator());
                if (this.isAction(lhsExpr) && lhsExpr.kind != SyntaxKind.BRACED_ACTION) {
                    lhsExpr = this.attachErrorExpectedActionFoundDiagnostic(lhsExpr);
                }
                STNode rhsExpr = this.parseExpression(nextOperatorPrecedence, isRhsExpr, false, isInConditionalExpr);
                newLhsExpr = STNodeFactory.createBinaryExpressionNode(SyntaxKind.BINARY_EXPRESSION, lhsExpr, operator, rhsExpr);
            }
        }
        return this.parseExpressionRhsInternal(currentPrecedenceLevel, newLhsExpr, isRhsExpr, allowActions, isInMatchGuard, isInConditionalExpr);
    }

    private STNode recoverExpressionRhs(OperatorPrecedence currentPrecedenceLevel, STNode lhsExpr, boolean isRhsExpr, boolean allowActions, boolean isInMatchGuard, boolean isInConditionalExpr) {
        STToken token = this.peek();
        AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.EXPRESSION_RHS, new Object[]{currentPrecedenceLevel, lhsExpr, isRhsExpr, allowActions, isInMatchGuard, isInConditionalExpr});
        if (solution.action == AbstractParserErrorHandler.Action.REMOVE) {
            return this.parseExpressionRhs(currentPrecedenceLevel, lhsExpr, isRhsExpr, allowActions, isInMatchGuard, isInConditionalExpr);
        }
        if (solution.ctx == ParserRuleContext.BINARY_OPERATOR) {
            SyntaxKind binaryOpKind = this.getBinaryOperatorKindToInsert(currentPrecedenceLevel);
            ParserRuleContext binaryOpContext = this.getMissingBinaryOperatorContext(currentPrecedenceLevel);
            this.insertToken(binaryOpKind, binaryOpContext);
            return this.parseExpressionRhsInternal(currentPrecedenceLevel, lhsExpr, isRhsExpr, allowActions, isInMatchGuard, isInConditionalExpr);
        }
        return this.parseExpressionRhsInternal(currentPrecedenceLevel, lhsExpr, isRhsExpr, allowActions, isInMatchGuard, isInConditionalExpr);
    }

    private STNode createXMLStepExpression(STNode lhsExpr) {
        STNode slashLT;
        STNode slashToken = this.parseSlashToken();
        STNode ltToken = this.parseLTToken();
        if (this.hasTrailingMinutiae(slashToken) || this.hasLeadingMinutiae(ltToken)) {
            ArrayList<STNodeDiagnostic> diagnostics = new ArrayList<STNodeDiagnostic>();
            diagnostics.add(SyntaxErrors.createDiagnostic(DiagnosticErrorCode.ERROR_INVALID_WHITESPACE_IN_SLASH_LT_TOKEN, new Object[0]));
            slashLT = STNodeFactory.createMissingToken(SyntaxKind.SLASH_LT_TOKEN, diagnostics);
            slashLT = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(slashLT, slashToken);
            slashLT = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(slashLT, ltToken);
        } else {
            slashLT = STNodeFactory.createToken(SyntaxKind.SLASH_LT_TOKEN, slashToken.leadingMinutiae(), ltToken.trailingMinutiae());
        }
        STNode namePattern = this.parseXMLNamePatternChain(slashLT);
        STNode newLhsExpr = STNodeFactory.createXMLStepExpressionNode(lhsExpr, namePattern);
        return newLhsExpr;
    }

    private SyntaxKind getExpectedNodeKind(int lookahead, boolean isRhsExpr, boolean isInMatchGuard, SyntaxKind precedingNodeKind) {
        STToken nextToken = this.peek(lookahead);
        block0 : switch (nextToken.kind) {
            case ASTERISK_TOKEN: {
                return SyntaxKind.XML_STEP_EXPRESSION;
            }
            case GT_TOKEN: {
                break;
            }
            case PIPE_TOKEN: {
                return this.getExpectedNodeKind(++lookahead, isRhsExpr, isInMatchGuard, precedingNodeKind);
            }
            case IDENTIFIER_TOKEN: {
                nextToken = this.peek(++lookahead);
                switch (nextToken.kind) {
                    case GT_TOKEN: {
                        break block0;
                    }
                    case PIPE_TOKEN: {
                        return this.getExpectedNodeKind(++lookahead, isRhsExpr, isInMatchGuard, precedingNodeKind);
                    }
                    case COLON_TOKEN: {
                        nextToken = this.peek(++lookahead);
                        switch (nextToken.kind) {
                            case ASTERISK_TOKEN: 
                            case GT_TOKEN: {
                                return SyntaxKind.XML_STEP_EXPRESSION;
                            }
                            case IDENTIFIER_TOKEN: {
                                nextToken = this.peek(++lookahead);
                                if (nextToken.kind != SyntaxKind.PIPE_TOKEN) break block0;
                                return this.getExpectedNodeKind(++lookahead, isRhsExpr, isInMatchGuard, precedingNodeKind);
                            }
                            default: {
                                return SyntaxKind.TYPE_CAST_EXPRESSION;
                            }
                        }
                    }
                    default: {
                        return SyntaxKind.TYPE_CAST_EXPRESSION;
                    }
                }
            }
            default: {
                return SyntaxKind.TYPE_CAST_EXPRESSION;
            }
        }
        nextToken = this.peek(++lookahead);
        switch (nextToken.kind) {
            case OPEN_BRACKET_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case PLUS_TOKEN: 
            case MINUS_TOKEN: 
            case FROM_KEYWORD: 
            case LET_KEYWORD: {
                return SyntaxKind.XML_STEP_EXPRESSION;
            }
        }
        if (!this.isValidExpressionStart(nextToken.kind, lookahead)) {
            return SyntaxKind.XML_STEP_EXPRESSION;
        }
        return SyntaxKind.TYPE_CAST_EXPRESSION;
    }

    private boolean hasTrailingMinutiae(STNode node) {
        return node.widthWithTrailingMinutiae() > node.width();
    }

    private boolean hasLeadingMinutiae(STNode node) {
        return node.widthWithLeadingMinutiae() > node.width();
    }

    private boolean isValidExprRhsStart(SyntaxKind tokenKind, SyntaxKind precedingNodeKind) {
        switch (tokenKind) {
            case OPEN_PAREN_TOKEN: {
                return precedingNodeKind == SyntaxKind.QUALIFIED_NAME_REFERENCE || precedingNodeKind == SyntaxKind.SIMPLE_NAME_REFERENCE;
            }
            case OPEN_BRACKET_TOKEN: 
            case QUESTION_MARK_TOKEN: 
            case COLON_TOKEN: 
            case DOT_TOKEN: 
            case RIGHT_DOUBLE_ARROW_TOKEN: 
            case IS_KEYWORD: 
            case ANNOT_CHAINING_TOKEN: 
            case OPTIONAL_CHAINING_TOKEN: 
            case DOT_LT_TOKEN: 
            case SLASH_LT_TOKEN: 
            case DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN: 
            case SLASH_ASTERISK_TOKEN: 
            case RIGHT_ARROW_TOKEN: 
            case SYNC_SEND_TOKEN: {
                return true;
            }
        }
        return this.isBinaryOperator(tokenKind);
    }

    private STNode parseMemberAccessExpr(STNode lhsExpr, boolean isRhsExpr) {
        this.startContext(ParserRuleContext.MEMBER_ACCESS_KEY_EXPR);
        STNode openBracket = this.parseOpenBracket();
        STNode keyExpr = this.parseMemberAccessKeyExprs(isRhsExpr);
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        if (isRhsExpr && ((STNodeList)keyExpr).isEmpty()) {
            STNode missingVarRef = STNodeFactory.createSimpleNameReferenceNode(SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN));
            keyExpr = STNodeFactory.createNodeList(missingVarRef);
            closeBracket = SyntaxErrors.addDiagnostic(closeBracket, DiagnosticErrorCode.ERROR_MISSING_KEY_EXPR_IN_MEMBER_ACCESS_EXPR, new Object[0]);
        }
        return STNodeFactory.createIndexedExpressionNode(lhsExpr, openBracket, keyExpr, closeBracket);
    }

    private STNode parseMemberAccessKeyExprs(boolean isRhsExpr) {
        ArrayList<STNode> exprList = new ArrayList<STNode>();
        while (!this.isEndOfTypeList(this.peek().kind)) {
            STNode keyExpr = this.parseKeyExpr(isRhsExpr);
            exprList.add(keyExpr);
            STNode keyExprEnd = this.parseMemberAccessKeyExprEnd();
            if (keyExprEnd == null) break;
            exprList.add(keyExprEnd);
        }
        return STNodeFactory.createNodeList(exprList);
    }

    private STNode parseKeyExpr(boolean isRhsExpr) {
        if (!isRhsExpr && this.peek().kind == SyntaxKind.ASTERISK_TOKEN) {
            return STNodeFactory.createBasicLiteralNode(SyntaxKind.ASTERISK_LITERAL, this.consume());
        }
        return this.parseExpression(isRhsExpr);
    }

    private STNode parseMemberAccessKeyExprEnd() {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case CLOSE_BRACKET_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.MEMBER_ACCESS_KEY_EXPR_END, new Object[0]);
        return this.parseMemberAccessKeyExprEnd();
    }

    private STNode parseCloseBracket() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CLOSE_BRACKET_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CLOSE_BRACKET, new Object[0]);
        return this.parseCloseBracket();
    }

    private STNode parseFieldAccessOrMethodCall(STNode lhsExpr, boolean isInConditionalExpr) {
        STNode dotToken = this.parseDotToken();
        STToken token = this.peek();
        if (token.kind == SyntaxKind.MAP_KEYWORD || token.kind == SyntaxKind.START_KEYWORD) {
            STNode methodName = this.getKeywordAsSimpleNameRef();
            STNode openParen = this.parseOpenParenthesis(ParserRuleContext.ARG_LIST_START);
            STNode args = this.parseArgsList();
            STNode closeParen = this.parseCloseParenthesis();
            return STNodeFactory.createMethodCallExpressionNode(lhsExpr, dotToken, methodName, openParen, args, closeParen);
        }
        STNode fieldOrMethodName = this.parseFieldAccessIdentifier(isInConditionalExpr);
        if (fieldOrMethodName.kind == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return STNodeFactory.createFieldAccessExpressionNode(lhsExpr, dotToken, fieldOrMethodName);
        }
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.OPEN_PAREN_TOKEN) {
            STNode openParen = this.parseOpenParenthesis(ParserRuleContext.ARG_LIST_START);
            STNode args = this.parseArgsList();
            STNode closeParen = this.parseCloseParenthesis();
            return STNodeFactory.createMethodCallExpressionNode(lhsExpr, dotToken, fieldOrMethodName, openParen, args, closeParen);
        }
        return STNodeFactory.createFieldAccessExpressionNode(lhsExpr, dotToken, fieldOrMethodName);
    }

    private STNode getKeywordAsSimpleNameRef() {
        STToken mapKeyword = this.consume();
        STNode methodName = STNodeFactory.createIdentifierToken(mapKeyword.text(), mapKeyword.leadingMinutiae(), mapKeyword.trailingMinutiae(), mapKeyword.diagnostics());
        methodName = STNodeFactory.createSimpleNameReferenceNode(methodName);
        return methodName;
    }

    private STNode parseBracedExpression(boolean isRhsExpr, boolean allowActions) {
        STNode openParen = this.parseOpenParenthesis(ParserRuleContext.OPEN_PARENTHESIS);
        if (this.peek().kind == SyntaxKind.CLOSE_PAREN_TOKEN) {
            return this.parseNilLiteralOrEmptyAnonFuncParamRhs(openParen);
        }
        this.startContext(ParserRuleContext.BRACED_EXPR_OR_ANON_FUNC_PARAMS);
        STNode expr = allowActions ? this.parseExpression(DEFAULT_OP_PRECEDENCE, isRhsExpr, true) : this.parseExpression(isRhsExpr);
        return this.parseBracedExprOrAnonFuncParamRhs(openParen, expr, isRhsExpr);
    }

    private STNode parseNilLiteralOrEmptyAnonFuncParamRhs(STNode openParen) {
        STNode closeParen = this.parseCloseParenthesis();
        STToken nextToken = this.peek();
        if (nextToken.kind != SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN) {
            return STNodeFactory.createNilLiteralNode(openParen, closeParen);
        }
        STNode params = STNodeFactory.createEmptyNodeList();
        STNode anonFuncParam = STNodeFactory.createImplicitAnonymousFunctionParameters(openParen, params, closeParen);
        return anonFuncParam;
    }

    private STNode parseBracedExprOrAnonFuncParamRhs(STNode openParen, STNode expr, boolean isRhsExpr) {
        STToken nextToken = this.peek();
        if (expr.kind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            switch (nextToken.kind) {
                case CLOSE_PAREN_TOKEN: {
                    break;
                }
                case COMMA_TOKEN: {
                    return this.parseImplicitAnonFunc(openParen, expr, isRhsExpr);
                }
                default: {
                    this.recover(nextToken, ParserRuleContext.BRACED_EXPR_OR_ANON_FUNC_PARAM_RHS, openParen, expr, isRhsExpr);
                    return this.parseBracedExprOrAnonFuncParamRhs(openParen, expr, isRhsExpr);
                }
            }
        }
        STNode closeParen = this.parseCloseParenthesis();
        this.endContext();
        if (this.isAction(expr)) {
            return STNodeFactory.createBracedExpressionNode(SyntaxKind.BRACED_ACTION, openParen, expr, closeParen);
        }
        return STNodeFactory.createBracedExpressionNode(SyntaxKind.BRACED_EXPRESSION, openParen, expr, closeParen);
    }

    private boolean isAction(STNode node) {
        switch (node.kind) {
            case REMOTE_METHOD_CALL_ACTION: 
            case BRACED_ACTION: 
            case CHECK_ACTION: 
            case START_ACTION: 
            case TRAP_ACTION: 
            case FLUSH_ACTION: 
            case ASYNC_SEND_ACTION: 
            case SYNC_SEND_ACTION: 
            case RECEIVE_ACTION: 
            case WAIT_ACTION: 
            case QUERY_ACTION: 
            case COMMIT_ACTION: {
                return true;
            }
        }
        return false;
    }

    private boolean isEndOfExpression(SyntaxKind tokenKind, boolean isRhsExpr, boolean isInMatchGuard, SyntaxKind precedingNodeKind) {
        if (!isRhsExpr) {
            if (this.isCompoundBinaryOperator(tokenKind)) {
                return true;
            }
            if (isInMatchGuard && tokenKind == SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN) {
                return true;
            }
            return !this.isValidExprRhsStart(tokenKind, precedingNodeKind);
        }
        switch (tokenKind) {
            case EOF_TOKEN: 
            case DOCUMENTATION_STRING: 
            case AT_TOKEN: 
            case PUBLIC_KEYWORD: 
            case LISTENER_KEYWORD: 
            case CONST_KEYWORD: 
            case EQUAL_TOKEN: 
            case SEMICOLON_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case COLON_TOKEN: 
            case AS_KEYWORD: 
            case RESOURCE_KEYWORD: 
            case COMMA_TOKEN: 
            case CLOSE_PAREN_TOKEN: 
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACKET_TOKEN: 
            case DO_KEYWORD: 
            case FROM_KEYWORD: 
            case LET_KEYWORD: 
            case IN_KEYWORD: 
            case WHERE_KEYWORD: 
            case SELECT_KEYWORD: 
            case ON_KEYWORD: 
            case CONFLICT_KEYWORD: 
            case LIMIT_KEYWORD: 
            case JOIN_KEYWORD: 
            case OUTER_KEYWORD: 
            case ORDER_KEYWORD: 
            case BY_KEYWORD: 
            case ASCENDING_KEYWORD: 
            case DESCENDING_KEYWORD: 
            case EQUALS_KEYWORD: {
                return true;
            }
            case RIGHT_DOUBLE_ARROW_TOKEN: {
                return isInMatchGuard;
            }
        }
        return BallerinaParser.isSimpleType(tokenKind);
    }

    private STNode parseBasicLiteral() {
        STToken literalToken = this.consume();
        return this.parseBasicLiteral(literalToken);
    }

    private STNode parseBasicLiteral(STNode literalToken) {
        SyntaxKind nodeKind;
        switch (literalToken.kind) {
            case NULL_KEYWORD: {
                nodeKind = SyntaxKind.NULL_LITERAL;
                break;
            }
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: {
                nodeKind = SyntaxKind.BOOLEAN_LITERAL;
                break;
            }
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                nodeKind = SyntaxKind.NUMERIC_LITERAL;
                break;
            }
            case STRING_LITERAL_TOKEN: {
                nodeKind = SyntaxKind.STRING_LITERAL;
                break;
            }
            case ASTERISK_TOKEN: {
                nodeKind = SyntaxKind.ASTERISK_LITERAL;
                break;
            }
            default: {
                nodeKind = literalToken.kind;
            }
        }
        return STNodeFactory.createBasicLiteralNode(nodeKind, literalToken);
    }

    private STNode parseFuncCall(STNode identifier) {
        STNode openParen = this.parseOpenParenthesis(ParserRuleContext.ARG_LIST_START);
        STNode args = this.parseArgsList();
        STNode closeParen = this.parseCloseParenthesis();
        return STNodeFactory.createFunctionCallExpressionNode(identifier, openParen, args, closeParen);
    }

    private STNode parseErrorConstructorExpr() {
        STNode errorKeyword = this.parseErrorKeyword();
        errorKeyword = this.createBuiltinSimpleNameReference(errorKeyword);
        return this.parseFuncCall(errorKeyword);
    }

    private STNode parseArgsList() {
        this.startContext(ParserRuleContext.ARG_LIST);
        STToken token = this.peek();
        if (this.isEndOfParametersList(token.kind)) {
            STNode args = STNodeFactory.createEmptyNodeList();
            this.endContext();
            return args;
        }
        STNode firstArg = this.parseArgument();
        STNode argsList = this.parseArgList(firstArg);
        this.endContext();
        return argsList;
    }

    private STNode parseArgList(STNode firstArg) {
        STNode argEnd;
        ArrayList<STNode> argsList = new ArrayList<STNode>();
        argsList.add(firstArg);
        SyntaxKind lastValidArgKind = firstArg.kind;
        STToken nextToken = this.peek();
        while (!this.isEndOfParametersList(nextToken.kind) && (argEnd = this.parseArgEnd()) != null) {
            STNode curArg = this.parseArgument();
            DiagnosticErrorCode errorCode = this.validateArgumentOrder(lastValidArgKind, curArg.kind);
            if (errorCode == null) {
                argsList.add(argEnd);
                argsList.add(curArg);
                lastValidArgKind = curArg.kind;
            } else if (errorCode == DiagnosticErrorCode.ERROR_NAMED_ARG_FOLLOWED_BY_POSITIONAL_ARG && this.isMissingPositionalArg(curArg)) {
                argsList.add(argEnd);
                argsList.add(curArg);
            } else {
                this.updateLastNodeInListWithInvalidNode(argsList, argEnd, null, new Object[0]);
                this.updateLastNodeInListWithInvalidNode(argsList, curArg, errorCode, new Object[0]);
            }
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(argsList);
    }

    private DiagnosticErrorCode validateArgumentOrder(SyntaxKind prevArgKind, SyntaxKind curArgKind) {
        DiagnosticErrorCode errorCode = null;
        switch (prevArgKind) {
            case POSITIONAL_ARG: {
                break;
            }
            case NAMED_ARG: {
                if (curArgKind != SyntaxKind.POSITIONAL_ARG) break;
                errorCode = DiagnosticErrorCode.ERROR_NAMED_ARG_FOLLOWED_BY_POSITIONAL_ARG;
                break;
            }
            case REST_ARG: {
                errorCode = DiagnosticErrorCode.ERROR_REST_ARG_FOLLOWED_BY_ANOTHER_ARG;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid SyntaxKind in an argument");
            }
        }
        return errorCode;
    }

    private boolean isMissingPositionalArg(STNode arg) {
        STNode expr = ((STPositionalArgumentNode)arg).expression;
        return expr.kind == SyntaxKind.SIMPLE_NAME_REFERENCE && ((STSimpleNameReferenceNode)expr).name.isMissing();
    }

    private STNode parseArgEnd() {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case CLOSE_PAREN_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.ARG_END, new Object[0]);
        return this.parseArgEnd();
    }

    private STNode parseArgument() {
        STNode arg;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case ELLIPSIS_TOKEN: {
                STToken ellipsis = this.consume();
                STNode expr = this.parseExpression();
                arg = STNodeFactory.createRestArgumentNode(ellipsis, expr);
                break;
            }
            case IDENTIFIER_TOKEN: {
                arg = this.parseNamedOrPositionalArg();
                break;
            }
            default: {
                if (this.isValidExprStart(nextToken.kind)) {
                    STNode expr = this.parseExpression();
                    arg = STNodeFactory.createPositionalArgumentNode(expr);
                    break;
                }
                this.recover(this.peek(), ParserRuleContext.ARG_START, new Object[0]);
                return this.parseArgument();
            }
        }
        return arg;
    }

    private STNode parseNamedOrPositionalArg() {
        STNode argNameOrExpr = this.parseTerminalExpression(true, false, false);
        STToken secondToken = this.peek();
        switch (secondToken.kind) {
            case EQUAL_TOKEN: {
                STNode equal = this.parseAssignOp();
                STNode valExpr = this.parseExpression();
                return STNodeFactory.createNamedArgumentNode(argNameOrExpr, equal, valExpr);
            }
            case COMMA_TOKEN: 
            case CLOSE_PAREN_TOKEN: {
                return STNodeFactory.createPositionalArgumentNode(argNameOrExpr);
            }
        }
        argNameOrExpr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, argNameOrExpr, true, false);
        return STNodeFactory.createPositionalArgumentNode(argNameOrExpr);
    }

    private STNode parseObjectTypeDescriptor(List<STNode> qualifiers) {
        this.startContext(ParserRuleContext.OBJECT_TYPE_DESCRIPTOR);
        STNode objectTypeQualifiers = this.createObjectTypeQualNodeList(qualifiers);
        STNode objectKeyword = this.parseObjectKeyword();
        STNode openBrace = this.parseOpenBrace();
        STNode objectMemberDescriptors = this.parseObjectMembers(ParserRuleContext.OBJECT_MEMBER_DESCRIPTOR);
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createObjectTypeDescriptorNode(objectTypeQualifiers, objectKeyword, openBrace, objectMemberDescriptors, closeBrace);
    }

    private STNode parseObjectConstructorExpression(STNode annots, List<STNode> qualifiers) {
        this.startContext(ParserRuleContext.OBJECT_CONSTRUCTOR);
        STNode objectTypeQualifier = this.createObjectTypeQualNodeList(qualifiers);
        STNode objectKeyword = this.parseObjectKeyword();
        STNode typeReference = this.parseObjectConstructorTypeReference();
        STNode openBrace = this.parseOpenBrace();
        STNode objectMembers = this.parseObjectMembers(ParserRuleContext.OBJECT_MEMBER);
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createObjectConstructorExpressionNode(annots, objectTypeQualifier, objectKeyword, typeReference, openBrace, objectMembers, closeBrace);
    }

    private STNode parseObjectConstructorTypeReference() {
        STNode typeReference;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: {
                typeReference = this.parseTypeReference();
                break;
            }
            case OPEN_BRACE_TOKEN: {
                return STNodeFactory.createEmptyNode();
            }
            default: {
                this.recover(nextToken, ParserRuleContext.OBJECT_CONSTRUCTOR_TYPE_REF, new Object[0]);
                return this.parseObjectConstructorTypeReference();
            }
        }
        return typeReference;
    }

    private STNode parseObjectKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OBJECT_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.OBJECT_KEYWORD, new Object[0]);
        return this.parseObjectKeyword();
    }

    private STNode parseObjectMembers(ParserRuleContext context) {
        ArrayList<STNode> objectMembers = new ArrayList<STNode>();
        while (!this.isEndOfObjectTypeNode()) {
            this.startContext(context);
            STNode member = this.parseObjectMember(context);
            this.endContext();
            if (member == null) break;
            if (context == ParserRuleContext.OBJECT_MEMBER && member.kind == SyntaxKind.TYPE_REFERENCE) {
                this.addInvalidNodeToNextToken(member, DiagnosticErrorCode.ERROR_TYPE_INCLUSION_IN_OBJECT_CONSTRUCTOR, new Object[0]);
                continue;
            }
            objectMembers.add(member);
        }
        return STNodeFactory.createNodeList(objectMembers);
    }

    private STNode parseObjectMember(ParserRuleContext context) {
        STNode metadata;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EOF_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                return null;
            }
            case FINAL_KEYWORD: 
            case PUBLIC_KEYWORD: 
            case FUNCTION_KEYWORD: 
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: 
            case REMOTE_KEYWORD: 
            case RESOURCE_KEYWORD: 
            case PRIVATE_KEYWORD: 
            case ASTERISK_TOKEN: {
                metadata = STNodeFactory.createEmptyNode();
                break;
            }
            case DOCUMENTATION_STRING: 
            case AT_TOKEN: {
                metadata = this.parseMetaData();
                break;
            }
            default: {
                if (this.isTypeStartingToken(nextToken.kind)) {
                    metadata = STNodeFactory.createEmptyNode();
                    break;
                }
                ParserRuleContext recoveryCtx = context == ParserRuleContext.OBJECT_MEMBER ? ParserRuleContext.OBJECT_MEMBER_START : ParserRuleContext.CLASS_MEMBER_START;
                this.recover(this.peek(), recoveryCtx, new Object[0]);
                return this.parseObjectMember(context);
            }
        }
        return this.parseObjectMemberWithoutMeta(metadata, context);
    }

    private STNode parseObjectMemberWithoutMeta(STNode metadata, ParserRuleContext context) {
        boolean isObjectTypeDesc = context == ParserRuleContext.OBJECT_MEMBER_DESCRIPTOR;
        ParserRuleContext recoveryCtx = context == ParserRuleContext.OBJECT_MEMBER ? ParserRuleContext.OBJECT_MEMBER_WITHOUT_METADATA : ParserRuleContext.CLASS_MEMBER_WITHOUT_METADATA;
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        return this.parseObjectMemberWithoutMeta(metadata, typeDescQualifiers, recoveryCtx, isObjectTypeDesc);
    }

    private STNode parseObjectMemberWithoutMeta(STNode metadata, List<STNode> qualifiers, ParserRuleContext recoveryCtx, boolean isObjectTypeDesc) {
        STNode member;
        this.parseObjectMemberQualifiers(qualifiers);
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EOF_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                this.reportInvalidMetaData(metadata);
                this.reportInvalidQualifierList(qualifiers);
                return null;
            }
            case PUBLIC_KEYWORD: 
            case PRIVATE_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                STNode visibilityQualifier = this.consume();
                if (isObjectTypeDesc && visibilityQualifier.kind == SyntaxKind.PRIVATE_KEYWORD) {
                    this.addInvalidNodeToNextToken(visibilityQualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STNode)visibilityQualifier).toString().trim());
                    visibilityQualifier = STNodeFactory.createEmptyNode();
                }
                member = this.parseObjectMethodOrField(metadata, visibilityQualifier, isObjectTypeDesc);
                break;
            }
            case FUNCTION_KEYWORD: {
                STNode visibilityQualifier = STNodeFactory.createEmptyNode();
                member = this.parseObjectMethodOrFuncTypeDesc(metadata, visibilityQualifier, qualifiers, isObjectTypeDesc);
                break;
            }
            case ASTERISK_TOKEN: {
                this.reportInvalidMetaData(metadata);
                this.reportInvalidQualifierList(qualifiers);
                STToken asterisk = this.consume();
                STNode type = this.parseTypeReference();
                STNode semicolonToken = this.parseSemicolon();
                member = STNodeFactory.createTypeReferenceNode(asterisk, type, semicolonToken);
                break;
            }
            default: {
                if (nextToken.kind == SyntaxKind.FINAL_KEYWORD || this.isTypeStartingToken(nextToken.kind)) {
                    member = this.parseObjectField(metadata, STNodeFactory.createEmptyNode(), qualifiers, isObjectTypeDesc);
                    break;
                }
                this.recover(this.peek(), recoveryCtx, new Object[]{metadata, qualifiers, recoveryCtx, isObjectTypeDesc});
                return this.parseObjectMemberWithoutMeta(metadata, qualifiers, recoveryCtx, isObjectTypeDesc);
            }
        }
        return member;
    }

    private STNode parseObjectMethodOrField(STNode metadata, STNode visibilityQualifier, boolean isObjectTypeDesc) {
        ArrayList<STNode> objectMemberQualifiers = new ArrayList<STNode>();
        return this.parseObjectMethodOrField(metadata, visibilityQualifier, objectMemberQualifiers, isObjectTypeDesc);
    }

    private STNode parseObjectMethodOrField(STNode metadata, STNode visibilityQualifier, List<STNode> qualifiers, boolean isObjectTypeDesc) {
        this.parseObjectMemberQualifiers(qualifiers);
        STToken nextToken = this.peek(1);
        STToken nextNextToken = this.peek(2);
        switch (nextToken.kind) {
            case FUNCTION_KEYWORD: {
                return this.parseObjectMethodOrFuncTypeDesc(metadata, visibilityQualifier, qualifiers, isObjectTypeDesc);
            }
            case IDENTIFIER_TOKEN: {
                if (nextNextToken.kind == SyntaxKind.OPEN_PAREN_TOKEN) break;
                return this.parseObjectField(metadata, visibilityQualifier, qualifiers, isObjectTypeDesc);
            }
            default: {
                if (nextToken.kind != SyntaxKind.FINAL_KEYWORD && !this.isTypeStartingToken(nextToken.kind)) break;
                return this.parseObjectField(metadata, visibilityQualifier, qualifiers, isObjectTypeDesc);
            }
        }
        this.recover(this.peek(), ParserRuleContext.OBJECT_FUNC_OR_FIELD_WITHOUT_VISIBILITY, metadata, visibilityQualifier, qualifiers, isObjectTypeDesc);
        return this.parseObjectMethodOrField(metadata, visibilityQualifier, qualifiers, isObjectTypeDesc);
    }

    private STNode parseFunctionQualifiers(ParserRuleContext context, List<STNode> qualifierList) {
        STToken nextToken = this.peek();
        while (!this.isEndOfFunctionQualifiers(nextToken.kind)) {
            STToken qualifier;
            switch (nextToken.kind) {
                case TRANSACTIONAL_KEYWORD: 
                case ISOLATED_KEYWORD: 
                case REMOTE_KEYWORD: 
                case RESOURCE_KEYWORD: {
                    qualifier = this.consume();
                    break;
                }
                default: {
                    this.recover(this.peek(), context, new Object[]{context, qualifierList});
                    return this.parseFunctionQualifiers(context, qualifierList);
                }
            }
            DiagnosticCode diagnosticCode = this.validateFunctionQualifier(qualifier, context, qualifierList);
            if (diagnosticCode != null) {
                this.updateLastNodeInListOrAddInvalidNodeToNextToken(qualifierList, qualifier, diagnosticCode, qualifier.text());
            } else {
                qualifierList.add(qualifier);
            }
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(qualifierList);
    }

    private boolean isEndOfFunctionQualifiers(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case EOF_TOKEN: 
            case FUNCTION_KEYWORD: {
                return true;
            }
        }
        return false;
    }

    private DiagnosticCode validateFunctionQualifier(STNode currentQualifier, ParserRuleContext context, List<STNode> qualifierList) {
        switch (currentQualifier.kind) {
            case REMOTE_KEYWORD: {
                if (context == ParserRuleContext.OBJECT_METHOD_START) break;
                return DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED;
            }
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: {
                break;
            }
            default: {
                if (context == ParserRuleContext.RESOURCE_DEF_QUALIFIERS) break;
                return DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED;
            }
        }
        if (this.isSyntaxKindInList(qualifierList, currentQualifier.kind)) {
            return DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER;
        }
        return null;
    }

    private STNode parseObjectField(STNode metadata, STNode visibilityQualifier, List<STNode> qualifiers, boolean isObjectTypeDesc) {
        STToken nextToken = this.peek();
        STNode finalQualifier = STNodeFactory.createEmptyNode();
        if (nextToken.kind == SyntaxKind.FINAL_KEYWORD) {
            this.reportInvalidQualifierList(qualifiers);
            finalQualifier = this.consume();
        }
        if (finalQualifier != null && isObjectTypeDesc) {
            this.addInvalidNodeToNextToken(finalQualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)finalQualifier).text());
            finalQualifier = STNodeFactory.createEmptyNode();
        }
        STNode type = this.parseTypeDescriptor(qualifiers, ParserRuleContext.TYPE_DESC_BEFORE_IDENTIFIER);
        STNode fieldName = this.parseVariableName();
        return this.parseObjectFieldRhs(metadata, visibilityQualifier, finalQualifier, type, fieldName, isObjectTypeDesc);
    }

    private STNode parseObjectFieldRhs(STNode metadata, STNode visibilityQualifier, STNode finalQualifier, STNode type, STNode fieldName, boolean isObjectTypeDesc) {
        STNode semicolonToken;
        STNode expression;
        STNode equalsToken;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case SEMICOLON_TOKEN: {
                equalsToken = STNodeFactory.createEmptyNode();
                expression = STNodeFactory.createEmptyNode();
                semicolonToken = this.parseSemicolon();
                break;
            }
            case EQUAL_TOKEN: {
                if (!isObjectTypeDesc) {
                    equalsToken = this.parseAssignOp();
                    expression = this.parseExpression();
                    semicolonToken = this.parseSemicolon();
                    break;
                }
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.OBJECT_FIELD_RHS, metadata, visibilityQualifier, finalQualifier, type, fieldName);
                return this.parseObjectFieldRhs(metadata, visibilityQualifier, finalQualifier, type, fieldName, isObjectTypeDesc);
            }
        }
        return STNodeFactory.createObjectFieldNode(metadata, visibilityQualifier, finalQualifier, type, fieldName, equalsToken, expression, semicolonToken);
    }

    private STNode parseObjectMethodOrFuncTypeDesc(STNode metadata, STNode visibilityQualifier, List<STNode> qualifiers, boolean isObjectTypeDesc) {
        return this.parseFuncDefOrFuncTypeDesc(metadata, visibilityQualifier, qualifiers, true, isObjectTypeDesc);
    }

    private STNode parseIfElseBlock() {
        this.startContext(ParserRuleContext.IF_BLOCK);
        STNode ifKeyword = this.parseIfKeyword();
        STNode condition = this.parseExpression();
        STNode ifBody = this.parseBlockNode();
        this.endContext();
        STNode elseBody = this.parseElseBlock();
        return STNodeFactory.createIfElseStatementNode(ifKeyword, condition, ifBody, elseBody);
    }

    private STNode parseIfKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IF_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.IF_KEYWORD, new Object[0]);
        return this.parseIfKeyword();
    }

    private STNode parseElseKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ELSE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ELSE_KEYWORD, new Object[0]);
        return this.parseElseKeyword();
    }

    private STNode parseBlockNode() {
        this.startContext(ParserRuleContext.BLOCK_STMT);
        STNode openBrace = this.parseOpenBrace();
        STNode stmts = this.parseStatements();
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createBlockStatementNode(openBrace, stmts, closeBrace);
    }

    private STNode parseElseBlock() {
        STToken nextToken = this.peek();
        if (nextToken.kind != SyntaxKind.ELSE_KEYWORD) {
            return STNodeFactory.createEmptyNode();
        }
        STNode elseKeyword = this.parseElseKeyword();
        STNode elseBody = this.parseElseBody();
        return STNodeFactory.createElseBlockNode(elseKeyword, elseBody);
    }

    private STNode parseElseBody() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IF_KEYWORD: {
                return this.parseIfElseBlock();
            }
            case OPEN_BRACE_TOKEN: {
                return this.parseBlockNode();
            }
        }
        this.recover(this.peek(), ParserRuleContext.ELSE_BODY, new Object[0]);
        return this.parseElseBody();
    }

    private STNode parseDoStatement() {
        this.startContext(ParserRuleContext.DO_BLOCK);
        STNode doKeyword = this.parseDoKeyword();
        STNode doBody = this.parseBlockNode();
        this.endContext();
        STNode onFailClause = this.parseOptionalOnFailClause();
        return STNodeFactory.createDoStatementNode(doKeyword, doBody, onFailClause);
    }

    private STNode parseWhileStatement() {
        this.startContext(ParserRuleContext.WHILE_BLOCK);
        STNode whileKeyword = this.parseWhileKeyword();
        STNode condition = this.parseExpression();
        STNode whileBody = this.parseBlockNode();
        this.endContext();
        STNode onFailClause = this.parseOptionalOnFailClause();
        return STNodeFactory.createWhileStatementNode(whileKeyword, condition, whileBody, onFailClause);
    }

    private STNode parseWhileKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.WHILE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.WHILE_KEYWORD, new Object[0]);
        return this.parseWhileKeyword();
    }

    private STNode parsePanicStatement() {
        this.startContext(ParserRuleContext.PANIC_STMT);
        STNode panicKeyword = this.parsePanicKeyword();
        STNode expression = this.parseExpression();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createPanicStatementNode(panicKeyword, expression, semicolon);
    }

    private STNode parsePanicKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.PANIC_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.PANIC_KEYWORD, new Object[0]);
        return this.parsePanicKeyword();
    }

    private STNode parseCheckExpression(boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        STNode checkingKeyword = this.parseCheckingKeyword();
        STNode expr = this.parseExpression(OperatorPrecedence.EXPRESSION_ACTION, isRhsExpr, allowActions, isInConditionalExpr);
        if (this.isAction(expr)) {
            return STNodeFactory.createCheckExpressionNode(SyntaxKind.CHECK_ACTION, checkingKeyword, expr);
        }
        return STNodeFactory.createCheckExpressionNode(SyntaxKind.CHECK_EXPRESSION, checkingKeyword, expr);
    }

    private STNode parseCheckingKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CHECK_KEYWORD || token.kind == SyntaxKind.CHECKPANIC_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CHECKING_KEYWORD, new Object[0]);
        return this.parseCheckingKeyword();
    }

    private STNode parseContinueStatement() {
        this.startContext(ParserRuleContext.CONTINUE_STATEMENT);
        STNode continueKeyword = this.parseContinueKeyword();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createContinueStatementNode(continueKeyword, semicolon);
    }

    private STNode parseContinueKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CONTINUE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CONTINUE_KEYWORD, new Object[0]);
        return this.parseContinueKeyword();
    }

    private STNode parseFailStatement() {
        this.startContext(ParserRuleContext.FAIL_STATEMENT);
        STNode failKeyword = this.parseFailKeyword();
        STNode expr = this.parseExpression();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createFailStatementNode(failKeyword, expr, semicolon);
    }

    private STNode parseFailKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FAIL_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FAIL_KEYWORD, new Object[0]);
        return this.parseFailKeyword();
    }

    private STNode parseReturnStatement() {
        this.startContext(ParserRuleContext.RETURN_STMT);
        STNode returnKeyword = this.parseReturnKeyword();
        STNode returnRhs = this.parseReturnStatementRhs(returnKeyword);
        this.endContext();
        return returnRhs;
    }

    private STNode parseReturnKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.RETURN_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.RETURN_KEYWORD, new Object[0]);
        return this.parseReturnKeyword();
    }

    private STNode parseBreakStatement() {
        this.startContext(ParserRuleContext.BREAK_STATEMENT);
        STNode breakKeyword = this.parseBreakKeyword();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createBreakStatementNode(breakKeyword, semicolon);
    }

    private STNode parseBreakKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.BREAK_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.BREAK_KEYWORD, new Object[0]);
        return this.parseBreakKeyword();
    }

    private STNode parseReturnStatementRhs(STNode returnKeyword) {
        STNode expr;
        STToken token = this.peek();
        switch (token.kind) {
            case SEMICOLON_TOKEN: {
                expr = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                expr = this.parseActionOrExpression();
            }
        }
        STNode semicolon = this.parseSemicolon();
        return STNodeFactory.createReturnStatementNode(returnKeyword, expr, semicolon);
    }

    private STNode parseMappingConstructorExpr() {
        this.startContext(ParserRuleContext.MAPPING_CONSTRUCTOR);
        STNode openBrace = this.parseOpenBrace();
        STNode fields = this.parseMappingConstructorFields();
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createMappingConstructorExpressionNode(openBrace, fields, closeBrace);
    }

    private STNode parseMappingConstructorFields() {
        STToken nextToken = this.peek();
        if (this.isEndOfMappingConstructor(nextToken.kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        ArrayList<STNode> fields = new ArrayList<STNode>();
        STNode field = this.parseMappingField(ParserRuleContext.FIRST_MAPPING_FIELD);
        if (field != null) {
            fields.add(field);
        }
        return this.parseMappingConstructorFields(fields);
    }

    private STNode parseMappingConstructorFields(List<STNode> fields) {
        STNode mappingFieldEnd;
        STToken nextToken = this.peek();
        while (!this.isEndOfMappingConstructor(nextToken.kind) && (mappingFieldEnd = this.parseMappingFieldEnd()) != null) {
            fields.add(mappingFieldEnd);
            STNode field = this.parseMappingField(ParserRuleContext.MAPPING_FIELD);
            fields.add(field);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(fields);
    }

    private STNode parseMappingFieldEnd() {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case CLOSE_BRACE_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.MAPPING_FIELD_END, new Object[0]);
        return this.parseMappingFieldEnd();
    }

    private boolean isEndOfMappingConstructor(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case READONLY_KEYWORD: 
            case IDENTIFIER_TOKEN: {
                return false;
            }
            case EOF_TOKEN: 
            case DOCUMENTATION_STRING: 
            case AT_TOKEN: 
            case FINAL_KEYWORD: 
            case PUBLIC_KEYWORD: 
            case FUNCTION_KEYWORD: 
            case TYPE_KEYWORD: 
            case LISTENER_KEYWORD: 
            case CONST_KEYWORD: 
            case SERVICE_KEYWORD: 
            case SEMICOLON_TOKEN: 
            case RESOURCE_KEYWORD: 
            case PRIVATE_KEYWORD: 
            case RETURNS_KEYWORD: 
            case CLOSE_BRACE_TOKEN: {
                return true;
            }
        }
        return BallerinaParser.isSimpleType(tokenKind);
    }

    private STNode parseMappingField(ParserRuleContext fieldContext) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: {
                STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                return this.parseSpecificFieldWithOptionalValue(readonlyKeyword);
            }
            case STRING_LITERAL_TOKEN: {
                STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                return this.parseQualifiedSpecificField(readonlyKeyword);
            }
            case READONLY_KEYWORD: {
                STNode readonlyKeyword = this.parseReadonlyKeyword();
                return this.parseSpecificField(readonlyKeyword);
            }
            case OPEN_BRACKET_TOKEN: {
                return this.parseComputedField();
            }
            case ELLIPSIS_TOKEN: {
                STNode ellipsis = this.parseEllipsis();
                STNode expr = this.parseExpression();
                return STNodeFactory.createSpreadFieldNode(ellipsis, expr);
            }
            case CLOSE_BRACE_TOKEN: {
                if (fieldContext != ParserRuleContext.FIRST_MAPPING_FIELD) break;
                return null;
            }
        }
        this.recover(nextToken, fieldContext, new Object[]{fieldContext});
        return this.parseMappingField(fieldContext);
    }

    private STNode parseSpecificField(STNode readonlyKeyword) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case STRING_LITERAL_TOKEN: {
                return this.parseQualifiedSpecificField(readonlyKeyword);
            }
            case IDENTIFIER_TOKEN: {
                return this.parseSpecificFieldWithOptionalValue(readonlyKeyword);
            }
        }
        this.recover(this.peek(), ParserRuleContext.SPECIFIC_FIELD, readonlyKeyword);
        return this.parseSpecificField(readonlyKeyword);
    }

    private STNode parseQualifiedSpecificField(STNode readonlyKeyword) {
        STNode key = this.parseStringLiteral();
        STNode colon = this.parseColon();
        STNode valueExpr = this.parseExpression();
        return STNodeFactory.createSpecificFieldNode(readonlyKeyword, key, colon, valueExpr);
    }

    private STNode parseSpecificFieldWithOptionalValue(STNode readonlyKeyword) {
        STNode key = this.parseIdentifier(ParserRuleContext.MAPPING_FIELD_NAME);
        return this.parseSpecificFieldRhs(readonlyKeyword, key);
    }

    private STNode parseSpecificFieldRhs(STNode readonlyKeyword, STNode key) {
        STNode valueExpr;
        STNode colon;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case COLON_TOKEN: {
                colon = this.parseColon();
                valueExpr = this.parseExpression();
                break;
            }
            case COMMA_TOKEN: {
                colon = STNodeFactory.createEmptyNode();
                valueExpr = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                if (this.isEndOfMappingConstructor(nextToken.kind)) {
                    colon = STNodeFactory.createEmptyNode();
                    valueExpr = STNodeFactory.createEmptyNode();
                    break;
                }
                this.recover(nextToken, ParserRuleContext.SPECIFIC_FIELD_RHS, readonlyKeyword, key);
                return this.parseSpecificFieldRhs(readonlyKeyword, key);
            }
        }
        return STNodeFactory.createSpecificFieldNode(readonlyKeyword, key, colon, valueExpr);
    }

    private STNode parseStringLiteral() {
        STToken token = this.peek();
        if (token.kind != SyntaxKind.STRING_LITERAL_TOKEN) {
            this.recover(token, ParserRuleContext.STRING_LITERAL_TOKEN, new Object[0]);
            return this.parseStringLiteral();
        }
        STToken stringLiteral = this.consume();
        return this.parseBasicLiteral(stringLiteral);
    }

    private STNode parseColon() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.COLON_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.COLON, new Object[0]);
        return this.parseColon();
    }

    private STNode parseReadonlyKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.READONLY_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.READONLY_KEYWORD, new Object[0]);
        return this.parseReadonlyKeyword();
    }

    private STNode parseComputedField() {
        this.startContext(ParserRuleContext.COMPUTED_FIELD_NAME);
        STNode openBracket = this.parseOpenBracket();
        STNode fieldNameExpr = this.parseExpression();
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        STNode colon = this.parseColon();
        STNode valueExpr = this.parseExpression();
        return STNodeFactory.createComputedNameFieldNode(openBracket, fieldNameExpr, closeBracket, colon, valueExpr);
    }

    private STNode parseOpenBracket() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OPEN_BRACKET_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.OPEN_BRACKET, new Object[0]);
        return this.parseOpenBracket();
    }

    private STNode parseCompoundAssignmentStmtRhs(STNode lvExpr) {
        STNode binaryOperator = this.parseCompoundBinaryOperator();
        STNode equalsToken = this.parseAssignOp();
        STNode expr = this.parseActionOrExpression();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        boolean lvExprValid = this.isValidLVExpr(lvExpr);
        if (!lvExprValid) {
            STToken identifier = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
            STNode simpleNameRef = STNodeFactory.createSimpleNameReferenceNode(identifier);
            lvExpr = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(simpleNameRef, lvExpr, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_EXPR_IN_COMPOUND_ASSIGNMENT_LHS, new Object[0]);
        }
        return STNodeFactory.createCompoundAssignmentStatementNode(lvExpr, binaryOperator, equalsToken, expr, semicolon);
    }

    private STNode parseCompoundBinaryOperator() {
        STToken token = this.peek();
        if (this.isCompoundBinaryOperator(token.kind)) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.COMPOUND_BINARY_OPERATOR, new Object[0]);
        return this.parseCompoundBinaryOperator();
    }

    private STNode parseServiceDecl(STNode metadata, List<STNode> qualifiers) {
        this.startContext(ParserRuleContext.SERVICE_DECL);
        STNode qualNodeList = this.createServiceDeclQualNodeList(qualifiers);
        STNode serviceKeyword = this.parseServiceKeyword();
        STNode serviceDecl = this.parseServiceRhs(metadata, qualNodeList, serviceKeyword);
        this.endContext();
        return serviceDecl;
    }

    private STNode createServiceDeclQualNodeList(List<STNode> qualifierList) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (qualifier.kind == SyntaxKind.ISOLATED_KEYWORD) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) {
                this.addInvalidNodeToNextToken(qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
                continue;
            }
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        return STNodeFactory.createNodeList(validatedList);
    }

    private STNode parseServiceRhs(STNode metadata, STNode qualNodeList, STNode serviceKeyword) {
        STNode serviceName = this.parseServiceName();
        STNode onKeyword = this.parseOnKeyword();
        STNode expressionList = this.parseListeners();
        STNode serviceBody = this.parseServiceBody();
        onKeyword = this.cloneWithDiagnosticIfListEmpty(expressionList, onKeyword, DiagnosticErrorCode.ERROR_MISSING_EXPRESSION);
        return STNodeFactory.createServiceDeclarationNode(metadata, qualNodeList, serviceKeyword, serviceName, onKeyword, expressionList, serviceBody);
    }

    private STNode parseServiceName() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: {
                return this.parseIdentifier(ParserRuleContext.SERVICE_NAME);
            }
            case ON_KEYWORD: {
                return STNodeFactory.createEmptyNode();
            }
        }
        this.recover(nextToken, ParserRuleContext.OPTIONAL_SERVICE_NAME, new Object[0]);
        return this.parseServiceName();
    }

    private STNode parseServiceKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.SERVICE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.SERVICE_KEYWORD, new Object[0]);
        return this.parseServiceKeyword();
    }

    private boolean isCompoundBinaryOperator(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case PIPE_TOKEN: 
            case BITWISE_AND_TOKEN: 
            case SLASH_TOKEN: 
            case PLUS_TOKEN: 
            case MINUS_TOKEN: 
            case ASTERISK_TOKEN: 
            case BITWISE_XOR_TOKEN: 
            case DOUBLE_LT_TOKEN: 
            case DOUBLE_GT_TOKEN: 
            case TRIPPLE_GT_TOKEN: {
                return this.getNextNextToken().kind == SyntaxKind.EQUAL_TOKEN;
            }
        }
        return false;
    }

    private STNode parseOnKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ON_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ON_KEYWORD, new Object[0]);
        return this.parseOnKeyword();
    }

    private STNode parseListeners() {
        STNode listenersMemberEnd;
        this.startContext(ParserRuleContext.LISTENERS_LIST);
        ArrayList<STNode> listeners = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndOfListeners(nextToken.kind)) {
            this.endContext();
            return STNodeFactory.createEmptyNodeList();
        }
        STNode expr = this.parseExpression();
        listeners.add(expr);
        while (!this.isEndOfListeners(this.peek().kind) && (listenersMemberEnd = this.parseListenersMemberEnd()) != null) {
            listeners.add(listenersMemberEnd);
            expr = this.parseExpression();
            listeners.add(expr);
        }
        this.endContext();
        return STNodeFactory.createNodeList(listeners);
    }

    private boolean isEndOfListeners(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case EOF_TOKEN: 
            case OPEN_BRACE_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseListenersMemberEnd() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case OPEN_BRACE_TOKEN: {
                return null;
            }
        }
        this.recover(nextToken, ParserRuleContext.LISTENERS_LIST_END, new Object[0]);
        return this.parseListenersMemberEnd();
    }

    private STNode parseServiceBody() {
        STNode openBrace = this.parseOpenBrace();
        STNode resources = this.parseResources();
        STNode closeBrace = this.parseCloseBrace();
        return STNodeFactory.createServiceBodyNode(openBrace, resources, closeBrace);
    }

    private STNode parseResources() {
        STNode serviceMethod;
        ArrayList<STNode> resources = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (!this.isEndOfServiceDecl(nextToken.kind) && (serviceMethod = this.parseResource()) != null) {
            resources.add(serviceMethod);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(resources);
    }

    private boolean isEndOfServiceDecl(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case EOF_TOKEN: 
            case TYPE_KEYWORD: 
            case SERVICE_KEYWORD: 
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACE_PIPE_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseResource() {
        STNode metadata;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case FUNCTION_KEYWORD: 
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: 
            case REMOTE_KEYWORD: 
            case RESOURCE_KEYWORD: {
                metadata = STNodeFactory.createEmptyNode();
                break;
            }
            case DOCUMENTATION_STRING: 
            case AT_TOKEN: {
                metadata = this.parseMetaData();
                break;
            }
            default: {
                if (this.isEndOfServiceDecl(nextToken.kind)) {
                    return null;
                }
                this.recover(this.peek(), ParserRuleContext.RESOURCE_DEF, new Object[0]);
                return this.parseResource();
            }
        }
        return this.parseResource(metadata);
    }

    private STNode parseResource(STNode metadata) {
        STNode qualifierList = this.parseFunctionQualifiers(ParserRuleContext.RESOURCE_DEF_QUALIFIERS, new ArrayList<STNode>());
        return this.parseFuncDefinition(metadata, qualifierList);
    }

    private boolean isServiceDeclStart(ParserRuleContext currentContext, int lookahead) {
        switch (this.peek((int)(lookahead + 1)).kind) {
            case IDENTIFIER_TOKEN: {
                SyntaxKind tokenAfterIdentifier = this.peek((int)(lookahead + 2)).kind;
                switch (tokenAfterIdentifier) {
                    case OPEN_BRACE_TOKEN: 
                    case ON_KEYWORD: {
                        return true;
                    }
                    case EQUAL_TOKEN: 
                    case SEMICOLON_TOKEN: 
                    case QUESTION_MARK_TOKEN: {
                        return false;
                    }
                }
                return false;
            }
            case ON_KEYWORD: {
                return true;
            }
        }
        return false;
    }

    private STNode parseListenerDeclaration(STNode metadata, STNode qualifier) {
        this.startContext(ParserRuleContext.LISTENER_DECL);
        STNode listenerKeyword = this.parseListenerKeyword();
        if (this.peek().kind == SyntaxKind.IDENTIFIER_TOKEN) {
            STNode listenerDecl = this.parseConstantOrListenerDeclWithOptionalType(metadata, qualifier, listenerKeyword, true);
            this.endContext();
            return listenerDecl;
        }
        STNode typeDesc = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_BEFORE_IDENTIFIER);
        STNode variableName = this.parseVariableName();
        STNode equalsToken = this.parseAssignOp();
        STNode initializer = this.parseExpression();
        STNode semicolonToken = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createListenerDeclarationNode(metadata, qualifier, listenerKeyword, typeDesc, variableName, equalsToken, initializer, semicolonToken);
    }

    private STNode parseListenerKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.LISTENER_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.LISTENER_KEYWORD, new Object[0]);
        return this.parseListenerKeyword();
    }

    private STNode parseConstantDeclaration(STNode metadata, STNode qualifier) {
        this.startContext(ParserRuleContext.CONSTANT_DECL);
        STNode constKeyword = this.parseConstantKeyword();
        return this.parseConstDecl(metadata, qualifier, constKeyword);
    }

    private STNode parseConstDecl(STNode metadata, STNode qualifier, STNode constKeyword) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case ANNOTATION_KEYWORD: {
                this.endContext();
                return this.parseAnnotationDeclaration(metadata, qualifier, constKeyword);
            }
            case IDENTIFIER_TOKEN: {
                STNode constantDecl = this.parseConstantOrListenerDeclWithOptionalType(metadata, qualifier, constKeyword, false);
                this.endContext();
                return constantDecl;
            }
        }
        if (!this.isTypeStartingToken(nextToken.kind)) {
            this.recover(this.peek(), ParserRuleContext.CONST_DECL_TYPE, metadata, qualifier, constKeyword);
            return this.parseConstDecl(metadata, qualifier, constKeyword);
        }
        STNode typeDesc = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_BEFORE_IDENTIFIER);
        STNode variableName = this.parseVariableName();
        STNode equalsToken = this.parseAssignOp();
        STNode initializer = this.parseExpression();
        STNode semicolonToken = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createConstantDeclarationNode(metadata, qualifier, constKeyword, typeDesc, variableName, equalsToken, initializer, semicolonToken);
    }

    private STNode parseConstantOrListenerDeclWithOptionalType(STNode metadata, STNode qualifier, STNode constKeyword, boolean isListener) {
        STNode varNameOrTypeName = this.parseStatementStartIdentifier();
        return this.parseConstantOrListenerDeclRhs(metadata, qualifier, constKeyword, varNameOrTypeName, isListener);
    }

    private STNode parseConstantOrListenerDeclRhs(STNode metadata, STNode qualifier, STNode keyword, STNode typeOrVarName, boolean isListener) {
        STNode variableName;
        STNode type;
        if (typeOrVarName.kind == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            STNode type2 = typeOrVarName;
            STNode variableName2 = this.parseVariableName();
            return this.parseListenerOrConstRhs(metadata, qualifier, keyword, isListener, type2, variableName2);
        }
        switch (this.peek().kind) {
            case IDENTIFIER_TOKEN: {
                type = typeOrVarName;
                variableName = this.parseVariableName();
                break;
            }
            case EQUAL_TOKEN: {
                variableName = ((STSimpleNameReferenceNode)typeOrVarName).name;
                type = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.CONST_DECL_RHS, metadata, qualifier, keyword, typeOrVarName, isListener);
                return this.parseConstantOrListenerDeclRhs(metadata, qualifier, keyword, typeOrVarName, isListener);
            }
        }
        return this.parseListenerOrConstRhs(metadata, qualifier, keyword, isListener, type, variableName);
    }

    private STNode parseListenerOrConstRhs(STNode metadata, STNode qualifier, STNode keyword, boolean isListener, STNode type, STNode variableName) {
        STNode equalsToken = this.parseAssignOp();
        STNode initializer = this.parseExpression();
        STNode semicolonToken = this.parseSemicolon();
        if (isListener) {
            return STNodeFactory.createListenerDeclarationNode(metadata, qualifier, keyword, type, variableName, equalsToken, initializer, semicolonToken);
        }
        return STNodeFactory.createConstantDeclarationNode(metadata, qualifier, keyword, type, variableName, equalsToken, initializer, semicolonToken);
    }

    private STNode parseConstantKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CONST_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CONST_KEYWORD, new Object[0]);
        return this.parseConstantKeyword();
    }

    private STNode parseTypeofExpression(boolean isRhsExpr, boolean isInConditionalExpr) {
        STNode typeofKeyword = this.parseTypeofKeyword();
        STNode expr = this.parseExpression(OperatorPrecedence.UNARY, isRhsExpr, false, isInConditionalExpr);
        return STNodeFactory.createTypeofExpressionNode(typeofKeyword, expr);
    }

    private STNode parseTypeofKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.TYPEOF_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.TYPEOF_KEYWORD, new Object[0]);
        return this.parseTypeofKeyword();
    }

    private STNode parseOptionalTypeDescriptor(STNode typeDescriptorNode) {
        this.startContext(ParserRuleContext.OPTIONAL_TYPE_DESCRIPTOR);
        STNode questionMarkToken = this.parseQuestionMark();
        this.endContext();
        typeDescriptorNode = this.validateForUsageOfVar(typeDescriptorNode);
        return STNodeFactory.createOptionalTypeDescriptorNode(typeDescriptorNode, questionMarkToken);
    }

    private STNode parseUnaryExpression(boolean isRhsExpr, boolean isInConditionalExpr) {
        STNode unaryOperator = this.parseUnaryOperator();
        STNode expr = this.parseExpression(OperatorPrecedence.UNARY, isRhsExpr, false, isInConditionalExpr);
        return STNodeFactory.createUnaryExpressionNode(unaryOperator, expr);
    }

    private STNode parseUnaryOperator() {
        STToken token = this.peek();
        if (this.isUnaryOperator(token.kind)) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.UNARY_OPERATOR, new Object[0]);
        return this.parseUnaryOperator();
    }

    private boolean isUnaryOperator(SyntaxKind kind) {
        switch (kind) {
            case PLUS_TOKEN: 
            case MINUS_TOKEN: 
            case NEGATION_TOKEN: 
            case EXCLAMATION_MARK_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseArrayTypeDescriptor(STNode memberTypeDesc) {
        this.startContext(ParserRuleContext.ARRAY_TYPE_DESCRIPTOR);
        STNode openBracketToken = this.parseOpenBracket();
        STNode arrayLengthNode = this.parseArrayLength();
        STNode closeBracketToken = this.parseCloseBracket();
        this.endContext();
        return this.createArrayTypeDesc(memberTypeDesc, openBracketToken, arrayLengthNode, closeBracketToken);
    }

    private STNode createArrayTypeDesc(STNode memberTypeDesc, STNode openBracketToken, STNode arrayLengthNode, STNode closeBracketToken) {
        memberTypeDesc = this.validateForUsageOfVar(memberTypeDesc);
        if (arrayLengthNode != null) {
            switch (arrayLengthNode.kind) {
                case SIMPLE_NAME_REFERENCE: 
                case QUALIFIED_NAME_REFERENCE: 
                case ASTERISK_LITERAL: {
                    break;
                }
                case NUMERIC_LITERAL: {
                    SyntaxKind numericLiteralKind = arrayLengthNode.childInBucket((int)0).kind;
                    if (numericLiteralKind == SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN || numericLiteralKind == SyntaxKind.HEX_INTEGER_LITERAL_TOKEN) break;
                }
                default: {
                    openBracketToken = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(openBracketToken, arrayLengthNode, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_ARRAY_LENGTH, new Object[0]);
                    arrayLengthNode = STNodeFactory.createEmptyNode();
                }
            }
        }
        return STNodeFactory.createArrayTypeDescriptorNode(memberTypeDesc, openBracketToken, arrayLengthNode, closeBracketToken);
    }

    private STNode parseArrayLength() {
        STToken token = this.peek();
        switch (token.kind) {
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case ASTERISK_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: {
                return this.parseBasicLiteral();
            }
            case CLOSE_BRACKET_TOKEN: {
                return STNodeFactory.createEmptyNode();
            }
            case IDENTIFIER_TOKEN: {
                return this.parseQualifiedIdentifier(ParserRuleContext.ARRAY_LENGTH);
            }
        }
        this.recover(token, ParserRuleContext.ARRAY_LENGTH, new Object[0]);
        return this.parseArrayLength();
    }

    private STNode parseOptionalAnnotations() {
        this.startContext(ParserRuleContext.ANNOTATIONS);
        ArrayList<STNode> annotList = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (nextToken.kind == SyntaxKind.AT_TOKEN) {
            annotList.add(this.parseAnnotation());
            nextToken = this.peek();
        }
        this.endContext();
        return STNodeFactory.createNodeList(annotList);
    }

    private STNode parseAnnotations() {
        this.startContext(ParserRuleContext.ANNOTATIONS);
        ArrayList<STNode> annotList = new ArrayList<STNode>();
        annotList.add(this.parseAnnotation());
        while (this.peek().kind == SyntaxKind.AT_TOKEN) {
            annotList.add(this.parseAnnotation());
        }
        this.endContext();
        return STNodeFactory.createNodeList(annotList);
    }

    private STNode parseAnnotation() {
        STNode atToken = this.parseAtToken();
        STNode annotReference = this.peek().kind != SyntaxKind.IDENTIFIER_TOKEN ? STNodeFactory.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN) : this.parseQualifiedIdentifier(ParserRuleContext.ANNOT_REFERENCE);
        STNode annotValue = this.peek().kind == SyntaxKind.OPEN_BRACE_TOKEN ? this.parseMappingConstructorExpr() : STNodeFactory.createEmptyNode();
        return STNodeFactory.createAnnotationNode(atToken, annotReference, annotValue);
    }

    private STNode parseAtToken() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.AT_TOKEN) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.AT, new Object[0]);
        return this.parseAtToken();
    }

    private STNode parseMetaData() {
        STNode annotations;
        STNode docString;
        switch (this.peek().kind) {
            case DOCUMENTATION_STRING: {
                docString = this.parseMarkdownDocumentation();
                annotations = this.parseOptionalAnnotations();
                break;
            }
            case AT_TOKEN: {
                docString = STNodeFactory.createEmptyNode();
                annotations = this.parseOptionalAnnotations();
                break;
            }
            default: {
                return STNodeFactory.createEmptyNode();
            }
        }
        return this.createMetadata(docString, annotations);
    }

    private STNode createMetadata(STNode docString, STNode annotations) {
        if (annotations == null && docString == null) {
            return STNodeFactory.createEmptyNode();
        }
        return STNodeFactory.createMetadataNode(docString, annotations);
    }

    private STNode parseTypeTestExpression(STNode lhsExpr, boolean isInConditionalExpr) {
        STNode isKeyword = this.parseIsKeyword();
        STNode typeDescriptor = this.parseTypeDescriptorInExpression(isInConditionalExpr);
        return STNodeFactory.createTypeTestExpressionNode(lhsExpr, isKeyword, typeDescriptor);
    }

    private STNode parseIsKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IS_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.IS_KEYWORD, new Object[0]);
        return this.parseIsKeyword();
    }

    private STNode parseLocalTypeDefinitionStatement(STNode annots) {
        this.startContext(ParserRuleContext.LOCAL_TYPE_DEFINITION_STMT);
        STNode typeKeyword = this.parseTypeKeyword();
        STNode typeName = this.parseTypeName();
        STNode typeDescriptor = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TYPE_DEF);
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createLocalTypeDefinitionStatementNode(annots, typeKeyword, typeName, typeDescriptor, semicolon);
    }

    private STNode parseExpressionStatement(STNode annots) {
        this.startContext(ParserRuleContext.EXPRESSION_STATEMENT);
        STNode expression = this.parseActionOrExpressionInLhs(annots);
        return this.getExpressionAsStatement(expression);
    }

    private STNode parseStatementStartWithExpr(STNode annots) {
        this.startContext(ParserRuleContext.AMBIGUOUS_STMT);
        STNode expr = this.parseActionOrExpressionInLhs(annots);
        return this.parseStatementStartWithExprRhs(expr);
    }

    private STNode parseStatementStartWithExprRhs(STNode expression) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EQUAL_TOKEN: {
                this.switchContext(ParserRuleContext.ASSIGNMENT_STMT);
                return this.parseAssignmentStmtRhs(expression);
            }
            case SEMICOLON_TOKEN: {
                return this.getExpressionAsStatement(expression);
            }
        }
        if (this.isCompoundBinaryOperator(nextToken.kind)) {
            return this.parseCompoundAssignmentStmtRhs(expression);
        }
        ParserRuleContext context = this.isPossibleExpressionStatement(expression) ? ParserRuleContext.EXPR_STMT_RHS : ParserRuleContext.STMT_START_WITH_EXPR_RHS;
        this.recover(this.peek(), context, expression);
        return this.parseStatementStartWithExprRhs(expression);
    }

    private boolean isPossibleExpressionStatement(STNode expression) {
        switch (expression.kind) {
            case REMOTE_METHOD_CALL_ACTION: 
            case BRACED_ACTION: 
            case CHECK_ACTION: 
            case START_ACTION: 
            case TRAP_ACTION: 
            case FLUSH_ACTION: 
            case ASYNC_SEND_ACTION: 
            case SYNC_SEND_ACTION: 
            case RECEIVE_ACTION: 
            case WAIT_ACTION: 
            case QUERY_ACTION: 
            case COMMIT_ACTION: 
            case METHOD_CALL: 
            case FUNCTION_CALL: 
            case CHECK_EXPRESSION: {
                return true;
            }
        }
        return false;
    }

    private STNode getExpressionAsStatement(STNode expression) {
        switch (expression.kind) {
            case METHOD_CALL: 
            case FUNCTION_CALL: 
            case CHECK_EXPRESSION: {
                return this.parseCallStatement(expression);
            }
            case REMOTE_METHOD_CALL_ACTION: 
            case BRACED_ACTION: 
            case CHECK_ACTION: 
            case START_ACTION: 
            case TRAP_ACTION: 
            case FLUSH_ACTION: 
            case ASYNC_SEND_ACTION: 
            case SYNC_SEND_ACTION: 
            case RECEIVE_ACTION: 
            case WAIT_ACTION: 
            case QUERY_ACTION: 
            case COMMIT_ACTION: {
                return this.parseActionStatement(expression);
            }
        }
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        STNode exprStmt = STNodeFactory.createExpressionStatementNode(SyntaxKind.INVALID_EXPRESSION_STATEMENT, expression, semicolon);
        exprStmt = SyntaxErrors.addDiagnostic(exprStmt, DiagnosticErrorCode.ERROR_INVALID_EXPRESSION_STATEMENT, new Object[0]);
        return exprStmt;
    }

    private STNode parseArrayTypeDescriptorNode(STIndexedExpressionNode indexedExpr) {
        STNode memberTypeDesc = this.getTypeDescFromExpr(indexedExpr.containerExpression);
        STNodeList lengthExprs = (STNodeList)indexedExpr.keyExpression;
        if (lengthExprs.isEmpty()) {
            return this.createArrayTypeDesc(memberTypeDesc, indexedExpr.openBracket, STNodeFactory.createEmptyNode(), indexedExpr.closeBracket);
        }
        STNode lengthExpr = lengthExprs.get(0);
        switch (lengthExpr.kind) {
            case SIMPLE_NAME_REFERENCE: 
            case QUALIFIED_NAME_REFERENCE: 
            case ASTERISK_LITERAL: {
                break;
            }
            case NUMERIC_LITERAL: {
                SyntaxKind innerChildKind = lengthExpr.childInBucket((int)0).kind;
                if (innerChildKind == SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN || innerChildKind == SyntaxKind.HEX_INTEGER_LITERAL_TOKEN) break;
            }
            default: {
                STNode newOpenBracketWithDiagnostics = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(indexedExpr.openBracket, lengthExpr, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_ARRAY_LENGTH, new Object[0]);
                indexedExpr = (STIndexedExpressionNode)indexedExpr.replace(indexedExpr.openBracket, newOpenBracketWithDiagnostics);
                lengthExpr = STNodeFactory.createEmptyNode();
            }
        }
        return this.createArrayTypeDesc(memberTypeDesc, indexedExpr.openBracket, lengthExpr, indexedExpr.closeBracket);
    }

    private STNode parseCallStatement(STNode expression) {
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createExpressionStatementNode(SyntaxKind.CALL_STATEMENT, expression, semicolon);
    }

    private STNode parseActionStatement(STNode action) {
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createExpressionStatementNode(SyntaxKind.ACTION_STATEMENT, action, semicolon);
    }

    private STNode parseRemoteMethodCallOrAsyncSendAction(STNode expression, boolean isRhsExpr) {
        STNode rightArrow = this.parseRightArrow();
        return this.parseRemoteCallOrAsyncSendActionRhs(expression, isRhsExpr, rightArrow);
    }

    private STNode parseRemoteCallOrAsyncSendActionRhs(STNode expression, boolean isRhsExpr, STNode rightArrow) {
        STNode name;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case DEFAULT_KEYWORD: {
                STNode defaultKeyword = this.parseDefaultKeyword();
                STNode name2 = STNodeFactory.createSimpleNameReferenceNode(defaultKeyword);
                return this.parseAsyncSendAction(expression, rightArrow, name2);
            }
            case IDENTIFIER_TOKEN: {
                name = STNodeFactory.createSimpleNameReferenceNode(this.parseFunctionName());
                break;
            }
            case CONTINUE_KEYWORD: 
            case COMMIT_KEYWORD: {
                name = this.getKeywordAsSimpleNameRef();
                break;
            }
            default: {
                STToken token = this.peek();
                this.recover(token, ParserRuleContext.REMOTE_CALL_OR_ASYNC_SEND_RHS, expression, isRhsExpr, rightArrow);
                return this.parseRemoteCallOrAsyncSendActionRhs(expression, isRhsExpr, rightArrow);
            }
        }
        return this.parseRemoteCallOrAsyncSendEnd(expression, rightArrow, name);
    }

    private STNode parseRemoteCallOrAsyncSendEnd(STNode expression, STNode rightArrow, STNode name) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_PAREN_TOKEN: {
                return this.parseRemoteMethodCallAction(expression, rightArrow, name);
            }
            case SEMICOLON_TOKEN: {
                return this.parseAsyncSendAction(expression, rightArrow, name);
            }
        }
        this.recover(this.peek(), ParserRuleContext.REMOTE_CALL_OR_ASYNC_SEND_END, expression, rightArrow, name);
        return this.parseRemoteCallOrAsyncSendEnd(expression, rightArrow, name);
    }

    private STNode parseDefaultKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.DEFAULT_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.DEFAULT_KEYWORD, new Object[0]);
        return this.parseDefaultKeyword();
    }

    private STNode parseAsyncSendAction(STNode expression, STNode rightArrow, STNode peerWorker) {
        return STNodeFactory.createAsyncSendActionNode(expression, rightArrow, peerWorker);
    }

    private STNode parseRemoteMethodCallAction(STNode expression, STNode rightArrow, STNode name) {
        STNode openParenToken = this.parseOpenParenthesis(ParserRuleContext.ARG_LIST_START);
        STNode arguments = this.parseArgsList();
        STNode closeParenToken = this.parseCloseParenthesis();
        return STNodeFactory.createRemoteMethodCallActionNode(expression, rightArrow, name, openParenToken, arguments, closeParenToken);
    }

    private STNode parseRightArrow() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.RIGHT_ARROW_TOKEN) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.RIGHT_ARROW, new Object[0]);
        return this.parseRightArrow();
    }

    private STNode parseParameterizedTypeDescriptor() {
        STNode parameterizedTypeKeyword = this.parseParameterizedTypeKeyword();
        STNode typeParameter = this.parseTypeParameter();
        return STNodeFactory.createParameterizedTypeDescriptorNode(parameterizedTypeKeyword, typeParameter);
    }

    private STNode parseParameterizedTypeKeyword() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case MAP_KEYWORD: 
            case FUTURE_KEYWORD: {
                return this.consume();
            }
        }
        this.recover(nextToken, ParserRuleContext.PARAMETERIZED_TYPE, new Object[0]);
        return this.parseParameterizedTypeKeyword();
    }

    private STNode parseGTToken() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.GT_TOKEN) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.GT, new Object[0]);
        return this.parseGTToken();
    }

    private STNode parseLTToken() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.LT_TOKEN) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.LT, new Object[0]);
        return this.parseLTToken();
    }

    private STNode parseNilLiteral() {
        this.startContext(ParserRuleContext.NIL_LITERAL);
        STNode openParenthesisToken = this.parseOpenParenthesis(ParserRuleContext.OPEN_PARENTHESIS);
        STNode closeParenthesisToken = this.parseCloseParenthesis();
        this.endContext();
        return STNodeFactory.createNilLiteralNode(openParenthesisToken, closeParenthesisToken);
    }

    private STNode parseAnnotationDeclaration(STNode metadata, STNode qualifier, STNode constKeyword) {
        this.startContext(ParserRuleContext.ANNOTATION_DECL);
        STNode annotationKeyword = this.parseAnnotationKeyword();
        STNode annotDecl = this.parseAnnotationDeclFromType(metadata, qualifier, constKeyword, annotationKeyword);
        this.endContext();
        return annotDecl;
    }

    private STNode parseAnnotationKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ANNOTATION_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ANNOTATION_KEYWORD, new Object[0]);
        return this.parseAnnotationKeyword();
    }

    private STNode parseAnnotationDeclFromType(STNode metadata, STNode qualifier, STNode constKeyword, STNode annotationKeyword) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: {
                return this.parseAnnotationDeclWithOptionalType(metadata, qualifier, constKeyword, annotationKeyword);
            }
        }
        if (!this.isTypeStartingToken(nextToken.kind)) {
            this.recover(this.peek(), ParserRuleContext.ANNOT_DECL_OPTIONAL_TYPE, metadata, qualifier, constKeyword, annotationKeyword);
            return this.parseAnnotationDeclFromType(metadata, qualifier, constKeyword, annotationKeyword);
        }
        STNode typeDesc = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_ANNOTATION_DECL);
        STNode annotTag = this.parseAnnotationTag();
        return this.parseAnnotationDeclAttachPoints(metadata, qualifier, constKeyword, annotationKeyword, typeDesc, annotTag);
    }

    private STNode parseAnnotationTag() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.ANNOTATION_TAG, new Object[0]);
        return this.parseAnnotationTag();
    }

    private STNode parseAnnotationDeclWithOptionalType(STNode metadata, STNode qualifier, STNode constKeyword, STNode annotationKeyword) {
        STNode typeDescOrAnnotTag = this.parseQualifiedIdentifier(ParserRuleContext.ANNOT_DECL_OPTIONAL_TYPE);
        if (typeDescOrAnnotTag.kind == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            STNode annotTag = this.parseAnnotationTag();
            return this.parseAnnotationDeclAttachPoints(metadata, qualifier, constKeyword, annotationKeyword, typeDescOrAnnotTag, annotTag);
        }
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.IDENTIFIER_TOKEN || this.isValidTypeContinuationToken(nextToken)) {
            STNode typeDesc = this.parseComplexTypeDescriptor(typeDescOrAnnotTag, ParserRuleContext.TYPE_DESC_IN_ANNOTATION_DECL, false);
            STNode annotTag = this.parseAnnotationTag();
            return this.parseAnnotationDeclAttachPoints(metadata, qualifier, constKeyword, annotationKeyword, typeDesc, annotTag);
        }
        STNode annotTag = ((STSimpleNameReferenceNode)typeDescOrAnnotTag).name;
        return this.parseAnnotationDeclRhs(metadata, qualifier, constKeyword, annotationKeyword, annotTag);
    }

    private STNode parseAnnotationDeclRhs(STNode metadata, STNode qualifier, STNode constKeyword, STNode annotationKeyword, STNode typeDescOrAnnotTag) {
        STNode annotTag;
        STNode typeDesc;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: {
                typeDesc = typeDescOrAnnotTag;
                annotTag = this.parseAnnotationTag();
                break;
            }
            case SEMICOLON_TOKEN: 
            case ON_KEYWORD: {
                typeDesc = STNodeFactory.createEmptyNode();
                annotTag = typeDescOrAnnotTag;
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.ANNOT_DECL_RHS, metadata, qualifier, constKeyword, annotationKeyword, typeDescOrAnnotTag);
                return this.parseAnnotationDeclRhs(metadata, qualifier, constKeyword, annotationKeyword, typeDescOrAnnotTag);
            }
        }
        return this.parseAnnotationDeclAttachPoints(metadata, qualifier, constKeyword, annotationKeyword, typeDesc, annotTag);
    }

    private STNode parseAnnotationDeclAttachPoints(STNode metadata, STNode qualifier, STNode constKeyword, STNode annotationKeyword, STNode typeDesc, STNode annotTag) {
        STNode attachPoints;
        STNode onKeyword;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case SEMICOLON_TOKEN: {
                onKeyword = STNodeFactory.createEmptyNode();
                attachPoints = STNodeFactory.createEmptyNodeList();
                break;
            }
            case ON_KEYWORD: {
                onKeyword = this.parseOnKeyword();
                attachPoints = this.parseAnnotationAttachPoints();
                onKeyword = this.cloneWithDiagnosticIfListEmpty(attachPoints, onKeyword, DiagnosticErrorCode.ERROR_MISSING_ANNOTATION_ATTACH_POINT);
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.ANNOT_OPTIONAL_ATTACH_POINTS, metadata, qualifier, constKeyword, annotationKeyword, typeDesc, annotTag);
                return this.parseAnnotationDeclAttachPoints(metadata, qualifier, constKeyword, annotationKeyword, typeDesc, annotTag);
            }
        }
        STNode semicolonToken = this.parseSemicolon();
        return STNodeFactory.createAnnotationDeclarationNode(metadata, qualifier, constKeyword, annotationKeyword, typeDesc, annotTag, onKeyword, attachPoints, semicolonToken);
    }

    private STNode parseAnnotationAttachPoints() {
        STNode leadingComma;
        this.startContext(ParserRuleContext.ANNOT_ATTACH_POINTS_LIST);
        ArrayList<STNode> attachPoints = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndAnnotAttachPointList(nextToken.kind)) {
            this.endContext();
            return STNodeFactory.createEmptyNodeList();
        }
        STNode attachPoint = this.parseAnnotationAttachPoint();
        attachPoints.add(attachPoint);
        nextToken = this.peek();
        while (!this.isEndAnnotAttachPointList(nextToken.kind) && (leadingComma = this.parseAttachPointEnd()) != null) {
            attachPoints.add(leadingComma);
            attachPoint = this.parseAnnotationAttachPoint();
            if (attachPoint == null) {
                attachPoint = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_ANNOTATION_ATTACH_POINT);
                attachPoints.add(attachPoint);
                break;
            }
            attachPoints.add(attachPoint);
            nextToken = this.peek();
        }
        this.endContext();
        return STNodeFactory.createNodeList(attachPoints);
    }

    private STNode parseAttachPointEnd() {
        switch (this.peek().kind) {
            case SEMICOLON_TOKEN: {
                return null;
            }
            case COMMA_TOKEN: {
                return this.consume();
            }
        }
        this.recover(this.peek(), ParserRuleContext.ATTACH_POINT_END, new Object[0]);
        return this.parseAttachPointEnd();
    }

    private boolean isEndAnnotAttachPointList(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case EOF_TOKEN: 
            case SEMICOLON_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseAnnotationAttachPoint() {
        switch (this.peek().kind) {
            case EOF_TOKEN: {
                return null;
            }
            case LISTENER_KEYWORD: 
            case CONST_KEYWORD: 
            case ANNOTATION_KEYWORD: 
            case EXTERNAL_KEYWORD: 
            case WORKER_KEYWORD: 
            case VAR_KEYWORD: 
            case SOURCE_KEYWORD: {
                STNode sourceKeyword = this.parseSourceKeyword();
                return this.parseAttachPointIdent(sourceKeyword);
            }
            case FUNCTION_KEYWORD: 
            case TYPE_KEYWORD: 
            case SERVICE_KEYWORD: 
            case CLASS_KEYWORD: 
            case RESOURCE_KEYWORD: 
            case OBJECT_KEYWORD: 
            case RECORD_KEYWORD: 
            case RETURN_KEYWORD: 
            case PARAMETER_KEYWORD: 
            case FIELD_KEYWORD: {
                STNode sourceKeyword = STNodeFactory.createEmptyNode();
                STToken firstIdent = this.consume();
                return this.parseDualAttachPointIdent(sourceKeyword, firstIdent);
            }
        }
        this.recover(this.peek(), ParserRuleContext.ATTACH_POINT, new Object[0]);
        return this.parseAnnotationAttachPoint();
    }

    private STNode parseSourceKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.SOURCE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.SOURCE_KEYWORD, new Object[0]);
        return this.parseSourceKeyword();
    }

    private STNode parseAttachPointIdent(STNode sourceKeyword) {
        switch (this.peek().kind) {
            case LISTENER_KEYWORD: 
            case CONST_KEYWORD: 
            case ANNOTATION_KEYWORD: 
            case EXTERNAL_KEYWORD: 
            case WORKER_KEYWORD: 
            case VAR_KEYWORD: {
                STToken firstIdent = this.consume();
                STNode secondIdent = STNodeFactory.createEmptyNode();
                return STNodeFactory.createAnnotationAttachPointNode(sourceKeyword, firstIdent, secondIdent);
            }
            case FUNCTION_KEYWORD: 
            case TYPE_KEYWORD: 
            case SERVICE_KEYWORD: 
            case CLASS_KEYWORD: 
            case RESOURCE_KEYWORD: 
            case OBJECT_KEYWORD: 
            case RECORD_KEYWORD: 
            case RETURN_KEYWORD: 
            case PARAMETER_KEYWORD: 
            case FIELD_KEYWORD: {
                STToken firstIdent = this.consume();
                return this.parseDualAttachPointIdent(sourceKeyword, firstIdent);
            }
        }
        this.recover(this.peek(), ParserRuleContext.ATTACH_POINT_IDENT, sourceKeyword);
        return this.parseAttachPointIdent(sourceKeyword);
    }

    private STNode parseDualAttachPointIdent(STNode sourceKeyword, STNode firstIdent) {
        STNode secondIdent;
        switch (firstIdent.kind) {
            case OBJECT_KEYWORD: {
                secondIdent = this.parseIdentAfterObjectIdent();
                break;
            }
            case RESOURCE_KEYWORD: {
                secondIdent = this.parseFunctionIdent();
                break;
            }
            case RECORD_KEYWORD: {
                secondIdent = this.parseFieldIdent();
                break;
            }
            default: {
                secondIdent = STNodeFactory.createEmptyNode();
            }
        }
        return STNodeFactory.createAnnotationAttachPointNode(sourceKeyword, firstIdent, secondIdent);
    }

    private STNode parseIdentAfterObjectIdent() {
        STToken token = this.peek();
        switch (token.kind) {
            case FUNCTION_KEYWORD: 
            case FIELD_KEYWORD: {
                return this.consume();
            }
        }
        this.recover(token, ParserRuleContext.IDENT_AFTER_OBJECT_IDENT, new Object[0]);
        return this.parseIdentAfterObjectIdent();
    }

    private STNode parseFunctionIdent() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FUNCTION_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FUNCTION_IDENT, new Object[0]);
        return this.parseFunctionIdent();
    }

    private STNode parseFieldIdent() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FIELD_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FIELD_IDENT, new Object[0]);
        return this.parseFieldIdent();
    }

    private STNode parseXMLNamespaceDeclaration(boolean isModuleVar) {
        this.startContext(ParserRuleContext.XML_NAMESPACE_DECLARATION);
        STNode xmlnsKeyword = this.parseXMLNSKeyword();
        STNode namespaceUri = this.parseSimpleConstExpr();
        while (!this.isValidXMLNameSpaceURI(namespaceUri)) {
            xmlnsKeyword = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(xmlnsKeyword, namespaceUri, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_XML_NAMESPACE_URI, new Object[0]);
            namespaceUri = this.parseSimpleConstExpr();
        }
        STNode xmlnsDecl = this.parseXMLDeclRhs(xmlnsKeyword, namespaceUri, isModuleVar);
        this.endContext();
        return xmlnsDecl;
    }

    private STNode parseXMLNSKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.XMLNS_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.XMLNS_KEYWORD, new Object[0]);
        return this.parseXMLNSKeyword();
    }

    private boolean isValidXMLNameSpaceURI(STNode expr) {
        switch (expr.kind) {
            case SIMPLE_NAME_REFERENCE: 
            case QUALIFIED_NAME_REFERENCE: 
            case STRING_LITERAL: {
                return true;
            }
        }
        return false;
    }

    private STNode parseSimpleConstExpr() {
        this.startContext(ParserRuleContext.CONSTANT_EXPRESSION);
        STNode expr = this.parseSimpleConstExprInternal();
        this.endContext();
        return expr;
    }

    private STNode parseSimpleConstExprInternal() {
        switch (this.peek().kind) {
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                return this.parseBasicLiteral();
            }
            case IDENTIFIER_TOKEN: {
                return this.parseQualifiedIdentifier(ParserRuleContext.VARIABLE_REF);
            }
            case PLUS_TOKEN: 
            case MINUS_TOKEN: {
                return this.parseSignedIntOrFloat();
            }
            case OPEN_PAREN_TOKEN: {
                return this.parseNilLiteral();
            }
        }
        STToken token = this.peek();
        this.recover(token, ParserRuleContext.CONSTANT_EXPRESSION_START, new Object[0]);
        return this.parseSimpleConstExprInternal();
    }

    private STNode parseXMLDeclRhs(STNode xmlnsKeyword, STNode namespaceUri, boolean isModuleVar) {
        STNode asKeyword = STNodeFactory.createEmptyNode();
        STNode namespacePrefix = STNodeFactory.createEmptyNode();
        switch (this.peek().kind) {
            case AS_KEYWORD: {
                asKeyword = this.parseAsKeyword();
                namespacePrefix = this.parseNamespacePrefix();
                break;
            }
            case SEMICOLON_TOKEN: {
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.XML_NAMESPACE_PREFIX_DECL, xmlnsKeyword, namespaceUri, isModuleVar);
                return this.parseXMLDeclRhs(xmlnsKeyword, namespaceUri, isModuleVar);
            }
        }
        STNode semicolon = this.parseSemicolon();
        if (isModuleVar) {
            return STNodeFactory.createModuleXMLNamespaceDeclarationNode(xmlnsKeyword, namespaceUri, asKeyword, namespacePrefix, semicolon);
        }
        return STNodeFactory.createXMLNamespaceDeclarationNode(xmlnsKeyword, namespaceUri, asKeyword, namespacePrefix, semicolon);
    }

    private STNode parseNamespacePrefix() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.NAMESPACE_PREFIX, new Object[0]);
        return this.parseNamespacePrefix();
    }

    private STNode parseNamedWorkerDeclaration(STNode annots, List<STNode> qualifiers) {
        this.startContext(ParserRuleContext.NAMED_WORKER_DECL);
        STNode transactionalKeyword = this.getTransactionalKeyword(qualifiers);
        STNode workerKeyword = this.parseWorkerKeyword();
        STNode workerName = this.parseWorkerName();
        STNode returnTypeDesc = this.parseReturnTypeDescriptor();
        STNode workerBody = this.parseBlockNode();
        this.endContext();
        return STNodeFactory.createNamedWorkerDeclarationNode(annots, transactionalKeyword, workerKeyword, workerName, returnTypeDesc, workerBody);
    }

    private STNode getTransactionalKeyword(List<STNode> qualifierList) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (qualifier.kind == SyntaxKind.TRANSACTIONAL_KEYWORD) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) {
                this.addInvalidNodeToNextToken(qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
                continue;
            }
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        STNode transactionalKeyword = validatedList.isEmpty() ? STNodeFactory.createEmptyNode() : (STNode)validatedList.get(0);
        return transactionalKeyword;
    }

    private STNode parseReturnTypeDescriptor() {
        STToken token = this.peek();
        if (token.kind != SyntaxKind.RETURNS_KEYWORD) {
            return STNodeFactory.createEmptyNode();
        }
        STToken returnsKeyword = this.consume();
        STNode annot = this.parseOptionalAnnotations();
        STNode type = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_RETURN_TYPE_DESC);
        return STNodeFactory.createReturnTypeDescriptorNode(returnsKeyword, annot, type);
    }

    private STNode parseWorkerKeyword() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.WORKER_KEYWORD) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.WORKER_KEYWORD, new Object[0]);
        return this.parseWorkerKeyword();
    }

    private STNode parseWorkerName() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.WORKER_NAME, new Object[0]);
        return this.parseWorkerName();
    }

    private STNode parseLockStatement() {
        this.startContext(ParserRuleContext.LOCK_STMT);
        STNode lockKeyword = this.parseLockKeyword();
        STNode blockStatement = this.parseBlockNode();
        this.endContext();
        STNode onFailClause = this.parseOptionalOnFailClause();
        return STNodeFactory.createLockStatementNode(lockKeyword, blockStatement, onFailClause);
    }

    private STNode parseLockKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.LOCK_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.LOCK_KEYWORD, new Object[0]);
        return this.parseLockKeyword();
    }

    private STNode parseUnionTypeDescriptor(STNode leftTypeDesc, ParserRuleContext context, boolean isTypedBindingPattern) {
        STNode pipeToken = this.parsePipeToken();
        STNode rightTypeDesc = this.parseTypeDescriptor(context, isTypedBindingPattern, false);
        return this.createUnionTypeDesc(leftTypeDesc, pipeToken, rightTypeDesc);
    }

    private STNode createUnionTypeDesc(STNode leftTypeDesc, STNode pipeToken, STNode rightTypeDesc) {
        leftTypeDesc = this.validateForUsageOfVar(leftTypeDesc);
        rightTypeDesc = this.validateForUsageOfVar(rightTypeDesc);
        return STNodeFactory.createUnionTypeDescriptorNode(leftTypeDesc, pipeToken, rightTypeDesc);
    }

    private STNode parsePipeToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.PIPE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.PIPE, new Object[0]);
        return this.parsePipeToken();
    }

    private boolean isTypeStartingToken(SyntaxKind nodeKind) {
        switch (nodeKind) {
            case FUNCTION_KEYWORD: 
            case SERVICE_KEYWORD: 
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: 
            case DISTINCT_KEYWORD: 
            case CLIENT_KEYWORD: 
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACKET_TOKEN: 
            case ERROR_KEYWORD: 
            case ABSTRACT_KEYWORD: 
            case OBJECT_KEYWORD: 
            case OPEN_PAREN_TOKEN: 
            case RECORD_KEYWORD: 
            case MAP_KEYWORD: 
            case FUTURE_KEYWORD: 
            case TYPEDESC_KEYWORD: 
            case STREAM_KEYWORD: 
            case TABLE_KEYWORD: {
                return true;
            }
        }
        if (this.isSingletonTypeDescStart(nodeKind, true)) {
            return true;
        }
        return BallerinaParser.isSimpleType(nodeKind);
    }

    static boolean isSimpleType(SyntaxKind nodeKind) {
        switch (nodeKind) {
            case SERVICE_KEYWORD: 
            case DISTINCT_KEYWORD: 
            case READONLY_KEYWORD: 
            case ERROR_KEYWORD: 
            case TYPEDESC_KEYWORD: 
            case XML_KEYWORD: 
            case STREAM_KEYWORD: 
            case STRING_KEYWORD: 
            case VAR_KEYWORD: 
            case INT_KEYWORD: 
            case FLOAT_KEYWORD: 
            case DECIMAL_KEYWORD: 
            case BOOLEAN_KEYWORD: 
            case BYTE_KEYWORD: 
            case JSON_KEYWORD: 
            case HANDLE_KEYWORD: 
            case ANY_KEYWORD: 
            case ANYDATA_KEYWORD: 
            case NEVER_KEYWORD: {
                return true;
            }
        }
        return false;
    }

    private SyntaxKind getTypeSyntaxKind(SyntaxKind typeKeyword) {
        switch (typeKeyword) {
            case INT_KEYWORD: {
                return SyntaxKind.INT_TYPE_DESC;
            }
            case FLOAT_KEYWORD: {
                return SyntaxKind.FLOAT_TYPE_DESC;
            }
            case DECIMAL_KEYWORD: {
                return SyntaxKind.DECIMAL_TYPE_DESC;
            }
            case BOOLEAN_KEYWORD: {
                return SyntaxKind.BOOLEAN_TYPE_DESC;
            }
            case STRING_KEYWORD: {
                return SyntaxKind.STRING_TYPE_DESC;
            }
            case BYTE_KEYWORD: {
                return SyntaxKind.BYTE_TYPE_DESC;
            }
            case XML_KEYWORD: {
                return SyntaxKind.XML_TYPE_DESC;
            }
            case JSON_KEYWORD: {
                return SyntaxKind.JSON_TYPE_DESC;
            }
            case HANDLE_KEYWORD: {
                return SyntaxKind.HANDLE_TYPE_DESC;
            }
            case ANY_KEYWORD: {
                return SyntaxKind.ANY_TYPE_DESC;
            }
            case ANYDATA_KEYWORD: {
                return SyntaxKind.ANYDATA_TYPE_DESC;
            }
            case READONLY_KEYWORD: {
                return SyntaxKind.READONLY_TYPE_DESC;
            }
            case NEVER_KEYWORD: {
                return SyntaxKind.NEVER_TYPE_DESC;
            }
            case SERVICE_KEYWORD: {
                return SyntaxKind.SERVICE_TYPE_DESC;
            }
            case VAR_KEYWORD: {
                return SyntaxKind.VAR_TYPE_DESC;
            }
            case ERROR_KEYWORD: {
                return SyntaxKind.ERROR_TYPE_DESC;
            }
        }
        return SyntaxKind.TYPE_REFERENCE;
    }

    private STNode parseForkKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FORK_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FORK_KEYWORD, new Object[0]);
        return this.parseForkKeyword();
    }

    private STNode parseForkStatement() {
        STNode stmt;
        this.startContext(ParserRuleContext.FORK_STMT);
        STNode forkKeyword = this.parseForkKeyword();
        STNode openBrace = this.parseOpenBrace();
        ArrayList<STNode> workers = new ArrayList<STNode>();
        block3: while (!this.isEndOfStatements() && (stmt = this.parseStatement()) != null) {
            if (stmt.kind == SyntaxKind.LOCAL_TYPE_DEFINITION_STATEMENT) {
                this.addInvalidNodeToNextToken(stmt, DiagnosticErrorCode.ERROR_LOCAL_TYPE_DEFINITION_NOT_ALLOWED, new Object[0]);
                continue;
            }
            switch (stmt.kind) {
                case NAMED_WORKER_DECLARATION: {
                    workers.add(stmt);
                    continue block3;
                }
            }
            if (workers.isEmpty()) {
                openBrace = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(openBrace, stmt, (DiagnosticCode)DiagnosticErrorCode.ERROR_ONLY_NAMED_WORKERS_ALLOWED_HERE, new Object[0]);
                continue;
            }
            this.updateLastNodeInListWithInvalidNode(workers, stmt, DiagnosticErrorCode.ERROR_ONLY_NAMED_WORKERS_ALLOWED_HERE, new Object[0]);
        }
        STNode namedWorkerDeclarations = STNodeFactory.createNodeList(workers);
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        STNode forkStmt = STNodeFactory.createForkStatementNode(forkKeyword, openBrace, namedWorkerDeclarations, closeBrace);
        if (this.isNodeListEmpty(namedWorkerDeclarations)) {
            return SyntaxErrors.addDiagnostic(forkStmt, DiagnosticErrorCode.ERROR_MISSING_NAMED_WORKER_DECLARATION_IN_FORK_STMT, new Object[0]);
        }
        return forkStmt;
    }

    private STNode parseTrapExpression(boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        STNode trapKeyword = this.parseTrapKeyword();
        STNode expr = this.parseExpression(OperatorPrecedence.EXPRESSION_ACTION, isRhsExpr, allowActions, isInConditionalExpr);
        if (this.isAction(expr)) {
            return STNodeFactory.createTrapExpressionNode(SyntaxKind.TRAP_ACTION, trapKeyword, expr);
        }
        return STNodeFactory.createTrapExpressionNode(SyntaxKind.TRAP_EXPRESSION, trapKeyword, expr);
    }

    private STNode parseTrapKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.TRAP_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.TRAP_KEYWORD, new Object[0]);
        return this.parseTrapKeyword();
    }

    private STNode parseListConstructorExpr() {
        this.startContext(ParserRuleContext.LIST_CONSTRUCTOR);
        STNode openBracket = this.parseOpenBracket();
        STNode expressions = this.parseOptionalExpressionsList();
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        return STNodeFactory.createListConstructorExpressionNode(openBracket, expressions, closeBracket);
    }

    private STNode parseOptionalExpressionsList() {
        ArrayList<STNode> expressions = new ArrayList<STNode>();
        if (this.isEndOfListConstructor(this.peek().kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        STNode expr = this.parseExpression();
        expressions.add(expr);
        return this.parseOptionalExpressionsList(expressions);
    }

    private STNode parseOptionalExpressionsList(List<STNode> expressions) {
        STNode listConstructorMemberEnd;
        while (!this.isEndOfListConstructor(this.peek().kind) && (listConstructorMemberEnd = this.parseListConstructorMemberEnd()) != null) {
            expressions.add(listConstructorMemberEnd);
            STNode expr = this.parseExpression();
            expressions.add(expr);
        }
        return STNodeFactory.createNodeList(expressions);
    }

    private boolean isEndOfListConstructor(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case EOF_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseListConstructorMemberEnd() {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case CLOSE_BRACKET_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.LIST_CONSTRUCTOR_MEMBER_END, new Object[0]);
        return this.parseListConstructorMemberEnd();
    }

    private STNode parseForEachStatement() {
        this.startContext(ParserRuleContext.FOREACH_STMT);
        STNode forEachKeyword = this.parseForEachKeyword();
        STNode typedBindingPattern = this.parseTypedBindingPattern(ParserRuleContext.FOREACH_STMT);
        STNode inKeyword = this.parseInKeyword();
        STNode actionOrExpr = this.parseActionOrExpression();
        STNode blockStatement = this.parseBlockNode();
        this.endContext();
        STNode onFailClause = this.parseOptionalOnFailClause();
        return STNodeFactory.createForEachStatementNode(forEachKeyword, typedBindingPattern, inKeyword, actionOrExpr, blockStatement, onFailClause);
    }

    private STNode parseForEachKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FOREACH_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FOREACH_KEYWORD, new Object[0]);
        return this.parseForEachKeyword();
    }

    private STNode parseInKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IN_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.IN_KEYWORD, new Object[0]);
        return this.parseInKeyword();
    }

    private STNode parseTypeCastExpr(boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        this.startContext(ParserRuleContext.TYPE_CAST);
        STNode ltToken = this.parseLTToken();
        STNode typeCastParam = this.parseTypeCastParam();
        STNode gtToken = this.parseGTToken();
        this.endContext();
        STNode expression = this.parseExpression(OperatorPrecedence.EXPRESSION_ACTION, isRhsExpr, allowActions, isInConditionalExpr);
        return STNodeFactory.createTypeCastExpressionNode(ltToken, typeCastParam, gtToken, expression);
    }

    private STNode parseTypeCastParam() {
        STNode type;
        STNode annot;
        STToken token = this.peek();
        switch (token.kind) {
            case AT_TOKEN: {
                annot = this.parseOptionalAnnotations();
                token = this.peek();
                if (this.isTypeStartingToken(token.kind)) {
                    type = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_ANGLE_BRACKETS);
                    break;
                }
                type = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                annot = STNodeFactory.createEmptyNode();
                type = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_ANGLE_BRACKETS);
            }
        }
        return STNodeFactory.createTypeCastParamNode(this.getAnnotations(annot), type);
    }

    private STNode parseTableConstructorExprRhs(STNode tableKeyword, STNode keySpecifier) {
        this.switchContext(ParserRuleContext.TABLE_CONSTRUCTOR);
        STNode openBracket = this.parseOpenBracket();
        STNode rowList = this.parseRowList();
        STNode closeBracket = this.parseCloseBracket();
        return STNodeFactory.createTableConstructorExpressionNode(tableKeyword, keySpecifier, openBracket, rowList, closeBracket);
    }

    private STNode parseTableKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.TABLE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.TABLE_KEYWORD, new Object[0]);
        return this.parseTableKeyword();
    }

    private STNode parseRowList() {
        STNode rowEnd;
        STToken nextToken = this.peek();
        if (this.isEndOfTableRowList(nextToken.kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        ArrayList<STNode> mappings = new ArrayList<STNode>();
        STNode mapExpr = this.parseMappingConstructorExpr();
        mappings.add(mapExpr);
        nextToken = this.peek();
        while (!this.isEndOfTableRowList(nextToken.kind) && (rowEnd = this.parseTableRowEnd()) != null) {
            mappings.add(rowEnd);
            mapExpr = this.parseMappingConstructorExpr();
            mappings.add(mapExpr);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(mappings);
    }

    private boolean isEndOfTableRowList(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case EOF_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                return true;
            }
            case OPEN_BRACE_TOKEN: 
            case COMMA_TOKEN: {
                return false;
            }
        }
        return this.isEndOfMappingConstructor(tokenKind);
    }

    private STNode parseTableRowEnd() {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case EOF_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.TABLE_ROW_END, new Object[0]);
        return this.parseTableRowEnd();
    }

    private STNode parseKeySpecifier() {
        this.startContext(ParserRuleContext.KEY_SPECIFIER);
        STNode keyKeyword = this.parseKeyKeyword();
        STNode openParen = this.parseOpenParenthesis(ParserRuleContext.OPEN_PARENTHESIS);
        STNode fieldNames = this.parseFieldNames();
        STNode closeParen = this.parseCloseParenthesis();
        this.endContext();
        return STNodeFactory.createKeySpecifierNode(keyKeyword, openParen, fieldNames, closeParen);
    }

    private STNode parseKeyKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.KEY_KEYWORD) {
            return this.consume();
        }
        if (BallerinaParser.isKeyKeyword(token)) {
            return this.getKeyKeyword(this.consume());
        }
        this.recover(token, ParserRuleContext.KEY_KEYWORD, new Object[0]);
        return this.parseKeyKeyword();
    }

    static boolean isKeyKeyword(STToken token) {
        return token.kind == SyntaxKind.IDENTIFIER_TOKEN && "key".equals(token.text());
    }

    private STNode getKeyKeyword(STToken token) {
        return STNodeFactory.createToken(SyntaxKind.KEY_KEYWORD, token.leadingMinutiae(), token.trailingMinutiae(), token.diagnostics());
    }

    private STNode parseFieldNames() {
        STToken nextToken = this.peek();
        if (this.isEndOfFieldNamesList(nextToken.kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        ArrayList<STNode> fieldNames = new ArrayList<STNode>();
        STNode fieldName = this.parseVariableName();
        fieldNames.add(fieldName);
        nextToken = this.peek();
        while (!this.isEndOfFieldNamesList(nextToken.kind)) {
            STNode leadingComma = this.parseComma();
            fieldNames.add(leadingComma);
            fieldName = this.parseVariableName();
            fieldNames.add(fieldName);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(fieldNames);
    }

    private boolean isEndOfFieldNamesList(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case IDENTIFIER_TOKEN: 
            case COMMA_TOKEN: {
                return false;
            }
        }
        return true;
    }

    private STNode parseErrorTypeDescriptor() {
        STNode errorKeywordToken = this.parseErrorKeyword();
        return this.parseErrorTypeDescriptor(errorKeywordToken);
    }

    private STNode parseErrorTypeDescriptor(STNode errorKeywordToken) {
        STToken nextToken = this.peek();
        STNode errorTypeParamsNode = nextToken.kind == SyntaxKind.LT_TOKEN ? this.parseErrorTypeParamsNode() : STNodeFactory.createEmptyNode();
        return STNodeFactory.createErrorTypeDescriptorNode(errorKeywordToken, errorTypeParamsNode);
    }

    private STNode parseErrorTypeParamsNode() {
        STNode ltToken = this.parseLTToken();
        STToken nextToken = this.peek();
        STNode parameter = nextToken.kind == SyntaxKind.ASTERISK_TOKEN ? this.consume() : this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_ANGLE_BRACKETS);
        STNode gtToken = this.parseGTToken();
        return STNodeFactory.createErrorTypeParamsNode(ltToken, parameter, gtToken);
    }

    private STNode parseErrorKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ERROR_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ERROR_KEYWORD, new Object[0]);
        return this.parseErrorKeyword();
    }

    private STNode parseTypedescTypeDescriptor() {
        STNode typedescKeywordToken = this.parseTypedescKeyword();
        STToken nextToken = this.peek();
        STNode typedescTypeParamsNode = nextToken.kind == SyntaxKind.LT_TOKEN ? this.parseTypeParameter() : STNodeFactory.createEmptyNode();
        return STNodeFactory.createTypedescTypeDescriptorNode(typedescKeywordToken, typedescTypeParamsNode);
    }

    private STNode parseTypedescKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.TYPEDESC_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.TYPEDESC_KEYWORD, new Object[0]);
        return this.parseTypedescKeyword();
    }

    private STNode parseStreamTypeDescriptor() {
        STNode streamKeywordToken = this.parseStreamKeyword();
        STToken nextToken = this.peek();
        STNode streamTypeParamsNode = nextToken.kind == SyntaxKind.LT_TOKEN ? this.parseStreamTypeParamsNode() : STNodeFactory.createEmptyNode();
        return STNodeFactory.createStreamTypeDescriptorNode(streamKeywordToken, streamTypeParamsNode);
    }

    private STNode parseXmlTypeDescriptor() {
        STNode xmlKeywordToken = this.parseXMLKeyword();
        STToken nextToken = this.peek();
        STNode typedescTypeParamsNode = nextToken.kind == SyntaxKind.LT_TOKEN ? this.parseTypeParameter() : STNodeFactory.createEmptyNode();
        return STNodeFactory.createXmlTypeDescriptorNode(xmlKeywordToken, typedescTypeParamsNode);
    }

    private STNode parseStreamTypeParamsNode() {
        STNode ltToken = this.parseLTToken();
        this.startContext(ParserRuleContext.TYPE_DESC_IN_STREAM_TYPE_DESC);
        STNode leftTypeDescNode = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_STREAM_TYPE_DESC);
        STNode streamTypedesc = this.parseStreamTypeParamsNode(ltToken, leftTypeDescNode);
        this.endContext();
        return streamTypedesc;
    }

    private STNode parseStreamTypeParamsNode(STNode ltToken, STNode leftTypeDescNode) {
        STNode rightTypeDescNode;
        STNode commaToken;
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                commaToken = this.parseComma();
                rightTypeDescNode = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_STREAM_TYPE_DESC);
                break;
            }
            case GT_TOKEN: {
                commaToken = STNodeFactory.createEmptyNode();
                rightTypeDescNode = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.STREAM_TYPE_FIRST_PARAM_RHS, ltToken, leftTypeDescNode);
                return this.parseStreamTypeParamsNode(ltToken, leftTypeDescNode);
            }
        }
        STNode gtToken = this.parseGTToken();
        return STNodeFactory.createStreamTypeParamsNode(ltToken, leftTypeDescNode, commaToken, rightTypeDescNode, gtToken);
    }

    private STNode parseStreamKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.STREAM_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.STREAM_KEYWORD, new Object[0]);
        return this.parseStreamKeyword();
    }

    private STNode parseLetExpression(boolean isRhsExpr) {
        STNode letKeyword = this.parseLetKeyword();
        STNode letVarDeclarations = this.parseLetVarDeclarations(ParserRuleContext.LET_EXPR_LET_VAR_DECL, isRhsExpr);
        STNode inKeyword = this.parseInKeyword();
        letKeyword = this.cloneWithDiagnosticIfListEmpty(letVarDeclarations, letKeyword, DiagnosticErrorCode.ERROR_MISSING_LET_VARIABLE_DECLARATION);
        STNode expression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        return STNodeFactory.createLetExpressionNode(letKeyword, letVarDeclarations, inKeyword, expression);
    }

    private STNode parseLetKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.LET_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.LET_KEYWORD, new Object[0]);
        return this.parseLetKeyword();
    }

    private STNode parseLetVarDeclarations(ParserRuleContext context, boolean isRhsExpr) {
        this.startContext(context);
        ArrayList<STNode> varDecls = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndOfLetVarDeclarations(nextToken.kind)) {
            this.endContext();
            return STNodeFactory.createEmptyNodeList();
        }
        STNode varDec = this.parseLetVarDecl(isRhsExpr);
        varDecls.add(varDec);
        nextToken = this.peek();
        while (!this.isEndOfLetVarDeclarations(nextToken.kind)) {
            STNode leadingComma = this.parseComma();
            varDecls.add(leadingComma);
            varDec = this.parseLetVarDecl(isRhsExpr);
            varDecls.add(varDec);
            nextToken = this.peek();
        }
        this.endContext();
        return STNodeFactory.createNodeList(varDecls);
    }

    private boolean isEndOfLetVarDeclarations(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case AT_TOKEN: 
            case COMMA_TOKEN: {
                return false;
            }
            case IN_KEYWORD: {
                return true;
            }
        }
        return !this.isTypeStartingToken(tokenKind);
    }

    private STNode parseLetVarDecl(boolean isRhsExpr) {
        STNode annot = this.parseOptionalAnnotations();
        STNode typedBindingPattern = this.parseTypedBindingPattern(ParserRuleContext.LET_EXPR_LET_VAR_DECL);
        STNode assign = this.parseAssignOp();
        STNode expression = this.parseExpression(OperatorPrecedence.ANON_FUNC_OR_LET, isRhsExpr, false);
        return STNodeFactory.createLetVariableDeclarationNode(annot, typedBindingPattern, assign, expression);
    }

    private STNode parseTemplateExpression() {
        STNode type = STNodeFactory.createEmptyNode();
        STNode startingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_START);
        STNode content = this.parseTemplateContent();
        STNode endingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_START);
        return STNodeFactory.createTemplateExpressionNode(SyntaxKind.RAW_TEMPLATE_EXPRESSION, type, startingBackTick, content, endingBackTick);
    }

    private STNode parseTemplateContent() {
        ArrayList<STNode> items = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (!this.isEndOfBacktickContent(nextToken.kind)) {
            STNode contentItem = this.parseTemplateItem();
            items.add(contentItem);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(items);
    }

    private boolean isEndOfBacktickContent(SyntaxKind kind) {
        switch (kind) {
            case EOF_TOKEN: 
            case BACKTICK_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseTemplateItem() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.INTERPOLATION_START_TOKEN) {
            return this.parseInterpolation();
        }
        return this.consume();
    }

    private STNode parseStringTemplateExpression() {
        STNode type = this.parseStringKeyword();
        STNode startingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_START);
        STNode content = this.parseTemplateContent();
        STNode endingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_END);
        return STNodeFactory.createTemplateExpressionNode(SyntaxKind.STRING_TEMPLATE_EXPRESSION, type, startingBackTick, content, endingBackTick);
    }

    private STNode parseStringKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.STRING_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.STRING_KEYWORD, new Object[0]);
        return this.parseStringKeyword();
    }

    private STNode parseXMLTemplateExpression() {
        STNode xmlKeyword = this.parseXMLKeyword();
        STNode startingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_START);
        STNode content = this.parseTemplateContentAsXML();
        STNode endingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_END);
        return STNodeFactory.createTemplateExpressionNode(SyntaxKind.XML_TEMPLATE_EXPRESSION, xmlKeyword, startingBackTick, content, endingBackTick);
    }

    private STNode parseXMLKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.XML_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.XML_KEYWORD, new Object[0]);
        return this.parseXMLKeyword();
    }

    private STNode parseTemplateContentAsXML() {
        ArrayDeque<STNode> expressions = new ArrayDeque<STNode>();
        StringBuilder xmlStringBuilder = new StringBuilder();
        STToken nextToken = this.peek();
        while (!this.isEndOfBacktickContent(nextToken.kind)) {
            STNode contentItem = this.parseTemplateItem();
            if (contentItem.kind == SyntaxKind.TEMPLATE_STRING) {
                xmlStringBuilder.append(((STToken)contentItem).text());
            } else {
                xmlStringBuilder.append("${}");
                expressions.add(contentItem);
            }
            nextToken = this.peek();
        }
        CharReader charReader = CharReader.from(xmlStringBuilder.toString());
        TokenReader tokenReader = new TokenReader(new XMLLexer(charReader));
        XMLParser xmlParser = new XMLParser((AbstractTokenReader)tokenReader, expressions);
        return xmlParser.parse();
    }

    private STNode parseInterpolation() {
        this.startContext(ParserRuleContext.INTERPOLATION);
        STNode interpolStart = this.parseInterpolationStart();
        STNode expr = this.parseExpression();
        while (true) {
            STToken nextToken = this.peek();
            if (nextToken.kind == SyntaxKind.EOF_TOKEN || nextToken.kind == SyntaxKind.CLOSE_BRACE_TOKEN) break;
            nextToken = this.consume();
            expr = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(expr, (STNode)nextToken, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_TOKEN, nextToken.text());
        }
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createInterpolationNode(interpolStart, expr, closeBrace);
    }

    private STNode parseInterpolationStart() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.INTERPOLATION_START_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.INTERPOLATION_START_TOKEN, new Object[0]);
        return this.parseInterpolationStart();
    }

    private STNode parseBacktickToken(ParserRuleContext ctx) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.BACKTICK_TOKEN) {
            return this.consume();
        }
        this.recover(token, ctx, new Object[0]);
        return this.parseBacktickToken(ctx);
    }

    private STNode parseTableTypeDescriptor() {
        STNode keyConstraintNode;
        STNode tableKeywordToken = this.parseTableKeyword();
        STNode rowTypeParameterNode = this.parseRowTypeParameter();
        STToken nextToken = this.peek();
        if (BallerinaParser.isKeyKeyword(nextToken)) {
            STNode keyKeywordToken = this.getKeyKeyword(this.consume());
            keyConstraintNode = this.parseKeyConstraint(keyKeywordToken);
        } else {
            keyConstraintNode = STNodeFactory.createEmptyNode();
        }
        return STNodeFactory.createTableTypeDescriptorNode(tableKeywordToken, rowTypeParameterNode, keyConstraintNode);
    }

    private STNode parseRowTypeParameter() {
        this.startContext(ParserRuleContext.ROW_TYPE_PARAM);
        STNode rowTypeParameterNode = this.parseTypeParameter();
        this.endContext();
        return rowTypeParameterNode;
    }

    private STNode parseTypeParameter() {
        STNode ltToken = this.parseLTToken();
        STNode typeNode = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_ANGLE_BRACKETS);
        STNode gtToken = this.parseGTToken();
        return STNodeFactory.createTypeParameterNode(ltToken, typeNode, gtToken);
    }

    private STNode parseKeyConstraint(STNode keyKeywordToken) {
        switch (this.peek().kind) {
            case OPEN_PAREN_TOKEN: {
                return this.parseKeySpecifier(keyKeywordToken);
            }
            case LT_TOKEN: {
                return this.parseKeyTypeConstraint(keyKeywordToken);
            }
        }
        this.recover(this.peek(), ParserRuleContext.KEY_CONSTRAINTS_RHS, keyKeywordToken);
        return this.parseKeyConstraint(keyKeywordToken);
    }

    private STNode parseKeySpecifier(STNode keyKeywordToken) {
        this.startContext(ParserRuleContext.KEY_SPECIFIER);
        STNode openParenToken = this.parseOpenParenthesis(ParserRuleContext.OPEN_PARENTHESIS);
        STNode fieldNamesNode = this.parseFieldNames();
        STNode closeParenToken = this.parseCloseParenthesis();
        this.endContext();
        return STNodeFactory.createKeySpecifierNode(keyKeywordToken, openParenToken, fieldNamesNode, closeParenToken);
    }

    private STNode parseKeyTypeConstraint(STNode keyKeywordToken) {
        STNode typeParameterNode = this.parseTypeParameter();
        return STNodeFactory.createKeyTypeConstraintNode(keyKeywordToken, typeParameterNode);
    }

    private STNode parseFunctionTypeDesc(List<STNode> qualifiers) {
        this.startContext(ParserRuleContext.FUNC_TYPE_DESC);
        STNode qualifierList = this.createFuncTypeQualNodeList(qualifiers);
        STNode functionKeyword = this.parseFunctionKeyword();
        STNode signature = this.parseFuncSignature(true);
        this.endContext();
        return STNodeFactory.createFunctionTypeDescriptorNode(qualifierList, functionKeyword, signature);
    }

    private STNode createFuncTypeQualNodeList(List<STNode> qualifierList) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (this.isRegularFuncQualifier(qualifier.kind)) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) {
                this.addInvalidNodeToNextToken(qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
                continue;
            }
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        return STNodeFactory.createNodeList(validatedList);
    }

    private boolean isRegularFuncQualifier(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: {
                return true;
            }
        }
        return false;
    }

    private STNode parseExplicitFunctionExpression(STNode annots, List<STNode> qualifiers, boolean isRhsExpr) {
        this.startContext(ParserRuleContext.ANON_FUNC_EXPRESSION);
        STNode qualifierList = this.createFuncTypeQualNodeList(qualifiers);
        STNode funcKeyword = this.parseFunctionKeyword();
        STNode funcSignature = this.parseFuncSignature(false);
        STNode funcBody = this.parseAnonFuncBody(isRhsExpr);
        return STNodeFactory.createExplicitAnonymousFunctionExpressionNode(annots, qualifierList, funcKeyword, funcSignature, funcBody);
    }

    private STNode parseAnonFuncBody(boolean isRhsExpr) {
        switch (this.peek().kind) {
            case EOF_TOKEN: 
            case OPEN_BRACE_TOKEN: {
                STNode body = this.parseFunctionBodyBlock(true);
                this.endContext();
                return body;
            }
            case RIGHT_DOUBLE_ARROW_TOKEN: {
                this.endContext();
                return this.parseExpressionFuncBody(true, isRhsExpr);
            }
        }
        this.recover(this.peek(), ParserRuleContext.ANON_FUNC_BODY, isRhsExpr);
        return this.parseAnonFuncBody(isRhsExpr);
    }

    private STNode parseExpressionFuncBody(boolean isAnon, boolean isRhsExpr) {
        STNode rightDoubleArrow = this.parseDoubleRightArrow();
        STNode expression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        STNode semiColon = isAnon ? STNodeFactory.createEmptyNode() : this.parseSemicolon();
        return STNodeFactory.createExpressionFunctionBodyNode(rightDoubleArrow, expression, semiColon);
    }

    private STNode parseDoubleRightArrow() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.EXPR_FUNC_BODY_START, new Object[0]);
        return this.parseDoubleRightArrow();
    }

    private STNode parseImplicitAnonFunc(STNode params, boolean isRhsExpr) {
        switch (params.kind) {
            case SIMPLE_NAME_REFERENCE: 
            case INFER_PARAM_LIST: {
                break;
            }
            case BRACED_EXPRESSION: {
                params = this.getAnonFuncParam((STBracedExpressionNode)params);
                break;
            }
            default: {
                STToken syntheticParam = STNodeFactory.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
                syntheticParam = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(syntheticParam, params, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_PARAM_LIST_IN_INFER_ANONYMOUS_FUNCTION_EXPR, new Object[0]);
                params = STNodeFactory.createSimpleNameReferenceNode(syntheticParam);
            }
        }
        STNode rightDoubleArrow = this.parseDoubleRightArrow();
        STNode expression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        return STNodeFactory.createImplicitAnonymousFunctionExpressionNode(params, rightDoubleArrow, expression);
    }

    private STNode getAnonFuncParam(STBracedExpressionNode params) {
        ArrayList<STNode> paramList = new ArrayList<STNode>();
        paramList.add(params.expression);
        return STNodeFactory.createImplicitAnonymousFunctionParameters(params.openParen, STNodeFactory.createNodeList(paramList), params.closeParen);
    }

    private STNode parseImplicitAnonFunc(STNode openParen, STNode firstParam, boolean isRhsExpr) {
        STNode paramEnd;
        ArrayList<STNode> paramList = new ArrayList<STNode>();
        paramList.add(firstParam);
        STToken nextToken = this.peek();
        while (!this.isEndOfAnonFuncParametersList(nextToken.kind) && (paramEnd = this.parseImplicitAnonFuncParamEnd()) != null) {
            paramList.add(paramEnd);
            STNode param = this.parseIdentifier(ParserRuleContext.IMPLICIT_ANON_FUNC_PARAM);
            param = STNodeFactory.createSimpleNameReferenceNode(param);
            paramList.add(param);
            nextToken = this.peek();
        }
        STNode params = STNodeFactory.createNodeList(paramList);
        STNode closeParen = this.parseCloseParenthesis();
        this.endContext();
        STNode inferedParams = STNodeFactory.createImplicitAnonymousFunctionParameters(openParen, params, closeParen);
        return this.parseImplicitAnonFunc(inferedParams, isRhsExpr);
    }

    private STNode parseImplicitAnonFuncParamEnd() {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case CLOSE_PAREN_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.ANON_FUNC_PARAM_RHS, new Object[0]);
        return this.parseImplicitAnonFuncParamEnd();
    }

    private boolean isEndOfAnonFuncParametersList(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case EOF_TOKEN: 
            case TYPE_KEYWORD: 
            case LISTENER_KEYWORD: 
            case SEMICOLON_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case CLOSE_PAREN_TOKEN: 
            case RETURNS_KEYWORD: 
            case RIGHT_DOUBLE_ARROW_TOKEN: 
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACKET_TOKEN: 
            case IF_KEYWORD: 
            case WHILE_KEYWORD: 
            case DO_KEYWORD: {
                return true;
            }
        }
        return false;
    }

    private STNode parseTupleTypeDesc() {
        STNode openBracket = this.parseOpenBracket();
        this.startContext(ParserRuleContext.TYPE_DESC_IN_TUPLE);
        STNode memberTypeDesc = this.parseTupleMemberTypeDescList();
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        openBracket = this.cloneWithDiagnosticIfListEmpty(memberTypeDesc, openBracket, DiagnosticErrorCode.ERROR_MISSING_TYPE_DESC);
        return STNodeFactory.createTupleTypeDescriptorNode(openBracket, memberTypeDesc, closeBracket);
    }

    private STNode parseTupleMemberTypeDescList() {
        ArrayList<STNode> typeDescList = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndOfTypeList(nextToken.kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        STNode typeDesc = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
        return this.parseTupleTypeMembers(typeDesc, typeDescList);
    }

    private STNode parseTupleTypeMembers(STNode typeDesc, List<STNode> typeDescList) {
        STNode tupleMemberRhs;
        STToken nextToken = this.peek();
        while (!this.isEndOfTypeList(nextToken.kind) && (tupleMemberRhs = this.parseTupleMemberRhs()) != null) {
            if (tupleMemberRhs.kind == SyntaxKind.ELLIPSIS_TOKEN) {
                typeDesc = STNodeFactory.createRestDescriptorNode(typeDesc, tupleMemberRhs);
                break;
            }
            typeDescList.add(typeDesc);
            typeDescList.add(tupleMemberRhs);
            typeDesc = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
            nextToken = this.peek();
        }
        typeDescList.add(typeDesc);
        return STNodeFactory.createNodeList(typeDescList);
    }

    private STNode parseTupleMemberRhs() {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case CLOSE_BRACKET_TOKEN: {
                return null;
            }
            case ELLIPSIS_TOKEN: {
                return this.parseEllipsis();
            }
        }
        this.recover(this.peek(), ParserRuleContext.TYPE_DESC_IN_TUPLE_RHS, new Object[0]);
        return this.parseTupleMemberRhs();
    }

    private boolean isEndOfTypeList(SyntaxKind nextTokenKind) {
        switch (nextTokenKind) {
            case EOF_TOKEN: 
            case EQUAL_TOKEN: 
            case SEMICOLON_TOKEN: 
            case CLOSE_PAREN_TOKEN: 
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseTableConstructorOrQuery(boolean isRhsExpr) {
        this.startContext(ParserRuleContext.TABLE_CONSTRUCTOR_OR_QUERY_EXPRESSION);
        STNode tableOrQueryExpr = this.parseTableConstructorOrQueryInternal(isRhsExpr);
        this.endContext();
        return tableOrQueryExpr;
    }

    private STNode parseTableConstructorOrQueryInternal(boolean isRhsExpr) {
        switch (this.peek().kind) {
            case FROM_KEYWORD: {
                STNode queryConstructType = STNodeFactory.createEmptyNode();
                return this.parseQueryExprRhs(queryConstructType, isRhsExpr);
            }
            case STREAM_KEYWORD: {
                STNode queryConstructType = this.parseQueryConstructType(this.parseStreamKeyword(), null);
                return this.parseQueryExprRhs(queryConstructType, isRhsExpr);
            }
            case TABLE_KEYWORD: {
                STNode tableKeyword = this.parseTableKeyword();
                return this.parseTableConstructorOrQuery(tableKeyword, isRhsExpr);
            }
        }
        this.recover(this.peek(), ParserRuleContext.TABLE_CONSTRUCTOR_OR_QUERY_START, isRhsExpr);
        return this.parseTableConstructorOrQueryInternal(isRhsExpr);
    }

    private STNode parseTableConstructorOrQuery(STNode tableKeyword, boolean isRhsExpr) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_BRACKET_TOKEN: {
                STNode keySpecifier = STNodeFactory.createEmptyNode();
                return this.parseTableConstructorExprRhs(tableKeyword, keySpecifier);
            }
            case KEY_KEYWORD: {
                STNode keySpecifier = this.parseKeySpecifier();
                return this.parseTableConstructorOrQueryRhs(tableKeyword, keySpecifier, isRhsExpr);
            }
            case IDENTIFIER_TOKEN: {
                if (!BallerinaParser.isKeyKeyword(nextToken)) break;
                STNode keySpecifier = this.parseKeySpecifier();
                return this.parseTableConstructorOrQueryRhs(tableKeyword, keySpecifier, isRhsExpr);
            }
        }
        this.recover(this.peek(), ParserRuleContext.TABLE_KEYWORD_RHS, tableKeyword, isRhsExpr);
        return this.parseTableConstructorOrQuery(tableKeyword, isRhsExpr);
    }

    private STNode parseTableConstructorOrQueryRhs(STNode tableKeyword, STNode keySpecifier, boolean isRhsExpr) {
        switch (this.peek().kind) {
            case FROM_KEYWORD: {
                return this.parseQueryExprRhs(this.parseQueryConstructType(tableKeyword, keySpecifier), isRhsExpr);
            }
            case OPEN_BRACKET_TOKEN: {
                return this.parseTableConstructorExprRhs(tableKeyword, keySpecifier);
            }
        }
        this.recover(this.peek(), ParserRuleContext.TABLE_CONSTRUCTOR_OR_QUERY_RHS, tableKeyword, keySpecifier, isRhsExpr);
        return this.parseTableConstructorOrQueryRhs(tableKeyword, keySpecifier, isRhsExpr);
    }

    private STNode parseQueryConstructType(STNode keyword, STNode keySpecifier) {
        return STNodeFactory.createQueryConstructTypeNode(keyword, keySpecifier);
    }

    private STNode parseQueryExprRhs(STNode queryConstructType, boolean isRhsExpr) {
        STNode intermediateClause;
        this.switchContext(ParserRuleContext.QUERY_EXPRESSION);
        STNode fromClause = this.parseFromClause(isRhsExpr);
        ArrayList<STNode> clauses = new ArrayList<STNode>();
        STNode selectClause = null;
        while (!this.isEndOfIntermediateClause(this.peek().kind) && (intermediateClause = this.parseIntermediateClause(isRhsExpr)) != null) {
            if (selectClause != null) {
                selectClause = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(selectClause, intermediateClause, (DiagnosticCode)DiagnosticErrorCode.ERROR_MORE_CLAUSES_AFTER_SELECT_CLAUSE, new Object[0]);
                continue;
            }
            if (intermediateClause.kind == SyntaxKind.SELECT_CLAUSE) {
                selectClause = intermediateClause;
                continue;
            }
            clauses.add(intermediateClause);
        }
        if (this.peek().kind == SyntaxKind.DO_KEYWORD) {
            STNode intermediateClauses = STNodeFactory.createNodeList(clauses);
            STNode queryPipeline = STNodeFactory.createQueryPipelineNode(fromClause, intermediateClauses);
            return this.parseQueryAction(queryConstructType, queryPipeline, selectClause, isRhsExpr);
        }
        if (selectClause == null) {
            STToken selectKeyword = SyntaxErrors.createMissingToken(SyntaxKind.SELECT_KEYWORD);
            STNode expr = STNodeFactory.createSimpleNameReferenceNode(SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN));
            selectClause = STNodeFactory.createSelectClauseNode(selectKeyword, expr);
            if (clauses.isEmpty()) {
                fromClause = SyntaxErrors.addDiagnostic(fromClause, DiagnosticErrorCode.ERROR_MISSING_SELECT_CLAUSE, new Object[0]);
            } else {
                int lastIndex = clauses.size() - 1;
                STNode intClauseWithDiagnostic = SyntaxErrors.addDiagnostic((STNode)clauses.get(lastIndex), DiagnosticErrorCode.ERROR_MISSING_SELECT_CLAUSE, new Object[0]);
                clauses.set(lastIndex, intClauseWithDiagnostic);
            }
        }
        STNode intermediateClauses = STNodeFactory.createNodeList(clauses);
        STNode queryPipeline = STNodeFactory.createQueryPipelineNode(fromClause, intermediateClauses);
        STNode onConflictClause = this.parseOnConflictClause(isRhsExpr);
        return STNodeFactory.createQueryExpressionNode(queryConstructType, queryPipeline, selectClause, onConflictClause);
    }

    private STNode parseIntermediateClause(boolean isRhsExpr) {
        switch (this.peek().kind) {
            case FROM_KEYWORD: {
                return this.parseFromClause(isRhsExpr);
            }
            case WHERE_KEYWORD: {
                return this.parseWhereClause(isRhsExpr);
            }
            case LET_KEYWORD: {
                return this.parseLetClause(isRhsExpr);
            }
            case SELECT_KEYWORD: {
                return this.parseSelectClause(isRhsExpr);
            }
            case JOIN_KEYWORD: 
            case OUTER_KEYWORD: {
                return this.parseJoinClause(isRhsExpr);
            }
            case ORDER_KEYWORD: 
            case BY_KEYWORD: 
            case ASCENDING_KEYWORD: 
            case DESCENDING_KEYWORD: {
                return this.parseOrderByClause(isRhsExpr);
            }
            case LIMIT_KEYWORD: {
                return this.parseLimitClause(isRhsExpr);
            }
            case SEMICOLON_TOKEN: 
            case DO_KEYWORD: 
            case ON_KEYWORD: 
            case CONFLICT_KEYWORD: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.QUERY_PIPELINE_RHS, isRhsExpr);
        return this.parseIntermediateClause(isRhsExpr);
    }

    private STNode parseJoinKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.JOIN_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.JOIN_KEYWORD, new Object[0]);
        return this.parseJoinKeyword();
    }

    private STNode parseEqualsKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.EQUALS_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.EQUALS_KEYWORD, new Object[0]);
        return this.parseEqualsKeyword();
    }

    private boolean isEndOfIntermediateClause(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case EOF_TOKEN: 
            case DOCUMENTATION_STRING: 
            case FINAL_KEYWORD: 
            case PUBLIC_KEYWORD: 
            case FUNCTION_KEYWORD: 
            case TYPE_KEYWORD: 
            case LISTENER_KEYWORD: 
            case CONST_KEYWORD: 
            case SERVICE_KEYWORD: 
            case SEMICOLON_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case RESOURCE_KEYWORD: 
            case PRIVATE_KEYWORD: 
            case CLOSE_PAREN_TOKEN: 
            case RETURNS_KEYWORD: 
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACKET_TOKEN: 
            case DO_KEYWORD: {
                return true;
            }
        }
        return this.isValidExprRhsStart(tokenKind, SyntaxKind.NONE);
    }

    private STNode parseFromClause(boolean isRhsExpr) {
        STNode fromKeyword = this.parseFromKeyword();
        STNode typedBindingPattern = this.parseTypedBindingPattern(ParserRuleContext.FROM_CLAUSE);
        STNode inKeyword = this.parseInKeyword();
        STNode expression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        return STNodeFactory.createFromClauseNode(fromKeyword, typedBindingPattern, inKeyword, expression);
    }

    private STNode parseFromKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FROM_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FROM_KEYWORD, new Object[0]);
        return this.parseFromKeyword();
    }

    private STNode parseWhereClause(boolean isRhsExpr) {
        STNode whereKeyword = this.parseWhereKeyword();
        STNode expression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        return STNodeFactory.createWhereClauseNode(whereKeyword, expression);
    }

    private STNode parseWhereKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.WHERE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.WHERE_KEYWORD, new Object[0]);
        return this.parseWhereKeyword();
    }

    private STNode parseLimitKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.LIMIT_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.LIMIT_KEYWORD, new Object[0]);
        return this.parseLimitKeyword();
    }

    private STNode parseLetClause(boolean isRhsExpr) {
        STNode letKeyword = this.parseLetKeyword();
        STNode letVarDeclarations = this.parseLetVarDeclarations(ParserRuleContext.LET_CLAUSE_LET_VAR_DECL, isRhsExpr);
        letKeyword = this.cloneWithDiagnosticIfListEmpty(letVarDeclarations, letKeyword, DiagnosticErrorCode.ERROR_MISSING_LET_VARIABLE_DECLARATION);
        return STNodeFactory.createLetClauseNode(letKeyword, letVarDeclarations);
    }

    private STNode parseOrderKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ORDER_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ORDER_KEYWORD, new Object[0]);
        return this.parseOrderKeyword();
    }

    private STNode parseByKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.BY_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.BY_KEYWORD, new Object[0]);
        return this.parseByKeyword();
    }

    private STNode parseOrderByClause(boolean isRhsExpr) {
        STNode orderKeyword = this.parseOrderKeyword();
        STNode byKeyword = this.parseByKeyword();
        STNode orderKeys = this.parseOrderKeyList(isRhsExpr);
        byKeyword = this.cloneWithDiagnosticIfListEmpty(orderKeys, byKeyword, DiagnosticErrorCode.ERROR_MISSING_ORDER_KEY);
        return STNodeFactory.createOrderByClauseNode(orderKeyword, byKeyword, orderKeys);
    }

    private STNode parseOrderKeyList(boolean isRhsExpr) {
        STNode orderKeyListMemberEnd;
        this.startContext(ParserRuleContext.ORDER_KEY_LIST);
        ArrayList<STNode> orderKeys = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndOfOrderKeys(nextToken.kind)) {
            this.endContext();
            return STNodeFactory.createEmptyNodeList();
        }
        STNode orderKey = this.parseOrderKey(isRhsExpr);
        orderKeys.add(orderKey);
        nextToken = this.peek();
        while (!this.isEndOfOrderKeys(nextToken.kind) && (orderKeyListMemberEnd = this.parseOrderKeyListMemberEnd()) != null) {
            orderKeys.add(orderKeyListMemberEnd);
            orderKey = this.parseOrderKey(isRhsExpr);
            orderKeys.add(orderKey);
            nextToken = this.peek();
        }
        this.endContext();
        return STNodeFactory.createNodeList(orderKeys);
    }

    private boolean isEndOfOrderKeys(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case COMMA_TOKEN: 
            case ASCENDING_KEYWORD: 
            case DESCENDING_KEYWORD: {
                return false;
            }
            case EOF_TOKEN: 
            case SEMICOLON_TOKEN: {
                return true;
            }
        }
        return this.isQueryClauseStartToken(tokenKind);
    }

    private boolean isQueryClauseStartToken(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case DO_KEYWORD: 
            case FROM_KEYWORD: 
            case LET_KEYWORD: 
            case WHERE_KEYWORD: 
            case SELECT_KEYWORD: 
            case LIMIT_KEYWORD: 
            case JOIN_KEYWORD: 
            case OUTER_KEYWORD: 
            case ORDER_KEYWORD: {
                return true;
            }
        }
        return false;
    }

    private STNode parseOrderKeyListMemberEnd() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case EOF_TOKEN: {
                return null;
            }
        }
        if (this.isQueryClauseStartToken(nextToken.kind)) {
            return null;
        }
        this.recover(this.peek(), ParserRuleContext.ORDER_KEY_LIST_END, new Object[0]);
        return this.parseOrderKeyListMemberEnd();
    }

    private STNode parseOrderKey(boolean isRhsExpr) {
        STNode orderDirection;
        STNode expression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case ASCENDING_KEYWORD: 
            case DESCENDING_KEYWORD: {
                orderDirection = this.consume();
                break;
            }
            default: {
                orderDirection = STNodeFactory.createEmptyNode();
            }
        }
        return STNodeFactory.createOrderKeyNode(expression, orderDirection);
    }

    private STNode parseSelectClause(boolean isRhsExpr) {
        this.startContext(ParserRuleContext.SELECT_CLAUSE);
        STNode selectKeyword = this.parseSelectKeyword();
        STNode expression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        this.endContext();
        return STNodeFactory.createSelectClauseNode(selectKeyword, expression);
    }

    private STNode parseSelectKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.SELECT_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.SELECT_KEYWORD, new Object[0]);
        return this.parseSelectKeyword();
    }

    private STNode parseOnConflictClause(boolean isRhsExpr) {
        STToken nextToken = this.peek();
        if (nextToken.kind != SyntaxKind.ON_KEYWORD && nextToken.kind != SyntaxKind.CONFLICT_KEYWORD) {
            return STNodeFactory.createEmptyNode();
        }
        this.startContext(ParserRuleContext.ON_CONFLICT_CLAUSE);
        STNode onKeyword = this.parseOnKeyword();
        STNode conflictKeyword = this.parseConflictKeyword();
        this.endContext();
        STNode expr = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        return STNodeFactory.createOnConflictClauseNode(onKeyword, conflictKeyword, expr);
    }

    private STNode parseConflictKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CONFLICT_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CONFLICT_KEYWORD, new Object[0]);
        return this.parseConflictKeyword();
    }

    private STNode parseLimitClause(boolean isRhsExpr) {
        STNode limitKeyword = this.parseLimitKeyword();
        STNode expr = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        return STNodeFactory.createLimitClauseNode(limitKeyword, expr);
    }

    private STNode parseJoinClause(boolean isRhsExpr) {
        this.startContext(ParserRuleContext.JOIN_CLAUSE);
        STToken nextToken = this.peek();
        STNode outerKeyword = nextToken.kind == SyntaxKind.OUTER_KEYWORD ? this.consume() : STNodeFactory.createEmptyNode();
        STNode joinKeyword = this.parseJoinKeyword();
        STNode typedBindingPattern = this.parseTypedBindingPattern(ParserRuleContext.JOIN_CLAUSE);
        STNode inKeyword = this.parseInKeyword();
        STNode expression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        this.endContext();
        STNode onCondition = this.parseOnClause(isRhsExpr);
        return STNodeFactory.createJoinClauseNode(outerKeyword, joinKeyword, typedBindingPattern, inKeyword, expression, onCondition);
    }

    private STNode parseOnClause(boolean isRhsExpr) {
        STToken nextToken = this.peek();
        if (this.isQueryClauseStartToken(nextToken.kind)) {
            return this.createMissingOnClauseNode();
        }
        this.startContext(ParserRuleContext.ON_CLAUSE);
        STNode onKeyword = this.parseOnKeyword();
        STNode lhsExpression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        STNode equalsKeyword = this.parseEqualsKeyword();
        this.endContext();
        STNode rhsExpression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        return STNodeFactory.createOnClauseNode(onKeyword, lhsExpression, equalsKeyword, rhsExpression);
    }

    private STNode createMissingOnClauseNode() {
        STToken onKeyword = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.ON_KEYWORD, DiagnosticErrorCode.ERROR_MISSING_ON_KEYWORD);
        STToken identifier = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_IDENTIFIER);
        STToken equalsKeyword = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.EQUALS_KEYWORD, DiagnosticErrorCode.ERROR_MISSING_EQUALS_KEYWORD);
        STNode lhsExpression = STNodeFactory.createSimpleNameReferenceNode(identifier);
        STNode rhsExpression = STNodeFactory.createSimpleNameReferenceNode(identifier);
        return STNodeFactory.createOnClauseNode(onKeyword, lhsExpression, equalsKeyword, rhsExpression);
    }

    private STNode parseStartAction(STNode annots) {
        STNode startKeyword = this.parseStartKeyword();
        STNode expr = this.parseActionOrExpression();
        switch (expr.kind) {
            case REMOTE_METHOD_CALL_ACTION: 
            case METHOD_CALL: 
            case FUNCTION_CALL: {
                break;
            }
            case SIMPLE_NAME_REFERENCE: 
            case QUALIFIED_NAME_REFERENCE: {
                STToken openParenToken = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.OPEN_PAREN_TOKEN, DiagnosticErrorCode.ERROR_MISSING_OPEN_PAREN_TOKEN);
                STNode arguments = STNodeFactory.createEmptyNodeList();
                STToken closeParenToken = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.CLOSE_PAREN_TOKEN, DiagnosticErrorCode.ERROR_MISSING_CLOSE_PAREN_TOKEN);
                expr = STNodeFactory.createFunctionCallExpressionNode(expr, openParenToken, arguments, closeParenToken);
                break;
            }
            default: {
                startKeyword = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(startKeyword, expr, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_EXPRESSION_IN_START_ACTION, new Object[0]);
                STNode funcName = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
                funcName = STNodeFactory.createSimpleNameReferenceNode(funcName);
                STToken openParenToken = SyntaxErrors.createMissingToken(SyntaxKind.OPEN_PAREN_TOKEN);
                STNode arguments = STNodeFactory.createEmptyNodeList();
                STToken closeParenToken = SyntaxErrors.createMissingToken(SyntaxKind.CLOSE_PAREN_TOKEN);
                expr = STNodeFactory.createFunctionCallExpressionNode(funcName, openParenToken, arguments, closeParenToken);
            }
        }
        return STNodeFactory.createStartActionNode(this.getAnnotations(annots), startKeyword, expr);
    }

    private STNode parseStartKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.START_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.START_KEYWORD, new Object[0]);
        return this.parseStartKeyword();
    }

    private STNode parseFlushAction() {
        STNode flushKeyword = this.parseFlushKeyword();
        STNode peerWorker = this.parseOptionalPeerWorkerName();
        return STNodeFactory.createFlushActionNode(flushKeyword, peerWorker);
    }

    private STNode parseFlushKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FLUSH_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FLUSH_KEYWORD, new Object[0]);
        return this.parseFlushKeyword();
    }

    private STNode parseOptionalPeerWorkerName() {
        STToken token = this.peek();
        switch (token.kind) {
            case IDENTIFIER_TOKEN: 
            case DEFAULT_KEYWORD: {
                return STNodeFactory.createSimpleNameReferenceNode(this.consume());
            }
        }
        return STNodeFactory.createEmptyNode();
    }

    private STNode parseIntersectionTypeDescriptor(STNode leftTypeDesc, ParserRuleContext context, boolean isTypedBindingPattern) {
        STToken bitwiseAndToken = this.consume();
        STNode rightTypeDesc = this.parseTypeDescriptor(context, isTypedBindingPattern, false);
        return this.createIntersectionTypeDesc(leftTypeDesc, bitwiseAndToken, rightTypeDesc);
    }

    private STNode createIntersectionTypeDesc(STNode leftTypeDesc, STNode bitwiseAndToken, STNode rightTypeDesc) {
        leftTypeDesc = this.validateForUsageOfVar(leftTypeDesc);
        rightTypeDesc = this.validateForUsageOfVar(rightTypeDesc);
        return STNodeFactory.createIntersectionTypeDescriptorNode(leftTypeDesc, bitwiseAndToken, rightTypeDesc);
    }

    private STNode parseSingletonTypeDesc() {
        STNode simpleContExpr = this.parseSimpleConstExpr();
        return STNodeFactory.createSingletonTypeDescriptorNode(simpleContExpr);
    }

    private STNode parseSignedIntOrFloat() {
        STNode literal;
        STNode operator = this.parseUnaryOperator();
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case HEX_INTEGER_LITERAL_TOKEN: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                literal = this.parseBasicLiteral();
                break;
            }
            default: {
                literal = this.parseDecimalIntLiteral(ParserRuleContext.DECIMAL_INTEGER_LITERAL_TOKEN);
                literal = STNodeFactory.createBasicLiteralNode(SyntaxKind.NUMERIC_LITERAL, literal);
            }
        }
        return STNodeFactory.createUnaryExpressionNode(operator, literal);
    }

    private boolean isSingletonTypeDescStart(SyntaxKind tokenKind, boolean inTypeDescCtx) {
        STToken nextNextToken = this.getNextNextToken();
        switch (tokenKind) {
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                return inTypeDescCtx || this.isValidTypeDescRHSOutSideTypeDescCtx(nextNextToken);
            }
            case PLUS_TOKEN: 
            case MINUS_TOKEN: {
                return BallerinaParser.isIntOrFloat(nextNextToken);
            }
        }
        return false;
    }

    static boolean isIntOrFloat(STToken token) {
        switch (token.kind) {
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private boolean isValidTypeDescRHSOutSideTypeDescCtx(STToken token) {
        switch (token.kind) {
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACKET_TOKEN: 
            case QUESTION_MARK_TOKEN: 
            case PIPE_TOKEN: 
            case BITWISE_AND_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: 
            case OPEN_PAREN_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private boolean isValidExpressionStart(SyntaxKind nextTokenKind, int nextTokenIndex) {
        ++nextTokenIndex;
        switch (nextTokenKind) {
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                SyntaxKind nextNextTokenKind = this.peek((int)nextTokenIndex).kind;
                return nextNextTokenKind == SyntaxKind.SEMICOLON_TOKEN || nextNextTokenKind == SyntaxKind.COMMA_TOKEN || nextNextTokenKind == SyntaxKind.CLOSE_BRACKET_TOKEN || this.isValidExprRhsStart(nextNextTokenKind, SyntaxKind.SIMPLE_NAME_REFERENCE);
            }
            case IDENTIFIER_TOKEN: {
                return this.isValidExprRhsStart(this.peek((int)nextTokenIndex).kind, SyntaxKind.SIMPLE_NAME_REFERENCE);
            }
            case FUNCTION_KEYWORD: 
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: 
            case OPEN_BRACKET_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case OPEN_PAREN_TOKEN: 
            case BACKTICK_TOKEN: 
            case LT_TOKEN: 
            case CHECK_KEYWORD: 
            case CHECKPANIC_KEYWORD: 
            case TRAP_KEYWORD: 
            case LEFT_ARROW_TOKEN: 
            case FROM_KEYWORD: 
            case TYPEOF_KEYWORD: 
            case NEGATION_TOKEN: 
            case EXCLAMATION_MARK_TOKEN: 
            case LET_KEYWORD: 
            case NEW_KEYWORD: {
                return true;
            }
            case PLUS_TOKEN: 
            case MINUS_TOKEN: {
                return this.isValidExpressionStart(this.peek((int)nextTokenIndex).kind, nextTokenIndex);
            }
            case TABLE_KEYWORD: {
                return this.peek((int)nextTokenIndex).kind == SyntaxKind.FROM_KEYWORD;
            }
            case STREAM_KEYWORD: {
                STToken nextNextToken = this.peek(nextTokenIndex);
                return nextNextToken.kind == SyntaxKind.KEY_KEYWORD || nextNextToken.kind == SyntaxKind.OPEN_BRACKET_TOKEN || nextNextToken.kind == SyntaxKind.FROM_KEYWORD;
            }
            case ERROR_KEYWORD: {
                return this.peek((int)nextTokenIndex).kind == SyntaxKind.OPEN_PAREN_TOKEN;
            }
            case SERVICE_KEYWORD: {
                return this.peek((int)nextTokenIndex).kind == SyntaxKind.OPEN_BRACE_TOKEN;
            }
            case XML_KEYWORD: 
            case STRING_KEYWORD: {
                return this.peek((int)nextTokenIndex).kind == SyntaxKind.BACKTICK_TOKEN;
            }
        }
        return false;
    }

    private STNode parseSyncSendAction(STNode expression) {
        STNode syncSendToken = this.parseSyncSendToken();
        STNode peerWorker = this.parsePeerWorkerName();
        return STNodeFactory.createSyncSendActionNode(expression, syncSendToken, peerWorker);
    }

    private STNode parsePeerWorkerName() {
        STToken token = this.peek();
        switch (token.kind) {
            case IDENTIFIER_TOKEN: 
            case DEFAULT_KEYWORD: {
                return STNodeFactory.createSimpleNameReferenceNode(this.consume());
            }
        }
        this.recover(token, ParserRuleContext.PEER_WORKER_NAME, new Object[0]);
        return this.parsePeerWorkerName();
    }

    private STNode parseSyncSendToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.SYNC_SEND_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.SYNC_SEND_TOKEN, new Object[0]);
        return this.parseSyncSendToken();
    }

    private STNode parseReceiveAction() {
        STNode leftArrow = this.parseLeftArrowToken();
        STNode receiveWorkers = this.parseReceiveWorkers();
        return STNodeFactory.createReceiveActionNode(leftArrow, receiveWorkers);
    }

    private STNode parseReceiveWorkers() {
        switch (this.peek().kind) {
            case IDENTIFIER_TOKEN: 
            case DEFAULT_KEYWORD: {
                return this.parsePeerWorkerName();
            }
            case OPEN_BRACE_TOKEN: {
                return this.parseMultipleReceiveWorkers();
            }
        }
        this.recover(this.peek(), ParserRuleContext.RECEIVE_WORKERS, new Object[0]);
        return this.parseReceiveWorkers();
    }

    private STNode parseMultipleReceiveWorkers() {
        this.startContext(ParserRuleContext.MULTI_RECEIVE_WORKERS);
        STNode openBrace = this.parseOpenBrace();
        STNode receiveFields = this.parseReceiveFields();
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        openBrace = this.cloneWithDiagnosticIfListEmpty(receiveFields, openBrace, DiagnosticErrorCode.ERROR_MISSING_RECEIVE_FIELD_IN_RECEIVE_ACTION);
        return STNodeFactory.createReceiveFieldsNode(openBrace, receiveFields, closeBrace);
    }

    private STNode parseReceiveFields() {
        STNode recieveFieldEnd;
        ArrayList<STNode> receiveFields = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndOfReceiveFields(nextToken.kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        STNode receiveField = this.parseReceiveField();
        receiveFields.add(receiveField);
        nextToken = this.peek();
        while (!this.isEndOfReceiveFields(nextToken.kind) && (recieveFieldEnd = this.parseReceiveFieldEnd()) != null) {
            receiveFields.add(recieveFieldEnd);
            receiveField = this.parseReceiveField();
            receiveFields.add(receiveField);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(receiveFields);
    }

    private boolean isEndOfReceiveFields(SyntaxKind nextTokenKind) {
        switch (nextTokenKind) {
            case EOF_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseReceiveFieldEnd() {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case CLOSE_BRACE_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.RECEIVE_FIELD_END, new Object[0]);
        return this.parseReceiveFieldEnd();
    }

    private STNode parseReceiveField() {
        switch (this.peek().kind) {
            case DEFAULT_KEYWORD: {
                STNode defaultKeyword = this.parseDefaultKeyword();
                return STNodeFactory.createSimpleNameReferenceNode(defaultKeyword);
            }
            case IDENTIFIER_TOKEN: {
                STNode identifier = this.parseIdentifier(ParserRuleContext.RECEIVE_FIELD_NAME);
                return this.createQualifiedReceiveField(identifier);
            }
        }
        this.recover(this.peek(), ParserRuleContext.RECEIVE_FIELD, new Object[0]);
        return this.parseReceiveField();
    }

    private STNode createQualifiedReceiveField(STNode identifier) {
        if (this.peek().kind != SyntaxKind.COLON_TOKEN) {
            return identifier;
        }
        STNode colon = this.parseColon();
        STNode peerWorker = this.parsePeerWorkerName();
        return STNodeFactory.createQualifiedNameReferenceNode(identifier, colon, peerWorker);
    }

    private STNode parseLeftArrowToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.LEFT_ARROW_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.LEFT_ARROW_TOKEN, new Object[0]);
        return this.parseLeftArrowToken();
    }

    private STNode parseSignedRightShiftToken() {
        STToken openGTToken = this.consume();
        STToken endLGToken = this.consume();
        STToken doubleGTToken = STNodeFactory.createToken(SyntaxKind.DOUBLE_GT_TOKEN, ((STNode)openGTToken).leadingMinutiae(), endLGToken.trailingMinutiae());
        if (this.hasTrailingMinutiae(openGTToken)) {
            doubleGTToken = SyntaxErrors.addDiagnostic(doubleGTToken, DiagnosticErrorCode.ERROR_NO_WHITESPACES_ALLOWED_IN_RIGHT_SHIFT_OP, new Object[0]);
        }
        return doubleGTToken;
    }

    private STNode parseUnsignedRightShiftToken() {
        boolean validMiddleGTToken;
        STToken openGTToken = this.consume();
        STToken middleGTToken = this.consume();
        STToken endLGToken = this.consume();
        STToken unsignedRightShiftToken = STNodeFactory.createToken(SyntaxKind.TRIPPLE_GT_TOKEN, ((STNode)openGTToken).leadingMinutiae(), ((STNode)endLGToken).trailingMinutiae());
        boolean validOpenGTToken = !this.hasTrailingMinutiae(openGTToken);
        boolean bl = validMiddleGTToken = !this.hasTrailingMinutiae(middleGTToken);
        if (validOpenGTToken && validMiddleGTToken) {
            return unsignedRightShiftToken;
        }
        unsignedRightShiftToken = SyntaxErrors.addDiagnostic(unsignedRightShiftToken, DiagnosticErrorCode.ERROR_NO_WHITESPACES_ALLOWED_IN_UNSIGNED_RIGHT_SHIFT_OP, new Object[0]);
        return unsignedRightShiftToken;
    }

    private STNode parseWaitAction() {
        STNode waitKeyword = this.parseWaitKeyword();
        if (this.peek().kind == SyntaxKind.OPEN_BRACE_TOKEN) {
            return this.parseMultiWaitAction(waitKeyword);
        }
        return this.parseSingleOrAlternateWaitAction(waitKeyword);
    }

    private STNode parseWaitKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.WAIT_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.WAIT_KEYWORD, new Object[0]);
        return this.parseWaitKeyword();
    }

    private STNode parseSingleOrAlternateWaitAction(STNode waitKeyword) {
        STNode waitFutureExprEnd;
        this.startContext(ParserRuleContext.ALTERNATE_WAIT_EXPRS);
        STToken nextToken = this.peek();
        if (this.isEndOfWaitFutureExprList(nextToken.kind)) {
            this.endContext();
            STNode waitFutureExprs = STNodeFactory.createSimpleNameReferenceNode(STNodeFactory.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN));
            waitFutureExprs = SyntaxErrors.addDiagnostic(waitFutureExprs, DiagnosticErrorCode.ERROR_MISSING_WAIT_FUTURE_EXPRESSION, new Object[0]);
            return STNodeFactory.createWaitActionNode(waitKeyword, waitFutureExprs);
        }
        ArrayList<STNode> waitFutureExprList = new ArrayList<STNode>();
        STNode waitField = this.parseWaitFutureExpr();
        waitFutureExprList.add(waitField);
        nextToken = this.peek();
        while (!this.isEndOfWaitFutureExprList(nextToken.kind) && (waitFutureExprEnd = this.parseWaitFutureExprEnd()) != null) {
            waitFutureExprList.add(waitFutureExprEnd);
            waitField = this.parseWaitFutureExpr();
            waitFutureExprList.add(waitField);
            nextToken = this.peek();
        }
        this.endContext();
        return STNodeFactory.createWaitActionNode(waitKeyword, (STNode)waitFutureExprList.get(0));
    }

    private boolean isEndOfWaitFutureExprList(SyntaxKind nextTokenKind) {
        switch (nextTokenKind) {
            case EOF_TOKEN: 
            case SEMICOLON_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseWaitFutureExpr() {
        STNode waitFutureExpr = this.parseActionOrExpression();
        if (waitFutureExpr.kind == SyntaxKind.MAPPING_CONSTRUCTOR) {
            waitFutureExpr = SyntaxErrors.addDiagnostic(waitFutureExpr, DiagnosticErrorCode.ERROR_MAPPING_CONSTRUCTOR_EXPR_AS_A_WAIT_EXPR, new Object[0]);
        } else if (this.isAction(waitFutureExpr)) {
            waitFutureExpr = SyntaxErrors.addDiagnostic(waitFutureExpr, DiagnosticErrorCode.ERROR_ACTION_AS_A_WAIT_EXPR, new Object[0]);
        }
        return waitFutureExpr;
    }

    private STNode parseWaitFutureExprEnd() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case PIPE_TOKEN: {
                return this.parsePipeToken();
            }
        }
        if (this.isEndOfWaitFutureExprList(nextToken.kind) || !this.isValidExpressionStart(nextToken.kind, 1)) {
            return null;
        }
        this.recover(this.peek(), ParserRuleContext.WAIT_FUTURE_EXPR_END, new Object[0]);
        return this.parseWaitFutureExprEnd();
    }

    private STNode parseMultiWaitAction(STNode waitKeyword) {
        this.startContext(ParserRuleContext.MULTI_WAIT_FIELDS);
        STNode openBrace = this.parseOpenBrace();
        STNode waitFields = this.parseWaitFields();
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        openBrace = this.cloneWithDiagnosticIfListEmpty(waitFields, openBrace, DiagnosticErrorCode.ERROR_MISSING_WAIT_FIELD_IN_WAIT_ACTION);
        STNode waitFieldsNode = STNodeFactory.createWaitFieldsListNode(openBrace, waitFields, closeBrace);
        return STNodeFactory.createWaitActionNode(waitKeyword, waitFieldsNode);
    }

    private STNode parseWaitFields() {
        STNode waitFieldEnd;
        ArrayList<STNode> waitFields = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndOfWaitFields(nextToken.kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        STNode waitField = this.parseWaitField();
        waitFields.add(waitField);
        nextToken = this.peek();
        while (!this.isEndOfWaitFields(nextToken.kind) && (waitFieldEnd = this.parseWaitFieldEnd()) != null) {
            waitFields.add(waitFieldEnd);
            waitField = this.parseWaitField();
            waitFields.add(waitField);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(waitFields);
    }

    private boolean isEndOfWaitFields(SyntaxKind nextTokenKind) {
        switch (nextTokenKind) {
            case EOF_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseWaitFieldEnd() {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case CLOSE_BRACE_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.WAIT_FIELD_END, new Object[0]);
        return this.parseWaitFieldEnd();
    }

    private STNode parseWaitField() {
        switch (this.peek().kind) {
            case IDENTIFIER_TOKEN: {
                STNode identifier = this.parseIdentifier(ParserRuleContext.WAIT_FIELD_NAME);
                identifier = STNodeFactory.createSimpleNameReferenceNode(identifier);
                return this.createQualifiedWaitField(identifier);
            }
        }
        this.recover(this.peek(), ParserRuleContext.WAIT_FIELD_NAME, new Object[0]);
        return this.parseWaitField();
    }

    private STNode createQualifiedWaitField(STNode identifier) {
        if (this.peek().kind != SyntaxKind.COLON_TOKEN) {
            return identifier;
        }
        STNode colon = this.parseColon();
        STNode waitFutureExpr = this.parseWaitFutureExpr();
        return STNodeFactory.createWaitFieldNode(identifier, colon, waitFutureExpr);
    }

    private STNode parseAnnotAccessExpression(STNode lhsExpr, boolean isInConditionalExpr) {
        STNode annotAccessToken = this.parseAnnotChainingToken();
        STNode annotTagReference = this.parseFieldAccessIdentifier(isInConditionalExpr);
        return STNodeFactory.createAnnotAccessExpressionNode(lhsExpr, annotAccessToken, annotTagReference);
    }

    private STNode parseAnnotChainingToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ANNOT_CHAINING_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ANNOT_CHAINING_TOKEN, new Object[0]);
        return this.parseAnnotChainingToken();
    }

    private STNode parseFieldAccessIdentifier(boolean isInConditionalExpr) {
        return this.parseQualifiedIdentifier(ParserRuleContext.FIELD_ACCESS_IDENTIFIER, isInConditionalExpr);
    }

    private STNode parseQueryAction(STNode queryConstructType, STNode queryPipeline, STNode selectClause, boolean isRhsExpr) {
        if (queryConstructType != null) {
            queryPipeline = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(queryPipeline, queryConstructType, (DiagnosticCode)DiagnosticErrorCode.ERROR_QUERY_CONSTRUCT_TYPE_IN_QUERY_ACTION, new Object[0]);
        }
        if (selectClause != null) {
            queryPipeline = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(queryPipeline, selectClause, (DiagnosticCode)DiagnosticErrorCode.ERROR_SELECT_CLAUSE_IN_QUERY_ACTION, new Object[0]);
        }
        this.startContext(ParserRuleContext.DO_CLAUSE);
        STNode doKeyword = this.parseDoKeyword();
        STNode blockStmt = this.parseBlockNode();
        this.endContext();
        return STNodeFactory.createQueryActionNode(queryPipeline, doKeyword, blockStmt);
    }

    private STNode parseDoKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.DO_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.DO_KEYWORD, new Object[0]);
        return this.parseDoKeyword();
    }

    private STNode parseOptionalFieldAccessExpression(STNode lhsExpr, boolean isInConditionalExpr) {
        STNode optionalFieldAccessToken = this.parseOptionalChainingToken();
        STNode fieldName = this.parseFieldAccessIdentifier(isInConditionalExpr);
        return STNodeFactory.createOptionalFieldAccessExpressionNode(lhsExpr, optionalFieldAccessToken, fieldName);
    }

    private STNode parseOptionalChainingToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OPTIONAL_CHAINING_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.OPTIONAL_CHAINING_TOKEN, new Object[0]);
        return this.parseOptionalChainingToken();
    }

    private STNode parseConditionalExpression(STNode lhsExpr) {
        STNode endExpr;
        STNode colon;
        this.startContext(ParserRuleContext.CONDITIONAL_EXPRESSION);
        STNode questionMark = this.parseQuestionMark();
        STNode middleExpr = this.parseExpression(OperatorPrecedence.ANON_FUNC_OR_LET, true, false, true);
        STToken nextToken = this.peek();
        if (nextToken.kind != SyntaxKind.COLON_TOKEN && middleExpr.kind == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            STQualifiedNameReferenceNode qualifiedNameRef = (STQualifiedNameReferenceNode)middleExpr;
            middleExpr = STNodeFactory.createSimpleNameReferenceNode(qualifiedNameRef.modulePrefix);
            colon = qualifiedNameRef.colon;
            this.endContext();
            endExpr = STNodeFactory.createSimpleNameReferenceNode(qualifiedNameRef.identifier);
        } else {
            colon = this.parseColon();
            this.endContext();
            endExpr = this.parseExpression(OperatorPrecedence.ANON_FUNC_OR_LET, true, false);
        }
        return STNodeFactory.createConditionalExpressionNode(lhsExpr, questionMark, middleExpr, colon, endExpr);
    }

    private STNode parseEnumDeclaration(STNode metadata, STNode qualifier) {
        this.startContext(ParserRuleContext.MODULE_ENUM_DECLARATION);
        STNode enumKeywordToken = this.parseEnumKeyword();
        STNode identifier = this.parseIdentifier(ParserRuleContext.MODULE_ENUM_NAME);
        STNode openBraceToken = this.parseOpenBrace();
        STNode enumMemberList = this.parseEnumMemberList();
        STNode closeBraceToken = this.parseCloseBrace();
        this.endContext();
        openBraceToken = this.cloneWithDiagnosticIfListEmpty(enumMemberList, openBraceToken, DiagnosticErrorCode.ERROR_MISSING_ENUM_MEMBER);
        return STNodeFactory.createEnumDeclarationNode(metadata, qualifier, enumKeywordToken, identifier, openBraceToken, enumMemberList, closeBraceToken);
    }

    private STNode parseEnumKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ENUM_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ENUM_KEYWORD, new Object[0]);
        return this.parseEnumKeyword();
    }

    private STNode parseEnumMemberList() {
        STNode enumMemberRhs;
        this.startContext(ParserRuleContext.ENUM_MEMBER_LIST);
        if (this.peek().kind == SyntaxKind.CLOSE_BRACE_TOKEN) {
            return STNodeFactory.createEmptyNodeList();
        }
        ArrayList<STNode> enumMemberList = new ArrayList<STNode>();
        STNode enumMember = this.parseEnumMember();
        while (this.peek().kind != SyntaxKind.CLOSE_BRACE_TOKEN && (enumMemberRhs = this.parseEnumMemberEnd()) != null) {
            enumMemberList.add(enumMember);
            enumMemberList.add(enumMemberRhs);
            enumMember = this.parseEnumMember();
        }
        enumMemberList.add(enumMember);
        this.endContext();
        return STNodeFactory.createNodeList(enumMemberList);
    }

    private STNode parseEnumMember() {
        STNode metadata;
        switch (this.peek().kind) {
            case DOCUMENTATION_STRING: 
            case AT_TOKEN: {
                metadata = this.parseMetaData();
                break;
            }
            default: {
                metadata = STNodeFactory.createEmptyNode();
            }
        }
        STNode identifierNode = this.parseIdentifier(ParserRuleContext.ENUM_MEMBER_NAME);
        return this.parseEnumMemberRhs(metadata, identifierNode);
    }

    private STNode parseEnumMemberRhs(STNode metadata, STNode identifierNode) {
        STNode constExprNode;
        STNode equalToken;
        switch (this.peek().kind) {
            case EQUAL_TOKEN: {
                equalToken = this.parseAssignOp();
                constExprNode = this.parseExpression();
                break;
            }
            case COMMA_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                equalToken = STNodeFactory.createEmptyNode();
                constExprNode = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.ENUM_MEMBER_RHS, metadata, identifierNode);
                return this.parseEnumMemberRhs(metadata, identifierNode);
            }
        }
        return STNodeFactory.createEnumMemberNode(metadata, identifierNode, equalToken, constExprNode);
    }

    private STNode parseEnumMemberEnd() {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case CLOSE_BRACE_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.ENUM_MEMBER_END, new Object[0]);
        return this.parseEnumMemberEnd();
    }

    private STNode parseTransactionStatement() {
        this.startContext(ParserRuleContext.TRANSACTION_STMT);
        STNode transactionKeyword = this.parseTransactionKeyword();
        STNode blockStmt = this.parseBlockNode();
        this.endContext();
        STNode onFailClause = this.parseOptionalOnFailClause();
        return STNodeFactory.createTransactionStatementNode(transactionKeyword, blockStmt, onFailClause);
    }

    private STNode parseTransactionKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.TRANSACTION_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.TRANSACTION_KEYWORD, new Object[0]);
        return this.parseTransactionKeyword();
    }

    private STNode parseCommitAction() {
        STNode commitKeyword = this.parseCommitKeyword();
        return STNodeFactory.createCommitActionNode(commitKeyword);
    }

    private STNode parseCommitKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.COMMIT_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.COMMIT_KEYWORD, new Object[0]);
        return this.parseCommitKeyword();
    }

    private STNode parseRetryStatement() {
        this.startContext(ParserRuleContext.RETRY_STMT);
        STNode retryKeyword = this.parseRetryKeyword();
        STNode retryStmt = this.parseRetryKeywordRhs(retryKeyword);
        return retryStmt;
    }

    private STNode parseRetryKeywordRhs(STNode retryKeyword) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case LT_TOKEN: {
                STNode typeParam = this.parseTypeParameter();
                return this.parseRetryTypeParamRhs(retryKeyword, typeParam);
            }
            case OPEN_BRACE_TOKEN: 
            case OPEN_PAREN_TOKEN: 
            case TRANSACTION_KEYWORD: {
                STNode typeParam = STNodeFactory.createEmptyNode();
                return this.parseRetryTypeParamRhs(retryKeyword, typeParam);
            }
        }
        this.recover(this.peek(), ParserRuleContext.RETRY_KEYWORD_RHS, retryKeyword);
        return this.parseRetryKeywordRhs(retryKeyword);
    }

    private STNode parseRetryTypeParamRhs(STNode retryKeyword, STNode typeParam) {
        STNode args;
        switch (this.peek().kind) {
            case OPEN_PAREN_TOKEN: {
                args = this.parseParenthesizedArgList();
                break;
            }
            case OPEN_BRACE_TOKEN: 
            case TRANSACTION_KEYWORD: {
                args = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.RETRY_TYPE_PARAM_RHS, retryKeyword, typeParam);
                return this.parseRetryTypeParamRhs(retryKeyword, typeParam);
            }
        }
        STNode blockStmt = this.parseRetryBody();
        this.endContext();
        STNode onFailClause = this.parseOptionalOnFailClause();
        return STNodeFactory.createRetryStatementNode(retryKeyword, typeParam, args, blockStmt, onFailClause);
    }

    private STNode parseRetryBody() {
        switch (this.peek().kind) {
            case OPEN_BRACE_TOKEN: {
                return this.parseBlockNode();
            }
            case TRANSACTION_KEYWORD: {
                return this.parseTransactionStatement();
            }
        }
        this.recover(this.peek(), ParserRuleContext.RETRY_BODY, new Object[0]);
        return this.parseRetryBody();
    }

    private STNode parseOptionalOnFailClause() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.ON_KEYWORD) {
            return this.parseOnFailClause();
        }
        if (this.isEndOfRegularCompoundStmt(nextToken.kind)) {
            return STNodeFactory.createEmptyNode();
        }
        this.recover(nextToken, ParserRuleContext.REGULAR_COMPOUND_STMT_RHS, new Object[0]);
        return this.parseOptionalOnFailClause();
    }

    private boolean isEndOfRegularCompoundStmt(SyntaxKind nodeKind) {
        switch (nodeKind) {
            case EOF_TOKEN: 
            case AT_TOKEN: 
            case SEMICOLON_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                return true;
            }
        }
        return this.isStatementStartingToken(nodeKind);
    }

    private boolean isStatementStartingToken(SyntaxKind nodeKind) {
        switch (nodeKind) {
            case FINAL_KEYWORD: 
            case TYPE_KEYWORD: 
            case XMLNS_KEYWORD: 
            case OPEN_BRACE_TOKEN: 
            case IF_KEYWORD: 
            case WHILE_KEYWORD: 
            case DO_KEYWORD: 
            case PANIC_KEYWORD: 
            case CONTINUE_KEYWORD: 
            case BREAK_KEYWORD: 
            case RETURN_KEYWORD: 
            case FAIL_KEYWORD: 
            case LOCK_KEYWORD: 
            case WORKER_KEYWORD: 
            case FORK_KEYWORD: 
            case FOREACH_KEYWORD: 
            case START_KEYWORD: 
            case CHECK_KEYWORD: 
            case CHECKPANIC_KEYWORD: 
            case TRAP_KEYWORD: 
            case FLUSH_KEYWORD: 
            case LEFT_ARROW_TOKEN: 
            case WAIT_KEYWORD: 
            case COMMIT_KEYWORD: 
            case TRANSACTION_KEYWORD: 
            case RETRY_KEYWORD: 
            case ROLLBACK_KEYWORD: 
            case MATCH_KEYWORD: {
                return true;
            }
        }
        if (this.isTypeStartingToken(nodeKind)) {
            return true;
        }
        return this.isValidExpressionStart(nodeKind, 1);
    }

    private STNode parseOnFailClause() {
        this.startContext(ParserRuleContext.ON_FAIL_CLAUSE);
        STNode onKeyword = this.parseOnKeyword();
        STNode failKeyword = this.parseFailKeyword();
        STNode typeDescriptor = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true, false);
        STNode identifier = this.parseIdentifier(ParserRuleContext.VARIABLE_REF);
        STNode blockStatement = this.parseBlockNode();
        this.endContext();
        return STNodeFactory.createOnFailClauseNode(onKeyword, failKeyword, typeDescriptor, identifier, blockStatement);
    }

    private STNode parseRetryKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.RETRY_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.RETRY_KEYWORD, new Object[0]);
        return this.parseRetryKeyword();
    }

    private STNode parseRollbackStatement() {
        this.startContext(ParserRuleContext.ROLLBACK_STMT);
        STNode rollbackKeyword = this.parseRollbackKeyword();
        STNode expression = this.peek().kind == SyntaxKind.SEMICOLON_TOKEN ? STNodeFactory.createEmptyNode() : this.parseExpression();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createRollbackStatementNode(rollbackKeyword, expression, semicolon);
    }

    private STNode parseRollbackKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ROLLBACK_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ROLLBACK_KEYWORD, new Object[0]);
        return this.parseRollbackKeyword();
    }

    private STNode parseTransactionalExpression() {
        STNode transactionalKeyword = this.parseTransactionalKeyword();
        return STNodeFactory.createTransactionalExpressionNode(transactionalKeyword);
    }

    private STNode parseTransactionalKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.TRANSACTIONAL_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.TRANSACTIONAL_KEYWORD, new Object[0]);
        return this.parseTransactionalKeyword();
    }

    private STNode parseServiceConstructorExpression(STNode annots) {
        this.startContext(ParserRuleContext.SERVICE_CONSTRUCTOR_EXPRESSION);
        STNode serviceKeyword = this.parseServiceKeyword();
        STNode serviceBody = this.parseServiceBody();
        this.endContext();
        return STNodeFactory.createServiceConstructorExpressionNode(annots, serviceKeyword, serviceBody);
    }

    private STNode parseByteArrayLiteral() {
        STNode type = this.peek().kind == SyntaxKind.BASE16_KEYWORD ? this.parseBase16Keyword() : this.parseBase64Keyword();
        STNode startingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_START);
        if (startingBackTick.isMissing()) {
            startingBackTick = SyntaxErrors.createMissingToken(SyntaxKind.BACKTICK_TOKEN);
            STToken endingBackTick = SyntaxErrors.createMissingToken(SyntaxKind.BACKTICK_TOKEN);
            STNode content = STNodeFactory.createEmptyNode();
            STNode byteArrayLiteral = STNodeFactory.createByteArrayLiteralNode(type, startingBackTick, content, endingBackTick);
            byteArrayLiteral = SyntaxErrors.addDiagnostic(byteArrayLiteral, DiagnosticErrorCode.ERROR_MISSING_BYTE_ARRAY_CONTENT, new Object[0]);
            return byteArrayLiteral;
        }
        STNode content = this.parseByteArrayContent();
        return this.parseByteArrayLiteral(type, startingBackTick, content);
    }

    private STNode parseByteArrayLiteral(STNode typeKeyword, STNode startingBackTick, STNode byteArrayContent) {
        STNode content = STNodeFactory.createEmptyNode();
        STNode newStartingBackTick = startingBackTick;
        STNodeList items = (STNodeList)byteArrayContent;
        if (items.size() == 1) {
            STNode item = items.get(0);
            if (typeKeyword.kind == SyntaxKind.BASE16_KEYWORD && !BallerinaParser.isValidBase16LiteralContent(item.toString())) {
                newStartingBackTick = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(startingBackTick, item, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_BASE16_CONTENT_IN_BYTE_ARRAY_LITERAL, new Object[0]);
            } else if (typeKeyword.kind == SyntaxKind.BASE64_KEYWORD && !BallerinaParser.isValidBase64LiteralContent(item.toString())) {
                newStartingBackTick = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(startingBackTick, item, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_BASE64_CONTENT_IN_BYTE_ARRAY_LITERAL, new Object[0]);
            } else if (item.kind != SyntaxKind.TEMPLATE_STRING) {
                newStartingBackTick = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(startingBackTick, item, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_CONTENT_IN_BYTE_ARRAY_LITERAL, new Object[0]);
            } else {
                content = item;
            }
        } else if (items.size() > 1) {
            STNode clonedStartingBackTick = startingBackTick;
            for (int index = 0; index < items.size(); ++index) {
                STNode item = items.get(index);
                clonedStartingBackTick = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(clonedStartingBackTick, item);
            }
            newStartingBackTick = SyntaxErrors.addDiagnostic(clonedStartingBackTick, DiagnosticErrorCode.ERROR_INVALID_CONTENT_IN_BYTE_ARRAY_LITERAL, new Object[0]);
        }
        STNode endingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_END);
        return STNodeFactory.createByteArrayLiteralNode(typeKeyword, newStartingBackTick, content, endingBackTick);
    }

    private STNode parseBase16Keyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.BASE16_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.BASE16_KEYWORD, new Object[0]);
        return this.parseBase16Keyword();
    }

    private STNode parseBase64Keyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.BASE64_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.BASE64_KEYWORD, new Object[0]);
        return this.parseBase64Keyword();
    }

    private STNode parseByteArrayContent() {
        STToken nextToken = this.peek();
        ArrayList<STNode> items = new ArrayList<STNode>();
        while (!this.isEndOfBacktickContent(nextToken.kind)) {
            STNode content = this.parseTemplateItem();
            items.add(content);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(items);
    }

    static boolean isValidBase16LiteralContent(String content) {
        char[] charArray = content.toCharArray();
        int hexDigitCount = 0;
        block3: for (char c : charArray) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    if (BallerinaParser.isHexDigit(c)) {
                        ++hexDigitCount;
                        continue block3;
                    }
                    return false;
                }
            }
        }
        return hexDigitCount % 2 == 0;
    }

    static boolean isValidBase64LiteralContent(String content) {
        char[] charArray = content.toCharArray();
        int base64CharCount = 0;
        int paddingCharCount = 0;
        block4: for (char c : charArray) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block4;
                }
                case '=': {
                    ++paddingCharCount;
                    continue block4;
                }
                default: {
                    if (BallerinaParser.isBase64Char(c)) {
                        if (paddingCharCount == 0) {
                            ++base64CharCount;
                            continue block4;
                        }
                        return false;
                    }
                    return false;
                }
            }
        }
        if (paddingCharCount > 2) {
            return false;
        }
        if (paddingCharCount == 0) {
            return base64CharCount % 4 == 0;
        }
        return base64CharCount % 4 == 4 - paddingCharCount;
    }

    static boolean isBase64Char(int c) {
        if (97 <= c && c <= 122) {
            return true;
        }
        if (65 <= c && c <= 90) {
            return true;
        }
        if (c == 43 || c == 47) {
            return true;
        }
        return BallerinaParser.isDigit(c);
    }

    static boolean isHexDigit(int c) {
        if (97 <= c && c <= 102) {
            return true;
        }
        if (65 <= c && c <= 70) {
            return true;
        }
        return BallerinaParser.isDigit(c);
    }

    static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    private STNode parseXMLFilterExpression(STNode lhsExpr) {
        STNode xmlNamePatternChain = this.parseXMLFilterExpressionRhs();
        return STNodeFactory.createXMLFilterExpressionNode(lhsExpr, xmlNamePatternChain);
    }

    private STNode parseXMLFilterExpressionRhs() {
        STNode dotLTToken = this.parseDotLTToken();
        return this.parseXMLNamePatternChain(dotLTToken);
    }

    private STNode parseXMLNamePatternChain(STNode startToken) {
        this.startContext(ParserRuleContext.XML_NAME_PATTERN);
        STNode xmlNamePattern = this.parseXMLNamePattern();
        STNode gtToken = this.parseGTToken();
        this.endContext();
        startToken = this.cloneWithDiagnosticIfListEmpty(xmlNamePattern, startToken, DiagnosticErrorCode.ERROR_MISSING_XML_ATOMIC_NAME_PATTERN);
        return STNodeFactory.createXMLNamePatternChainingNode(startToken, xmlNamePattern, gtToken);
    }

    private STNode parseDotLTToken() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.DOT_LT_TOKEN) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.DOT_LT_TOKEN, new Object[0]);
        return this.parseDotLTToken();
    }

    private STNode parseXMLNamePattern() {
        STNode separator;
        ArrayList<STNode> xmlAtomicNamePatternList = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndOfXMLNamePattern(nextToken.kind)) {
            return STNodeFactory.createNodeList(xmlAtomicNamePatternList);
        }
        STNode xmlAtomicNamePattern = this.parseXMLAtomicNamePattern();
        xmlAtomicNamePatternList.add(xmlAtomicNamePattern);
        while (!this.isEndOfXMLNamePattern(this.peek().kind) && (separator = this.parseXMLNamePatternSeparator()) != null) {
            xmlAtomicNamePatternList.add(separator);
            xmlAtomicNamePattern = this.parseXMLAtomicNamePattern();
            xmlAtomicNamePatternList.add(xmlAtomicNamePattern);
        }
        return STNodeFactory.createNodeList(xmlAtomicNamePatternList);
    }

    private boolean isEndOfXMLNamePattern(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case EOF_TOKEN: 
            case GT_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseXMLNamePatternSeparator() {
        STToken token = this.peek();
        switch (token.kind) {
            case PIPE_TOKEN: {
                return this.consume();
            }
            case EOF_TOKEN: 
            case GT_TOKEN: {
                return null;
            }
        }
        this.recover(token, ParserRuleContext.XML_NAME_PATTERN_RHS, new Object[0]);
        return this.parseXMLNamePatternSeparator();
    }

    private STNode parseXMLAtomicNamePattern() {
        this.startContext(ParserRuleContext.XML_ATOMIC_NAME_PATTERN);
        STNode atomicNamePattern = this.parseXMLAtomicNamePatternBody();
        this.endContext();
        return atomicNamePattern;
    }

    private STNode parseXMLAtomicNamePatternBody() {
        STToken identifier;
        STToken token = this.peek();
        switch (token.kind) {
            case ASTERISK_TOKEN: {
                return this.consume();
            }
            case IDENTIFIER_TOKEN: {
                identifier = this.consume();
                break;
            }
            default: {
                this.recover(token, ParserRuleContext.XML_ATOMIC_NAME_PATTERN_START, new Object[0]);
                return this.parseXMLAtomicNamePatternBody();
            }
        }
        return this.parseXMLAtomicNameIdentifier(identifier);
    }

    private STNode parseXMLAtomicNameIdentifier(STNode identifier) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.COLON_TOKEN) {
            STToken colon = this.consume();
            STToken nextToken = this.peek();
            if (nextToken.kind == SyntaxKind.IDENTIFIER_TOKEN || nextToken.kind == SyntaxKind.ASTERISK_TOKEN) {
                STToken endToken = this.consume();
                return STNodeFactory.createXMLAtomicNamePatternNode(identifier, colon, endToken);
            }
        }
        return STNodeFactory.createSimpleNameReferenceNode(identifier);
    }

    private STNode parseXMLStepExpression(STNode lhsExpr) {
        STNode xmlStepStart = this.parseXMLStepStart();
        return STNodeFactory.createXMLStepExpressionNode(lhsExpr, xmlStepStart);
    }

    private STNode parseXMLStepStart() {
        STNode startToken;
        STToken token = this.peek();
        switch (token.kind) {
            case SLASH_ASTERISK_TOKEN: {
                return this.consume();
            }
            case DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN: {
                startToken = this.parseDoubleSlashDoubleAsteriskLTToken();
                break;
            }
            default: {
                startToken = this.parseSlashLTToken();
            }
        }
        return this.parseXMLNamePatternChain(startToken);
    }

    private STNode parseSlashLTToken() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.SLASH_LT_TOKEN) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.SLASH_LT_TOKEN, new Object[0]);
        return this.parseSlashLTToken();
    }

    private STNode parseDoubleSlashDoubleAsteriskLTToken() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN, new Object[0]);
        return this.parseDoubleSlashDoubleAsteriskLTToken();
    }

    private STNode parseMatchStatement() {
        this.startContext(ParserRuleContext.MATCH_STMT);
        STNode matchKeyword = this.parseMatchKeyword();
        STNode actionOrExpr = this.parseActionOrExpression();
        this.startContext(ParserRuleContext.MATCH_BODY);
        STNode openBrace = this.parseOpenBrace();
        ArrayList<STNode> matchClausesList = new ArrayList<STNode>();
        while (!this.isEndOfMatchClauses(this.peek().kind)) {
            STNode clause = this.parseMatchClause();
            matchClausesList.add(clause);
        }
        STNode matchClauses = STNodeFactory.createNodeList(matchClausesList);
        if (this.isNodeListEmpty(matchClauses)) {
            openBrace = SyntaxErrors.addDiagnostic(openBrace, DiagnosticErrorCode.ERROR_MATCH_STATEMENT_SHOULD_HAVE_ONE_OR_MORE_MATCH_CLAUSES, new Object[0]);
        }
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        this.endContext();
        STNode onFailClause = this.parseOptionalOnFailClause();
        return STNodeFactory.createMatchStatementNode(matchKeyword, actionOrExpr, openBrace, matchClauses, closeBrace, onFailClause);
    }

    private STNode parseMatchKeyword() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.MATCH_KEYWORD) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.MATCH_KEYWORD, new Object[0]);
        return this.parseMatchKeyword();
    }

    private boolean isEndOfMatchClauses(SyntaxKind nextTokenKind) {
        switch (nextTokenKind) {
            case EOF_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseMatchClause() {
        STNode matchPatterns = this.parseMatchPatternList();
        STNode matchGuard = this.parseMatchGuard();
        STNode rightDoubleArrow = this.parseDoubleRightArrow();
        STNode blockStmt = this.parseBlockNode();
        return STNodeFactory.createMatchClauseNode(matchPatterns, matchGuard, rightDoubleArrow, blockStmt);
    }

    private STNode parseMatchGuard() {
        switch (this.peek().kind) {
            case IF_KEYWORD: {
                STNode ifKeyword = this.parseIfKeyword();
                STNode expr = this.parseExpression(DEFAULT_OP_PRECEDENCE, true, false, true, false);
                return STNodeFactory.createMatchGuardNode(ifKeyword, expr);
            }
            case RIGHT_DOUBLE_ARROW_TOKEN: {
                return STNodeFactory.createEmptyNode();
            }
        }
        this.recover(this.peek(), ParserRuleContext.OPTIONAL_MATCH_GUARD, new Object[0]);
        return this.parseMatchGuard();
    }

    private STNode parseMatchPatternList() {
        STNode clause;
        this.startContext(ParserRuleContext.MATCH_PATTERN);
        ArrayList<STNode> matchClauses = new ArrayList<STNode>();
        while (!this.isEndOfMatchPattern(this.peek().kind) && (clause = this.parseMatchPattern()) != null) {
            matchClauses.add(clause);
            STNode seperator = this.parseMatchPatternEnd();
            if (seperator == null) break;
            matchClauses.add(seperator);
        }
        this.endContext();
        return STNodeFactory.createNodeList(matchClauses);
    }

    private boolean isEndOfMatchPattern(SyntaxKind nextTokenKind) {
        switch (nextTokenKind) {
            case PIPE_TOKEN: 
            case IF_KEYWORD: 
            case RIGHT_ARROW_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseMatchPattern() {
        switch (this.peek().kind) {
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case OPEN_PAREN_TOKEN: 
            case PLUS_TOKEN: 
            case MINUS_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                return this.parseSimpleConstExpr();
            }
            case IDENTIFIER_TOKEN: {
                STNode typeRefOrConstExpr = this.parseQualifiedIdentifier(ParserRuleContext.MATCH_PATTERN);
                return this.parseErrorMatchPatternOrConsPattern(typeRefOrConstExpr);
            }
            case VAR_KEYWORD: {
                return this.parseVarTypedBindingPattern();
            }
            case OPEN_BRACKET_TOKEN: {
                return this.parseListMatchPattern();
            }
            case OPEN_BRACE_TOKEN: {
                return this.parseMappingMatchPattern();
            }
            case ERROR_KEYWORD: {
                return this.parseErrorMatchPattern();
            }
        }
        this.recover(this.peek(), ParserRuleContext.MATCH_PATTERN_START, new Object[0]);
        return this.parseMatchPattern();
    }

    private STNode parseMatchPatternEnd() {
        switch (this.peek().kind) {
            case PIPE_TOKEN: {
                return this.parsePipeToken();
            }
            case RIGHT_DOUBLE_ARROW_TOKEN: 
            case IF_KEYWORD: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.MATCH_PATTERN_RHS, new Object[0]);
        return this.parseMatchPatternEnd();
    }

    private STNode parseVarTypedBindingPattern() {
        STNode varKeyword = this.parseVarKeyword();
        STNode varTypeDesc = this.createBuiltinSimpleNameReference(varKeyword);
        STNode bindingPattern = this.parseBindingPattern();
        return STNodeFactory.createTypedBindingPatternNode(varTypeDesc, bindingPattern);
    }

    private STNode parseVarKeyword() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.VAR_KEYWORD) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.VAR_KEYWORD, new Object[0]);
        return this.parseVarKeyword();
    }

    private STNode parseListMatchPattern() {
        this.startContext(ParserRuleContext.LIST_MATCH_PATTERN);
        STNode openBracketToken = this.parseOpenBracket();
        ArrayList<STNode> matchPatternList = new ArrayList<STNode>();
        STNode restMatchPattern = null;
        STNode listMatchPatternMemberRhs = null;
        boolean isEndOfFields = false;
        while (!this.isEndOfListMatchPattern()) {
            STNode listMatchPatternMember = this.parseListMatchPatternMember();
            if (listMatchPatternMember.kind == SyntaxKind.REST_MATCH_PATTERN) {
                restMatchPattern = listMatchPatternMember;
                listMatchPatternMemberRhs = this.parseListMatchPatternMemberRhs();
                isEndOfFields = true;
                break;
            }
            matchPatternList.add(listMatchPatternMember);
            listMatchPatternMemberRhs = this.parseListMatchPatternMemberRhs();
            if (listMatchPatternMemberRhs == null) break;
            matchPatternList.add(listMatchPatternMemberRhs);
        }
        while (isEndOfFields && listMatchPatternMemberRhs != null) {
            STNode invalidField = this.parseListMatchPatternMember();
            restMatchPattern = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(restMatchPattern, listMatchPatternMemberRhs);
            restMatchPattern = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(restMatchPattern, invalidField);
            restMatchPattern = SyntaxErrors.addDiagnostic(restMatchPattern, DiagnosticErrorCode.ERROR_MORE_MATCH_PATTERNS_AFTER_REST_MATCH_PATTERN, new Object[0]);
            listMatchPatternMemberRhs = this.parseListMatchPatternMemberRhs();
        }
        if (restMatchPattern == null) {
            restMatchPattern = STNodeFactory.createEmptyNode();
        }
        STNode matchPatternListNode = STNodeFactory.createNodeList(matchPatternList);
        STNode closeBracketToken = this.parseCloseBracket();
        this.endContext();
        return STNodeFactory.createListMatchPatternNode(openBracketToken, matchPatternListNode, restMatchPattern, closeBracketToken);
    }

    public boolean isEndOfListMatchPattern() {
        switch (this.peek().kind) {
            case EOF_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseListMatchPatternMember() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case ELLIPSIS_TOKEN: {
                return this.parseRestMatchPattern();
            }
        }
        return this.parseMatchPattern();
    }

    private STNode parseRestMatchPattern() {
        this.startContext(ParserRuleContext.REST_MATCH_PATTERN);
        STNode ellipsisToken = this.parseEllipsis();
        STNode varKeywordToken = this.parseVarKeyword();
        STNode variableName = this.parseVariableName();
        this.endContext();
        STSimpleNameReferenceNode simpleNameReferenceNode = (STSimpleNameReferenceNode)STNodeFactory.createSimpleNameReferenceNode(variableName);
        return STNodeFactory.createRestMatchPatternNode(ellipsisToken, varKeywordToken, simpleNameReferenceNode);
    }

    private STNode parseListMatchPatternMemberRhs() {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case EOF_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.LIST_MATCH_PATTERN_MEMBER_RHS, new Object[0]);
        return this.parseListMatchPatternMemberRhs();
    }

    private STNode parseMappingMatchPattern() {
        this.startContext(ParserRuleContext.MAPPING_MATCH_PATTERN);
        STNode openBraceToken = this.parseOpenBrace();
        ArrayList<STNode> fieldMatchPatternList = new ArrayList<STNode>();
        STNode restMatchPattern = null;
        boolean isEndOfFields = false;
        while (!this.isEndOfMappingMatchPattern()) {
            STNode fieldMatchPatternMember = this.parseFieldMatchPatternMember();
            if (fieldMatchPatternMember.kind == SyntaxKind.REST_MATCH_PATTERN) {
                restMatchPattern = fieldMatchPatternMember;
                isEndOfFields = true;
                break;
            }
            fieldMatchPatternList.add(fieldMatchPatternMember);
            STNode fieldMatchPatternRhs = this.parseFieldMatchPatternRhs();
            if (fieldMatchPatternRhs == null) break;
            fieldMatchPatternList.add(fieldMatchPatternRhs);
        }
        STNode fieldMatchPatternRhs = this.parseFieldMatchPatternRhs();
        while (isEndOfFields && fieldMatchPatternRhs != null) {
            STNode invalidField = this.parseFieldMatchPatternMember();
            restMatchPattern = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(restMatchPattern, fieldMatchPatternRhs);
            restMatchPattern = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(restMatchPattern, invalidField);
            restMatchPattern = SyntaxErrors.addDiagnostic(restMatchPattern, DiagnosticErrorCode.ERROR_MORE_FIELD_MATCH_PATTERNS_AFTER_REST_FIELD, new Object[0]);
            fieldMatchPatternRhs = this.parseFieldMatchPatternRhs();
        }
        if (restMatchPattern == null) {
            restMatchPattern = STNodeFactory.createEmptyNode();
        }
        STNode fieldMatchPatterns = STNodeFactory.createNodeList(fieldMatchPatternList);
        STNode closeBraceToken = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createMappingMatchPatternNode(openBraceToken, fieldMatchPatterns, restMatchPattern, closeBraceToken);
    }

    private STNode parseFieldMatchPatternMember() {
        switch (this.peek().kind) {
            case IDENTIFIER_TOKEN: {
                return this.parseFieldMatchPattern();
            }
            case ELLIPSIS_TOKEN: {
                return this.parseRestMatchPattern();
            }
        }
        this.recover(this.peek(), ParserRuleContext.FIELD_MATCH_PATTERN_MEMBER, new Object[0]);
        return this.parseFieldMatchPatternMember();
    }

    public STNode parseFieldMatchPattern() {
        STNode fieldNameNode = this.parseVariableName();
        STNode colonToken = this.parseColon();
        STNode matchPattern = this.parseMatchPattern();
        return STNodeFactory.createFieldMatchPatternNode(fieldNameNode, colonToken, matchPattern);
    }

    public boolean isEndOfMappingMatchPattern() {
        switch (this.peek().kind) {
            case EOF_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseFieldMatchPatternRhs() {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case EOF_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.FIELD_MATCH_PATTERN_MEMBER_RHS, new Object[0]);
        return this.parseFieldMatchPatternRhs();
    }

    private STNode parseErrorMatchPatternOrConsPattern(STNode typeRefOrConstExpr) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_PAREN_TOKEN: {
                STToken errorKeyword = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.ERROR_KEYWORD, ParserRuleContext.ERROR_KEYWORD);
                this.startContext(ParserRuleContext.ERROR_MATCH_PATTERN);
                return this.parseErrorMatchPattern(errorKeyword, typeRefOrConstExpr);
            }
        }
        if (this.isMatchPatternEnd(this.peek().kind)) {
            return typeRefOrConstExpr;
        }
        this.recover(this.peek(), ParserRuleContext.ERROR_MATCH_PATTERN_OR_CONST_PATTERN, typeRefOrConstExpr);
        return this.parseErrorMatchPatternOrConsPattern(typeRefOrConstExpr);
    }

    private boolean isMatchPatternEnd(SyntaxKind tokenKind) {
        switch (tokenKind) {
            case EOF_TOKEN: 
            case PIPE_TOKEN: 
            case COMMA_TOKEN: 
            case CLOSE_PAREN_TOKEN: 
            case RIGHT_DOUBLE_ARROW_TOKEN: 
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACKET_TOKEN: 
            case IF_KEYWORD: {
                return true;
            }
        }
        return false;
    }

    private STNode parseErrorMatchPattern() {
        this.startContext(ParserRuleContext.ERROR_MATCH_PATTERN);
        STToken errorKeyword = this.consume();
        return this.parseErrorMatchPattern(errorKeyword);
    }

    private STNode parseErrorMatchPattern(STNode errorKeyword) {
        STNode typeRef;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: {
                typeRef = this.parseTypeReference();
                break;
            }
            case OPEN_PAREN_TOKEN: {
                typeRef = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.ERROR_MATCH_PATTERN_ERROR_KEYWORD_RHS, new Object[0]);
                return this.parseErrorMatchPattern(errorKeyword);
            }
        }
        return this.parseErrorMatchPattern(errorKeyword, typeRef);
    }

    private STNode parseErrorMatchPattern(STNode errorKeyword, STNode typeRef) {
        STNode openParenthesisToken = this.parseOpenParenthesis(ParserRuleContext.OPEN_PARENTHESIS);
        STNode argListMatchPatternNode = this.parseErrorArgListMatchPatterns();
        STNode closeParenthesisToken = this.parseCloseParenthesis();
        this.endContext();
        return STNodeFactory.createErrorMatchPatternNode(errorKeyword, typeRef, openParenthesisToken, argListMatchPatternNode, closeParenthesisToken);
    }

    private STNode parseErrorArgListMatchPatterns() {
        ArrayList<STNode> argListMatchPatterns = new ArrayList<STNode>();
        if (this.isEndOfErrorFieldMatchPatterns()) {
            return STNodeFactory.createNodeList(argListMatchPatterns);
        }
        this.startContext(ParserRuleContext.ERROR_ARG_LIST_MATCH_PATTERN_FIRST_ARG);
        STNode firstArg = this.parseErrorArgListMatchPattern(ParserRuleContext.ERROR_ARG_LIST_MATCH_PATTERN_START);
        this.endContext();
        if (this.isSimpleMatchPattern(firstArg.kind)) {
            argListMatchPatterns.add(firstArg);
            STNode argEnd = this.parseErrorArgListMatchPatternEnd(ParserRuleContext.ERROR_MESSAGE_MATCH_PATTERN_END);
            if (argEnd != null) {
                STNode secondArg = this.parseErrorArgListMatchPattern(ParserRuleContext.ERROR_MESSAGE_MATCH_PATTERN_RHS);
                if (this.isValidSecondArgMatchPattern(secondArg.kind)) {
                    argListMatchPatterns.add(argEnd);
                    argListMatchPatterns.add(secondArg);
                } else {
                    this.updateLastNodeInListWithInvalidNode(argListMatchPatterns, argEnd, null, new Object[0]);
                    this.updateLastNodeInListWithInvalidNode(argListMatchPatterns, secondArg, DiagnosticErrorCode.ERROR_MATCH_PATTERN_NOT_ALLOWED, new Object[0]);
                }
            }
        } else if (firstArg.kind != SyntaxKind.NAMED_ARG_MATCH_PATTERN && firstArg.kind != SyntaxKind.REST_MATCH_PATTERN) {
            this.addInvalidNodeToNextToken(firstArg, DiagnosticErrorCode.ERROR_MATCH_PATTERN_NOT_ALLOWED, new Object[0]);
        } else {
            argListMatchPatterns.add(firstArg);
        }
        this.parseErrorFieldMatchPatterns(argListMatchPatterns);
        return STNodeFactory.createNodeList(argListMatchPatterns);
    }

    private boolean isSimpleMatchPattern(SyntaxKind matchPatternKind) {
        switch (matchPatternKind) {
            case IDENTIFIER_TOKEN: 
            case SIMPLE_NAME_REFERENCE: 
            case NUMERIC_LITERAL: 
            case STRING_LITERAL: 
            case NULL_LITERAL: 
            case NIL_LITERAL: 
            case BOOLEAN_LITERAL: 
            case TYPED_BINDING_PATTERN: 
            case UNARY_EXPRESSION: {
                return true;
            }
        }
        return false;
    }

    private boolean isValidSecondArgMatchPattern(SyntaxKind syntaxKind) {
        switch (syntaxKind) {
            case ERROR_MATCH_PATTERN: 
            case NAMED_ARG_MATCH_PATTERN: 
            case REST_MATCH_PATTERN: {
                return true;
            }
        }
        return this.isSimpleMatchPattern(syntaxKind);
    }

    private void parseErrorFieldMatchPatterns(List<STNode> argListMatchPatterns) {
        STNode argEnd;
        SyntaxKind lastValidArgKind = SyntaxKind.NAMED_ARG_MATCH_PATTERN;
        while (!this.isEndOfErrorFieldMatchPatterns() && (argEnd = this.parseErrorArgListMatchPatternEnd(ParserRuleContext.ERROR_FIELD_MATCH_PATTERN_RHS)) != null) {
            STNode currentArg = this.parseErrorArgListMatchPattern(ParserRuleContext.ERROR_FIELD_MATCH_PATTERN);
            DiagnosticErrorCode errorCode = this.validateErrorFieldMatchPatternOrder(lastValidArgKind, currentArg.kind);
            if (errorCode == null) {
                argListMatchPatterns.add(argEnd);
                argListMatchPatterns.add(currentArg);
                lastValidArgKind = currentArg.kind;
                continue;
            }
            if (argListMatchPatterns.size() == 0) {
                this.addInvalidNodeToNextToken(argEnd, null, new Object[0]);
                this.addInvalidNodeToNextToken(currentArg, errorCode, new Object[0]);
                continue;
            }
            this.updateLastNodeInListWithInvalidNode(argListMatchPatterns, argEnd, null, new Object[0]);
            this.updateLastNodeInListWithInvalidNode(argListMatchPatterns, currentArg, errorCode, new Object[0]);
        }
    }

    private boolean isEndOfErrorFieldMatchPatterns() {
        return this.isEndOfErrorFieldBindingPatterns();
    }

    private STNode parseErrorArgListMatchPatternEnd(ParserRuleContext currentCtx) {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.consume();
            }
            case CLOSE_PAREN_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), currentCtx, new Object[0]);
        return this.parseErrorArgListMatchPatternEnd(currentCtx);
    }

    private STNode parseErrorArgListMatchPattern(ParserRuleContext context) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case ELLIPSIS_TOKEN: {
                return this.parseRestMatchPattern();
            }
            case IDENTIFIER_TOKEN: {
                return this.parseNamedOrSimpleMatchPattern();
            }
            case OPEN_BRACKET_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: 
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case OPEN_PAREN_TOKEN: 
            case PLUS_TOKEN: 
            case MINUS_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                return this.parseMatchPattern();
            }
            case VAR_KEYWORD: {
                STToken varKeyword = this.consume();
                STNode variableName = this.parseVariableName();
                return STNodeFactory.createTypedBindingPatternNode(varKeyword, variableName);
            }
        }
        this.recover(nextToken, context, new Object[0]);
        return this.parseErrorArgListMatchPattern(context);
    }

    private STNode parseNamedOrSimpleMatchPattern() {
        STToken identifier = this.consume();
        STToken secondToken = this.peek();
        switch (secondToken.kind) {
            case EQUAL_TOKEN: {
                return this.parseNamedArgMatchPattern(identifier);
            }
        }
        return identifier;
    }

    private STNode parseNamedArgMatchPattern(STNode identifier) {
        this.startContext(ParserRuleContext.NAMED_ARG_MATCH_PATTERN);
        STNode equalToken = this.parseAssignOp();
        STNode matchPattern = this.parseMatchPattern();
        this.endContext();
        return STNodeFactory.createNamedArgMatchPatternNode(identifier, equalToken, matchPattern);
    }

    private DiagnosticErrorCode validateErrorFieldMatchPatternOrder(SyntaxKind prevArgKind, SyntaxKind currentArgKind) {
        switch (currentArgKind) {
            case NAMED_ARG_MATCH_PATTERN: 
            case REST_MATCH_PATTERN: {
                if (prevArgKind == SyntaxKind.REST_MATCH_PATTERN) {
                    return DiagnosticErrorCode.ERROR_REST_ARG_FOLLOWED_BY_ANOTHER_ARG;
                }
                return null;
            }
        }
        return DiagnosticErrorCode.ERROR_MATCH_PATTERN_NOT_ALLOWED;
    }

    private STNode parseMarkdownDocumentation() {
        ArrayList<STNode> markdownDocLineList = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (nextToken.kind == SyntaxKind.DOCUMENTATION_STRING) {
            STToken documentationString = this.consume();
            STNode parsedDocLines = this.parseDocumentationString(documentationString);
            this.appendParsedDocumentationLines(markdownDocLineList, parsedDocLines);
            nextToken = this.peek();
        }
        STNode markdownDocLines = STNodeFactory.createNodeList(markdownDocLineList);
        return STNodeFactory.createMarkdownDocumentationNode(markdownDocLines);
    }

    private STNode parseDocumentationString(STToken documentationStringToken) {
        List<STNode> leadingTriviaList = this.getLeadingTriviaList(documentationStringToken.leadingMinutiae());
        ArrayList<STNodeDiagnostic> diagnostics = new ArrayList<STNodeDiagnostic>(documentationStringToken.diagnostics());
        CharReader charReader = CharReader.from(documentationStringToken.text());
        DocumentationLexer documentationLexer = new DocumentationLexer(charReader, leadingTriviaList, diagnostics);
        TokenReader tokenReader = new TokenReader(documentationLexer);
        DocumentationParser documentationParser = new DocumentationParser(tokenReader);
        return documentationParser.parse();
    }

    private List<STNode> getLeadingTriviaList(STNode leadingMinutiaeNode) {
        ArrayList<STNode> leadingTriviaList = new ArrayList<STNode>();
        int bucketCount = leadingMinutiaeNode.bucketCount();
        for (int i = 0; i < bucketCount; ++i) {
            leadingTriviaList.add(leadingMinutiaeNode.childInBucket(i));
        }
        return leadingTriviaList;
    }

    private void appendParsedDocumentationLines(List<STNode> markdownDocLineList, STNode parsedDocLines) {
        int bucketCount = parsedDocLines.bucketCount();
        for (int i = 0; i < bucketCount; ++i) {
            STNode markdownDocLine = parsedDocLines.childInBucket(i);
            markdownDocLineList.add(markdownDocLine);
        }
    }

    private STNode parseStmtStartsWithTypeOrExpr(STNode annots, List<STNode> qualifiers) {
        this.startContext(ParserRuleContext.AMBIGUOUS_STMT);
        STNode typeOrExpr = this.parseTypedBindingPatternOrExpr(qualifiers, true);
        return this.parseStmtStartsWithTypedBPOrExprRhs(annots, typeOrExpr);
    }

    private STNode parseStmtStartsWithTypedBPOrExprRhs(STNode annots, STNode typedBindingPatternOrExpr) {
        if (typedBindingPatternOrExpr.kind == SyntaxKind.TYPED_BINDING_PATTERN) {
            ArrayList<STNode> varDeclQualifiers = new ArrayList<STNode>();
            this.switchContext(ParserRuleContext.VAR_DECL_STMT);
            return this.parseVarDeclRhs(annots, varDeclQualifiers, typedBindingPatternOrExpr, false);
        }
        STNode expr = this.getExpression(typedBindingPatternOrExpr);
        expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, expr, false, true);
        return this.parseStatementStartWithExprRhs(expr);
    }

    private STNode parseTypedBindingPatternOrExpr(boolean allowAssignment) {
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        return this.parseTypedBindingPatternOrExpr(typeDescQualifiers, allowAssignment);
    }

    private STNode parseTypedBindingPatternOrExpr(List<STNode> qualifiers, boolean allowAssignment) {
        this.parseTypeDescQualifiers(qualifiers);
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_PAREN_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseTypedBPOrExprStartsWithOpenParenthesis();
            }
            case FUNCTION_KEYWORD: {
                return this.parseAnonFuncExprOrTypedBPWithFuncType(qualifiers);
            }
            case IDENTIFIER_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                STNode typeOrExpr = this.parseQualifiedIdentifier(ParserRuleContext.TYPE_NAME_OR_VAR_NAME);
                return this.parseTypedBindingPatternOrExprRhs(typeOrExpr, allowAssignment);
            }
            case OPEN_BRACKET_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                STNode typeOrExpr = this.parseTupleTypeDescOrExprStartsWithOpenBracket();
                return this.parseTypedBindingPatternOrExprRhs(typeOrExpr, allowAssignment);
            }
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                STNode basicLiteral = this.parseBasicLiteral();
                return this.parseTypedBindingPatternOrExprRhs(basicLiteral, allowAssignment);
            }
        }
        if (this.isValidExpressionStart(nextToken.kind, 1)) {
            this.reportInvalidQualifierList(qualifiers);
            return this.parseActionOrExpressionInLhs(STNodeFactory.createEmptyNodeList());
        }
        return this.parseTypedBindingPattern(qualifiers, ParserRuleContext.VAR_DECL_STMT);
    }

    private STNode parseTypedBindingPatternOrExprRhs(STNode typeOrExpr, boolean allowAssignment) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case PIPE_TOKEN: {
                STToken nextNextToken = this.peek(2);
                if (nextNextToken.kind == SyntaxKind.EQUAL_TOKEN) {
                    return typeOrExpr;
                }
                STNode pipe = this.parsePipeToken();
                STNode rhsTypedBPOrExpr = this.parseTypedBindingPatternOrExpr(allowAssignment);
                if (rhsTypedBPOrExpr.kind == SyntaxKind.TYPED_BINDING_PATTERN) {
                    STTypedBindingPatternNode typedBP = (STTypedBindingPatternNode)rhsTypedBPOrExpr;
                    typeOrExpr = this.getTypeDescFromExpr(typeOrExpr);
                    STNode newTypeDesc = this.createUnionTypeDesc(typeOrExpr, pipe, typedBP.typeDescriptor);
                    return STNodeFactory.createTypedBindingPatternNode(newTypeDesc, typedBP.bindingPattern);
                }
                return STNodeFactory.createBinaryExpressionNode(SyntaxKind.BINARY_EXPRESSION, typeOrExpr, pipe, rhsTypedBPOrExpr);
            }
            case BITWISE_AND_TOKEN: {
                STToken nextNextToken = this.peek(2);
                if (nextNextToken.kind == SyntaxKind.EQUAL_TOKEN) {
                    return typeOrExpr;
                }
                STNode ampersand = this.parseBinaryOperator();
                STNode rhsTypedBPOrExpr = this.parseTypedBindingPatternOrExpr(allowAssignment);
                if (rhsTypedBPOrExpr.kind == SyntaxKind.TYPED_BINDING_PATTERN) {
                    STTypedBindingPatternNode typedBP = (STTypedBindingPatternNode)rhsTypedBPOrExpr;
                    typeOrExpr = this.getTypeDescFromExpr(typeOrExpr);
                    STNode newTypeDesc = this.createIntersectionTypeDesc(typeOrExpr, ampersand, typedBP.typeDescriptor);
                    return STNodeFactory.createTypedBindingPatternNode(newTypeDesc, typedBP.bindingPattern);
                }
                return STNodeFactory.createBinaryExpressionNode(SyntaxKind.BINARY_EXPRESSION, typeOrExpr, ampersand, rhsTypedBPOrExpr);
            }
            case SEMICOLON_TOKEN: {
                if (this.isDefiniteExpr(typeOrExpr.kind)) {
                    return typeOrExpr;
                }
                if (this.isDefiniteTypeDesc(typeOrExpr.kind) || !this.isAllBasicLiterals(typeOrExpr)) {
                    STNode typeDesc = this.getTypeDescFromExpr(typeOrExpr);
                    return this.parseTypeBindingPatternStartsWithAmbiguousNode(typeDesc);
                }
                return typeOrExpr;
            }
            case IDENTIFIER_TOKEN: 
            case QUESTION_MARK_TOKEN: {
                if (this.isAmbiguous(typeOrExpr) || this.isDefiniteTypeDesc(typeOrExpr.kind)) {
                    STNode typeDesc = this.getTypeDescFromExpr(typeOrExpr);
                    return this.parseTypeBindingPatternStartsWithAmbiguousNode(typeDesc);
                }
                return typeOrExpr;
            }
            case EQUAL_TOKEN: {
                return typeOrExpr;
            }
            case OPEN_BRACKET_TOKEN: {
                return this.parseTypedBindingPatternOrMemberAccess(typeOrExpr, false, allowAssignment, ParserRuleContext.AMBIGUOUS_STMT);
            }
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: {
                STNode typeDesc = this.getTypeDescFromExpr(typeOrExpr);
                return this.parseTypeBindingPatternStartsWithAmbiguousNode(typeDesc);
            }
        }
        if (this.isCompoundBinaryOperator(nextToken.kind)) {
            return typeOrExpr;
        }
        if (this.isValidExprRhsStart(nextToken.kind, typeOrExpr.kind)) {
            return typeOrExpr;
        }
        STToken token = this.peek();
        this.recover(token, ParserRuleContext.BINDING_PATTERN_OR_EXPR_RHS, typeOrExpr, allowAssignment);
        return this.parseTypedBindingPatternOrExprRhs(typeOrExpr, allowAssignment);
    }

    private STNode parseTypeBindingPatternStartsWithAmbiguousNode(STNode typeDesc) {
        this.startContext(ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN);
        typeDesc = this.parseComplexTypeDescriptor(typeDesc, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, false);
        this.endContext();
        return this.parseTypedBindingPatternTypeRhs(typeDesc, ParserRuleContext.VAR_DECL_STMT);
    }

    private STNode parseTypedBPOrExprStartsWithOpenParenthesis() {
        STNode exprOrTypeDesc = this.parseTypedDescOrExprStartsWithOpenParenthesis();
        if (this.isDefiniteTypeDesc(exprOrTypeDesc.kind)) {
            return this.parseTypeBindingPatternStartsWithAmbiguousNode(exprOrTypeDesc);
        }
        return this.parseTypedBindingPatternOrExprRhs(exprOrTypeDesc, false);
    }

    private boolean isDefiniteTypeDesc(SyntaxKind kind) {
        return kind.compareTo(SyntaxKind.RECORD_TYPE_DESC) >= 0 && kind.compareTo(SyntaxKind.SINGLETON_TYPE_DESC) <= 0;
    }

    private boolean isDefiniteExpr(SyntaxKind kind) {
        if (kind == SyntaxKind.QUALIFIED_NAME_REFERENCE || kind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            return false;
        }
        return kind.compareTo(SyntaxKind.BINARY_EXPRESSION) >= 0 && kind.compareTo(SyntaxKind.XML_ATOMIC_NAME_PATTERN) <= 0;
    }

    private STNode parseTypedDescOrExprStartsWithOpenParenthesis() {
        STNode openParen = this.parseOpenParenthesis(ParserRuleContext.OPEN_PARENTHESIS);
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.CLOSE_PAREN_TOKEN) {
            STNode closeParen = this.parseCloseParenthesis();
            return this.parseTypeOrExprStartWithEmptyParenthesis(openParen, closeParen);
        }
        STNode typeOrExpr = this.parseTypeDescOrExpr();
        if (this.isAction(typeOrExpr)) {
            STNode closeParen = this.parseCloseParenthesis();
            return STNodeFactory.createBracedExpressionNode(SyntaxKind.BRACED_ACTION, openParen, typeOrExpr, closeParen);
        }
        if (this.isExpression(typeOrExpr.kind)) {
            this.startContext(ParserRuleContext.BRACED_EXPR_OR_ANON_FUNC_PARAMS);
            return this.parseBracedExprOrAnonFuncParamRhs(openParen, typeOrExpr, false);
        }
        STNode closeParen = this.parseCloseParenthesis();
        return STNodeFactory.createParenthesisedTypeDescriptorNode(openParen, typeOrExpr, closeParen);
    }

    private STNode parseTypeDescOrExpr() {
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        return this.parseTypeDescOrExpr(typeDescQualifiers);
    }

    private STNode parseTypeDescOrExpr(List<STNode> qualifiers) {
        STNode typeOrExpr;
        this.parseTypeDescQualifiers(qualifiers);
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_PAREN_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                typeOrExpr = this.parseTypedDescOrExprStartsWithOpenParenthesis();
                break;
            }
            case FUNCTION_KEYWORD: {
                typeOrExpr = this.parseAnonFuncExprOrFuncTypeDesc(qualifiers);
                break;
            }
            case IDENTIFIER_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                STNode typeOrExpr2 = this.parseQualifiedIdentifier(ParserRuleContext.TYPE_NAME_OR_VAR_NAME);
                return this.parseTypeDescOrExprRhs(typeOrExpr2);
            }
            case OPEN_BRACKET_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                typeOrExpr = this.parseTupleTypeDescOrExprStartsWithOpenBracket();
                break;
            }
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                STNode basicLiteral = this.parseBasicLiteral();
                return this.parseTypeDescOrExprRhs(basicLiteral);
            }
            default: {
                if (this.isValidExpressionStart(nextToken.kind, 1)) {
                    this.reportInvalidQualifierList(qualifiers);
                    return this.parseActionOrExpressionInLhs(STNodeFactory.createEmptyNodeList());
                }
                return this.parseTypeDescriptor(qualifiers, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN);
            }
        }
        if (this.isDefiniteTypeDesc(typeOrExpr.kind)) {
            return this.parseComplexTypeDescriptor(typeOrExpr, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
        }
        return this.parseTypeDescOrExprRhs(typeOrExpr);
    }

    private boolean isExpression(SyntaxKind kind) {
        switch (kind) {
            case STRING_LITERAL_TOKEN: 
            case NUMERIC_LITERAL: 
            case NULL_LITERAL: 
            case NIL_LITERAL: 
            case BOOLEAN_LITERAL: {
                return true;
            }
        }
        return kind.compareTo(SyntaxKind.BINARY_EXPRESSION) >= 0 && kind.compareTo(SyntaxKind.XML_ATOMIC_NAME_PATTERN) <= 0;
    }

    private STNode parseTypeOrExprStartWithEmptyParenthesis(STNode openParen, STNode closeParen) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case RIGHT_DOUBLE_ARROW_TOKEN: {
                STNode params = STNodeFactory.createEmptyNodeList();
                STNode anonFuncParam = STNodeFactory.createImplicitAnonymousFunctionParameters(openParen, params, closeParen);
                this.endContext();
                return anonFuncParam;
            }
        }
        return STNodeFactory.createNilLiteralNode(openParen, closeParen);
    }

    private STNode parseAnonFuncExprOrTypedBPWithFuncType(List<STNode> qualifiers) {
        STNode exprOrTypeDesc = this.parseAnonFuncExprOrFuncTypeDesc(qualifiers);
        if (this.isAction(exprOrTypeDesc) || this.isExpression(exprOrTypeDesc.kind)) {
            return exprOrTypeDesc;
        }
        return this.parseTypedBindingPatternTypeRhs(exprOrTypeDesc, ParserRuleContext.VAR_DECL_STMT);
    }

    private STNode parseAnonFuncExprOrFuncTypeDesc(List<STNode> qualifiers) {
        this.startContext(ParserRuleContext.FUNC_TYPE_DESC_OR_ANON_FUNC);
        STNode qualifierList = this.createFuncTypeQualNodeList(qualifiers);
        STNode functionKeyword = this.parseFunctionKeyword();
        STNode funcSignature = this.parseFuncSignature(true);
        this.endContext();
        ParserRuleContext currentCtx = this.getCurrentContext();
        switch (this.peek().kind) {
            case OPEN_BRACE_TOKEN: 
            case RIGHT_DOUBLE_ARROW_TOKEN: {
                if (currentCtx != ParserRuleContext.STMT_START_BRACKETED_LIST) {
                    this.switchContext(ParserRuleContext.EXPRESSION_STATEMENT);
                }
                this.startContext(ParserRuleContext.ANON_FUNC_EXPRESSION);
                funcSignature = this.validateAndGetFuncParams((STFunctionSignatureNode)funcSignature);
                STNode funcBody = this.parseAnonFuncBody(false);
                STNode annots = STNodeFactory.createEmptyNodeList();
                STNode anonFunc = STNodeFactory.createExplicitAnonymousFunctionExpressionNode(annots, qualifierList, functionKeyword, funcSignature, funcBody);
                return this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, anonFunc, false, true);
            }
        }
        STNode funcTypeDesc = STNodeFactory.createFunctionTypeDescriptorNode(qualifierList, functionKeyword, funcSignature);
        if (currentCtx != ParserRuleContext.STMT_START_BRACKETED_LIST) {
            this.switchContext(ParserRuleContext.VAR_DECL_STMT);
            return this.parseComplexTypeDescriptor(funcTypeDesc, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
        }
        return this.parseComplexTypeDescriptor(funcTypeDesc, ParserRuleContext.TYPE_DESC_IN_TUPLE, false);
    }

    private STNode parseTypeDescOrExprRhs(STNode typeOrExpr) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case PIPE_TOKEN: {
                STToken nextNextToken = this.peek(2);
                if (nextNextToken.kind == SyntaxKind.EQUAL_TOKEN) {
                    return typeOrExpr;
                }
                STNode pipe = this.parsePipeToken();
                STNode rhsTypeDescOrExpr = this.parseTypeDescOrExpr();
                if (this.isExpression(rhsTypeDescOrExpr.kind)) {
                    return STNodeFactory.createBinaryExpressionNode(SyntaxKind.BINARY_EXPRESSION, typeOrExpr, pipe, rhsTypeDescOrExpr);
                }
                STNode typeDesc = this.getTypeDescFromExpr(typeOrExpr);
                rhsTypeDescOrExpr = this.getTypeDescFromExpr(rhsTypeDescOrExpr);
                return this.createUnionTypeDesc(typeDesc, pipe, rhsTypeDescOrExpr);
            }
            case BITWISE_AND_TOKEN: {
                STToken nextNextToken = this.peek(2);
                if (nextNextToken.kind == SyntaxKind.EQUAL_TOKEN) {
                    return typeOrExpr;
                }
                STNode ampersand = this.parseBinaryOperator();
                STNode rhsTypeDescOrExpr = this.parseTypeDescOrExpr();
                if (this.isExpression(rhsTypeDescOrExpr.kind)) {
                    return STNodeFactory.createBinaryExpressionNode(SyntaxKind.BINARY_EXPRESSION, typeOrExpr, ampersand, rhsTypeDescOrExpr);
                }
                STNode typeDesc = this.getTypeDescFromExpr(typeOrExpr);
                rhsTypeDescOrExpr = this.getTypeDescFromExpr(rhsTypeDescOrExpr);
                return this.createIntersectionTypeDesc(typeDesc, ampersand, rhsTypeDescOrExpr);
            }
            case IDENTIFIER_TOKEN: 
            case QUESTION_MARK_TOKEN: {
                this.startContext(ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN);
                STNode typeDesc = this.parseComplexTypeDescriptor(typeOrExpr, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, false);
                this.endContext();
                return typeDesc;
            }
            case SEMICOLON_TOKEN: {
                return this.getTypeDescFromExpr(typeOrExpr);
            }
            case EOF_TOKEN: 
            case EQUAL_TOKEN: 
            case COMMA_TOKEN: 
            case CLOSE_PAREN_TOKEN: 
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                return typeOrExpr;
            }
            case OPEN_BRACKET_TOKEN: {
                return this.parseTypedBindingPatternOrMemberAccess(typeOrExpr, false, true, ParserRuleContext.AMBIGUOUS_STMT);
            }
            case ELLIPSIS_TOKEN: {
                STNode ellipsis = this.parseEllipsis();
                typeOrExpr = this.getTypeDescFromExpr(typeOrExpr);
                return STNodeFactory.createRestDescriptorNode(typeOrExpr, ellipsis);
            }
        }
        if (this.isCompoundBinaryOperator(nextToken.kind)) {
            return typeOrExpr;
        }
        if (this.isValidExprRhsStart(nextToken.kind, typeOrExpr.kind)) {
            return this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, typeOrExpr, false, false, false, false);
        }
        this.recover(this.peek(), ParserRuleContext.TYPE_DESC_OR_EXPR_RHS, typeOrExpr);
        return this.parseTypeDescOrExprRhs(typeOrExpr);
    }

    private boolean isAmbiguous(STNode node) {
        switch (node.kind) {
            case SIMPLE_NAME_REFERENCE: 
            case QUALIFIED_NAME_REFERENCE: 
            case NUMERIC_LITERAL: 
            case STRING_LITERAL: 
            case NULL_LITERAL: 
            case NIL_LITERAL: 
            case BOOLEAN_LITERAL: 
            case BRACKETED_LIST: {
                return true;
            }
            case BINARY_EXPRESSION: {
                STBinaryExpressionNode binaryExpr = (STBinaryExpressionNode)node;
                if (binaryExpr.operator.kind != SyntaxKind.PIPE_TOKEN || binaryExpr.operator.kind == SyntaxKind.BITWISE_AND_TOKEN) {
                    return false;
                }
                return this.isAmbiguous(binaryExpr.lhsExpr) && this.isAmbiguous(binaryExpr.rhsExpr);
            }
            case BRACED_EXPRESSION: {
                return this.isAmbiguous(((STBracedExpressionNode)node).expression);
            }
            case INDEXED_EXPRESSION: {
                STIndexedExpressionNode indexExpr = (STIndexedExpressionNode)node;
                if (!this.isAmbiguous(indexExpr.containerExpression)) {
                    return false;
                }
                STNode keys = indexExpr.keyExpression;
                for (int i = 0; i < keys.bucketCount(); ++i) {
                    STNode item = keys.childInBucket(i);
                    if (item.kind == SyntaxKind.COMMA_TOKEN || this.isAmbiguous(item)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isAllBasicLiterals(STNode node) {
        switch (node.kind) {
            case NUMERIC_LITERAL: 
            case STRING_LITERAL: 
            case NULL_LITERAL: 
            case NIL_LITERAL: 
            case BOOLEAN_LITERAL: {
                return true;
            }
            case BINARY_EXPRESSION: {
                STBinaryExpressionNode binaryExpr = (STBinaryExpressionNode)node;
                if (binaryExpr.operator.kind != SyntaxKind.PIPE_TOKEN || binaryExpr.operator.kind == SyntaxKind.BITWISE_AND_TOKEN) {
                    return false;
                }
                return this.isAmbiguous(binaryExpr.lhsExpr) && this.isAmbiguous(binaryExpr.rhsExpr);
            }
            case BRACED_EXPRESSION: {
                return this.isAmbiguous(((STBracedExpressionNode)node).expression);
            }
            case BRACKETED_LIST: {
                STAmbiguousCollectionNode list = (STAmbiguousCollectionNode)node;
                for (STNode member : list.members) {
                    if (member.kind == SyntaxKind.COMMA_TOKEN || this.isAllBasicLiterals(member)) continue;
                    return false;
                }
                return true;
            }
            case UNARY_EXPRESSION: {
                STUnaryExpressionNode unaryExpr = (STUnaryExpressionNode)node;
                if (unaryExpr.unaryOperator.kind != SyntaxKind.PLUS_TOKEN && unaryExpr.unaryOperator.kind != SyntaxKind.MINUS_TOKEN) {
                    return false;
                }
                return this.isNumericLiteral(unaryExpr.expression);
            }
        }
        return false;
    }

    private boolean isNumericLiteral(STNode node) {
        switch (node.kind) {
            case NUMERIC_LITERAL: {
                return true;
            }
        }
        return false;
    }

    private STNode parseTupleTypeDescOrExprStartsWithOpenBracket() {
        this.startContext(ParserRuleContext.BRACKETED_LIST);
        STNode openBracket = this.parseOpenBracket();
        ArrayList<STNode> members = new ArrayList<STNode>();
        while (!this.isEndOfListConstructor(this.peek().kind)) {
            STNode expr = this.parseTypeDescOrExpr();
            if (this.peek().kind == SyntaxKind.ELLIPSIS_TOKEN && this.isDefiniteTypeDesc(expr.kind)) {
                STToken ellipsis = this.consume();
                expr = STNodeFactory.createRestDescriptorNode(expr, ellipsis);
            }
            members.add(expr);
            STNode memberEnd = this.parseBracketedListMemberEnd();
            if (memberEnd == null) break;
            members.add(memberEnd);
        }
        STNode memberNodes = STNodeFactory.createNodeList(members);
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        return STNodeFactory.createTupleTypeDescriptorNode(openBracket, memberNodes, closeBracket);
    }

    private STNode parseBindingPattern() {
        switch (this.peek().kind) {
            case OPEN_BRACKET_TOKEN: {
                return this.parseListBindingPattern();
            }
            case IDENTIFIER_TOKEN: {
                return this.parseBindingPatternStartsWithIdentifier();
            }
            case OPEN_BRACE_TOKEN: {
                return this.parseMappingBindingPattern();
            }
            case ERROR_KEYWORD: {
                return this.parseErrorBindingPattern();
            }
        }
        this.recover(this.peek(), ParserRuleContext.BINDING_PATTERN, new Object[0]);
        return this.parseBindingPattern();
    }

    private STNode parseBindingPatternStartsWithIdentifier() {
        STNode argNameOrBindingPattern = this.parseQualifiedIdentifier(ParserRuleContext.BINDING_PATTERN_STARTING_IDENTIFIER);
        STToken secondToken = this.peek();
        if (secondToken.kind == SyntaxKind.OPEN_PAREN_TOKEN) {
            this.startContext(ParserRuleContext.ERROR_BINDING_PATTERN);
            STToken errorKeyword = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.ERROR_KEYWORD, ParserRuleContext.ERROR_KEYWORD);
            return this.parseErrorBindingPattern(errorKeyword, argNameOrBindingPattern);
        }
        if (argNameOrBindingPattern.kind != SyntaxKind.SIMPLE_NAME_REFERENCE) {
            STNode identifier = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, ParserRuleContext.BINDING_PATTERN_STARTING_IDENTIFIER);
            identifier = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(identifier, argNameOrBindingPattern);
            return this.createCaptureOrWildcardBP(identifier);
        }
        return this.createCaptureOrWildcardBP(((STSimpleNameReferenceNode)argNameOrBindingPattern).name);
    }

    private STNode createCaptureOrWildcardBP(STNode varName) {
        STNode bindingPattern = this.isWildcardBP(varName) ? this.getWildcardBindingPattern(varName) : STNodeFactory.createCaptureBindingPatternNode(varName);
        return bindingPattern;
    }

    private STNode parseListBindingPattern() {
        this.startContext(ParserRuleContext.LIST_BINDING_PATTERN);
        STNode openBracket = this.parseOpenBracket();
        ArrayList<STNode> bindingPatternsList = new ArrayList<STNode>();
        STNode listBindingPattern = this.parseListBindingPattern(openBracket, bindingPatternsList);
        this.endContext();
        return listBindingPattern;
    }

    private STNode parseListBindingPattern(STNode openBracket, List<STNode> bindingPatternsList) {
        if (this.isEndOfListBindingPattern(this.peek().kind) && bindingPatternsList.size() == 0) {
            STNode closeBracket = this.parseCloseBracket();
            STNode restBindingPattern = STNodeFactory.createEmptyNode();
            STNode bindingPatternsNode = STNodeFactory.createNodeList(bindingPatternsList);
            return STNodeFactory.createListBindingPatternNode(openBracket, bindingPatternsNode, restBindingPattern, closeBracket);
        }
        STNode listBindingPatternMember = this.parseListBindingPatternMember();
        bindingPatternsList.add(listBindingPatternMember);
        STNode listBindingPattern = this.parseListBindingPattern(openBracket, listBindingPatternMember, bindingPatternsList);
        return listBindingPattern;
    }

    private STNode parseListBindingPattern(STNode openBracket, STNode firstMember, List<STNode> bindingPatterns) {
        STNode member = firstMember;
        STToken token = this.peek();
        STNode listBindingPatternRhs = null;
        while (!this.isEndOfListBindingPattern(token.kind) && member.kind != SyntaxKind.REST_BINDING_PATTERN && (listBindingPatternRhs = this.parseListBindingPatternMemberRhs()) != null) {
            bindingPatterns.add(listBindingPatternRhs);
            member = this.parseListBindingPatternMember();
            bindingPatterns.add(member);
            token = this.peek();
        }
        STNode restBindingPattern = member.kind == SyntaxKind.REST_BINDING_PATTERN ? bindingPatterns.remove(bindingPatterns.size() - 1) : STNodeFactory.createEmptyNode();
        STNode closeBracket = this.parseCloseBracket();
        STNode bindingPatternsNode = STNodeFactory.createNodeList(bindingPatterns);
        return STNodeFactory.createListBindingPatternNode(openBracket, bindingPatternsNode, restBindingPattern, closeBracket);
    }

    private STNode parseListBindingPatternMemberRhs() {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case CLOSE_BRACKET_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.LIST_BINDING_PATTERN_MEMBER_END, new Object[0]);
        return this.parseListBindingPatternMemberRhs();
    }

    private boolean isEndOfListBindingPattern(SyntaxKind nextTokenKind) {
        switch (nextTokenKind) {
            case EOF_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseListBindingPatternMember() {
        switch (this.peek().kind) {
            case ELLIPSIS_TOKEN: {
                return this.parseRestBindingPattern();
            }
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACKET_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: {
                return this.parseBindingPattern();
            }
        }
        this.recover(this.peek(), ParserRuleContext.LIST_BINDING_PATTERN_MEMBER, new Object[0]);
        return this.parseListBindingPatternMember();
    }

    private STNode parseRestBindingPattern() {
        this.startContext(ParserRuleContext.REST_BINDING_PATTERN);
        STNode ellipsis = this.parseEllipsis();
        STNode varName = this.parseVariableName();
        this.endContext();
        STSimpleNameReferenceNode simpleNameReferenceNode = (STSimpleNameReferenceNode)STNodeFactory.createSimpleNameReferenceNode(varName);
        return STNodeFactory.createRestBindingPatternNode(ellipsis, simpleNameReferenceNode);
    }

    private STNode parseTypedBindingPattern(ParserRuleContext context) {
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        return this.parseTypedBindingPattern(typeDescQualifiers, context);
    }

    private STNode parseTypedBindingPattern(List<STNode> qualifiers, ParserRuleContext context) {
        STNode typeDesc = this.parseTypeDescriptor(qualifiers, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true, false);
        STNode typeBindingPattern = this.parseTypedBindingPatternTypeRhs(typeDesc, context);
        return typeBindingPattern;
    }

    private STNode parseMappingBindingPattern() {
        this.startContext(ParserRuleContext.MAPPING_BINDING_PATTERN);
        STNode openBrace = this.parseOpenBrace();
        STToken token = this.peek();
        if (this.isEndOfMappingBindingPattern(token.kind)) {
            STNode closeBrace = this.parseCloseBrace();
            STNode bindingPatternsNode = STNodeFactory.createEmptyNodeList();
            STNode restBindingPattern = STNodeFactory.createEmptyNode();
            this.endContext();
            return STNodeFactory.createMappingBindingPatternNode(openBrace, bindingPatternsNode, restBindingPattern, closeBrace);
        }
        ArrayList<STNode> bindingPatterns = new ArrayList<STNode>();
        STNode prevMember = this.parseMappingBindingPatternMember();
        if (prevMember.kind != SyntaxKind.REST_BINDING_PATTERN) {
            bindingPatterns.add(prevMember);
        }
        return this.parseMappingBindingPattern(openBrace, bindingPatterns, prevMember);
    }

    private STNode parseMappingBindingPattern(STNode openBrace, List<STNode> bindingPatterns, STNode prevMember) {
        STToken token = this.peek();
        STNode mappingBindingPatternRhs = null;
        while (!this.isEndOfMappingBindingPattern(token.kind) && prevMember.kind != SyntaxKind.REST_BINDING_PATTERN && (mappingBindingPatternRhs = this.parseMappingBindingPatternEnd()) != null) {
            bindingPatterns.add(mappingBindingPatternRhs);
            prevMember = this.parseMappingBindingPatternMember();
            if (prevMember.kind == SyntaxKind.REST_BINDING_PATTERN) break;
            bindingPatterns.add(prevMember);
            token = this.peek();
        }
        STNode restBindingPattern = prevMember.kind == SyntaxKind.REST_BINDING_PATTERN ? prevMember : STNodeFactory.createEmptyNode();
        STNode closeBrace = this.parseCloseBrace();
        STNode bindingPatternsNode = STNodeFactory.createNodeList(bindingPatterns);
        this.endContext();
        return STNodeFactory.createMappingBindingPatternNode(openBrace, bindingPatternsNode, restBindingPattern, closeBrace);
    }

    private STNode parseMappingBindingPatternMember() {
        STToken token = this.peek();
        switch (token.kind) {
            case ELLIPSIS_TOKEN: {
                return this.parseRestBindingPattern();
            }
        }
        return this.parseFieldBindingPattern();
    }

    private STNode parseMappingBindingPatternEnd() {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case CLOSE_BRACE_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.MAPPING_BINDING_PATTERN_END, new Object[0]);
        return this.parseMappingBindingPatternEnd();
    }

    private STNode parseFieldBindingPattern() {
        switch (this.peek().kind) {
            case IDENTIFIER_TOKEN: {
                STNode identifier = this.parseIdentifier(ParserRuleContext.FIELD_BINDING_PATTERN_NAME);
                STNode fieldBindingPattern = this.parseFieldBindingPattern(identifier);
                return fieldBindingPattern;
            }
        }
        this.recover(this.peek(), ParserRuleContext.FIELD_BINDING_PATTERN_NAME, new Object[0]);
        return this.parseFieldBindingPattern();
    }

    private STNode parseFieldBindingPattern(STNode identifier) {
        STNode simpleNameReference = STNodeFactory.createSimpleNameReferenceNode(identifier);
        if (this.peek().kind != SyntaxKind.COLON_TOKEN) {
            return STNodeFactory.createFieldBindingPatternVarnameNode(simpleNameReference);
        }
        STNode colon = this.parseColon();
        STNode bindingPattern = this.parseBindingPattern();
        return STNodeFactory.createFieldBindingPatternFullNode(simpleNameReference, colon, bindingPattern);
    }

    private boolean isEndOfMappingBindingPattern(SyntaxKind nextTokenKind) {
        return nextTokenKind == SyntaxKind.CLOSE_BRACE_TOKEN;
    }

    private STNode parseErrorTypeDescOrErrorBP(STNode annots) {
        STToken nextNextToken = this.peek(2);
        switch (nextNextToken.kind) {
            case OPEN_PAREN_TOKEN: {
                return this.parseAsErrorBindingPattern();
            }
            case LT_TOKEN: {
                return this.parseAsErrorTypeDesc(annots);
            }
            case IDENTIFIER_TOKEN: {
                SyntaxKind nextNextNextTokenKind = this.peek((int)3).kind;
                if (nextNextNextTokenKind != SyntaxKind.COLON_TOKEN && nextNextNextTokenKind != SyntaxKind.OPEN_PAREN_TOKEN) break;
                return this.parseAsErrorBindingPattern();
            }
        }
        return this.parseAsErrorTypeDesc(annots);
    }

    private STNode parseAsErrorBindingPattern() {
        this.startContext(ParserRuleContext.ASSIGNMENT_STMT);
        return this.parseAssignmentStmtRhs(this.parseErrorBindingPattern());
    }

    private STNode parseAsErrorTypeDesc(STNode annots) {
        STNode finalKeyword = STNodeFactory.createEmptyNode();
        return this.parseVariableDecl(this.getAnnotations(annots), finalKeyword);
    }

    private STNode parseErrorBindingPattern() {
        this.startContext(ParserRuleContext.ERROR_BINDING_PATTERN);
        STNode errorKeyword = this.parseErrorKeyword();
        return this.parseErrorBindingPattern(errorKeyword);
    }

    private STNode parseErrorBindingPattern(STNode errorKeyword) {
        STNode typeRef;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: {
                typeRef = this.parseTypeReference();
                break;
            }
            case OPEN_PAREN_TOKEN: {
                typeRef = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.ERROR_BINDING_PATTERN_ERROR_KEYWORD_RHS, new Object[0]);
                return this.parseErrorBindingPattern(errorKeyword);
            }
        }
        return this.parseErrorBindingPattern(errorKeyword, typeRef);
    }

    private STNode parseErrorBindingPattern(STNode errorKeyword, STNode typeRef) {
        STNode openParenthesis = this.parseOpenParenthesis(ParserRuleContext.OPEN_PARENTHESIS);
        STNode argListBindingPatterns = this.parseErrorArgListBindingPatterns();
        STNode closeParenthesis = this.parseCloseParenthesis();
        this.endContext();
        return STNodeFactory.createErrorBindingPatternNode(errorKeyword, typeRef, openParenthesis, argListBindingPatterns, closeParenthesis);
    }

    private STNode parseErrorArgListBindingPatterns() {
        ArrayList<STNode> argListBindingPatterns = new ArrayList<STNode>();
        if (this.isEndOfErrorFieldBindingPatterns()) {
            return STNodeFactory.createNodeList(argListBindingPatterns);
        }
        return this.parseErrorArgListBindingPatterns(argListBindingPatterns);
    }

    private STNode parseErrorArgListBindingPatterns(List<STNode> argListBindingPatterns) {
        STNode firstArg = this.parseErrorArgListBindingPattern(ParserRuleContext.ERROR_ARG_LIST_BINDING_PATTERN_START, true);
        if (firstArg == null) {
            return STNodeFactory.createNodeList(argListBindingPatterns);
        }
        switch (firstArg.kind) {
            case CAPTURE_BINDING_PATTERN: 
            case WILDCARD_BINDING_PATTERN: {
                argListBindingPatterns.add(firstArg);
                return this.parseErrorArgListBPWithoutErrorMsg(argListBindingPatterns);
            }
            case ERROR_BINDING_PATTERN: {
                STToken missingIdentifier = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
                STNode missingErrorMsgBP = STNodeFactory.createCaptureBindingPatternNode(missingIdentifier);
                missingErrorMsgBP = SyntaxErrors.addDiagnostic(missingErrorMsgBP, DiagnosticErrorCode.ERROR_MISSING_ERROR_MESSAGE_BINDING_PATTERN, new Object[0]);
                STToken missingComma = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.COMMA_TOKEN, DiagnosticErrorCode.ERROR_MISSING_COMMA_TOKEN);
                argListBindingPatterns.add(missingErrorMsgBP);
                argListBindingPatterns.add(missingComma);
                argListBindingPatterns.add(firstArg);
                return this.parseErrorArgListBPWithoutErrorMsgAndCause(argListBindingPatterns, firstArg.kind);
            }
            case REST_BINDING_PATTERN: 
            case NAMED_ARG_BINDING_PATTERN: {
                argListBindingPatterns.add(firstArg);
                return this.parseErrorArgListBPWithoutErrorMsgAndCause(argListBindingPatterns, firstArg.kind);
            }
        }
        this.addInvalidNodeToNextToken(firstArg, DiagnosticErrorCode.ERROR_BINDING_PATTERN_NOT_ALLOWED, new Object[0]);
        return this.parseErrorArgListBindingPatterns(argListBindingPatterns);
    }

    private STNode parseErrorArgListBPWithoutErrorMsg(List<STNode> argListBindingPatterns) {
        STNode argEnd = this.parseErrorArgsBindingPatternEnd(ParserRuleContext.ERROR_MESSAGE_BINDING_PATTERN_END);
        if (argEnd == null) {
            return STNodeFactory.createNodeList(argListBindingPatterns);
        }
        STNode secondArg = this.parseErrorArgListBindingPattern(ParserRuleContext.ERROR_MESSAGE_BINDING_PATTERN_RHS, false);
        assert (secondArg != null);
        switch (secondArg.kind) {
            case ERROR_BINDING_PATTERN: 
            case CAPTURE_BINDING_PATTERN: 
            case WILDCARD_BINDING_PATTERN: 
            case REST_BINDING_PATTERN: 
            case NAMED_ARG_BINDING_PATTERN: {
                argListBindingPatterns.add(argEnd);
                argListBindingPatterns.add(secondArg);
                return this.parseErrorArgListBPWithoutErrorMsgAndCause(argListBindingPatterns, secondArg.kind);
            }
        }
        this.updateLastNodeInListWithInvalidNode(argListBindingPatterns, argEnd, null, new Object[0]);
        this.updateLastNodeInListWithInvalidNode(argListBindingPatterns, secondArg, DiagnosticErrorCode.ERROR_BINDING_PATTERN_NOT_ALLOWED, new Object[0]);
        return this.parseErrorArgListBPWithoutErrorMsg(argListBindingPatterns);
    }

    private STNode parseErrorArgListBPWithoutErrorMsgAndCause(List<STNode> argListBindingPatterns, SyntaxKind lastValidArgKind) {
        STNode argEnd;
        while (!this.isEndOfErrorFieldBindingPatterns() && (argEnd = this.parseErrorArgsBindingPatternEnd(ParserRuleContext.ERROR_FIELD_BINDING_PATTERN_END)) != null) {
            STNode currentArg = this.parseErrorArgListBindingPattern(ParserRuleContext.ERROR_FIELD_BINDING_PATTERN, false);
            assert (currentArg != null);
            DiagnosticErrorCode errorCode = this.validateErrorFieldBindingPatternOrder(lastValidArgKind, currentArg.kind);
            if (errorCode == null) {
                argListBindingPatterns.add(argEnd);
                argListBindingPatterns.add(currentArg);
                lastValidArgKind = currentArg.kind;
                continue;
            }
            if (argListBindingPatterns.size() == 0) {
                this.addInvalidNodeToNextToken(argEnd, null, new Object[0]);
                this.addInvalidNodeToNextToken(currentArg, errorCode, new Object[0]);
                continue;
            }
            this.updateLastNodeInListWithInvalidNode(argListBindingPatterns, argEnd, null, new Object[0]);
            this.updateLastNodeInListWithInvalidNode(argListBindingPatterns, currentArg, errorCode, new Object[0]);
        }
        return STNodeFactory.createNodeList(argListBindingPatterns);
    }

    private boolean isEndOfErrorFieldBindingPatterns() {
        SyntaxKind nextTokenKind = this.peek().kind;
        switch (nextTokenKind) {
            case EOF_TOKEN: 
            case CLOSE_PAREN_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseErrorArgsBindingPatternEnd(ParserRuleContext currentCtx) {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.consume();
            }
            case CLOSE_PAREN_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), currentCtx, new Object[0]);
        return this.parseErrorArgsBindingPatternEnd(currentCtx);
    }

    private STNode parseErrorArgListBindingPattern(ParserRuleContext context, boolean isFirstArg) {
        switch (this.peek().kind) {
            case ELLIPSIS_TOKEN: {
                return this.parseRestBindingPattern();
            }
            case IDENTIFIER_TOKEN: {
                STToken argNameOrSimpleBindingPattern = this.consume();
                return this.parseNamedOrSimpleArgBindingPattern(argNameOrSimpleBindingPattern);
            }
            case OPEN_BRACKET_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: {
                return this.parseBindingPattern();
            }
            case CLOSE_PAREN_TOKEN: {
                if (!isFirstArg) break;
                return null;
            }
        }
        this.recover(this.peek(), context, new Object[0]);
        return this.parseErrorArgListBindingPattern(context, isFirstArg);
    }

    private STNode parseNamedOrSimpleArgBindingPattern(STNode argNameOrSimpleBindingPattern) {
        STToken secondToken = this.peek();
        switch (secondToken.kind) {
            case EQUAL_TOKEN: {
                STToken equal = this.consume();
                STNode bindingPattern = this.parseBindingPattern();
                return STNodeFactory.createNamedArgBindingPatternNode(argNameOrSimpleBindingPattern, equal, bindingPattern);
            }
        }
        return this.createCaptureOrWildcardBP(argNameOrSimpleBindingPattern);
    }

    private DiagnosticErrorCode validateErrorFieldBindingPatternOrder(SyntaxKind prevArgKind, SyntaxKind currentArgKind) {
        switch (currentArgKind) {
            case REST_BINDING_PATTERN: 
            case NAMED_ARG_BINDING_PATTERN: {
                if (prevArgKind == SyntaxKind.REST_BINDING_PATTERN) {
                    return DiagnosticErrorCode.ERROR_REST_ARG_FOLLOWED_BY_ANOTHER_ARG;
                }
                return null;
            }
        }
        return DiagnosticErrorCode.ERROR_BINDING_PATTERN_NOT_ALLOWED;
    }

    private STNode parseTypedBindingPatternTypeRhs(STNode typeDesc, ParserRuleContext context) {
        return this.parseTypedBindingPatternTypeRhs(typeDesc, context, true);
    }

    private STNode parseTypedBindingPatternTypeRhs(STNode typeDesc, ParserRuleContext context, boolean isRoot) {
        switch (this.peek().kind) {
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: {
                STNode bindingPattern = this.parseBindingPattern();
                return STNodeFactory.createTypedBindingPatternNode(typeDesc, bindingPattern);
            }
            case OPEN_BRACKET_TOKEN: {
                STNode typedBindingPattern = this.parseTypedBindingPatternOrMemberAccess(typeDesc, true, true, context);
                assert (typedBindingPattern.kind == SyntaxKind.TYPED_BINDING_PATTERN);
                return typedBindingPattern;
            }
            case COMMA_TOKEN: 
            case CLOSE_PAREN_TOKEN: 
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                if (isRoot) break;
                return typeDesc;
            }
        }
        this.recover(this.peek(), ParserRuleContext.TYPED_BINDING_PATTERN_TYPE_RHS, new Object[]{typeDesc, context, isRoot});
        return this.parseTypedBindingPatternTypeRhs(typeDesc, context, isRoot);
    }

    private STNode parseTypedBindingPatternOrMemberAccess(STNode typeDescOrExpr, boolean isTypedBindingPattern, boolean allowAssignment, ParserRuleContext context) {
        this.startContext(ParserRuleContext.BRACKETED_LIST);
        STNode openBracket = this.parseOpenBracket();
        if (this.isBracketedListEnd(this.peek().kind)) {
            return this.parseAsArrayTypeDesc(typeDescOrExpr, openBracket, STNodeFactory.createEmptyNode(), context);
        }
        STNode member = this.parseBracketedListMember(isTypedBindingPattern);
        SyntaxKind currentNodeType = this.getBracketedListNodeType(member, isTypedBindingPattern);
        switch (currentNodeType) {
            case ARRAY_TYPE_DESC: {
                STNode typedBindingPattern = this.parseAsArrayTypeDesc(typeDescOrExpr, openBracket, member, context);
                return typedBindingPattern;
            }
            case LIST_BINDING_PATTERN: {
                STNode bindingPattern = this.parseAsListBindingPattern(openBracket, new ArrayList<STNode>(), member, false);
                STNode typeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
                return STNodeFactory.createTypedBindingPatternNode(typeDesc, bindingPattern);
            }
            case INDEXED_EXPRESSION: {
                return this.parseAsMemberAccessExpr(typeDescOrExpr, openBracket, member);
            }
        }
        STNode memberEnd = this.parseBracketedListMemberEnd();
        if (memberEnd != null) {
            ArrayList<STNode> memberList = new ArrayList<STNode>();
            memberList.add(member);
            memberList.add(memberEnd);
            STNode bindingPattern = this.parseAsListBindingPattern(openBracket, memberList);
            STNode typeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
            return STNodeFactory.createTypedBindingPatternNode(typeDesc, bindingPattern);
        }
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        return this.parseTypedBindingPatternOrMemberAccessRhs(typeDescOrExpr, openBracket, member, closeBracket, isTypedBindingPattern, allowAssignment, context);
    }

    private STNode parseAsMemberAccessExpr(STNode typeNameOrExpr, STNode openBracket, STNode member) {
        member = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, member, false, true);
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        STNode keyExpr = STNodeFactory.createNodeList(member);
        STNode memberAccessExpr = STNodeFactory.createIndexedExpressionNode(typeNameOrExpr, openBracket, keyExpr, closeBracket);
        return this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, memberAccessExpr, false, false);
    }

    private boolean isBracketedListEnd(SyntaxKind nextTokenKind) {
        switch (nextTokenKind) {
            case EOF_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseBracketedListMember(boolean isTypedBindingPattern) {
        STNode expr;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case ASTERISK_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: {
                return this.parseBasicLiteral();
            }
            case CLOSE_BRACKET_TOKEN: {
                return STNodeFactory.createEmptyNode();
            }
            case OPEN_BRACKET_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: 
            case ELLIPSIS_TOKEN: {
                return this.parseStatementStartBracketedListMember();
            }
            case IDENTIFIER_TOKEN: {
                if (!isTypedBindingPattern) break;
                return this.parseQualifiedIdentifier(ParserRuleContext.VARIABLE_REF);
            }
            default: {
                if (!isTypedBindingPattern && this.isValidExpressionStart(nextToken.kind, 1)) break;
                ParserRuleContext recoverContext = isTypedBindingPattern ? ParserRuleContext.LIST_BINDING_MEMBER_OR_ARRAY_LENGTH : ParserRuleContext.BRACKETED_LIST_MEMBER;
                this.recover(this.peek(), recoverContext, isTypedBindingPattern);
                return this.parseBracketedListMember(isTypedBindingPattern);
            }
        }
        if (this.isWildcardBP(expr = this.parseExpression())) {
            return this.getWildcardBindingPattern(expr);
        }
        return expr;
    }

    private STNode parseAsArrayTypeDesc(STNode typeDesc, STNode openBracket, STNode member, ParserRuleContext context) {
        typeDesc = this.getTypeDescFromExpr(typeDesc);
        typeDesc = this.validateForUsageOfVar(typeDesc);
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        return this.parseTypedBindingPatternOrMemberAccessRhs(typeDesc, openBracket, member, closeBracket, true, true, context);
    }

    private STNode parseBracketedListMemberEnd() {
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case CLOSE_BRACKET_TOKEN: {
                return null;
            }
        }
        this.recover(this.peek(), ParserRuleContext.BRACKETED_LIST_MEMBER_END, new Object[0]);
        return this.parseBracketedListMemberEnd();
    }

    private STNode parseTypedBindingPatternOrMemberAccessRhs(STNode typeDescOrExpr, STNode openBracket, STNode member, STNode closeBracket, boolean isTypedBindingPattern, boolean allowAssignment, ParserRuleContext context) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: {
                STNode typeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
                STNode arrayTypeDesc = this.getArrayTypeDesc(openBracket, member, closeBracket, typeDesc);
                return this.parseTypedBindingPatternTypeRhs(arrayTypeDesc, context);
            }
            case OPEN_BRACKET_TOKEN: {
                if (isTypedBindingPattern) {
                    STNode typeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
                    STNode arrayTypeDesc = this.createArrayTypeDesc(typeDesc, openBracket, member, closeBracket);
                    return this.parseTypedBindingPatternTypeRhs(arrayTypeDesc, context);
                }
                STNode keyExpr = this.getKeyExpr(member);
                STNode expr = STNodeFactory.createIndexedExpressionNode(typeDescOrExpr, openBracket, keyExpr, closeBracket);
                return this.parseTypedBindingPatternOrMemberAccess(expr, false, allowAssignment, context);
            }
            case QUESTION_MARK_TOKEN: {
                STNode typeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
                STNode arrayTypeDesc = this.getArrayTypeDesc(openBracket, member, closeBracket, typeDesc);
                typeDesc = this.parseComplexTypeDescriptor(arrayTypeDesc, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
                return this.parseTypedBindingPatternTypeRhs(typeDesc, context);
            }
            case PIPE_TOKEN: 
            case BITWISE_AND_TOKEN: {
                return this.parseComplexTypeDescInTypedBindingPattern(typeDescOrExpr, openBracket, member, closeBracket, context, isTypedBindingPattern);
            }
            case IN_KEYWORD: {
                if (context != ParserRuleContext.FOREACH_STMT && context != ParserRuleContext.FROM_CLAUSE) break;
                return this.createTypedBindingPattern(typeDescOrExpr, openBracket, member, closeBracket);
            }
            case EQUAL_TOKEN: {
                if (context == ParserRuleContext.FOREACH_STMT || context == ParserRuleContext.FROM_CLAUSE) break;
                if (isTypedBindingPattern || !allowAssignment || !this.isValidLVExpr(typeDescOrExpr)) {
                    return this.createTypedBindingPattern(typeDescOrExpr, openBracket, member, closeBracket);
                }
                STNode keyExpr = this.getKeyExpr(member);
                typeDescOrExpr = this.getExpression(typeDescOrExpr);
                return STNodeFactory.createIndexedExpressionNode(typeDescOrExpr, openBracket, keyExpr, closeBracket);
            }
            case SEMICOLON_TOKEN: {
                if (context == ParserRuleContext.FOREACH_STMT || context == ParserRuleContext.FROM_CLAUSE) break;
                return this.createTypedBindingPattern(typeDescOrExpr, openBracket, member, closeBracket);
            }
            case COMMA_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                if (context == ParserRuleContext.AMBIGUOUS_STMT) {
                    STNode keyExpr = this.getKeyExpr(member);
                    return STNodeFactory.createIndexedExpressionNode(typeDescOrExpr, openBracket, keyExpr, closeBracket);
                }
            }
            default: {
                if (!this.isValidExprRhsStart(nextToken.kind, closeBracket.kind)) break;
                STNode keyExpr = this.getKeyExpr(member);
                typeDescOrExpr = this.getExpression(typeDescOrExpr);
                return STNodeFactory.createIndexedExpressionNode(typeDescOrExpr, openBracket, keyExpr, closeBracket);
            }
        }
        this.recover(this.peek(), ParserRuleContext.BRACKETED_LIST_RHS, new Object[]{typeDescOrExpr, openBracket, member, closeBracket, isTypedBindingPattern, allowAssignment, context});
        return this.parseTypedBindingPatternOrMemberAccessRhs(typeDescOrExpr, openBracket, member, closeBracket, isTypedBindingPattern, allowAssignment, context);
    }

    private STNode getKeyExpr(STNode member) {
        if (member == null) {
            STToken keyIdentifier = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_KEY_EXPR_IN_MEMBER_ACCESS_EXPR);
            STNode missingVarRef = STNodeFactory.createSimpleNameReferenceNode(keyIdentifier);
            return STNodeFactory.createNodeList(missingVarRef);
        }
        return STNodeFactory.createNodeList(member);
    }

    private STNode createTypedBindingPattern(STNode typeDescOrExpr, STNode openBracket, STNode member, STNode closeBracket) {
        STNode bindingPatterns;
        if (this.isEmpty(member)) {
            bindingPatterns = STNodeFactory.createEmptyNodeList();
        } else {
            STNode bindingPattern = this.getBindingPattern(member);
            bindingPatterns = STNodeFactory.createNodeList(bindingPattern);
        }
        STNode restBindingPattern = STNodeFactory.createEmptyNode();
        STNode bindingPattern = STNodeFactory.createListBindingPatternNode(openBracket, bindingPatterns, restBindingPattern, closeBracket);
        STNode typeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
        return STNodeFactory.createTypedBindingPatternNode(typeDesc, bindingPattern);
    }

    private STNode parseComplexTypeDescInTypedBindingPattern(STNode typeDescOrExpr, STNode openBracket, STNode member, STNode closeBracket, ParserRuleContext context, boolean isTypedBindingPattern) {
        STNode pipeOrAndToken = this.parseUnionOrIntersectionToken();
        STNode typedBindingPatternOrExpr = this.parseTypedBindingPatternOrExpr(false);
        if (isTypedBindingPattern || typedBindingPatternOrExpr.kind == SyntaxKind.TYPED_BINDING_PATTERN) {
            STNode lhsTypeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
            lhsTypeDesc = this.getArrayTypeDesc(openBracket, member, closeBracket, lhsTypeDesc);
            STTypedBindingPatternNode rhsTypedBindingPattern = (STTypedBindingPatternNode)typedBindingPatternOrExpr;
            STNode newTypeDesc = pipeOrAndToken.kind == SyntaxKind.PIPE_TOKEN ? this.createUnionTypeDesc(lhsTypeDesc, pipeOrAndToken, rhsTypedBindingPattern.typeDescriptor) : this.createIntersectionTypeDesc(lhsTypeDesc, pipeOrAndToken, rhsTypedBindingPattern.typeDescriptor);
            return STNodeFactory.createTypedBindingPatternNode(newTypeDesc, rhsTypedBindingPattern.bindingPattern);
        }
        STNode keyExpr = this.getExpression(member);
        STNode containerExpr = this.getExpression(typeDescOrExpr);
        STNode lhsExpr = STNodeFactory.createIndexedExpressionNode(containerExpr, openBracket, keyExpr, closeBracket);
        return STNodeFactory.createBinaryExpressionNode(SyntaxKind.BINARY_EXPRESSION, lhsExpr, pipeOrAndToken, typedBindingPatternOrExpr);
    }

    private STNode getArrayTypeDesc(STNode openBracket, STNode member, STNode closeBracket, STNode lhsTypeDesc) {
        if (lhsTypeDesc.kind == SyntaxKind.UNION_TYPE_DESC) {
            STUnionTypeDescriptorNode unionTypeDesc = (STUnionTypeDescriptorNode)lhsTypeDesc;
            STNode middleTypeDesc = this.getArrayTypeDesc(openBracket, member, closeBracket, unionTypeDesc.rightTypeDesc);
            lhsTypeDesc = this.createUnionTypeDesc(unionTypeDesc.leftTypeDesc, unionTypeDesc.pipeToken, middleTypeDesc);
        } else if (lhsTypeDesc.kind == SyntaxKind.INTERSECTION_TYPE_DESC) {
            STIntersectionTypeDescriptorNode intersectionTypeDesc = (STIntersectionTypeDescriptorNode)lhsTypeDesc;
            STNode middleTypeDesc = this.getArrayTypeDesc(openBracket, member, closeBracket, intersectionTypeDesc.rightTypeDesc);
            lhsTypeDesc = this.createIntersectionTypeDesc(intersectionTypeDesc.leftTypeDesc, intersectionTypeDesc.bitwiseAndToken, middleTypeDesc);
        } else {
            lhsTypeDesc = this.createArrayTypeDesc(lhsTypeDesc, openBracket, member, closeBracket);
        }
        return lhsTypeDesc;
    }

    private STNode parseUnionOrIntersectionToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.PIPE_TOKEN || token.kind == SyntaxKind.BITWISE_AND_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.UNION_OR_INTERSECTION_TOKEN, new Object[0]);
        return this.parseUnionOrIntersectionToken();
    }

    private SyntaxKind getBracketedListNodeType(STNode memberNode, boolean isTypedBindingPattern) {
        if (this.isEmpty(memberNode)) {
            return SyntaxKind.NONE;
        }
        if (this.isDefiniteTypeDesc(memberNode.kind)) {
            return SyntaxKind.TUPLE_TYPE_DESC;
        }
        switch (memberNode.kind) {
            case ASTERISK_LITERAL: {
                return SyntaxKind.ARRAY_TYPE_DESC;
            }
            case LIST_BINDING_PATTERN: 
            case MAPPING_BINDING_PATTERN: 
            case CAPTURE_BINDING_PATTERN: 
            case WILDCARD_BINDING_PATTERN: 
            case REST_BINDING_PATTERN: {
                return SyntaxKind.LIST_BINDING_PATTERN;
            }
            case QUALIFIED_NAME_REFERENCE: 
            case REST_TYPE: {
                return SyntaxKind.TUPLE_TYPE_DESC;
            }
            case SIMPLE_NAME_REFERENCE: 
            case NUMERIC_LITERAL: 
            case BRACKETED_LIST: 
            case MAPPING_BP_OR_MAPPING_CONSTRUCTOR: {
                return SyntaxKind.NONE;
            }
        }
        if (isTypedBindingPattern) {
            return SyntaxKind.NONE;
        }
        return SyntaxKind.INDEXED_EXPRESSION;
    }

    private STNode parseStatementStartsWithOpenBracket(STNode annots, boolean possibleMappingField) {
        this.startContext(ParserRuleContext.ASSIGNMENT_OR_VAR_DECL_STMT);
        return this.parseStatementStartsWithOpenBracket(annots, true, possibleMappingField);
    }

    private STNode parseMemberBracketedList(boolean possibleMappingField) {
        STNode annots = STNodeFactory.createEmptyNodeList();
        return this.parseStatementStartsWithOpenBracket(annots, false, possibleMappingField);
    }

    private STNode parseStatementStartsWithOpenBracket(STNode annots, boolean isRoot, boolean possibleMappingField) {
        this.startContext(ParserRuleContext.STMT_START_BRACKETED_LIST);
        STNode openBracket = this.parseOpenBracket();
        ArrayList<STNode> memberList = new ArrayList<STNode>();
        while (!this.isBracketedListEnd(this.peek().kind)) {
            STNode member = this.parseStatementStartBracketedListMember();
            SyntaxKind currentNodeType = this.getStmtStartBracketedListType(member);
            switch (currentNodeType) {
                case TUPLE_TYPE_DESC: {
                    return this.parseAsTupleTypeDesc(annots, openBracket, memberList, member, isRoot);
                }
                case LIST_BINDING_PATTERN: {
                    return this.parseAsListBindingPattern(openBracket, memberList, member, isRoot);
                }
                case LIST_CONSTRUCTOR: {
                    return this.parseAsListConstructor(openBracket, memberList, member, isRoot);
                }
                case LIST_BP_OR_LIST_CONSTRUCTOR: {
                    return this.parseAsListBindingPatternOrListConstructor(openBracket, memberList, member, isRoot);
                }
                case TUPLE_TYPE_DESC_OR_LIST_CONST: {
                    return this.parseAsTupleTypeDescOrListConstructor(annots, openBracket, memberList, member, isRoot);
                }
            }
            memberList.add(member);
            STNode memberEnd = this.parseBracketedListMemberEnd();
            if (memberEnd == null) break;
            memberList.add(memberEnd);
        }
        STNode closeBracket = this.parseCloseBracket();
        STNode bracketedList = this.parseStatementStartBracketedList(annots, openBracket, memberList, closeBracket, isRoot, possibleMappingField);
        return bracketedList;
    }

    private STNode parseStatementStartBracketedListMember() {
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        return this.parseStatementStartBracketedListMember(typeDescQualifiers);
    }

    private STNode parseStatementStartBracketedListMember(List<STNode> qualifiers) {
        this.parseTypeDescQualifiers(qualifiers);
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_BRACKET_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseMemberBracketedList(false);
            }
            case IDENTIFIER_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                STNode identifier = this.parseQualifiedIdentifier(ParserRuleContext.VARIABLE_REF);
                if (this.isWildcardBP(identifier)) {
                    STNode varName = ((STSimpleNameReferenceNode)identifier).name;
                    return this.getWildcardBindingPattern(varName);
                }
                if (this.peek().kind == SyntaxKind.ELLIPSIS_TOKEN) {
                    STNode ellipsis = this.parseEllipsis();
                    return STNodeFactory.createRestDescriptorNode(identifier, ellipsis);
                }
                return this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, identifier, false, true);
            }
            case OPEN_BRACE_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseMappingBindingPatterOrMappingConstructor();
            }
            case ERROR_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                if (this.getNextNextToken().kind == SyntaxKind.OPEN_PAREN_TOKEN) {
                    return this.parseErrorConstructorExpr();
                }
                if (this.peek((int)2).kind == SyntaxKind.IDENTIFIER_TOKEN) {
                    return this.parseErrorBindingPattern();
                }
                return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
            }
            case ELLIPSIS_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseListBindingPatternMember();
            }
            case XML_KEYWORD: 
            case STRING_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                if (this.getNextNextToken().kind == SyntaxKind.BACKTICK_TOKEN) {
                    return this.parseExpression(false);
                }
                return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
            }
            case STREAM_KEYWORD: 
            case TABLE_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                if (this.getNextNextToken().kind == SyntaxKind.LT_TOKEN) {
                    return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
                }
                return this.parseExpression(false);
            }
            case OPEN_PAREN_TOKEN: {
                return this.parseTypeDescOrExpr(qualifiers);
            }
            case FUNCTION_KEYWORD: {
                return this.parseAnonFuncExprOrFuncTypeDesc(qualifiers);
            }
        }
        if (this.isValidExpressionStart(nextToken.kind, 1)) {
            this.reportInvalidQualifierList(qualifiers);
            return this.parseExpression(false);
        }
        if (this.isTypeStartingToken(nextToken.kind)) {
            return this.parseTypeDescriptor(qualifiers, ParserRuleContext.TYPE_DESC_IN_TUPLE);
        }
        this.recover(this.peek(), ParserRuleContext.STMT_START_BRACKETED_LIST_MEMBER, qualifiers);
        return this.parseStatementStartBracketedListMember(qualifiers);
    }

    private STNode parseAsTupleTypeDescOrListConstructor(STNode annots, STNode openBracket, List<STNode> memberList, STNode member, boolean isRoot) {
        STNode tupleTypeDescOrListCons;
        memberList.add(member);
        STNode memberEnd = this.parseBracketedListMemberEnd();
        if (memberEnd == null) {
            STNode closeBracket = this.parseCloseBracket();
            tupleTypeDescOrListCons = this.parseTupleTypeDescOrListConstructorRhs(openBracket, memberList, closeBracket, isRoot);
        } else {
            memberList.add(memberEnd);
            tupleTypeDescOrListCons = this.parseTupleTypeDescOrListConstructor(annots, openBracket, memberList, isRoot);
        }
        return tupleTypeDescOrListCons;
    }

    private STNode parseTupleTypeDescOrListConstructor(STNode annots) {
        this.startContext(ParserRuleContext.BRACKETED_LIST);
        STNode openBracket = this.parseOpenBracket();
        ArrayList<STNode> memberList = new ArrayList<STNode>();
        return this.parseTupleTypeDescOrListConstructor(annots, openBracket, memberList, false);
    }

    private STNode parseTupleTypeDescOrListConstructor(STNode annots, STNode openBracket, List<STNode> memberList, boolean isRoot) {
        STToken nextToken = this.peek();
        while (!this.isBracketedListEnd(nextToken.kind)) {
            STNode member = this.parseTupleTypeDescOrListConstructorMember(annots);
            SyntaxKind currentNodeType = this.getParsingNodeTypeOfTupleTypeOrListCons(member);
            switch (currentNodeType) {
                case LIST_CONSTRUCTOR: {
                    return this.parseAsListConstructor(openBracket, memberList, member, isRoot);
                }
                case TUPLE_TYPE_DESC: {
                    return this.parseAsTupleTypeDesc(annots, openBracket, memberList, member, isRoot);
                }
            }
            memberList.add(member);
            STNode memberEnd = this.parseBracketedListMemberEnd();
            if (memberEnd == null) break;
            memberList.add(memberEnd);
            nextToken = this.peek();
        }
        STNode closeBracket = this.parseCloseBracket();
        return this.parseTupleTypeDescOrListConstructorRhs(openBracket, memberList, closeBracket, isRoot);
    }

    private STNode parseTupleTypeDescOrListConstructorMember(STNode annots) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_BRACKET_TOKEN: {
                return this.parseTupleTypeDescOrListConstructor(annots);
            }
            case IDENTIFIER_TOKEN: {
                STNode identifier = this.parseQualifiedIdentifier(ParserRuleContext.VARIABLE_REF);
                if (this.peek().kind == SyntaxKind.ELLIPSIS_TOKEN) {
                    STNode ellipsis = this.parseEllipsis();
                    return STNodeFactory.createRestDescriptorNode(identifier, ellipsis);
                }
                return this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, identifier, false, false);
            }
            case OPEN_BRACE_TOKEN: {
                return this.parseMappingConstructorExpr();
            }
            case ERROR_KEYWORD: {
                if (this.getNextNextToken().kind == SyntaxKind.OPEN_PAREN_TOKEN) {
                    return this.parseErrorConstructorExpr();
                }
                return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
            }
            case XML_KEYWORD: 
            case STRING_KEYWORD: {
                if (this.getNextNextToken().kind == SyntaxKind.BACKTICK_TOKEN) {
                    return this.parseExpression(false);
                }
                return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
            }
            case STREAM_KEYWORD: 
            case TABLE_KEYWORD: {
                if (this.getNextNextToken().kind == SyntaxKind.LT_TOKEN) {
                    return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
                }
                return this.parseExpression(false);
            }
            case OPEN_PAREN_TOKEN: {
                return this.parseTypeDescOrExpr();
            }
        }
        if (this.isValidExpressionStart(nextToken.kind, 1)) {
            return this.parseExpression(false);
        }
        if (this.isTypeStartingToken(nextToken.kind)) {
            return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
        }
        this.recover(this.peek(), ParserRuleContext.TUPLE_TYPE_DESC_OR_LIST_CONST_MEMBER, annots);
        return this.parseTupleTypeDescOrListConstructorMember(annots);
    }

    private SyntaxKind getParsingNodeTypeOfTupleTypeOrListCons(STNode memberNode) {
        return this.getStmtStartBracketedListType(memberNode);
    }

    private STNode parseTupleTypeDescOrListConstructorRhs(STNode openBracket, List<STNode> members, STNode closeBracket, boolean isRoot) {
        STNode tupleTypeOrListConst;
        switch (this.peek().kind) {
            case COMMA_TOKEN: 
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                if (isRoot) break;
                this.endContext();
                return new STAmbiguousCollectionNode(SyntaxKind.TUPLE_TYPE_DESC_OR_LIST_CONST, openBracket, members, closeBracket);
            }
        }
        if (this.isValidExprRhsStart(this.peek().kind, closeBracket.kind) || isRoot && this.peek().kind == SyntaxKind.EQUAL_TOKEN) {
            members = this.getExpressionList(members);
            STNode memberExpressions = STNodeFactory.createNodeList(members);
            tupleTypeOrListConst = STNodeFactory.createListConstructorExpressionNode(openBracket, memberExpressions, closeBracket);
        } else {
            STNode memberTypeDescs = STNodeFactory.createNodeList(this.getTypeDescList(members));
            STNode tupleTypeDesc = STNodeFactory.createTupleTypeDescriptorNode(openBracket, memberTypeDescs, closeBracket);
            tupleTypeOrListConst = this.parseComplexTypeDescriptor(tupleTypeDesc, ParserRuleContext.TYPE_DESC_IN_TUPLE, false);
        }
        this.endContext();
        if (!isRoot) {
            return tupleTypeOrListConst;
        }
        STNode annots = STNodeFactory.createEmptyNodeList();
        return this.parseStmtStartsWithTupleTypeOrExprRhs(annots, tupleTypeOrListConst, isRoot);
    }

    private STNode parseStmtStartsWithTupleTypeOrExprRhs(STNode annots, STNode tupleTypeOrListConst, boolean isRoot) {
        if (tupleTypeOrListConst.kind.compareTo(SyntaxKind.RECORD_TYPE_DESC) >= 0 && tupleTypeOrListConst.kind.compareTo(SyntaxKind.TYPEDESC_TYPE_DESC) <= 0) {
            ArrayList<STNode> varDeclQualifiers = new ArrayList<STNode>();
            STNode typedBindingPattern = this.parseTypedBindingPatternTypeRhs(tupleTypeOrListConst, ParserRuleContext.VAR_DECL_STMT, isRoot);
            if (!isRoot) {
                return typedBindingPattern;
            }
            this.switchContext(ParserRuleContext.VAR_DECL_STMT);
            return this.parseVarDeclRhs(annots, varDeclQualifiers, typedBindingPattern, false);
        }
        STNode expr = this.getExpression(tupleTypeOrListConst);
        expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, expr, false, true);
        return this.parseStatementStartWithExprRhs(expr);
    }

    private STNode parseAsTupleTypeDesc(STNode annots, STNode openBracket, List<STNode> memberList, STNode member, boolean isRoot) {
        memberList = this.getTypeDescList(memberList);
        this.startContext(ParserRuleContext.TYPE_DESC_IN_TUPLE);
        STNode tupleTypeMembers = this.parseTupleTypeMembers(member, memberList);
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        STNode tupleType = STNodeFactory.createTupleTypeDescriptorNode(openBracket, tupleTypeMembers, closeBracket);
        STNode typeDesc = this.parseComplexTypeDescriptor(tupleType, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
        this.endContext();
        STNode typedBindingPattern = this.parseTypedBindingPatternTypeRhs(typeDesc, ParserRuleContext.VAR_DECL_STMT, isRoot);
        if (!isRoot) {
            return typedBindingPattern;
        }
        this.switchContext(ParserRuleContext.VAR_DECL_STMT);
        return this.parseVarDeclRhs(annots, new ArrayList<STNode>(), typedBindingPattern, false);
    }

    private STNode parseAsListBindingPattern(STNode openBracket, List<STNode> memberList, STNode member, boolean isRoot) {
        memberList = this.getBindingPatternsList(memberList);
        memberList.add(member);
        this.switchContext(ParserRuleContext.LIST_BINDING_PATTERN);
        STNode listBindingPattern = this.parseListBindingPattern(openBracket, member, memberList);
        this.endContext();
        if (!isRoot) {
            return listBindingPattern;
        }
        return this.parseAssignmentStmtRhs(listBindingPattern);
    }

    private STNode parseAsListBindingPattern(STNode openBracket, List<STNode> memberList) {
        memberList = this.getBindingPatternsList(memberList);
        this.switchContext(ParserRuleContext.LIST_BINDING_PATTERN);
        STNode listBindingPattern = this.parseListBindingPattern(openBracket, memberList);
        this.endContext();
        return listBindingPattern;
    }

    private STNode parseAsListBindingPatternOrListConstructor(STNode openBracket, List<STNode> memberList, STNode member, boolean isRoot) {
        STNode listBindingPatternOrListCons;
        memberList.add(member);
        STNode memberEnd = this.parseBracketedListMemberEnd();
        if (memberEnd == null) {
            STNode closeBracket = this.parseCloseBracket();
            listBindingPatternOrListCons = this.parseListBindingPatternOrListConstructor(openBracket, memberList, closeBracket, isRoot);
        } else {
            memberList.add(memberEnd);
            listBindingPatternOrListCons = this.parseListBindingPatternOrListConstructor(openBracket, memberList, isRoot);
        }
        return listBindingPatternOrListCons;
    }

    private SyntaxKind getStmtStartBracketedListType(STNode memberNode) {
        if (memberNode.kind.compareTo(SyntaxKind.RECORD_TYPE_DESC) >= 0 && memberNode.kind.compareTo(SyntaxKind.TYPEDESC_TYPE_DESC) <= 0) {
            return SyntaxKind.TUPLE_TYPE_DESC;
        }
        switch (memberNode.kind) {
            case ASTERISK_LITERAL: 
            case NUMERIC_LITERAL: {
                return SyntaxKind.ARRAY_TYPE_DESC;
            }
            case LIST_BINDING_PATTERN: 
            case ERROR_BINDING_PATTERN: 
            case CAPTURE_BINDING_PATTERN: 
            case WILDCARD_BINDING_PATTERN: 
            case REST_BINDING_PATTERN: {
                return SyntaxKind.LIST_BINDING_PATTERN;
            }
            case QUALIFIED_NAME_REFERENCE: 
            case REST_TYPE: {
                return SyntaxKind.TUPLE_TYPE_DESC;
            }
            case LIST_CONSTRUCTOR: 
            case MAPPING_CONSTRUCTOR: {
                return SyntaxKind.LIST_CONSTRUCTOR;
            }
            case MAPPING_BP_OR_MAPPING_CONSTRUCTOR: {
                return SyntaxKind.LIST_BP_OR_LIST_CONSTRUCTOR;
            }
            case SIMPLE_NAME_REFERENCE: 
            case BRACKETED_LIST: {
                return SyntaxKind.NONE;
            }
            case FUNCTION_CALL: {
                if (this.isPossibleErrorBindingPattern((STFunctionCallExpressionNode)memberNode)) {
                    return SyntaxKind.NONE;
                }
                return SyntaxKind.LIST_CONSTRUCTOR;
            }
            case INDEXED_EXPRESSION: {
                return SyntaxKind.TUPLE_TYPE_DESC_OR_LIST_CONST;
            }
        }
        if (this.isExpression(memberNode.kind) && !this.isAllBasicLiterals(memberNode) && !this.isAmbiguous(memberNode)) {
            return SyntaxKind.LIST_CONSTRUCTOR;
        }
        return SyntaxKind.NONE;
    }

    private boolean isPossibleErrorBindingPattern(STFunctionCallExpressionNode funcCall) {
        STNode args = funcCall.arguments;
        int size = args.bucketCount();
        for (int i = 0; i < size; ++i) {
            STNode arg = args.childInBucket(i);
            if (arg.kind != SyntaxKind.NAMED_ARG && arg.kind != SyntaxKind.POSITIONAL_ARG && arg.kind != SyntaxKind.REST_ARG || this.isPosibleArgBindingPattern((STFunctionArgumentNode)arg)) continue;
            return false;
        }
        return true;
    }

    private boolean isPosibleArgBindingPattern(STFunctionArgumentNode arg) {
        switch (arg.kind) {
            case POSITIONAL_ARG: {
                STNode expr = ((STPositionalArgumentNode)arg).expression;
                return this.isPosibleBindingPattern(expr);
            }
            case NAMED_ARG: {
                STNode expr = ((STNamedArgumentNode)arg).expression;
                return this.isPosibleBindingPattern(expr);
            }
            case REST_ARG: {
                STNode expr = ((STRestArgumentNode)arg).expression;
                return expr.kind == SyntaxKind.SIMPLE_NAME_REFERENCE;
            }
        }
        return false;
    }

    private boolean isPosibleBindingPattern(STNode node) {
        switch (node.kind) {
            case SIMPLE_NAME_REFERENCE: {
                return true;
            }
            case LIST_CONSTRUCTOR: {
                STListConstructorExpressionNode listConstructor = (STListConstructorExpressionNode)node;
                for (int i = 0; i < listConstructor.bucketCount(); ++i) {
                    STNode expr = listConstructor.childInBucket(i);
                    if (this.isPosibleBindingPattern(expr)) continue;
                    return false;
                }
                return true;
            }
            case MAPPING_CONSTRUCTOR: {
                STMappingConstructorExpressionNode mappingConstructor = (STMappingConstructorExpressionNode)node;
                for (int i = 0; i < mappingConstructor.bucketCount(); ++i) {
                    STNode expr = mappingConstructor.childInBucket(i);
                    if (this.isPosibleBindingPattern(expr)) continue;
                    return false;
                }
                return true;
            }
            case SPECIFIC_FIELD: {
                STSpecificFieldNode specificField = (STSpecificFieldNode)node;
                if (specificField.readonlyKeyword != null) {
                    return false;
                }
                if (specificField.valueExpr == null) {
                    return true;
                }
                return this.isPosibleBindingPattern(specificField.valueExpr);
            }
            case FUNCTION_CALL: {
                return this.isPossibleErrorBindingPattern((STFunctionCallExpressionNode)node);
            }
        }
        return false;
    }

    private STNode parseStatementStartBracketedList(STNode annots, STNode openBracket, List<STNode> members, STNode closeBracket, boolean isRoot, boolean possibleMappingField) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EQUAL_TOKEN: {
                if (!isRoot) {
                    this.endContext();
                    return new STAmbiguousCollectionNode(SyntaxKind.BRACKETED_LIST, openBracket, members, closeBracket);
                }
                STNode memberBindingPatterns = STNodeFactory.createNodeList(this.getBindingPatternsList(members));
                STNode restBindingPattern = STNodeFactory.createEmptyNode();
                STNode listBindingPattern = STNodeFactory.createListBindingPatternNode(openBracket, memberBindingPatterns, restBindingPattern, closeBracket);
                this.endContext();
                this.switchContext(ParserRuleContext.ASSIGNMENT_STMT);
                return this.parseAssignmentStmtRhs(listBindingPattern);
            }
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACE_TOKEN: {
                if (!isRoot) {
                    this.endContext();
                    return new STAmbiguousCollectionNode(SyntaxKind.BRACKETED_LIST, openBracket, members, closeBracket);
                }
                if (members.isEmpty()) {
                    openBracket = SyntaxErrors.addDiagnostic(openBracket, DiagnosticErrorCode.ERROR_MISSING_TUPLE_MEMBER, new Object[0]);
                }
                this.switchContext(ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN);
                this.startContext(ParserRuleContext.TYPE_DESC_IN_TUPLE);
                STNode memberTypeDescs = STNodeFactory.createNodeList(this.getTypeDescList(members));
                STNode tupleTypeDesc = STNodeFactory.createTupleTypeDescriptorNode(openBracket, memberTypeDescs, closeBracket);
                this.endContext();
                STNode typeDesc = this.parseComplexTypeDescriptor(tupleTypeDesc, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
                STNode typedBindingPattern = this.parseTypedBindingPatternTypeRhs(typeDesc, ParserRuleContext.VAR_DECL_STMT);
                this.endContext();
                return this.parseStmtStartsWithTypedBPOrExprRhs(annots, typedBindingPattern);
            }
            case OPEN_BRACKET_TOKEN: {
                if (!isRoot) {
                    STNode memberTypeDescs = STNodeFactory.createNodeList(this.getTypeDescList(members));
                    STNode tupleTypeDesc = STNodeFactory.createTupleTypeDescriptorNode(openBracket, memberTypeDescs, closeBracket);
                    this.endContext();
                    STNode typeDesc = this.parseComplexTypeDescriptor(tupleTypeDesc, ParserRuleContext.TYPE_DESC_IN_TUPLE, false);
                    return typeDesc;
                }
                STAmbiguousCollectionNode list = new STAmbiguousCollectionNode(SyntaxKind.BRACKETED_LIST, openBracket, members, closeBracket);
                this.endContext();
                STNode tpbOrExpr = this.parseTypedBindingPatternOrExprRhs(list, true);
                return this.parseStmtStartsWithTypedBPOrExprRhs(annots, tpbOrExpr);
            }
            case COLON_TOKEN: {
                if (!possibleMappingField || members.size() != 1) break;
                this.startContext(ParserRuleContext.MAPPING_CONSTRUCTOR);
                STNode colon = this.parseColon();
                STNode fieldNameExpr = this.getExpression(members.get(0));
                STNode valueExpr = this.parseExpression();
                return STNodeFactory.createComputedNameFieldNode(openBracket, fieldNameExpr, closeBracket, colon, valueExpr);
            }
        }
        this.endContext();
        if (!isRoot) {
            return new STAmbiguousCollectionNode(SyntaxKind.BRACKETED_LIST, openBracket, members, closeBracket);
        }
        STAmbiguousCollectionNode list = new STAmbiguousCollectionNode(SyntaxKind.BRACKETED_LIST, openBracket, members, closeBracket);
        STNode exprOrTPB = this.parseTypedBindingPatternOrExprRhs(list, false);
        return this.parseStmtStartsWithTypedBPOrExprRhs(annots, exprOrTPB);
    }

    private boolean isWildcardBP(STNode node) {
        switch (node.kind) {
            case SIMPLE_NAME_REFERENCE: {
                STToken nameToken = (STToken)((STSimpleNameReferenceNode)node).name;
                return this.isUnderscoreToken(nameToken);
            }
            case IDENTIFIER_TOKEN: {
                return this.isUnderscoreToken((STToken)node);
            }
        }
        return false;
    }

    private boolean isUnderscoreToken(STToken token) {
        return "_".equals(token.text());
    }

    private STNode getWildcardBindingPattern(STNode identifier) {
        switch (identifier.kind) {
            case SIMPLE_NAME_REFERENCE: {
                STNode varName = ((STSimpleNameReferenceNode)identifier).name;
                return STNodeFactory.createWildcardBindingPatternNode(varName);
            }
            case IDENTIFIER_TOKEN: {
                return STNodeFactory.createWildcardBindingPatternNode(identifier);
            }
        }
        throw new IllegalStateException();
    }

    private STNode parseStatementStartsWithOpenBrace() {
        this.startContext(ParserRuleContext.AMBIGUOUS_STMT);
        STNode openBrace = this.parseOpenBrace();
        if (this.peek().kind == SyntaxKind.CLOSE_BRACE_TOKEN) {
            STNode closeBrace = this.parseCloseBrace();
            switch (this.peek().kind) {
                case EQUAL_TOKEN: {
                    this.switchContext(ParserRuleContext.ASSIGNMENT_STMT);
                    STNode fields = STNodeFactory.createEmptyNodeList();
                    STNode restBindingPattern = STNodeFactory.createEmptyNode();
                    STNode bindingPattern = STNodeFactory.createMappingBindingPatternNode(openBrace, fields, restBindingPattern, closeBrace);
                    return this.parseAssignmentStmtRhs(bindingPattern);
                }
                case RIGHT_ARROW_TOKEN: 
                case SYNC_SEND_TOKEN: {
                    this.switchContext(ParserRuleContext.EXPRESSION_STATEMENT);
                    STNode fields = STNodeFactory.createEmptyNodeList();
                    STNode expr = STNodeFactory.createMappingConstructorExpressionNode(openBrace, fields, closeBrace);
                    expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, expr, false, true);
                    return this.parseStatementStartWithExprRhs(expr);
                }
            }
            STNode statements = STNodeFactory.createEmptyNodeList();
            this.endContext();
            return STNodeFactory.createBlockStatementNode(openBrace, statements, closeBrace);
        }
        STNode member = this.parseStatementStartingBracedListFirstMember();
        SyntaxKind nodeType = this.getBracedListType(member);
        switch (nodeType) {
            case MAPPING_BINDING_PATTERN: {
                return this.parseStmtAsMappingBindingPatternStart(openBrace, member);
            }
            case MAPPING_CONSTRUCTOR: {
                return this.parseStmtAsMappingConstructorStart(openBrace, member);
            }
            case MAPPING_BP_OR_MAPPING_CONSTRUCTOR: {
                return this.parseStmtAsMappingBPOrMappingConsStart(openBrace, member);
            }
            case BLOCK_STATEMENT: {
                STNode closeBrace = this.parseCloseBrace();
                STNode stmt = STNodeFactory.createBlockStatementNode(openBrace, member, closeBrace);
                this.endContext();
                return stmt;
            }
        }
        ArrayList<STNode> stmts = new ArrayList<STNode>();
        stmts.add(member);
        STNode statements = this.parseStatements(stmts);
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createBlockStatementNode(openBrace, statements, closeBrace);
    }

    private STNode parseStmtAsMappingBindingPatternStart(STNode openBrace, STNode firstMappingField) {
        this.switchContext(ParserRuleContext.ASSIGNMENT_STMT);
        this.startContext(ParserRuleContext.MAPPING_BINDING_PATTERN);
        ArrayList<STNode> bindingPatterns = new ArrayList<STNode>();
        if (firstMappingField.kind != SyntaxKind.REST_BINDING_PATTERN) {
            bindingPatterns.add(this.getBindingPattern(firstMappingField));
        }
        STNode mappingBP = this.parseMappingBindingPattern(openBrace, bindingPatterns, firstMappingField);
        return this.parseAssignmentStmtRhs(mappingBP);
    }

    private STNode parseStmtAsMappingConstructorStart(STNode openBrace, STNode firstMember) {
        this.switchContext(ParserRuleContext.EXPRESSION_STATEMENT);
        this.startContext(ParserRuleContext.MAPPING_CONSTRUCTOR);
        ArrayList<STNode> members = new ArrayList<STNode>();
        STNode mappingCons = this.parseAsMappingConstructor(openBrace, members, firstMember);
        STNode expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, mappingCons, false, true);
        return this.parseStatementStartWithExprRhs(expr);
    }

    private STNode parseAsMappingConstructor(STNode openBrace, List<STNode> members, STNode member) {
        members.add(member);
        members = this.getExpressionList(members);
        this.switchContext(ParserRuleContext.MAPPING_CONSTRUCTOR);
        STNode fields = this.parseMappingConstructorFields(members);
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createMappingConstructorExpressionNode(openBrace, fields, closeBrace);
    }

    private STNode parseStmtAsMappingBPOrMappingConsStart(STNode openBrace, STNode member) {
        STNode expr;
        STNode bpOrConstructor;
        this.startContext(ParserRuleContext.MAPPING_BP_OR_MAPPING_CONSTRUCTOR);
        ArrayList<STNode> members = new ArrayList<STNode>();
        members.add(member);
        STNode memberEnd = this.parseMappingFieldEnd();
        if (memberEnd == null) {
            STNode closeBrace = this.parseCloseBrace();
            bpOrConstructor = this.parseMappingBindingPatternOrMappingConstructor(openBrace, members, closeBrace);
        } else {
            members.add(memberEnd);
            bpOrConstructor = this.parseMappingBindingPatternOrMappingConstructor(openBrace, members);
        }
        switch (bpOrConstructor.kind) {
            case MAPPING_CONSTRUCTOR: {
                this.switchContext(ParserRuleContext.EXPRESSION_STATEMENT);
                expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, bpOrConstructor, false, true);
                return this.parseStatementStartWithExprRhs(expr);
            }
            case MAPPING_BINDING_PATTERN: {
                this.switchContext(ParserRuleContext.ASSIGNMENT_STMT);
                STNode bindingPattern = this.getBindingPattern(bpOrConstructor);
                return this.parseAssignmentStmtRhs(bindingPattern);
            }
        }
        if (this.peek().kind == SyntaxKind.EQUAL_TOKEN) {
            this.switchContext(ParserRuleContext.ASSIGNMENT_STMT);
            STNode bindingPattern = this.getBindingPattern(bpOrConstructor);
            return this.parseAssignmentStmtRhs(bindingPattern);
        }
        this.switchContext(ParserRuleContext.EXPRESSION_STATEMENT);
        expr = this.getExpression(bpOrConstructor);
        expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, expr, false, true);
        return this.parseStatementStartWithExprRhs(expr);
    }

    private STNode parseStatementStartingBracedListFirstMember() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case READONLY_KEYWORD: {
                STNode readonlyKeyword = this.parseReadonlyKeyword();
                return this.bracedListMemberStartsWithReadonly(readonlyKeyword);
            }
            case IDENTIFIER_TOKEN: {
                STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                return this.parseIdentifierRhsInStmtStartingBrace(readonlyKeyword);
            }
            case STRING_LITERAL_TOKEN: {
                STNode key = this.parseStringLiteral();
                if (this.peek().kind == SyntaxKind.COLON_TOKEN) {
                    STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                    STNode colon = this.parseColon();
                    STNode valueExpr = this.parseExpression();
                    return STNodeFactory.createSpecificFieldNode(readonlyKeyword, key, colon, valueExpr);
                }
                this.switchContext(ParserRuleContext.BLOCK_STMT);
                this.startContext(ParserRuleContext.AMBIGUOUS_STMT);
                STNode expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, key, false, true);
                return this.parseStatementStartWithExprRhs(expr);
            }
            case OPEN_BRACKET_TOKEN: {
                STNode annots = STNodeFactory.createEmptyNodeList();
                return this.parseStatementStartsWithOpenBracket(annots, true);
            }
            case OPEN_BRACE_TOKEN: {
                this.switchContext(ParserRuleContext.BLOCK_STMT);
                return this.parseStatementStartsWithOpenBrace();
            }
            case ELLIPSIS_TOKEN: {
                return this.parseRestBindingPattern();
            }
        }
        this.switchContext(ParserRuleContext.BLOCK_STMT);
        return this.parseStatements();
    }

    private STNode bracedListMemberStartsWithReadonly(STNode readonlyKeyword) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: {
                return this.parseIdentifierRhsInStmtStartingBrace(readonlyKeyword);
            }
            case STRING_LITERAL_TOKEN: {
                if (this.peek((int)2).kind != SyntaxKind.COLON_TOKEN) break;
                STNode key = this.parseStringLiteral();
                STNode colon = this.parseColon();
                STNode valueExpr = this.parseExpression();
                return STNodeFactory.createSpecificFieldNode(readonlyKeyword, key, colon, valueExpr);
            }
        }
        this.switchContext(ParserRuleContext.BLOCK_STMT);
        this.startContext(ParserRuleContext.VAR_DECL_STMT);
        this.startContext(ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN);
        STNode typeDesc = this.parseComplexTypeDescriptor(readonlyKeyword, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
        this.endContext();
        STNode annots = STNodeFactory.createEmptyNodeList();
        ArrayList<STNode> varDeclQualifiers = new ArrayList<STNode>();
        STNode typedBP = this.parseTypedBindingPatternTypeRhs(typeDesc, ParserRuleContext.VAR_DECL_STMT);
        return this.parseVarDeclRhs(annots, varDeclQualifiers, typedBP, false);
    }

    private STNode parseIdentifierRhsInStmtStartingBrace(STNode readonlyKeyword) {
        STNode identifier = this.parseIdentifier(ParserRuleContext.VARIABLE_REF);
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                STNode colon = STNodeFactory.createEmptyNode();
                STNode value = STNodeFactory.createEmptyNode();
                return STNodeFactory.createSpecificFieldNode(readonlyKeyword, identifier, colon, value);
            }
            case COLON_TOKEN: {
                STNode colon = this.parseColon();
                if (!this.isEmpty(readonlyKeyword)) {
                    STNode value = this.parseExpression();
                    return STNodeFactory.createSpecificFieldNode(readonlyKeyword, identifier, colon, value);
                }
                switch (this.peek().kind) {
                    case OPEN_BRACKET_TOKEN: {
                        STNode bindingPatternOrExpr = this.parseListBindingPatternOrListConstructor();
                        return this.getMappingField(identifier, colon, bindingPatternOrExpr);
                    }
                    case OPEN_BRACE_TOKEN: {
                        STNode bindingPatternOrExpr = this.parseMappingBindingPatterOrMappingConstructor();
                        return this.getMappingField(identifier, colon, bindingPatternOrExpr);
                    }
                    case IDENTIFIER_TOKEN: {
                        return this.parseQualifiedIdentifierRhsInStmtStartBrace(identifier, colon);
                    }
                }
                STNode expr = this.parseExpression();
                return this.getMappingField(identifier, colon, expr);
            }
        }
        this.switchContext(ParserRuleContext.BLOCK_STMT);
        if (!this.isEmpty(readonlyKeyword)) {
            this.startContext(ParserRuleContext.VAR_DECL_STMT);
            STNode bindingPattern = STNodeFactory.createCaptureBindingPatternNode(identifier);
            STNode typedBindingPattern = STNodeFactory.createTypedBindingPatternNode(readonlyKeyword, bindingPattern);
            STNode annots = STNodeFactory.createEmptyNodeList();
            ArrayList<STNode> varDeclQualifiers = new ArrayList<STNode>();
            return this.parseVarDeclRhs(annots, varDeclQualifiers, typedBindingPattern, false);
        }
        this.startContext(ParserRuleContext.AMBIGUOUS_STMT);
        STNode qualifiedIdentifier = this.parseQualifiedIdentifier(identifier, false);
        STNode expr = this.parseTypedBindingPatternOrExprRhs(qualifiedIdentifier, true);
        STNode annots = STNodeFactory.createEmptyNodeList();
        return this.parseStmtStartsWithTypedBPOrExprRhs(annots, expr);
    }

    private STNode parseQualifiedIdentifierRhsInStmtStartBrace(STNode identifier, STNode colon) {
        STNode secondIdentifier = this.parseIdentifier(ParserRuleContext.VARIABLE_REF);
        STNode secondNameRef = STNodeFactory.createSimpleNameReferenceNode(secondIdentifier);
        if (this.isWildcardBP(secondIdentifier)) {
            return this.getWildcardBindingPattern(secondIdentifier);
        }
        STNode qualifiedNameRef = STNodeFactory.createQualifiedNameReferenceNode(identifier, colon, secondNameRef);
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return qualifiedNameRef;
            }
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACE_TOKEN: {
                ArrayList<STNode> varDeclQualifiers = new ArrayList<STNode>();
                STNode typeBindingPattern = this.parseTypedBindingPatternTypeRhs(qualifiedNameRef, ParserRuleContext.VAR_DECL_STMT);
                STNode annots = STNodeFactory.createEmptyNodeList();
                return this.parseVarDeclRhs(annots, varDeclQualifiers, typeBindingPattern, false);
            }
            case OPEN_BRACKET_TOKEN: {
                return this.parseMemberRhsInStmtStartWithBrace(identifier, colon, secondNameRef);
            }
            case QUESTION_MARK_TOKEN: {
                STNode typeDesc = this.parseComplexTypeDescriptor(qualifiedNameRef, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
                ArrayList<STNode> varDeclQualifiers = new ArrayList<STNode>();
                STNode typeBindingPattern = this.parseTypedBindingPatternTypeRhs(typeDesc, ParserRuleContext.VAR_DECL_STMT);
                STNode annots = STNodeFactory.createEmptyNodeList();
                return this.parseVarDeclRhs(annots, varDeclQualifiers, typeBindingPattern, false);
            }
            case EQUAL_TOKEN: 
            case SEMICOLON_TOKEN: {
                return this.parseStatementStartWithExprRhs(qualifiedNameRef);
            }
        }
        return this.parseMemberWithExprInRhs(identifier, colon, secondNameRef, secondNameRef);
    }

    private SyntaxKind getBracedListType(STNode member) {
        switch (member.kind) {
            case LIST_BINDING_PATTERN: 
            case MAPPING_BINDING_PATTERN: 
            case CAPTURE_BINDING_PATTERN: 
            case WILDCARD_BINDING_PATTERN: 
            case FIELD_BINDING_PATTERN: {
                return SyntaxKind.MAPPING_BINDING_PATTERN;
            }
            case SPECIFIC_FIELD: {
                STNode expr = ((STSpecificFieldNode)member).valueExpr;
                if (expr == null) {
                    return SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR;
                }
                switch (expr.kind) {
                    case SIMPLE_NAME_REFERENCE: 
                    case MAPPING_BP_OR_MAPPING_CONSTRUCTOR: 
                    case LIST_BP_OR_LIST_CONSTRUCTOR: {
                        return SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR;
                    }
                    case ERROR_BINDING_PATTERN: {
                        return SyntaxKind.MAPPING_BINDING_PATTERN;
                    }
                    case FUNCTION_CALL: {
                        if (this.isPossibleErrorBindingPattern((STFunctionCallExpressionNode)expr)) {
                            return SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR;
                        }
                        return SyntaxKind.MAPPING_CONSTRUCTOR;
                    }
                }
                return SyntaxKind.MAPPING_CONSTRUCTOR;
            }
            case SPREAD_FIELD: 
            case COMPUTED_NAME_FIELD: {
                return SyntaxKind.MAPPING_CONSTRUCTOR;
            }
            case SIMPLE_NAME_REFERENCE: 
            case QUALIFIED_NAME_REFERENCE: 
            case REST_BINDING_PATTERN: 
            case MAPPING_BP_OR_MAPPING_CONSTRUCTOR: 
            case LIST_BP_OR_LIST_CONSTRUCTOR: {
                return SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR;
            }
            case LIST: {
                return SyntaxKind.BLOCK_STATEMENT;
            }
        }
        return SyntaxKind.NONE;
    }

    private STNode parseMappingBindingPatterOrMappingConstructor() {
        this.startContext(ParserRuleContext.MAPPING_BP_OR_MAPPING_CONSTRUCTOR);
        STNode openBrace = this.parseOpenBrace();
        ArrayList<STNode> memberList = new ArrayList<STNode>();
        return this.parseMappingBindingPatternOrMappingConstructor(openBrace, memberList);
    }

    private boolean isBracedListEnd(SyntaxKind nextTokenKind) {
        switch (nextTokenKind) {
            case EOF_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                return true;
            }
        }
        return false;
    }

    private STNode parseMappingBindingPatternOrMappingConstructor(STNode openBrace, List<STNode> memberList) {
        STToken nextToken = this.peek();
        while (!this.isBracedListEnd(nextToken.kind)) {
            STNode member = this.parseMappingBindingPatterOrMappingConstructorMember();
            SyntaxKind currentNodeType = this.getTypeOfMappingBPOrMappingCons(member);
            switch (currentNodeType) {
                case MAPPING_CONSTRUCTOR: {
                    return this.parseAsMappingConstructor(openBrace, memberList, member);
                }
                case MAPPING_BINDING_PATTERN: {
                    return this.parseAsMappingBindingPattern(openBrace, memberList, member);
                }
            }
            memberList.add(member);
            STNode memberEnd = this.parseMappingFieldEnd();
            if (memberEnd == null) break;
            memberList.add(memberEnd);
            nextToken = this.peek();
        }
        STNode closeBrace = this.parseCloseBrace();
        return this.parseMappingBindingPatternOrMappingConstructor(openBrace, memberList, closeBrace);
    }

    private STNode parseMappingBindingPatterOrMappingConstructorMember() {
        switch (this.peek().kind) {
            case IDENTIFIER_TOKEN: {
                STNode key = this.parseIdentifier(ParserRuleContext.MAPPING_FIELD_NAME);
                return this.parseMappingFieldRhs(key);
            }
            case STRING_LITERAL_TOKEN: {
                STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                STNode key = this.parseStringLiteral();
                STNode colon = this.parseColon();
                STNode valueExpr = this.parseExpression();
                return STNodeFactory.createSpecificFieldNode(readonlyKeyword, key, colon, valueExpr);
            }
            case OPEN_BRACKET_TOKEN: {
                return this.parseComputedField();
            }
            case ELLIPSIS_TOKEN: {
                STNode ellipsis = this.parseEllipsis();
                STNode expr = this.parseExpression();
                if (expr.kind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
                    return STNodeFactory.createRestBindingPatternNode(ellipsis, expr);
                }
                return STNodeFactory.createSpreadFieldNode(ellipsis, expr);
            }
        }
        this.recover(this.peek(), ParserRuleContext.MAPPING_BP_OR_MAPPING_CONSTRUCTOR_MEMBER, new Object[0]);
        return this.parseMappingBindingPatterOrMappingConstructorMember();
    }

    private STNode parseMappingFieldRhs(STNode key) {
        switch (this.peek().kind) {
            case COLON_TOKEN: {
                STNode colon = this.parseColon();
                return this.parseMappingFieldValue(key, colon);
            }
            case COMMA_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                STNode colon = STNodeFactory.createEmptyNode();
                STNode valueExpr = STNodeFactory.createEmptyNode();
                return STNodeFactory.createSpecificFieldNode(readonlyKeyword, key, colon, valueExpr);
            }
        }
        STToken token = this.peek();
        this.recover(token, ParserRuleContext.FIELD_BINDING_PATTERN_END, key);
        STNode readonlyKeyword = STNodeFactory.createEmptyNode();
        return this.parseSpecificFieldRhs(readonlyKeyword, key);
    }

    private STNode parseMappingFieldValue(STNode key, STNode colon) {
        STNode expr;
        switch (this.peek().kind) {
            case IDENTIFIER_TOKEN: {
                expr = this.parseExpression();
                break;
            }
            case OPEN_BRACKET_TOKEN: {
                expr = this.parseListBindingPatternOrListConstructor();
                break;
            }
            case OPEN_BRACE_TOKEN: {
                expr = this.parseMappingBindingPatterOrMappingConstructor();
                break;
            }
            default: {
                expr = this.parseExpression();
            }
        }
        if (this.isBindingPattern(expr.kind)) {
            return STNodeFactory.createFieldBindingPatternFullNode(key, colon, expr);
        }
        STNode readonlyKeyword = STNodeFactory.createEmptyNode();
        return STNodeFactory.createSpecificFieldNode(readonlyKeyword, key, colon, expr);
    }

    private boolean isBindingPattern(SyntaxKind kind) {
        switch (kind) {
            case LIST_BINDING_PATTERN: 
            case MAPPING_BINDING_PATTERN: 
            case CAPTURE_BINDING_PATTERN: 
            case WILDCARD_BINDING_PATTERN: 
            case FIELD_BINDING_PATTERN: {
                return true;
            }
        }
        return false;
    }

    private SyntaxKind getTypeOfMappingBPOrMappingCons(STNode memberNode) {
        switch (memberNode.kind) {
            case LIST_BINDING_PATTERN: 
            case MAPPING_BINDING_PATTERN: 
            case CAPTURE_BINDING_PATTERN: 
            case WILDCARD_BINDING_PATTERN: 
            case FIELD_BINDING_PATTERN: {
                return SyntaxKind.MAPPING_BINDING_PATTERN;
            }
            case SPECIFIC_FIELD: {
                STNode expr = ((STSpecificFieldNode)memberNode).valueExpr;
                if (expr == null || expr.kind == SyntaxKind.SIMPLE_NAME_REFERENCE || expr.kind == SyntaxKind.LIST_BP_OR_LIST_CONSTRUCTOR || expr.kind == SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR) {
                    return SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR;
                }
                return SyntaxKind.MAPPING_CONSTRUCTOR;
            }
            case SPREAD_FIELD: 
            case COMPUTED_NAME_FIELD: {
                return SyntaxKind.MAPPING_CONSTRUCTOR;
            }
        }
        return SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR;
    }

    private STNode parseMappingBindingPatternOrMappingConstructor(STNode openBrace, List<STNode> members, STNode closeBrace) {
        this.endContext();
        return new STAmbiguousCollectionNode(SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR, openBrace, members, closeBrace);
    }

    private STNode parseAsMappingBindingPattern(STNode openBrace, List<STNode> members, STNode member) {
        members.add(member);
        members = this.getBindingPatternsList(members);
        this.switchContext(ParserRuleContext.MAPPING_BINDING_PATTERN);
        return this.parseMappingBindingPattern(openBrace, members, member);
    }

    private STNode parseListBindingPatternOrListConstructor() {
        this.startContext(ParserRuleContext.BRACKETED_LIST);
        STNode openBracket = this.parseOpenBracket();
        ArrayList<STNode> memberList = new ArrayList<STNode>();
        return this.parseListBindingPatternOrListConstructor(openBracket, memberList, false);
    }

    private STNode parseListBindingPatternOrListConstructor(STNode openBracket, List<STNode> memberList, boolean isRoot) {
        STToken nextToken = this.peek();
        while (!this.isBracketedListEnd(nextToken.kind)) {
            STNode member = this.parseListBindingPatternOrListConstructorMember();
            SyntaxKind currentNodeType = this.getParsingNodeTypeOfListBPOrListCons(member);
            switch (currentNodeType) {
                case LIST_CONSTRUCTOR: {
                    return this.parseAsListConstructor(openBracket, memberList, member, isRoot);
                }
                case LIST_BINDING_PATTERN: {
                    return this.parseAsListBindingPattern(openBracket, memberList, member, isRoot);
                }
            }
            memberList.add(member);
            STNode memberEnd = this.parseBracketedListMemberEnd();
            if (memberEnd == null) break;
            memberList.add(memberEnd);
            nextToken = this.peek();
        }
        STNode closeBracket = this.parseCloseBracket();
        return this.parseListBindingPatternOrListConstructor(openBracket, memberList, closeBracket, isRoot);
    }

    private STNode parseListBindingPatternOrListConstructorMember() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_BRACKET_TOKEN: {
                return this.parseListBindingPatternOrListConstructor();
            }
            case IDENTIFIER_TOKEN: {
                STNode identifier = this.parseQualifiedIdentifier(ParserRuleContext.VARIABLE_REF);
                if (this.isWildcardBP(identifier)) {
                    return this.getWildcardBindingPattern(identifier);
                }
                return this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, identifier, false, false);
            }
            case OPEN_BRACE_TOKEN: {
                return this.parseMappingBindingPatterOrMappingConstructor();
            }
            case ELLIPSIS_TOKEN: {
                return this.parseListBindingPatternMember();
            }
        }
        if (this.isValidExpressionStart(nextToken.kind, 1)) {
            return this.parseExpression();
        }
        this.recover(this.peek(), ParserRuleContext.LIST_BP_OR_LIST_CONSTRUCTOR_MEMBER, new Object[0]);
        return this.parseListBindingPatternOrListConstructorMember();
    }

    private SyntaxKind getParsingNodeTypeOfListBPOrListCons(STNode memberNode) {
        switch (memberNode.kind) {
            case LIST_BINDING_PATTERN: 
            case MAPPING_BINDING_PATTERN: 
            case CAPTURE_BINDING_PATTERN: 
            case WILDCARD_BINDING_PATTERN: 
            case REST_BINDING_PATTERN: {
                return SyntaxKind.LIST_BINDING_PATTERN;
            }
            case SIMPLE_NAME_REFERENCE: 
            case MAPPING_BP_OR_MAPPING_CONSTRUCTOR: 
            case LIST_BP_OR_LIST_CONSTRUCTOR: {
                return SyntaxKind.LIST_BP_OR_LIST_CONSTRUCTOR;
            }
        }
        return SyntaxKind.LIST_CONSTRUCTOR;
    }

    private STNode parseAsListConstructor(STNode openBracket, List<STNode> memberList, STNode member, boolean isRoot) {
        memberList.add(member);
        memberList = this.getExpressionList(memberList);
        this.switchContext(ParserRuleContext.LIST_CONSTRUCTOR);
        STNode expressions = this.parseOptionalExpressionsList(memberList);
        STNode closeBracket = this.parseCloseBracket();
        STNode listConstructor = STNodeFactory.createListConstructorExpressionNode(openBracket, expressions, closeBracket);
        this.endContext();
        STNode expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, listConstructor, false, false);
        if (!isRoot) {
            return expr;
        }
        return this.parseStatementStartWithExprRhs(expr);
    }

    private STNode parseListBindingPatternOrListConstructor(STNode openBracket, List<STNode> members, STNode closeBracket, boolean isRoot) {
        STNode lbpOrListCons;
        switch (this.peek().kind) {
            case COMMA_TOKEN: 
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                if (isRoot) break;
                this.endContext();
                return new STAmbiguousCollectionNode(SyntaxKind.LIST_BP_OR_LIST_CONSTRUCTOR, openBracket, members, closeBracket);
            }
        }
        if (this.isValidExprRhsStart(this.peek().kind, closeBracket.kind)) {
            members = this.getExpressionList(members);
            STNode memberExpressions = STNodeFactory.createNodeList(members);
            lbpOrListCons = STNodeFactory.createListConstructorExpressionNode(openBracket, memberExpressions, closeBracket);
        } else {
            members = this.getBindingPatternsList(members);
            STNode bindingPatternsNode = STNodeFactory.createNodeList(members);
            STNode restBindingPattern = STNodeFactory.createEmptyNode();
            lbpOrListCons = STNodeFactory.createListBindingPatternNode(openBracket, bindingPatternsNode, restBindingPattern, closeBracket);
        }
        this.endContext();
        if (!isRoot) {
            return lbpOrListCons;
        }
        return this.parseStmtStartsWithTypedBPOrExprRhs(null, lbpOrListCons);
    }

    private STNode parseMemberRhsInStmtStartWithBrace(STNode identifier, STNode colon, STNode secondIdentifier) {
        STNode typedBPOrExpr = this.parseTypedBindingPatternOrMemberAccess(secondIdentifier, false, true, ParserRuleContext.AMBIGUOUS_STMT);
        if (this.isExpression(typedBPOrExpr.kind)) {
            return this.parseMemberWithExprInRhs(identifier, colon, secondIdentifier, typedBPOrExpr);
        }
        this.switchContext(ParserRuleContext.BLOCK_STMT);
        this.startContext(ParserRuleContext.VAR_DECL_STMT);
        ArrayList<STNode> varDeclQualifiers = new ArrayList<STNode>();
        STNode annots = STNodeFactory.createEmptyNodeList();
        STNode qualifiedNameRef = STNodeFactory.createQualifiedNameReferenceNode(identifier, colon, secondIdentifier);
        STNode typeDesc = this.mergeQualifiedNameWithTypeDesc(qualifiedNameRef, ((STTypedBindingPatternNode)typedBPOrExpr).typeDescriptor);
        return this.parseVarDeclRhs(annots, varDeclQualifiers, typeDesc, false);
    }

    private STNode parseMemberWithExprInRhs(STNode identifier, STNode colon, STNode secondIdentifier, STNode memberAccessExpr) {
        STNode expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, memberAccessExpr, false, true);
        switch (this.peek().kind) {
            case COMMA_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                this.switchContext(ParserRuleContext.EXPRESSION_STATEMENT);
                this.startContext(ParserRuleContext.MAPPING_CONSTRUCTOR);
                STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                return STNodeFactory.createSpecificFieldNode(readonlyKeyword, identifier, colon, expr);
            }
        }
        this.switchContext(ParserRuleContext.BLOCK_STMT);
        this.startContext(ParserRuleContext.EXPRESSION_STATEMENT);
        STNode qualifiedName = STNodeFactory.createQualifiedNameReferenceNode(identifier, colon, secondIdentifier);
        STNode updatedExpr = this.mergeQualifiedNameWithExpr(qualifiedName, expr);
        return this.parseStatementStartWithExprRhs(updatedExpr);
    }

    private STNode mergeQualifiedNameWithExpr(STNode qualifiedName, STNode exprOrAction) {
        switch (exprOrAction.kind) {
            case SIMPLE_NAME_REFERENCE: {
                return qualifiedName;
            }
            case BINARY_EXPRESSION: {
                STBinaryExpressionNode binaryExpr = (STBinaryExpressionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, binaryExpr.lhsExpr);
                return STNodeFactory.createBinaryExpressionNode(binaryExpr.kind, newLhsExpr, binaryExpr.operator, binaryExpr.rhsExpr);
            }
            case FIELD_ACCESS: {
                STFieldAccessExpressionNode fieldAccess = (STFieldAccessExpressionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, fieldAccess.expression);
                return STNodeFactory.createFieldAccessExpressionNode(newLhsExpr, fieldAccess.dotToken, fieldAccess.fieldName);
            }
            case INDEXED_EXPRESSION: {
                STIndexedExpressionNode memberAccess = (STIndexedExpressionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, memberAccess.containerExpression);
                return STNodeFactory.createIndexedExpressionNode(newLhsExpr, memberAccess.openBracket, memberAccess.keyExpression, memberAccess.closeBracket);
            }
            case TYPE_TEST_EXPRESSION: {
                STTypeTestExpressionNode typeTest = (STTypeTestExpressionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, typeTest.expression);
                return STNodeFactory.createTypeTestExpressionNode(newLhsExpr, typeTest.isKeyword, typeTest.typeDescriptor);
            }
            case ANNOT_ACCESS: {
                STAnnotAccessExpressionNode annotAccess = (STAnnotAccessExpressionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, annotAccess.expression);
                return STNodeFactory.createFieldAccessExpressionNode(newLhsExpr, annotAccess.annotChainingToken, annotAccess.annotTagReference);
            }
            case OPTIONAL_FIELD_ACCESS: {
                STOptionalFieldAccessExpressionNode optionalFieldAccess = (STOptionalFieldAccessExpressionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, optionalFieldAccess.expression);
                return STNodeFactory.createFieldAccessExpressionNode(newLhsExpr, optionalFieldAccess.optionalChainingToken, optionalFieldAccess.fieldName);
            }
            case CONDITIONAL_EXPRESSION: {
                STConditionalExpressionNode conditionalExpr = (STConditionalExpressionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, conditionalExpr.lhsExpression);
                return STNodeFactory.createConditionalExpressionNode(newLhsExpr, conditionalExpr.questionMarkToken, conditionalExpr.middleExpression, conditionalExpr.colonToken, conditionalExpr.endExpression);
            }
            case REMOTE_METHOD_CALL_ACTION: {
                STRemoteMethodCallActionNode remoteCall = (STRemoteMethodCallActionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, remoteCall.expression);
                return STNodeFactory.createRemoteMethodCallActionNode(newLhsExpr, remoteCall.rightArrowToken, remoteCall.methodName, remoteCall.openParenToken, remoteCall.arguments, remoteCall.closeParenToken);
            }
            case ASYNC_SEND_ACTION: {
                STAsyncSendActionNode asyncSend = (STAsyncSendActionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, asyncSend.expression);
                return STNodeFactory.createAsyncSendActionNode(newLhsExpr, asyncSend.rightArrowToken, asyncSend.peerWorker);
            }
            case SYNC_SEND_ACTION: {
                STSyncSendActionNode syncSend = (STSyncSendActionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, syncSend.expression);
                return STNodeFactory.createAsyncSendActionNode(newLhsExpr, syncSend.syncSendToken, syncSend.peerWorker);
            }
        }
        return exprOrAction;
    }

    private STNode mergeQualifiedNameWithTypeDesc(STNode qualifiedName, STNode typeDesc) {
        switch (typeDesc.kind) {
            case SIMPLE_NAME_REFERENCE: {
                return qualifiedName;
            }
            case ARRAY_TYPE_DESC: {
                STArrayTypeDescriptorNode arrayTypeDesc = (STArrayTypeDescriptorNode)typeDesc;
                STNode newMemberType = this.mergeQualifiedNameWithTypeDesc(qualifiedName, arrayTypeDesc.memberTypeDesc);
                return this.createArrayTypeDesc(newMemberType, arrayTypeDesc.openBracket, arrayTypeDesc.arrayLength, arrayTypeDesc.closeBracket);
            }
            case UNION_TYPE_DESC: {
                STUnionTypeDescriptorNode unionTypeDesc = (STUnionTypeDescriptorNode)typeDesc;
                STNode newlhsType = this.mergeQualifiedNameWithTypeDesc(qualifiedName, unionTypeDesc.leftTypeDesc);
                return this.createUnionTypeDesc(newlhsType, unionTypeDesc.pipeToken, unionTypeDesc.rightTypeDesc);
            }
            case INTERSECTION_TYPE_DESC: {
                STIntersectionTypeDescriptorNode intersectionTypeDesc = (STIntersectionTypeDescriptorNode)typeDesc;
                STNode newlhsType = this.mergeQualifiedNameWithTypeDesc(qualifiedName, intersectionTypeDesc.leftTypeDesc);
                return this.createUnionTypeDesc(newlhsType, intersectionTypeDesc.bitwiseAndToken, intersectionTypeDesc.rightTypeDesc);
            }
            case OPTIONAL_TYPE_DESC: {
                STOptionalTypeDescriptorNode optionalType = (STOptionalTypeDescriptorNode)typeDesc;
                STNode newMemberType = this.mergeQualifiedNameWithTypeDesc(qualifiedName, optionalType.typeDescriptor);
                return STNodeFactory.createOptionalTypeDescriptorNode(newMemberType, optionalType.questionMarkToken);
            }
        }
        return typeDesc;
    }

    private List<STNode> getTypeDescList(List<STNode> ambiguousList) {
        ArrayList<STNode> typeDescList = new ArrayList<STNode>();
        for (STNode item : ambiguousList) {
            typeDescList.add(this.getTypeDescFromExpr(item));
        }
        return typeDescList;
    }

    private STNode getTypeDescFromExpr(STNode expression) {
        switch (expression.kind) {
            case INDEXED_EXPRESSION: {
                return this.parseArrayTypeDescriptorNode((STIndexedExpressionNode)expression);
            }
            case NUMERIC_LITERAL: 
            case STRING_LITERAL: 
            case NULL_LITERAL: 
            case BOOLEAN_LITERAL: {
                return STNodeFactory.createSingletonTypeDescriptorNode(expression);
            }
            case TYPE_REFERENCE_TYPE_DESC: {
                return ((STTypeReferenceTypeDescNode)expression).typeRef;
            }
            case BRACED_EXPRESSION: {
                STBracedExpressionNode bracedExpr = (STBracedExpressionNode)expression;
                STNode typeDesc = this.getTypeDescFromExpr(bracedExpr.expression);
                return STNodeFactory.createParenthesisedTypeDescriptorNode(bracedExpr.openParen, typeDesc, bracedExpr.closeParen);
            }
            case NIL_LITERAL: {
                STNilLiteralNode nilLiteral = (STNilLiteralNode)expression;
                return STNodeFactory.createNilTypeDescriptorNode(nilLiteral.openParenToken, nilLiteral.closeParenToken);
            }
            case BRACKETED_LIST: 
            case LIST_BP_OR_LIST_CONSTRUCTOR: {
                STAmbiguousCollectionNode innerList = (STAmbiguousCollectionNode)expression;
                STNode memberTypeDescs = STNodeFactory.createNodeList(this.getTypeDescList(innerList.members));
                return STNodeFactory.createTupleTypeDescriptorNode(innerList.collectionStartToken, memberTypeDescs, innerList.collectionEndToken);
            }
            case BINARY_EXPRESSION: {
                STBinaryExpressionNode binaryExpr = (STBinaryExpressionNode)expression;
                switch (binaryExpr.operator.kind) {
                    case PIPE_TOKEN: {
                        STNode lhsTypeDesc = this.getTypeDescFromExpr(binaryExpr.lhsExpr);
                        STNode rhsTypeDesc = this.getTypeDescFromExpr(binaryExpr.rhsExpr);
                        return this.createUnionTypeDesc(lhsTypeDesc, binaryExpr.operator, rhsTypeDesc);
                    }
                    case BITWISE_AND_TOKEN: {
                        STNode lhsTypeDesc = this.getTypeDescFromExpr(binaryExpr.lhsExpr);
                        STNode rhsTypeDesc = this.getTypeDescFromExpr(binaryExpr.rhsExpr);
                        return this.createIntersectionTypeDesc(lhsTypeDesc, binaryExpr.operator, rhsTypeDesc);
                    }
                }
                return expression;
            }
            case UNARY_EXPRESSION: {
                return STNodeFactory.createSingletonTypeDescriptorNode(expression);
            }
        }
        return expression;
    }

    private List<STNode> getBindingPatternsList(List<STNode> ambibuousList) {
        ArrayList<STNode> bindingPatterns = new ArrayList<STNode>();
        for (STNode item : ambibuousList) {
            bindingPatterns.add(this.getBindingPattern(item));
        }
        return bindingPatterns;
    }

    private STNode getBindingPattern(STNode ambiguousNode) {
        if (this.isEmpty(ambiguousNode)) {
            return ambiguousNode;
        }
        switch (ambiguousNode.kind) {
            case SIMPLE_NAME_REFERENCE: {
                STNode varName = ((STSimpleNameReferenceNode)ambiguousNode).name;
                return this.createCaptureOrWildcardBP(varName);
            }
            case QUALIFIED_NAME_REFERENCE: {
                STQualifiedNameReferenceNode qualifiedName = (STQualifiedNameReferenceNode)ambiguousNode;
                STNode fieldName = STNodeFactory.createSimpleNameReferenceNode(qualifiedName.modulePrefix);
                return STNodeFactory.createFieldBindingPatternFullNode(fieldName, qualifiedName.colon, this.getBindingPattern(qualifiedName.identifier));
            }
            case BRACKETED_LIST: 
            case LIST_BP_OR_LIST_CONSTRUCTOR: {
                STAmbiguousCollectionNode innerList = (STAmbiguousCollectionNode)ambiguousNode;
                STNode memberBindingPatterns = STNodeFactory.createNodeList(this.getBindingPatternsList(innerList.members));
                STNode restBindingPattern = STNodeFactory.createEmptyNode();
                return STNodeFactory.createListBindingPatternNode(innerList.collectionStartToken, memberBindingPatterns, restBindingPattern, innerList.collectionEndToken);
            }
            case MAPPING_BP_OR_MAPPING_CONSTRUCTOR: {
                STAmbiguousCollectionNode innerList = (STAmbiguousCollectionNode)ambiguousNode;
                ArrayList<STNode> bindingPatterns = new ArrayList<STNode>();
                STNode restBindingPattern = STNodeFactory.createEmptyNode();
                for (int i = 0; i < innerList.members.size(); ++i) {
                    STNode bp = this.getBindingPattern(innerList.members.get(i));
                    if (bp.kind == SyntaxKind.REST_BINDING_PATTERN) {
                        restBindingPattern = bp;
                        break;
                    }
                    bindingPatterns.add(bp);
                }
                STNode memberBindingPatterns = STNodeFactory.createNodeList(bindingPatterns);
                return STNodeFactory.createMappingBindingPatternNode(innerList.collectionStartToken, memberBindingPatterns, restBindingPattern, innerList.collectionEndToken);
            }
            case SPECIFIC_FIELD: {
                STSpecificFieldNode field = (STSpecificFieldNode)ambiguousNode;
                STNode fieldName = STNodeFactory.createSimpleNameReferenceNode(field.fieldName);
                if (field.valueExpr == null) {
                    return STNodeFactory.createFieldBindingPatternVarnameNode(fieldName);
                }
                return STNodeFactory.createFieldBindingPatternFullNode(fieldName, field.colon, this.getBindingPattern(field.valueExpr));
            }
            case FUNCTION_CALL: {
                STNode typeRef;
                STNode errorKeyword;
                STFunctionCallExpressionNode funcCall = (STFunctionCallExpressionNode)ambiguousNode;
                STNode args = funcCall.arguments;
                int size = args.bucketCount();
                ArrayList<STNode> bindingPatterns = new ArrayList<STNode>();
                for (int i = 0; i < size; ++i) {
                    STNode arg = args.childInBucket(i);
                    bindingPatterns.add(this.getBindingPattern(arg));
                }
                STNode argListBindingPatterns = STNodeFactory.createNodeList(bindingPatterns);
                if (funcCall.functionName.kind == SyntaxKind.ERROR_TYPE_DESC) {
                    errorKeyword = funcCall.functionName;
                    typeRef = STNodeFactory.createEmptyNode();
                } else {
                    errorKeyword = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.ERROR_KEYWORD, ParserRuleContext.ERROR_KEYWORD);
                    typeRef = funcCall.functionName;
                }
                return STNodeFactory.createErrorBindingPatternNode(errorKeyword, typeRef, funcCall.openParenToken, argListBindingPatterns, funcCall.closeParenToken);
            }
            case POSITIONAL_ARG: {
                STPositionalArgumentNode positionalArg = (STPositionalArgumentNode)ambiguousNode;
                return this.getBindingPattern(positionalArg.expression);
            }
            case NAMED_ARG: {
                STNamedArgumentNode namedArg = (STNamedArgumentNode)ambiguousNode;
                return STNodeFactory.createNamedArgBindingPatternNode(namedArg.argumentName, namedArg.equalsToken, this.getBindingPattern(namedArg.expression));
            }
            case REST_ARG: {
                STRestArgumentNode restArg = (STRestArgumentNode)ambiguousNode;
                return STNodeFactory.createRestBindingPatternNode(restArg.ellipsis, restArg.expression);
            }
        }
        return ambiguousNode;
    }

    private List<STNode> getExpressionList(List<STNode> ambibuousList) {
        ArrayList<STNode> exprList = new ArrayList<STNode>();
        for (STNode item : ambibuousList) {
            exprList.add(this.getExpression(item));
        }
        return exprList;
    }

    private STNode getExpression(STNode ambiguousNode) {
        if (this.isEmpty(ambiguousNode)) {
            return ambiguousNode;
        }
        switch (ambiguousNode.kind) {
            case BRACKETED_LIST: 
            case LIST_BP_OR_LIST_CONSTRUCTOR: 
            case TUPLE_TYPE_DESC_OR_LIST_CONST: {
                STAmbiguousCollectionNode innerList = (STAmbiguousCollectionNode)ambiguousNode;
                STNode memberExprs = STNodeFactory.createNodeList(this.getExpressionList(innerList.members));
                return STNodeFactory.createListConstructorExpressionNode(innerList.collectionStartToken, memberExprs, innerList.collectionEndToken);
            }
            case MAPPING_BP_OR_MAPPING_CONSTRUCTOR: {
                STAmbiguousCollectionNode innerList = (STAmbiguousCollectionNode)ambiguousNode;
                ArrayList<STNode> fieldList = new ArrayList<STNode>();
                for (int i = 0; i < innerList.members.size(); ++i) {
                    STNode fieldNode;
                    STNode field = innerList.members.get(i);
                    if (field.kind == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
                        STQualifiedNameReferenceNode qualifiedNameRefNode = (STQualifiedNameReferenceNode)field;
                        STNode readOnlyKeyword = STNodeFactory.createEmptyNode();
                        STNode fieldName = qualifiedNameRefNode.modulePrefix;
                        STNode colon = qualifiedNameRefNode.colon;
                        STNode valueExpr = this.getExpression(qualifiedNameRefNode.identifier);
                        fieldNode = STNodeFactory.createSpecificFieldNode(readOnlyKeyword, fieldName, colon, valueExpr);
                    } else {
                        fieldNode = this.getExpression(field);
                    }
                    fieldList.add(fieldNode);
                }
                STNode fields = STNodeFactory.createNodeList(fieldList);
                return STNodeFactory.createMappingConstructorExpressionNode(innerList.collectionStartToken, fields, innerList.collectionEndToken);
            }
            case REST_BINDING_PATTERN: {
                STRestBindingPatternNode restBindingPattern = (STRestBindingPatternNode)ambiguousNode;
                return STNodeFactory.createSpreadFieldNode(restBindingPattern.ellipsisToken, restBindingPattern.variableName);
            }
            case SPECIFIC_FIELD: {
                STSpecificFieldNode field = (STSpecificFieldNode)ambiguousNode;
                return STNodeFactory.createSpecificFieldNode(field.readonlyKeyword, field.fieldName, field.colon, this.getExpression(field.valueExpr));
            }
        }
        return ambiguousNode;
    }

    private STNode getMappingField(STNode identifier, STNode colon, STNode bindingPatternOrExpr) {
        STNode simpleNameRef = STNodeFactory.createSimpleNameReferenceNode(identifier);
        switch (bindingPatternOrExpr.kind) {
            case LIST_BINDING_PATTERN: 
            case MAPPING_BINDING_PATTERN: {
                return STNodeFactory.createFieldBindingPatternFullNode(simpleNameRef, colon, bindingPatternOrExpr);
            }
            case LIST_CONSTRUCTOR: 
            case MAPPING_CONSTRUCTOR: {
                STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                return STNodeFactory.createSpecificFieldNode(readonlyKeyword, simpleNameRef, colon, identifier);
            }
        }
        STNode readonlyKeyword = STNodeFactory.createEmptyNode();
        return STNodeFactory.createSpecificFieldNode(readonlyKeyword, identifier, colon, bindingPatternOrExpr);
    }
}

