/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.parser.AbstractTokenReader;
import io.ballerina.compiler.internal.parser.BallerinaLexer;
import io.ballerina.compiler.internal.parser.BallerinaParser;
import io.ballerina.compiler.internal.parser.TokenReader;
import io.ballerina.compiler.internal.parser.incremental.HybridNodeStorage;
import io.ballerina.compiler.internal.parser.incremental.HybridTokenReader;
import io.ballerina.compiler.internal.parser.incremental.IncrementalParser;
import io.ballerina.compiler.internal.parser.incremental.UnmodifiedSubtreeSupplier;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.text.CharReader;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextDocuments;

public class ParserFactory {
    private ParserFactory() {
    }

    public static BallerinaParser getParser(String text) {
        TextDocument textDocument = TextDocuments.from(text);
        TokenReader tokenReader = new TokenReader(ParserFactory.getLexer(textDocument));
        return new BallerinaParser(tokenReader);
    }

    public static BallerinaParser getParser(TextDocument textDocument) {
        TokenReader tokenReader = new TokenReader(ParserFactory.getLexer(textDocument));
        return new BallerinaParser(tokenReader);
    }

    public static BallerinaParser getParser(SyntaxTree oldTree, TextDocument newTextDocument, TextDocumentChange textDocumentChange) {
        HybridNodeStorage hybridNodeStorage = new HybridNodeStorage(oldTree, ParserFactory.getLexer(newTextDocument), textDocumentChange);
        HybridTokenReader tokeReader = new HybridTokenReader(hybridNodeStorage);
        UnmodifiedSubtreeSupplier subtreeReader = new UnmodifiedSubtreeSupplier(hybridNodeStorage);
        return new IncrementalParser((AbstractTokenReader)tokeReader, subtreeReader);
    }

    private static BallerinaLexer getLexer(TextDocument textDocument) {
        return new BallerinaLexer(CharReader.from(textDocument));
    }
}

