/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.incremental;

import io.ballerina.compiler.internal.syntax.SyntaxUtils;
import io.ballerina.compiler.syntax.tree.ChildNodeList;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;

class NodePointer {
    private Node current;
    private int childBucketIndex;

    private NodePointer(Node node, int childBucketIndex) {
        this.current = node;
        this.childBucketIndex = childBucketIndex;
    }

    NodePointer(ModulePartNode node) {
        this(node, 0);
    }

    NodePointer clonePointer() {
        return new NodePointer(this.current, this.childBucketIndex);
    }

    Token currentToken() {
        return (Token)this.current;
    }

    Node currentNode() {
        return this.current;
    }

    boolean isAtEOF() {
        return this.isEOFToken(this.current);
    }

    NodePointer nextChild() {
        NonTerminalNode nonTerminalNode = (NonTerminalNode)this.current;
        int childIndex = 0;
        for (Node child : nonTerminalNode.children()) {
            if (!this.isZeroWidthNode(child) || this.isEOFToken(child)) {
                this.current = child;
                this.childBucketIndex = childIndex;
                return this;
            }
            ++childIndex;
        }
        return new NodePointer(null);
    }

    NodePointer nextSibling() {
        if (this.current.parent() == null) {
            return new NodePointer(null);
        }
        NonTerminalNode parent = this.current.parent();
        ChildNodeList childNodeList = parent.children();
        for (int childIndex = this.childBucketIndex + 1; childIndex < childNodeList.size(); ++childIndex) {
            Node sibling = childNodeList.get(childIndex);
            if (this.isZeroWidthNode(sibling) && !this.isEOFToken(sibling)) continue;
            this.current = sibling;
            this.childBucketIndex = childIndex;
            return this;
        }
        return this.moveToParent().nextSibling();
    }

    NodePointer nextToken() {
        NodePointer nodePointer = this;
        if (this.isAtEOF()) {
            return this;
        }
        Node node = nodePointer.current;
        while (!SyntaxUtils.isToken(node)) {
            nodePointer = nodePointer.nextChild();
            node = nodePointer.current;
        }
        return nodePointer;
    }

    private NodePointer moveToParent() {
        NonTerminalNode parent = this.current.parent();
        if (parent.parent() == null) {
            this.childBucketIndex = 0;
            this.current = parent;
            return this;
        }
        NonTerminalNode ancestor = parent.parent();
        int childIndex = 0;
        for (Node sibling : ancestor.children()) {
            if (parent == sibling) {
                this.current = parent;
                this.childBucketIndex = childIndex;
                return this;
            }
            ++childIndex;
        }
        return new NodePointer(null);
    }

    private boolean isEOFToken(Node node) {
        return node.kind() == SyntaxKind.EOF_TOKEN;
    }

    private boolean isZeroWidthNode(Node node) {
        return node.textRangeWithMinutiae().length() == 0;
    }
}

