/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STBinaryExpressionNode
extends STExpressionNode {
    public final STNode lhsExpr;
    public final STNode operator;
    public final STNode rhsExpr;

    STBinaryExpressionNode(SyntaxKind kind, STNode lhsExpr, STNode operator, STNode rhsExpr) {
        this(kind, lhsExpr, operator, rhsExpr, Collections.emptyList());
    }

    STBinaryExpressionNode(SyntaxKind kind, STNode lhsExpr, STNode operator, STNode rhsExpr, Collection<STNodeDiagnostic> diagnostics) {
        super(kind, diagnostics);
        this.lhsExpr = lhsExpr;
        this.operator = operator;
        this.rhsExpr = rhsExpr;
        this.addChildren(lhsExpr, operator, rhsExpr);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STBinaryExpressionNode(this.kind, this.lhsExpr, this.operator, this.rhsExpr, diagnostics);
    }

    public STBinaryExpressionNode modify(SyntaxKind kind, STNode lhsExpr, STNode operator, STNode rhsExpr) {
        if (this.checkForReferenceEquality(lhsExpr, operator, rhsExpr)) {
            return this;
        }
        return new STBinaryExpressionNode(kind, lhsExpr, operator, rhsExpr, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new BinaryExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

