/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STDocumentationNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.DocumentationReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STDocumentationReferenceNode
extends STDocumentationNode {
    public final STNode referenceType;
    public final STNode startBacktick;
    public final STNode backtickContent;
    public final STNode endBacktick;

    STDocumentationReferenceNode(STNode referenceType, STNode startBacktick, STNode backtickContent, STNode endBacktick) {
        this(referenceType, startBacktick, backtickContent, endBacktick, Collections.emptyList());
    }

    STDocumentationReferenceNode(STNode referenceType, STNode startBacktick, STNode backtickContent, STNode endBacktick, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.DOCUMENTATION_REFERENCE, diagnostics);
        this.referenceType = referenceType;
        this.startBacktick = startBacktick;
        this.backtickContent = backtickContent;
        this.endBacktick = endBacktick;
        this.addChildren(referenceType, startBacktick, backtickContent, endBacktick);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STDocumentationReferenceNode(this.referenceType, this.startBacktick, this.backtickContent, this.endBacktick, diagnostics);
    }

    public STDocumentationReferenceNode modify(STNode referenceType, STNode startBacktick, STNode backtickContent, STNode endBacktick) {
        if (this.checkForReferenceEquality(referenceType, startBacktick, backtickContent, endBacktick)) {
            return this;
        }
        return new STDocumentationReferenceNode(referenceType, startBacktick, backtickContent, endBacktick, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new DocumentationReferenceNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

