/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ErrorTypeParamsNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STErrorTypeParamsNode
extends STNode {
    public final STNode ltToken;
    public final STNode parameter;
    public final STNode gtToken;

    STErrorTypeParamsNode(STNode ltToken, STNode parameter, STNode gtToken) {
        this(ltToken, parameter, gtToken, Collections.emptyList());
    }

    STErrorTypeParamsNode(STNode ltToken, STNode parameter, STNode gtToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ERROR_TYPE_PARAMS, diagnostics);
        this.ltToken = ltToken;
        this.parameter = parameter;
        this.gtToken = gtToken;
        this.addChildren(ltToken, parameter, gtToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STErrorTypeParamsNode(this.ltToken, this.parameter, this.gtToken, diagnostics);
    }

    public STErrorTypeParamsNode modify(STNode ltToken, STNode parameter, STNode gtToken) {
        if (this.checkForReferenceEquality(ltToken, parameter, gtToken)) {
            return this;
        }
        return new STErrorTypeParamsNode(ltToken, parameter, gtToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ErrorTypeParamsNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

