/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.FieldMatchPatternNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STFieldMatchPatternNode
extends STNode {
    public final STNode fieldNameNode;
    public final STNode colonToken;
    public final STNode matchPattern;

    STFieldMatchPatternNode(STNode fieldNameNode, STNode colonToken, STNode matchPattern) {
        this(fieldNameNode, colonToken, matchPattern, Collections.emptyList());
    }

    STFieldMatchPatternNode(STNode fieldNameNode, STNode colonToken, STNode matchPattern, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.FIELD_MATCH_PATTERN, diagnostics);
        this.fieldNameNode = fieldNameNode;
        this.colonToken = colonToken;
        this.matchPattern = matchPattern;
        this.addChildren(fieldNameNode, colonToken, matchPattern);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STFieldMatchPatternNode(this.fieldNameNode, this.colonToken, this.matchPattern, diagnostics);
    }

    public STFieldMatchPatternNode modify(STNode fieldNameNode, STNode colonToken, STNode matchPattern) {
        if (this.checkForReferenceEquality(fieldNameNode, colonToken, matchPattern)) {
            return this;
        }
        return new STFieldMatchPatternNode(fieldNameNode, colonToken, matchPattern, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new FieldMatchPatternNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

