/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STFunctionCallExpressionNode
extends STExpressionNode {
    public final STNode functionName;
    public final STNode openParenToken;
    public final STNode arguments;
    public final STNode closeParenToken;

    STFunctionCallExpressionNode(STNode functionName, STNode openParenToken, STNode arguments, STNode closeParenToken) {
        this(functionName, openParenToken, arguments, closeParenToken, Collections.emptyList());
    }

    STFunctionCallExpressionNode(STNode functionName, STNode openParenToken, STNode arguments, STNode closeParenToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.FUNCTION_CALL, diagnostics);
        this.functionName = functionName;
        this.openParenToken = openParenToken;
        this.arguments = arguments;
        this.closeParenToken = closeParenToken;
        this.addChildren(functionName, openParenToken, arguments, closeParenToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STFunctionCallExpressionNode(this.functionName, this.openParenToken, this.arguments, this.closeParenToken, diagnostics);
    }

    public STFunctionCallExpressionNode modify(STNode functionName, STNode openParenToken, STNode arguments, STNode closeParenToken) {
        if (this.checkForReferenceEquality(functionName, openParenToken, arguments, closeParenToken)) {
            return this;
        }
        return new STFunctionCallExpressionNode(functionName, openParenToken, arguments, closeParenToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new FunctionCallExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

