/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.LockStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STLockStatementNode
extends STStatementNode {
    public final STNode lockKeyword;
    public final STNode blockStatement;
    public final STNode onFailClause;

    STLockStatementNode(STNode lockKeyword, STNode blockStatement, STNode onFailClause) {
        this(lockKeyword, blockStatement, onFailClause, Collections.emptyList());
    }

    STLockStatementNode(STNode lockKeyword, STNode blockStatement, STNode onFailClause, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.LOCK_STATEMENT, diagnostics);
        this.lockKeyword = lockKeyword;
        this.blockStatement = blockStatement;
        this.onFailClause = onFailClause;
        this.addChildren(lockKeyword, blockStatement, onFailClause);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STLockStatementNode(this.lockKeyword, this.blockStatement, this.onFailClause, diagnostics);
    }

    public STLockStatementNode modify(STNode lockKeyword, STNode blockStatement, STNode onFailClause) {
        if (this.checkForReferenceEquality(lockKeyword, blockStatement, onFailClause)) {
            return this;
        }
        return new STLockStatementNode(lockKeyword, blockStatement, onFailClause, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new LockStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

