/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STBindingPatternNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.MappingBindingPatternNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STMappingBindingPatternNode
extends STBindingPatternNode {
    public final STNode openBrace;
    public final STNode fieldBindingPatterns;
    public final STNode restBindingPattern;
    public final STNode closeBrace;

    STMappingBindingPatternNode(STNode openBrace, STNode fieldBindingPatterns, STNode restBindingPattern, STNode closeBrace) {
        this(openBrace, fieldBindingPatterns, restBindingPattern, closeBrace, Collections.emptyList());
    }

    STMappingBindingPatternNode(STNode openBrace, STNode fieldBindingPatterns, STNode restBindingPattern, STNode closeBrace, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.MAPPING_BINDING_PATTERN, diagnostics);
        this.openBrace = openBrace;
        this.fieldBindingPatterns = fieldBindingPatterns;
        this.restBindingPattern = restBindingPattern;
        this.closeBrace = closeBrace;
        this.addChildren(openBrace, fieldBindingPatterns, restBindingPattern, closeBrace);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STMappingBindingPatternNode(this.openBrace, this.fieldBindingPatterns, this.restBindingPattern, this.closeBrace, diagnostics);
    }

    public STMappingBindingPatternNode modify(STNode openBrace, STNode fieldBindingPatterns, STNode restBindingPattern, STNode closeBrace) {
        if (this.checkForReferenceEquality(openBrace, fieldBindingPatterns, restBindingPattern, closeBrace)) {
            return this;
        }
        return new STMappingBindingPatternNode(openBrace, fieldBindingPatterns, restBindingPattern, closeBrace, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new MappingBindingPatternNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

