/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.MatchClauseNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STMatchClauseNode
extends STNode {
    public final STNode matchPatterns;
    public final STNode matchGuard;
    public final STNode rightDoubleArrow;
    public final STNode blockStatement;

    STMatchClauseNode(STNode matchPatterns, STNode matchGuard, STNode rightDoubleArrow, STNode blockStatement) {
        this(matchPatterns, matchGuard, rightDoubleArrow, blockStatement, Collections.emptyList());
    }

    STMatchClauseNode(STNode matchPatterns, STNode matchGuard, STNode rightDoubleArrow, STNode blockStatement, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.MATCH_CLAUSE, diagnostics);
        this.matchPatterns = matchPatterns;
        this.matchGuard = matchGuard;
        this.rightDoubleArrow = rightDoubleArrow;
        this.blockStatement = blockStatement;
        this.addChildren(matchPatterns, matchGuard, rightDoubleArrow, blockStatement);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STMatchClauseNode(this.matchPatterns, this.matchGuard, this.rightDoubleArrow, this.blockStatement, diagnostics);
    }

    public STMatchClauseNode modify(STNode matchPatterns, STNode matchGuard, STNode rightDoubleArrow, STNode blockStatement) {
        if (this.checkForReferenceEquality(matchPatterns, matchGuard, rightDoubleArrow, blockStatement)) {
            return this;
        }
        return new STMatchClauseNode(matchPatterns, matchGuard, rightDoubleArrow, blockStatement, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new MatchClauseNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

