/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.MatchGuardNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STMatchGuardNode
extends STNode {
    public final STNode ifKeyword;
    public final STNode expression;

    STMatchGuardNode(STNode ifKeyword, STNode expression) {
        this(ifKeyword, expression, Collections.emptyList());
    }

    STMatchGuardNode(STNode ifKeyword, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.MATCH_GUARD, diagnostics);
        this.ifKeyword = ifKeyword;
        this.expression = expression;
        this.addChildren(ifKeyword, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STMatchGuardNode(this.ifKeyword, this.expression, diagnostics);
    }

    public STMatchGuardNode modify(STNode ifKeyword, STNode expression) {
        if (this.checkForReferenceEquality(ifKeyword, expression)) {
            return this;
        }
        return new STMatchGuardNode(ifKeyword, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new MatchGuardNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

