/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STMethodDeclarationNode
extends STNode {
    public final STNode metadata;
    public final STNode qualifierList;
    public final STNode functionKeyword;
    public final STNode methodName;
    public final STNode methodSignature;
    public final STNode semicolon;

    STMethodDeclarationNode(STNode metadata, STNode qualifierList, STNode functionKeyword, STNode methodName, STNode methodSignature, STNode semicolon) {
        this(metadata, qualifierList, functionKeyword, methodName, methodSignature, semicolon, Collections.emptyList());
    }

    STMethodDeclarationNode(STNode metadata, STNode qualifierList, STNode functionKeyword, STNode methodName, STNode methodSignature, STNode semicolon, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.METHOD_DECLARATION, diagnostics);
        this.metadata = metadata;
        this.qualifierList = qualifierList;
        this.functionKeyword = functionKeyword;
        this.methodName = methodName;
        this.methodSignature = methodSignature;
        this.semicolon = semicolon;
        this.addChildren(metadata, qualifierList, functionKeyword, methodName, methodSignature, semicolon);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STMethodDeclarationNode(this.metadata, this.qualifierList, this.functionKeyword, this.methodName, this.methodSignature, this.semicolon, diagnostics);
    }

    public STMethodDeclarationNode modify(STNode metadata, STNode qualifierList, STNode functionKeyword, STNode methodName, STNode methodSignature, STNode semicolon) {
        if (this.checkForReferenceEquality(metadata, qualifierList, functionKeyword, methodName, methodSignature, semicolon)) {
            return this;
        }
        return new STMethodDeclarationNode(metadata, qualifierList, functionKeyword, methodName, methodSignature, semicolon, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new MethodDeclarationNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

