/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STModulePartNode
extends STNode {
    public final STNode imports;
    public final STNode members;
    public final STNode eofToken;

    STModulePartNode(STNode imports, STNode members, STNode eofToken) {
        this(imports, members, eofToken, Collections.emptyList());
    }

    STModulePartNode(STNode imports, STNode members, STNode eofToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.MODULE_PART, diagnostics);
        this.imports = imports;
        this.members = members;
        this.eofToken = eofToken;
        this.addChildren(imports, members, eofToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STModulePartNode(this.imports, this.members, this.eofToken, diagnostics);
    }

    public STModulePartNode modify(STNode imports, STNode members, STNode eofToken) {
        if (this.checkForReferenceEquality(imports, members, eofToken)) {
            return this;
        }
        return new STModulePartNode(imports, members, eofToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ModulePartNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

