/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STBindingPatternNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.NamedArgBindingPatternNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STNamedArgBindingPatternNode
extends STBindingPatternNode {
    public final STNode argName;
    public final STNode equalsToken;
    public final STNode bindingPattern;

    STNamedArgBindingPatternNode(STNode argName, STNode equalsToken, STNode bindingPattern) {
        this(argName, equalsToken, bindingPattern, Collections.emptyList());
    }

    STNamedArgBindingPatternNode(STNode argName, STNode equalsToken, STNode bindingPattern, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.NAMED_ARG_BINDING_PATTERN, diagnostics);
        this.argName = argName;
        this.equalsToken = equalsToken;
        this.bindingPattern = bindingPattern;
        this.addChildren(argName, equalsToken, bindingPattern);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STNamedArgBindingPatternNode(this.argName, this.equalsToken, this.bindingPattern, diagnostics);
    }

    public STNamedArgBindingPatternNode modify(STNode argName, STNode equalsToken, STNode bindingPattern) {
        if (this.checkForReferenceEquality(argName, equalsToken, bindingPattern)) {
            return this;
        }
        return new STNamedArgBindingPatternNode(argName, equalsToken, bindingPattern, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new NamedArgBindingPatternNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

