/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.NilTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STNilTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode openParenToken;
    public final STNode closeParenToken;

    STNilTypeDescriptorNode(STNode openParenToken, STNode closeParenToken) {
        this(openParenToken, closeParenToken, Collections.emptyList());
    }

    STNilTypeDescriptorNode(STNode openParenToken, STNode closeParenToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.NIL_TYPE_DESC, diagnostics);
        this.openParenToken = openParenToken;
        this.closeParenToken = closeParenToken;
        this.addChildren(openParenToken, closeParenToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STNilTypeDescriptorNode(this.openParenToken, this.closeParenToken, diagnostics);
    }

    public STNilTypeDescriptorNode modify(STNode openParenToken, STNode closeParenToken) {
        if (this.checkForReferenceEquality(openParenToken, closeParenToken)) {
            return this;
        }
        return new STNilTypeDescriptorNode(openParenToken, closeParenToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new NilTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

