/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesisedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STParenthesisedTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode openParenToken;
    public final STNode typedesc;
    public final STNode closeParenToken;

    STParenthesisedTypeDescriptorNode(STNode openParenToken, STNode typedesc, STNode closeParenToken) {
        this(openParenToken, typedesc, closeParenToken, Collections.emptyList());
    }

    STParenthesisedTypeDescriptorNode(STNode openParenToken, STNode typedesc, STNode closeParenToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.PARENTHESISED_TYPE_DESC, diagnostics);
        this.openParenToken = openParenToken;
        this.typedesc = typedesc;
        this.closeParenToken = closeParenToken;
        this.addChildren(openParenToken, typedesc, closeParenToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STParenthesisedTypeDescriptorNode(this.openParenToken, this.typedesc, this.closeParenToken, diagnostics);
    }

    public STParenthesisedTypeDescriptorNode modify(STNode openParenToken, STNode typedesc, STNode closeParenToken) {
        if (this.checkForReferenceEquality(openParenToken, typedesc, closeParenToken)) {
            return this;
        }
        return new STParenthesisedTypeDescriptorNode(openParenToken, typedesc, closeParenToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ParenthesisedTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

