/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STReturnStatementNode
extends STStatementNode {
    public final STNode returnKeyword;
    public final STNode expression;
    public final STNode semicolonToken;

    STReturnStatementNode(STNode returnKeyword, STNode expression, STNode semicolonToken) {
        this(returnKeyword, expression, semicolonToken, Collections.emptyList());
    }

    STReturnStatementNode(STNode returnKeyword, STNode expression, STNode semicolonToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RETURN_STATEMENT, diagnostics);
        this.returnKeyword = returnKeyword;
        this.expression = expression;
        this.semicolonToken = semicolonToken;
        this.addChildren(returnKeyword, expression, semicolonToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STReturnStatementNode(this.returnKeyword, this.expression, this.semicolonToken, diagnostics);
    }

    public STReturnStatementNode modify(STNode returnKeyword, STNode expression, STNode semicolonToken) {
        if (this.checkForReferenceEquality(returnKeyword, expression, semicolonToken)) {
            return this;
        }
        return new STReturnStatementNode(returnKeyword, expression, semicolonToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ReturnStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

