/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RollbackStatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STRollbackStatementNode
extends STStatementNode {
    public final STNode rollbackKeyword;
    public final STNode expression;
    public final STNode semicolon;

    STRollbackStatementNode(STNode rollbackKeyword, STNode expression, STNode semicolon) {
        this(rollbackKeyword, expression, semicolon, Collections.emptyList());
    }

    STRollbackStatementNode(STNode rollbackKeyword, STNode expression, STNode semicolon, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ROLLBACK_STATEMENT, diagnostics);
        this.rollbackKeyword = rollbackKeyword;
        this.expression = expression;
        this.semicolon = semicolon;
        this.addChildren(rollbackKeyword, expression, semicolon);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STRollbackStatementNode(this.rollbackKeyword, this.expression, this.semicolon, diagnostics);
    }

    public STRollbackStatementNode modify(STNode rollbackKeyword, STNode expression, STNode semicolon) {
        if (this.checkForReferenceEquality(rollbackKeyword, expression, semicolon)) {
            return this;
        }
        return new STRollbackStatementNode(rollbackKeyword, expression, semicolon, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new RollbackStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

