/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ServiceBodyNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STServiceBodyNode
extends STNode {
    public final STNode openBraceToken;
    public final STNode resources;
    public final STNode closeBraceToken;

    STServiceBodyNode(STNode openBraceToken, STNode resources, STNode closeBraceToken) {
        this(openBraceToken, resources, closeBraceToken, Collections.emptyList());
    }

    STServiceBodyNode(STNode openBraceToken, STNode resources, STNode closeBraceToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.SERVICE_BODY, diagnostics);
        this.openBraceToken = openBraceToken;
        this.resources = resources;
        this.closeBraceToken = closeBraceToken;
        this.addChildren(openBraceToken, resources, closeBraceToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STServiceBodyNode(this.openBraceToken, this.resources, this.closeBraceToken, diagnostics);
    }

    public STServiceBodyNode modify(STNode openBraceToken, STNode resources, STNode closeBraceToken) {
        if (this.checkForReferenceEquality(openBraceToken, resources, closeBraceToken)) {
            return this;
        }
        return new STServiceBodyNode(openBraceToken, resources, closeBraceToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ServiceBodyNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

