/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TransactionalExpressionNode;
import java.util.Collection;
import java.util.Collections;

public class STTransactionalExpressionNode
extends STExpressionNode {
    public final STNode transactionalKeyword;

    STTransactionalExpressionNode(STNode transactionalKeyword) {
        this(transactionalKeyword, Collections.emptyList());
    }

    STTransactionalExpressionNode(STNode transactionalKeyword, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.TRANSACTIONAL_EXPRESSION, diagnostics);
        this.transactionalKeyword = transactionalKeyword;
        this.addChildren(transactionalKeyword);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTransactionalExpressionNode(this.transactionalKeyword, diagnostics);
    }

    public STTransactionalExpressionNode modify(STNode transactionalKeyword) {
        if (this.checkForReferenceEquality(transactionalKeyword)) {
            return this;
        }
        return new STTransactionalExpressionNode(transactionalKeyword, (Collection<STNodeDiagnostic>)this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TransactionalExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

