/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TrippleGTTokenNode;
import java.util.Collection;
import java.util.Collections;

public class STTrippleGTTokenNode
extends STNode {
    public final STNode openGTToken;
    public final STNode middleGTToken;
    public final STNode endGTToken;

    STTrippleGTTokenNode(STNode openGTToken, STNode middleGTToken, STNode endGTToken) {
        this(openGTToken, middleGTToken, endGTToken, Collections.emptyList());
    }

    STTrippleGTTokenNode(STNode openGTToken, STNode middleGTToken, STNode endGTToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.TRIPPLE_GT_TOKEN, diagnostics);
        this.openGTToken = openGTToken;
        this.middleGTToken = middleGTToken;
        this.endGTToken = endGTToken;
        this.addChildren(openGTToken, middleGTToken, endGTToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTrippleGTTokenNode(this.openGTToken, this.middleGTToken, this.endGTToken, diagnostics);
    }

    public STTrippleGTTokenNode modify(STNode openGTToken, STNode middleGTToken, STNode endGTToken) {
        if (this.checkForReferenceEquality(openGTToken, middleGTToken, endGTToken)) {
            return this;
        }
        return new STTrippleGTTokenNode(openGTToken, middleGTToken, endGTToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TrippleGTTokenNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

