/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.UnaryExpressionNode;
import java.util.Collection;
import java.util.Collections;

public class STUnaryExpressionNode
extends STExpressionNode {
    public final STNode unaryOperator;
    public final STNode expression;

    STUnaryExpressionNode(STNode unaryOperator, STNode expression) {
        this(unaryOperator, expression, Collections.emptyList());
    }

    STUnaryExpressionNode(STNode unaryOperator, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.UNARY_EXPRESSION, diagnostics);
        this.unaryOperator = unaryOperator;
        this.expression = expression;
        this.addChildren(unaryOperator, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STUnaryExpressionNode(this.unaryOperator, this.expression, diagnostics);
    }

    public STUnaryExpressionNode modify(STNode unaryOperator, STNode expression) {
        if (this.checkForReferenceEquality(unaryOperator, expression)) {
            return this;
        }
        return new STUnaryExpressionNode(unaryOperator, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new UnaryExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

