/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STXMLNameNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLSimpleNameNode;
import java.util.Collection;
import java.util.Collections;

public class STXMLSimpleNameNode
extends STXMLNameNode {
    public final STNode name;

    STXMLSimpleNameNode(STNode name) {
        this(name, Collections.emptyList());
    }

    STXMLSimpleNameNode(STNode name, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_SIMPLE_NAME, diagnostics);
        this.name = name;
        this.addChildren(name);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLSimpleNameNode(this.name, diagnostics);
    }

    public STXMLSimpleNameNode modify(STNode name) {
        if (this.checkForReferenceEquality(name)) {
            return this;
        }
        return new STXMLSimpleNameNode(name, (Collection<STNodeDiagnostic>)this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLSimpleNameNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

