/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STXMLItemNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLTextNode;
import java.util.Collection;
import java.util.Collections;

public class STXMLTextNode
extends STXMLItemNode {
    public final STNode content;

    STXMLTextNode(STNode content) {
        this(content, Collections.emptyList());
    }

    STXMLTextNode(STNode content, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_TEXT, diagnostics);
        this.content = content;
        this.addChildren(content);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLTextNode(this.content, diagnostics);
    }

    public STXMLTextNode modify(STNode content) {
        if (this.checkForReferenceEquality(content)) {
            return this;
        }
        return new STXMLTextNode(content, (Collection<STNodeDiagnostic>)this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLTextNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

