/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STMinutiae;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.internal.syntax.NodeListUtils;
import io.ballerina.compiler.syntax.tree.DocumentationLineToken;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.LiteralValueToken;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class AbstractNodeFactory {
    private static final MinutiaeList EMPTY_MINUTIAE_LIST = new MinutiaeList(null, STNodeFactory.createEmptyNodeList(), 0);
    private static final NodeList EMPTY_NODE_LIST = new NodeList((NonTerminalNode)STNodeFactory.createEmptyNodeList().createUnlinkedFacade());

    public static IdentifierToken createIdentifierToken(String text) {
        STToken token = STNodeFactory.createIdentifierToken(text, STNodeFactory.createNodeList(new STNode[0]), STNodeFactory.createNodeList(new STNode[0]));
        return (IdentifierToken)token.createUnlinkedFacade();
    }

    public static IdentifierToken createIdentifierToken(String text, MinutiaeList leadingMinutiae, MinutiaeList trailingMinutiae) {
        STNode trailingMinutiaeSTNode;
        STNode leadingMinutiaeSTNode = leadingMinutiae.internalNode();
        if (!NodeListUtils.isSTNodeList(leadingMinutiaeSTNode)) {
            leadingMinutiaeSTNode = STNodeFactory.createNodeList(leadingMinutiaeSTNode);
        }
        if (!NodeListUtils.isSTNodeList(trailingMinutiaeSTNode = trailingMinutiae.internalNode())) {
            trailingMinutiaeSTNode = STNodeFactory.createNodeList(trailingMinutiaeSTNode);
        }
        STToken token = STNodeFactory.createIdentifierToken(text, leadingMinutiaeSTNode, trailingMinutiaeSTNode);
        return (IdentifierToken)token.createUnlinkedFacade();
    }

    public static Token createToken(SyntaxKind kind) {
        return AbstractNodeFactory.createToken(kind, AbstractNodeFactory.createEmptyMinutiaeList(), AbstractNodeFactory.createEmptyMinutiaeList());
    }

    public static Token createMissingToken(SyntaxKind kind, MinutiaeList leadingMinutiae, MinutiaeList trailingMinutiae) {
        STNode trailingMinutiaeSTNode;
        STNode leadingMinutiaeSTNode = leadingMinutiae.internalNode();
        if (!NodeListUtils.isSTNodeList(leadingMinutiaeSTNode)) {
            leadingMinutiaeSTNode = STNodeFactory.createNodeList(leadingMinutiaeSTNode);
        }
        if (!NodeListUtils.isSTNodeList(trailingMinutiaeSTNode = trailingMinutiae.internalNode())) {
            trailingMinutiaeSTNode = STNodeFactory.createNodeList(trailingMinutiaeSTNode);
        }
        STToken token = STNodeFactory.createMissingToken(kind, leadingMinutiaeSTNode, trailingMinutiaeSTNode, Collections.EMPTY_LIST);
        return (Token)token.createUnlinkedFacade();
    }

    public static Token createToken(SyntaxKind kind, MinutiaeList leadingMinutiae, MinutiaeList trailingMinutiae) {
        STNode trailingMinutiaeSTNode;
        STNode leadingMinutiaeSTNode = leadingMinutiae.internalNode();
        if (!NodeListUtils.isSTNodeList(leadingMinutiaeSTNode)) {
            leadingMinutiaeSTNode = STNodeFactory.createNodeList(leadingMinutiaeSTNode);
        }
        if (!NodeListUtils.isSTNodeList(trailingMinutiaeSTNode = trailingMinutiae.internalNode())) {
            trailingMinutiaeSTNode = STNodeFactory.createNodeList(trailingMinutiaeSTNode);
        }
        STToken token = STNodeFactory.createToken(kind, leadingMinutiaeSTNode, trailingMinutiaeSTNode);
        return (Token)token.createUnlinkedFacade();
    }

    public static LiteralValueToken createLiteralValueToken(SyntaxKind kind, String text, MinutiaeList leadingMinutiae, MinutiaeList trailingMinutiae) {
        STNode trailingMinutiaeSTNode;
        STNode leadingMinutiaeSTNode = leadingMinutiae.internalNode();
        if (!NodeListUtils.isSTNodeList(leadingMinutiaeSTNode)) {
            leadingMinutiaeSTNode = STNodeFactory.createNodeList(leadingMinutiaeSTNode);
        }
        if (!NodeListUtils.isSTNodeList(trailingMinutiaeSTNode = trailingMinutiae.internalNode())) {
            trailingMinutiaeSTNode = STNodeFactory.createNodeList(trailingMinutiaeSTNode);
        }
        STToken token = STNodeFactory.createLiteralValueToken(kind, text, leadingMinutiaeSTNode, trailingMinutiaeSTNode);
        return (LiteralValueToken)token.createUnlinkedFacade();
    }

    public static DocumentationLineToken createDocumentationLineToken(String text, MinutiaeList leadingMinutiae, MinutiaeList trailingMinutiae) {
        STNode trailingMinutiaeSTNode;
        STNode leadingMinutiaeSTNode = leadingMinutiae.internalNode();
        if (!NodeListUtils.isSTNodeList(leadingMinutiaeSTNode)) {
            leadingMinutiaeSTNode = STNodeFactory.createNodeList(leadingMinutiaeSTNode);
        }
        if (!NodeListUtils.isSTNodeList(trailingMinutiaeSTNode = trailingMinutiae.internalNode())) {
            trailingMinutiaeSTNode = STNodeFactory.createNodeList(trailingMinutiaeSTNode);
        }
        STToken token = STNodeFactory.createDocumentationLineToken(text, leadingMinutiaeSTNode, trailingMinutiaeSTNode);
        return (DocumentationLineToken)token.createUnlinkedFacade();
    }

    public static MinutiaeList createEmptyMinutiaeList() {
        return EMPTY_MINUTIAE_LIST;
    }

    public static MinutiaeList createMinutiaeList(Minutiae ... minutiaeNodes) {
        STNode[] internalNodes = new STNode[minutiaeNodes.length];
        for (int index = 0; index < minutiaeNodes.length; ++index) {
            Minutiae minutiae = minutiaeNodes[index];
            Objects.requireNonNull(minutiae, "minutiae should not be null");
            internalNodes[index] = minutiae.internalNode();
        }
        return new MinutiaeList(null, STNodeFactory.createNodeList(internalNodes), 0);
    }

    public static MinutiaeList createMinutiaeList(Collection<Minutiae> minutiaeNodes) {
        return new MinutiaeList(null, STNodeFactory.createNodeList(minutiaeNodes.stream().map(minutiae -> Objects.requireNonNull(minutiae, "minutiae should not be null")).map(Minutiae::internalNode).collect(Collectors.toList())), 0);
    }

    public static Minutiae createCommentMinutiae(String text) {
        STMinutiae internalNode = (STMinutiae)STNodeFactory.createMinutiae(SyntaxKind.COMMENT_MINUTIAE, text);
        return Minutiae.createUnlinked(internalNode);
    }

    public static Minutiae createWhitespaceMinutiae(String text) {
        STMinutiae internalNode = (STMinutiae)STNodeFactory.createMinutiae(SyntaxKind.WHITESPACE_MINUTIAE, text);
        return Minutiae.createUnlinked(internalNode);
    }

    public static Minutiae createEndOfLineMinutiae(String text) {
        STMinutiae internalNode = (STMinutiae)STNodeFactory.createMinutiae(SyntaxKind.END_OF_LINE_MINUTIAE, text);
        return Minutiae.createUnlinked(internalNode);
    }

    public static <T extends Node> NodeList<T> createEmptyNodeList() {
        return EMPTY_NODE_LIST;
    }

    public static <T extends Node> NodeList<T> createNodeList(T ... nodes) {
        STNode[] internalNodes = new STNode[nodes.length];
        for (int index = 0; index < nodes.length; ++index) {
            T node = nodes[index];
            Objects.requireNonNull(node, "node should not be null");
            internalNodes[index] = ((Node)node).internalNode();
        }
        return new NodeList((NonTerminalNode)STNodeFactory.createNodeList(internalNodes).createUnlinkedFacade());
    }

    public static <T extends Node> NodeList<T> createNodeList(Collection<T> nodes) {
        return new NodeList((NonTerminalNode)STNodeFactory.createNodeList(nodes.stream().map(node -> Objects.requireNonNull(node, "node should not be null")).map(Node::internalNode).collect(Collectors.toList())).createUnlinkedFacade());
    }

    public static <T extends Node> SeparatedNodeList<T> createSeparatedNodeList(Node ... nodes) {
        STNode[] internalNodes = new STNode[nodes.length];
        for (int index = 0; index < nodes.length; ++index) {
            Node node = nodes[index];
            Objects.requireNonNull(node, "node should not be null");
            internalNodes[index] = node.internalNode();
        }
        return new SeparatedNodeList((NonTerminalNode)STNodeFactory.createNodeList(internalNodes).createUnlinkedFacade());
    }

    public static <T extends Node> SeparatedNodeList<T> createSeparatedNodeList(Collection<Node> nodes) {
        return new SeparatedNodeList((NonTerminalNode)STNodeFactory.createNodeList(nodes.stream().map(node -> Objects.requireNonNull(node, "node should not be null")).map(Node::internalNode).collect(Collectors.toList())).createUnlinkedFacade());
    }

    protected static STNode getOptionalSTNode(Node node) {
        return node != null ? node.internalNode() : null;
    }
}

