/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class AnnotationAttachPointNode
extends NonTerminalNode {
    public AnnotationAttachPointNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<Token> sourceKeyword() {
        return this.optionalChildInBucket(0);
    }

    public Token firstIdent() {
        return (Token)this.childInBucket(1);
    }

    public Optional<Token> secondIdent() {
        return this.optionalChildInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"sourceKeyword", "firstIdent", "secondIdent"};
    }

    public AnnotationAttachPointNode modify(Token sourceKeyword, Token firstIdent, Token secondIdent) {
        if (this.checkForReferenceEquality(sourceKeyword, firstIdent, secondIdent)) {
            return this;
        }
        return NodeFactory.createAnnotationAttachPointNode(sourceKeyword, firstIdent, secondIdent);
    }

    public AnnotationAttachPointNodeModifier modify() {
        return new AnnotationAttachPointNodeModifier(this);
    }

    public static class AnnotationAttachPointNodeModifier {
        private final AnnotationAttachPointNode oldNode;
        private Token sourceKeyword;
        private Token firstIdent;
        private Token secondIdent;

        public AnnotationAttachPointNodeModifier(AnnotationAttachPointNode oldNode) {
            this.oldNode = oldNode;
            this.sourceKeyword = oldNode.sourceKeyword().orElse(null);
            this.firstIdent = oldNode.firstIdent();
            this.secondIdent = oldNode.secondIdent().orElse(null);
        }

        public AnnotationAttachPointNodeModifier withSourceKeyword(Token sourceKeyword) {
            this.sourceKeyword = sourceKeyword;
            return this;
        }

        public AnnotationAttachPointNodeModifier withFirstIdent(Token firstIdent) {
            Objects.requireNonNull(firstIdent, "firstIdent must not be null");
            this.firstIdent = firstIdent;
            return this;
        }

        public AnnotationAttachPointNodeModifier withSecondIdent(Token secondIdent) {
            this.secondIdent = secondIdent;
            return this;
        }

        public AnnotationAttachPointNode apply() {
            return this.oldNode.modify(this.sourceKeyword, this.firstIdent, this.secondIdent);
        }
    }
}

