/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ClassDefinitionNode
extends ModuleMemberDeclarationNode {
    public ClassDefinitionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<MetadataNode> metadata() {
        return this.optionalChildInBucket(0);
    }

    public Optional<Token> visibilityQualifier() {
        return this.optionalChildInBucket(1);
    }

    public NodeList<Token> classTypeQualifiers() {
        return new NodeList<Token>((NonTerminalNode)this.childInBucket(2));
    }

    public Token classKeyword() {
        return (Token)this.childInBucket(3);
    }

    public Token className() {
        return (Token)this.childInBucket(4);
    }

    public Token openBrace() {
        return (Token)this.childInBucket(5);
    }

    public NodeList<Node> members() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(6));
    }

    public Token closeBrace() {
        return (Token)this.childInBucket(7);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"metadata", "visibilityQualifier", "classTypeQualifiers", "classKeyword", "className", "openBrace", "members", "closeBrace"};
    }

    public ClassDefinitionNode modify(MetadataNode metadata, Token visibilityQualifier, NodeList<Token> classTypeQualifiers, Token classKeyword, Token className, Token openBrace, NodeList<Node> members, Token closeBrace) {
        if (this.checkForReferenceEquality(metadata, visibilityQualifier, classTypeQualifiers.underlyingListNode(), classKeyword, className, openBrace, members.underlyingListNode(), closeBrace)) {
            return this;
        }
        return NodeFactory.createClassDefinitionNode(metadata, visibilityQualifier, classTypeQualifiers, classKeyword, className, openBrace, members, closeBrace);
    }

    public ClassDefinitionNodeModifier modify() {
        return new ClassDefinitionNodeModifier(this);
    }

    public static class ClassDefinitionNodeModifier {
        private final ClassDefinitionNode oldNode;
        private MetadataNode metadata;
        private Token visibilityQualifier;
        private NodeList<Token> classTypeQualifiers;
        private Token classKeyword;
        private Token className;
        private Token openBrace;
        private NodeList<Node> members;
        private Token closeBrace;

        public ClassDefinitionNodeModifier(ClassDefinitionNode oldNode) {
            this.oldNode = oldNode;
            this.metadata = oldNode.metadata().orElse(null);
            this.visibilityQualifier = oldNode.visibilityQualifier().orElse(null);
            this.classTypeQualifiers = oldNode.classTypeQualifiers();
            this.classKeyword = oldNode.classKeyword();
            this.className = oldNode.className();
            this.openBrace = oldNode.openBrace();
            this.members = oldNode.members();
            this.closeBrace = oldNode.closeBrace();
        }

        public ClassDefinitionNodeModifier withMetadata(MetadataNode metadata) {
            this.metadata = metadata;
            return this;
        }

        public ClassDefinitionNodeModifier withVisibilityQualifier(Token visibilityQualifier) {
            this.visibilityQualifier = visibilityQualifier;
            return this;
        }

        public ClassDefinitionNodeModifier withClassTypeQualifiers(NodeList<Token> classTypeQualifiers) {
            Objects.requireNonNull(classTypeQualifiers, "classTypeQualifiers must not be null");
            this.classTypeQualifiers = classTypeQualifiers;
            return this;
        }

        public ClassDefinitionNodeModifier withClassKeyword(Token classKeyword) {
            Objects.requireNonNull(classKeyword, "classKeyword must not be null");
            this.classKeyword = classKeyword;
            return this;
        }

        public ClassDefinitionNodeModifier withClassName(Token className) {
            Objects.requireNonNull(className, "className must not be null");
            this.className = className;
            return this;
        }

        public ClassDefinitionNodeModifier withOpenBrace(Token openBrace) {
            Objects.requireNonNull(openBrace, "openBrace must not be null");
            this.openBrace = openBrace;
            return this;
        }

        public ClassDefinitionNodeModifier withMembers(NodeList<Node> members) {
            Objects.requireNonNull(members, "members must not be null");
            this.members = members;
            return this;
        }

        public ClassDefinitionNodeModifier withCloseBrace(Token closeBrace) {
            Objects.requireNonNull(closeBrace, "closeBrace must not be null");
            this.closeBrace = closeBrace;
            return this;
        }

        public ClassDefinitionNode apply() {
            return this.oldNode.modify(this.metadata, this.visibilityQualifier, this.classTypeQualifiers, this.classKeyword, this.className, this.openBrace, this.members, this.closeBrace);
        }
    }
}

