/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ContinueStatementNode
extends StatementNode {
    public ContinueStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token continueToken() {
        return (Token)this.childInBucket(0);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"continueToken", "semicolonToken"};
    }

    public ContinueStatementNode modify(Token continueToken, Token semicolonToken) {
        if (this.checkForReferenceEquality(continueToken, semicolonToken)) {
            return this;
        }
        return NodeFactory.createContinueStatementNode(continueToken, semicolonToken);
    }

    public ContinueStatementNodeModifier modify() {
        return new ContinueStatementNodeModifier(this);
    }

    public static class ContinueStatementNodeModifier {
        private final ContinueStatementNode oldNode;
        private Token continueToken;
        private Token semicolonToken;

        public ContinueStatementNodeModifier(ContinueStatementNode oldNode) {
            this.oldNode = oldNode;
            this.continueToken = oldNode.continueToken();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public ContinueStatementNodeModifier withContinueToken(Token continueToken) {
            Objects.requireNonNull(continueToken, "continueToken must not be null");
            this.continueToken = continueToken;
            return this;
        }

        public ContinueStatementNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public ContinueStatementNode apply() {
            return this.oldNode.modify(this.continueToken, this.semicolonToken);
        }
    }
}

