/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ErrorBindingPatternNode
extends BindingPatternNode {
    public ErrorBindingPatternNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token errorKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Optional<Node> typeReference() {
        return this.optionalChildInBucket(1);
    }

    public Token openParenthesis() {
        return (Token)this.childInBucket(2);
    }

    public SeparatedNodeList<BindingPatternNode> argListBindingPatterns() {
        return new SeparatedNodeList<BindingPatternNode>((NonTerminalNode)this.childInBucket(3));
    }

    public Token closeParenthesis() {
        return (Token)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"errorKeyword", "typeReference", "openParenthesis", "argListBindingPatterns", "closeParenthesis"};
    }

    public ErrorBindingPatternNode modify(Token errorKeyword, Node typeReference, Token openParenthesis, SeparatedNodeList<BindingPatternNode> argListBindingPatterns, Token closeParenthesis) {
        if (this.checkForReferenceEquality(errorKeyword, typeReference, openParenthesis, argListBindingPatterns.underlyingListNode(), closeParenthesis)) {
            return this;
        }
        return NodeFactory.createErrorBindingPatternNode(errorKeyword, typeReference, openParenthesis, argListBindingPatterns, closeParenthesis);
    }

    public ErrorBindingPatternNodeModifier modify() {
        return new ErrorBindingPatternNodeModifier(this);
    }

    public static class ErrorBindingPatternNodeModifier {
        private final ErrorBindingPatternNode oldNode;
        private Token errorKeyword;
        private Node typeReference;
        private Token openParenthesis;
        private SeparatedNodeList<BindingPatternNode> argListBindingPatterns;
        private Token closeParenthesis;

        public ErrorBindingPatternNodeModifier(ErrorBindingPatternNode oldNode) {
            this.oldNode = oldNode;
            this.errorKeyword = oldNode.errorKeyword();
            this.typeReference = oldNode.typeReference().orElse(null);
            this.openParenthesis = oldNode.openParenthesis();
            this.argListBindingPatterns = oldNode.argListBindingPatterns();
            this.closeParenthesis = oldNode.closeParenthesis();
        }

        public ErrorBindingPatternNodeModifier withErrorKeyword(Token errorKeyword) {
            Objects.requireNonNull(errorKeyword, "errorKeyword must not be null");
            this.errorKeyword = errorKeyword;
            return this;
        }

        public ErrorBindingPatternNodeModifier withTypeReference(Node typeReference) {
            this.typeReference = typeReference;
            return this;
        }

        public ErrorBindingPatternNodeModifier withOpenParenthesis(Token openParenthesis) {
            Objects.requireNonNull(openParenthesis, "openParenthesis must not be null");
            this.openParenthesis = openParenthesis;
            return this;
        }

        public ErrorBindingPatternNodeModifier withArgListBindingPatterns(SeparatedNodeList<BindingPatternNode> argListBindingPatterns) {
            Objects.requireNonNull(argListBindingPatterns, "argListBindingPatterns must not be null");
            this.argListBindingPatterns = argListBindingPatterns;
            return this;
        }

        public ErrorBindingPatternNodeModifier withCloseParenthesis(Token closeParenthesis) {
            Objects.requireNonNull(closeParenthesis, "closeParenthesis must not be null");
            this.closeParenthesis = closeParenthesis;
            return this;
        }

        public ErrorBindingPatternNode apply() {
            return this.oldNode.modify(this.errorKeyword, this.typeReference, this.openParenthesis, this.argListBindingPatterns, this.closeParenthesis);
        }
    }
}

