/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ErrorTypeParamsNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;
import java.util.Optional;

public class ErrorTypeDescriptorNode
extends TypeDescriptorNode {
    public ErrorTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token errorKeywordToken() {
        return (Token)this.childInBucket(0);
    }

    public Optional<ErrorTypeParamsNode> errorTypeParamsNode() {
        return this.optionalChildInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"errorKeywordToken", "errorTypeParamsNode"};
    }

    public ErrorTypeDescriptorNode modify(Token errorKeywordToken, ErrorTypeParamsNode errorTypeParamsNode) {
        if (this.checkForReferenceEquality(errorKeywordToken, errorTypeParamsNode)) {
            return this;
        }
        return NodeFactory.createErrorTypeDescriptorNode(errorKeywordToken, errorTypeParamsNode);
    }

    public ErrorTypeDescriptorNodeModifier modify() {
        return new ErrorTypeDescriptorNodeModifier(this);
    }

    public static class ErrorTypeDescriptorNodeModifier {
        private final ErrorTypeDescriptorNode oldNode;
        private Token errorKeywordToken;
        private ErrorTypeParamsNode errorTypeParamsNode;

        public ErrorTypeDescriptorNodeModifier(ErrorTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.errorKeywordToken = oldNode.errorKeywordToken();
            this.errorTypeParamsNode = oldNode.errorTypeParamsNode().orElse(null);
        }

        public ErrorTypeDescriptorNodeModifier withErrorKeywordToken(Token errorKeywordToken) {
            Objects.requireNonNull(errorKeywordToken, "errorKeywordToken must not be null");
            this.errorKeywordToken = errorKeywordToken;
            return this;
        }

        public ErrorTypeDescriptorNodeModifier withErrorTypeParamsNode(ErrorTypeParamsNode errorTypeParamsNode) {
            this.errorTypeParamsNode = errorTypeParamsNode;
            return this;
        }

        public ErrorTypeDescriptorNode apply() {
            return this.oldNode.modify(this.errorKeywordToken, this.errorTypeParamsNode);
        }
    }
}

