/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ErrorTypeParamsNode
extends NonTerminalNode {
    public ErrorTypeParamsNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token ltToken() {
        return (Token)this.childInBucket(0);
    }

    public Node parameter() {
        return this.childInBucket(1);
    }

    public Token gtToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"ltToken", "parameter", "gtToken"};
    }

    public ErrorTypeParamsNode modify(Token ltToken, Node parameter, Token gtToken) {
        if (this.checkForReferenceEquality(ltToken, parameter, gtToken)) {
            return this;
        }
        return NodeFactory.createErrorTypeParamsNode(ltToken, parameter, gtToken);
    }

    public ErrorTypeParamsNodeModifier modify() {
        return new ErrorTypeParamsNodeModifier(this);
    }

    public static class ErrorTypeParamsNodeModifier {
        private final ErrorTypeParamsNode oldNode;
        private Token ltToken;
        private Node parameter;
        private Token gtToken;

        public ErrorTypeParamsNodeModifier(ErrorTypeParamsNode oldNode) {
            this.oldNode = oldNode;
            this.ltToken = oldNode.ltToken();
            this.parameter = oldNode.parameter();
            this.gtToken = oldNode.gtToken();
        }

        public ErrorTypeParamsNodeModifier withLtToken(Token ltToken) {
            Objects.requireNonNull(ltToken, "ltToken must not be null");
            this.ltToken = ltToken;
            return this;
        }

        public ErrorTypeParamsNodeModifier withParameter(Node parameter) {
            Objects.requireNonNull(parameter, "parameter must not be null");
            this.parameter = parameter;
            return this;
        }

        public ErrorTypeParamsNodeModifier withGtToken(Token gtToken) {
            Objects.requireNonNull(gtToken, "gtToken must not be null");
            this.gtToken = gtToken;
            return this;
        }

        public ErrorTypeParamsNode apply() {
            return this.oldNode.modify(this.ltToken, this.parameter, this.gtToken);
        }
    }
}

